/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool.re;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jiapi.reflect.BasicBlock;

public class Node {
    static final Node EXIT_NODE = new Node();
    private final BasicBlock bb;
    private Set<Node> dominators = new HashSet<Node>();
    private Set<Node> postDominators = new HashSet<Node>();
    private Set<Node> directSuccessors = new HashSet<Node>();
    private Set<Node> directPredessors = new HashSet<Node>();
    boolean visited = false;

    Node() {
        this.bb = null;
    }

    Node(BasicBlock bb) {
        this.bb = bb;
    }

    public int getId() {
        if (this.bb != null) {
            return this.bb.getId();
        }
        return -1;
    }

    public BasicBlock getBasicBlock() {
        return this.bb;
    }

    public Set<Node> getSuccessors() {
        return this.directSuccessors;
    }

    public Set<Node> getPredessors() {
        return this.directPredessors;
    }

    public Set<Node> getDominators() {
        return this.dominators;
    }

    public Set<Node> getPostDominators() {
        return this.postDominators;
    }

    void addSuccessor(Node n) {
        this.directSuccessors.add(n);
    }

    void addPredessor(Node n) {
        this.directPredessors.add(n);
    }

    public boolean dominates(Node n) {
        return n.getDominators().contains(this);
    }

    boolean postDominates(Node n) {
        return this.postDominators.contains(n);
    }

    private Set<Integer> getDominatorIds() {
        return Node.getNodeIds(this.dominators);
    }

    private Set<Integer> getPostDominatorIds() {
        return Node.getNodeIds(this.postDominators);
    }

    private Set<Integer> getSuccessorIds() {
        return Node.getNodeIds(this.directSuccessors);
    }

    private Set<Integer> getPredessorIds() {
        return Node.getNodeIds(this.directPredessors);
    }

    static Set<Integer> getNodeIds(Collection<Node> nodes) {
        TreeSet<Integer> ids = new TreeSet<Integer>();
        for (Node n : nodes) {
            ids.add(n.getId());
        }
        return ids;
    }

    void initDominators(Set<Node> allNodes) {
        this.dominators.addAll(allNodes);
    }

    void initPostDominators(Set<Node> allNodes) {
        this.postDominators.addAll(allNodes);
    }

    public List<Node> getCommonPostDominators(Node other) {
        HashSet<Node> ts = new HashSet<Node>();
        ts.addAll(this.postDominators);
        ts.retainAll(other.postDominators);
        ts.remove(EXIT_NODE);
        LinkedList<Node> ll = new LinkedList<Node>(ts);
        Collections.sort(ll, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                if (n1.postDominates(n2)) {
                    return -1;
                }
                return 1;
            }
        });
        return ll;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.bb.toString());
        sb.append("\n  ### dominators: ");
        sb.append(this.getDominatorIds());
        sb.append("\n  ### post dominators: ");
        sb.append(this.getPostDominatorIds());
        sb.append("\n  ### successors: ");
        sb.append(this.getSuccessorIds());
        sb.append("\n  ### predessors: ");
        sb.append(this.getPredessorIds());
        return sb.toString();
    }
}

