/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect.instruction;

import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.reflect.Signature;
import net.sf.jiapi.reflect.instruction.Opcodes;
import net.sf.jiapi.reflect.instruction.ReferencingInstruction;

public class Invocation
extends ReferencingInstruction {
    public Invocation(byte[] bytes, ConstantPool cp) {
        super(bytes, cp);
    }

    public String getMethodName() {
        return super.getName();
    }

    public String getReturnType() {
        Signature s = new Signature(this.getDescriptor());
        return s.getReturnType();
    }

    public String[] getParameterTypes() {
        Signature s = new Signature(this.getDescriptor());
        return s.getParameters();
    }

    @Override
    public short stackConsumption() {
        short consumption = 0;
        String[] paramTypes = this.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            consumption = "long".equals(paramTypes[i]) || "double".equals(paramTypes[i]) ? (short)(consumption + 2) : (short)(consumption + 1);
        }
        if (this.getOpcode() != -72) {
            consumption = (short)(consumption + 1);
        }
        return consumption;
    }

    @Override
    public short stackUsage() {
        int usage = 0;
        String[] paramTypes = this.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if ("long".equals(paramTypes[i]) || "double".equals(paramTypes[i])) {
                usage -= 2;
                continue;
            }
            --usage;
        }
        if (this.getOpcode() != -72) {
            --usage;
        }
        if (!"void".equals(this.getReturnType())) {
            ++usage;
        }
        if ("long".equals(this.getReturnType()) || "double".equals(this.getReturnType())) {
            ++usage;
        }
        return (short)usage;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(Opcodes.opcodeStrings[0xFF & this.getOpcode()]);
        byte[] bytes = this.getBytes();
        for (int i = 1; i < bytes.length; ++i) {
            sb.append(" ");
            sb.append(0xFF & bytes[i]);
        }
        sb.append(" ; ");
        sb.append(this.getClassName());
        sb.append(".");
        sb.append(this.getMethodName());
        sb.append(this.getDescriptor());
        return sb.toString();
    }
}

