/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.cobertura.dsl.ReportFormat;
import net.sourceforge.cobertura.reporting.ReportFormatStrategy;
import net.sourceforge.cobertura.reporting.html.HTMLReportFormatStrategy;
import net.sourceforge.cobertura.reporting.xml.SummaryXMLReportStrategy;
import net.sourceforge.cobertura.reporting.xml.XMLReportFormatStrategy;

public class ReportFormatStrategyRegistry {
    private static ReportFormatStrategyRegistry instance = null;
    private Map<ReportFormat, ReportFormatStrategy> reportFormatsRegistry = new HashMap<ReportFormat, ReportFormatStrategy>();

    private ReportFormatStrategyRegistry() {
        this.registerReportFormatStrategies();
    }

    public ReportFormatStrategy getReportFormatStrategy(ReportFormat reportFormat) {
        return this.reportFormatsRegistry.get((Object)reportFormat);
    }

    private void registerReportFormatStrategies() {
        this.reportFormatsRegistry = new HashMap<ReportFormat, ReportFormatStrategy>();
        this.registerReportFormatStrategy(new SummaryXMLReportStrategy());
        this.registerReportFormatStrategy(new XMLReportFormatStrategy());
        this.registerReportFormatStrategy(new HTMLReportFormatStrategy());
    }

    private void registerReportFormatStrategy(ReportFormatStrategy reportFormatStrategy) {
        this.reportFormatsRegistry.put(reportFormatStrategy.getName(), reportFormatStrategy);
    }

    public static ReportFormatStrategyRegistry getInstance() {
        if (instance == null) {
            instance = new ReportFormatStrategyRegistry();
        }
        return instance;
    }
}

