/*
 * Argus Client Software.  Tools to read, analyze and manage Argus data.
 * Copyright (c) 2000-2003 QoSient, LLC
 * All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

#ifndef ArgusUtil_h
#define ArgusUtil_h

#if !defined(__OpenBSD__)
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#endif

#include <argus_out.h>
#include <cons_out.h>

#include <CflowdFlowPdu.h>


typedef void (*proc)(void);
typedef char *(*strproc)(void);

struct QUEUE_HEADER {
   struct QUEUE_HEADER *nxt;
   struct QUEUE_HEADER *prv;
   struct QUEUE *queue;
   struct timeval last_time, logtime;
};


struct QUEUE {
   struct QUEUE_HEADER *start;
   proc timerRoutine, logRoutine;
   unsigned int count;
};

struct HASH_TABLE_HEADER {
   struct HASH_TABLE_HEADER *nxt;
   struct HASH_TABLE_HEADER *prv;
   unsigned int hash;
};
 
struct HASH_TABLE {
   struct HASH_TABLE_HEADER **hash_array;
   unsigned int size;
};


struct FILE_ENTRY {
   struct FILE_ENTRY *nxt;
   char *str;
};


#define Version1        1
#define Version5        5
#define Version6        6
#define Version7        7
#define Version8        8

typedef struct ArgusRecord * (*ArgusNetFlowHandler)(u_char **);

struct ArgusRecord *ArgusNetFlowCallRecord (u_char **);
struct ArgusRecord *ArgusNetFlowDetailInt  (u_char **);
struct ArgusRecord *ArgusParseCiscoRecord (u_char **);

#ifdef ARGUS_SASL
#include <sasl.h>
#endif

#include <sys/stat.h>

#define ARGUS_DATA_SOURCE		0x01
#define ARGUS_CISCO_DATA_SOURCE		0x10

struct ARGUS_INPUT {
   struct ARGUS_INPUT *nxt;
   arg_uint32 addr;
   unsigned short portnum;
   char *hostname, *filename;
   int mode, fd, in, out, offset;
   int ostart, ostop;
   FILE *pipe;
   unsigned int status;
   int major_version, minor_version;
   unsigned int ArgusLocalNet, ArgusNetMask;
   struct timeval ArgusLastTime;
   int ArgusMarInterval;
   struct stat statbuf;
   unsigned char *ArgusReadBuffer, *ArgusConvBuffer;
   unsigned char *ArgusReadPtr, *ArgusConvPtr, *ArgusReadBlockPtr;
   int ArgusReadSocketCnt, ArgusReadSocketSize;
   int ArgusReadSocketState, ArgusReadCiscoVersion;
   int ArgusReadSocketNum, ArgusReadSize;
   ArgusNetFlowHandler ArgusCiscoNetFlowParse;
#ifdef ARGUS_SASL
   sasl_conn_t *sasl_conn;
   int ArgusSaslBufCnt;
   unsigned char *ArgusSaslBuffer;
#endif
   struct ArgusRecord ArgusInitCon, ArgusManStart;
};


#define TSEQ_HASHSIZE	9029
#define HASHNAMESIZE	4096
#define IPPROTOSTR	134

#define ipaddr_string(p) getname((u_char *)(p))

#ifdef ArgusUtil

char *ip_proto_string [IPPROTOSTR] = {"ip", "icmp", "igmp", "ggp",
   "ipnip", "st", "tcp", "ucl", "egp", "igp", "bbn-rcc-mon", "nvp-ii",
   "pup", "argus", "emcon", "xnet", "chaos", "udp", "mux", "dcn-meas",
   "hmp", "prm", "xns-idp", "trunk-1", "trunk-2", "leaf-1", "leaf-2",
   "rdp", "irtp", "iso-tp4", "netblt", "mfe-nsp", "merit-inp", "sep",
   "3pc", "idpr", "xtp", "ddp", "idpr-cmtp", "tp++", "il", "ipv6",
   "sdrp", "ipv6-route", "ipv6-frag", "idrp", "rsvp", "gre", "mhrp", "bna",
   "esp", "ah", "i-nlsp", "swipe", "narp", "mobile", "tlsp", "skip",
   "ipv6-icmp", "ipv6-no", "ipv6-opts", "any", "cftp", "any", "sat-expak", "kryptolan",
   "rvd", "ippc", "any", "sat-mon", "visa", "ipcv", "cpnx", "cphb", "wsn",
   "pvp", "br-sat-mon", "sun-nd", "wb-mon", "wb-expak", "iso-ip", "vmtp",
   "secure-vmtp", "vines", "ttp", "nsfnet-igp", "dgp", "tcf", "igrp",
   "ospfigp", "sprite-rpc", "larp", "mtp", "ax.25", "ipip", "micp",
   "aes-sp3-d", "etherip", "encap", "pri-enc", "gmtp", "ifmp", "pnni",
   "pim", "aris", "scps", "qnx", "a/n", "ipcomp", "snp", "compaq-peer",
   "ipx-n-ip", "vrrp", "pgm", "zero", "l2tp", "ddx", "iatp", "stp", "srp",
   "uti", "smp", "ptp", "isis", "fire", "crtp", "crudp", "sccopmce", "iplt",
   "sps", "pipe", "sctp", "fc",
};

#if defined(__OpenBSD__)
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#endif

#include <netinet/ip_icmp.h>
#undef ICMP_MAXTYPE
#define ICMP_MAXTYPE	41
char *icmptypestr[ICMP_MAXTYPE + 1] = {
   "ECR", "   ", "   ", "UR" , "SRC", "RED",
   "AHA", "   ", "ECO", "RTA", "RTS", "TXD",
   "PAR", "TST", "TSR", "IRQ", "IRR", "MAS",
   "MSR", "SEC", "ROB", "ROB", "ROB", "ROB",
   "ROB", "ROB", "ROB", "ROB", "ROB", "ROB",
   "TRC", "DCE", "MHR", "WAY", "IAH", "MRQ",
   "MRP", "DNQ", "DNP", "SKP", "PHO",
};   


int ArgusSrcUserDataLen = 0;
int ArgusDstUserDataLen = 0;
int ArgusPrintGMT = 0;

void ArgusAdjustGlobalTime (struct timeval *);
u_int ArgusIndexNetworkRecord (struct ArgusRecord *, struct ArgusFarHeaderStruct **);
u_int ArgusIndexRecord (struct ArgusRecord *, struct ArgusFarHeaderStruct **);
void ArgusReverseRecord (struct ArgusRecord *); 
void ArgusZeroRecord (struct ArgusRecord *); 
struct ArgusRecord *ArgusSubtractRecord (struct ArgusRecord *, struct ArgusRecord *);

int ArgusConvertInitialWriteStruct (struct WriteStruct *, struct ArgusRecord *);
int ArgusConvertWriteStruct (struct WriteStruct *, struct ArgusRecord *);

char *print_time(struct timeval *);

void ArgusPrintCommonRecord (char *, struct ArgusRecord *);
void ArgusPrintDate(char *, struct ArgusRecord *);
void ArgusPrintStartDate(char *, struct ArgusRecord *);
void ArgusPrintLastDate(char *, struct ArgusRecord *);
void ArgusPrintSourceID (char *, struct ArgusRecord *);
void ArgusPrintIndicator (char *, struct ArgusRecord *);
void ArgusPrintMACAddress (char *, struct ArgusRecord *);
void ArgusPrintProto (char *, struct ArgusRecord *);
void ArgusPrintAddr (char *, unsigned short, void *);
void ArgusPrintSrcAddr (char *, struct ArgusRecord *);
void ArgusPrintDstAddr (char *, struct ArgusRecord *);
void ArgusPrintPort (char *, struct ArgusRecord *, unsigned short);
void ArgusPrintSrcPort (char *, struct ArgusRecord *);
void ArgusPrintDstPort (char *, struct ArgusRecord *);
void ArgusPrintIpId (char *, struct ArgusRecord *);
void ArgusPrintDir (char *, struct ArgusRecord *);
void ArgusPrintCounts (char *, struct ArgusRecord *);
void ArgusPrintSrcPackets (char *, struct ArgusRecord *);
void ArgusPrintDstPackets (char *, struct ArgusRecord *);
void ArgusPrintBytes (char *, struct ArgusRecord *);
void ArgusPrintJitter (char *, struct ArgusRecord *);
void ArgusPrintStatus (char *, struct ArgusRecord *);
void ArgusPrintDeltaDuration (char *, struct ArgusRecord *);
void ArgusPrintDeltaStarTime (char *, struct ArgusRecord *);
void ArgusPrintDeltaLastTime (char *, struct ArgusRecord *);
void ArgusPrintUserData (char *, struct ArgusRecord *);
void ArgusPrintTCPExtensions (char *, struct ArgusRecord *);
char *ArgusGetManStatus (struct ArgusRecord *);
char *ArgusGetICMPStatus (struct ArgusRecord *);
char *ArgusGetIGMPStatus (struct ArgusRecord *);
char *ArgusGetIPStatus (struct ArgusRecord *);

char *get_argus_string (struct ArgusRecord *ptr);
char *get_man_string (struct ArgusRecord *ptr);
char *get_tcp_string (struct ArgusRecord *ptr);
char *get_icmp_string (struct ArgusRecord *ptr);
char *get_udp_string (struct ArgusRecord *ptr);
char *get_ip_string (struct ArgusRecord *ptr);
char *get_arp_string (struct ArgusRecord *ptr);
char *get_nonip_string (struct ArgusRecord *ptr);

char *RaGetUserDataString (struct ArgusRecord *);

int ArgusEncode (const char *, const char *, int, char *, int);
int ArgusEncode32 (const char *, int, char *, int);
int ArgusEncode64 (const char *, int, char *, int);
int ArgusEncodeAscii (const char *, int, char *, int);

extern unsigned int thisnet, localaddr, localnet, netmask;


#else

extern char *ip_proto_string [];

extern int ArgusSrcUserDataLen;
extern int ArgusDstUserDataLen;
extern int ArgusPrintGMT;

extern void ArgusAdjustGlobalTime (struct timeval *);
extern u_int ArgusIndexNetworkRecord (struct ArgusRecord *, struct ArgusFarHeaderStruct **);
extern u_int ArgusIndexRecord (struct ArgusRecord *, struct ArgusFarHeaderStruct **);
extern void ArgusReverseRecord (struct ArgusRecord *); 
extern void ArgusZeroRecord (struct ArgusRecord *); 
extern struct ArgusRecord *ArgusSubtractRecord (struct ArgusRecord *, struct ArgusRecord *);

extern int ArgusConvertInitialWriteStruct (struct WriteStruct *, struct ArgusRecord *);
extern int ArgusConvertWriteStruct (struct WriteStruct *, struct ArgusRecord *);

extern char *print_time(struct timeval *);

extern void ArgusPrintCommonRecord (char *, struct ArgusRecord *);
extern void ArgusPrintDate(char *, struct ArgusRecord *);
extern void ArgusPrintStartDate(char *, struct ArgusRecord *);
extern void ArgusPrintLastDate(char *, struct ArgusRecord *);
extern void ArgusPrintSourceID (char *, struct ArgusRecord *);
extern void ArgusPrintIndicator (char *, struct ArgusRecord *);
extern void ArgusPrintMACAddress (char *, struct ArgusRecord *);
extern void ArgusPrintProto (char *, struct ArgusRecord *);
extern void ArgusPrintAddr (char *, unsigned short, void *);
extern void ArgusPrintSrcAddr (char *, struct ArgusRecord *);
extern void ArgusPrintDstAddr (char *, struct ArgusRecord *);
extern void ArgusPrintPort (char *, struct ArgusRecord *, unsigned short);
extern void ArgusPrintSrcPort (char *, struct ArgusRecord *);
extern void ArgusPrintDstPort (char *, struct ArgusRecord *);
extern void ArgusPrintIpId (char *, struct ArgusRecord *);
extern void ArgusPrintDir (char *, struct ArgusRecord *);
extern void ArgusPrintCounts (char *, struct ArgusRecord *);
extern void ArgusPrintSrcPackets (char *, struct ArgusRecord *);
extern void ArgusPrintDstPackets (char *, struct ArgusRecord *);
extern void ArgusPrintBytes (char *, struct ArgusRecord *);
extern void ArgusPrintJitter (char *, struct ArgusRecord *);
extern void ArgusPrintStatus (char *, struct ArgusRecord *);
extern void ArgusPrintDeltaDuration (char *, struct ArgusRecord *);
extern void ArgusPrintDeltaStarTime (char *, struct ArgusRecord *);
extern void ArgusPrintDeltaLastTime (char *, struct ArgusRecord *);
extern void ArgusPrintUserData (char *, struct ArgusRecord *);
extern void ArgusPrintTCPExtensions (char *, struct ArgusRecord *);
extern char *ArgusGetManStatus (struct ArgusRecord *);
extern char *ArgusGetICMPStatus (struct ArgusRecord *);
extern char *ArgusGetIGMPStatus (struct ArgusRecord *);
extern char *ArgusGetIPStatus (struct ArgusRecord *);

extern char *get_argus_string (struct ArgusRecord *ptr);
extern char *get_man_string (struct ArgusRecord *ptr);
extern char *get_tcp_string (struct ArgusRecord *ptr);
extern char *get_icmp_string (struct ArgusRecord *ptr);
extern char *get_udp_string (struct ArgusRecord *ptr);
extern char *get_ip_string (struct ArgusRecord *ptr);
extern char *get_arp_string (struct ArgusRecord *ptr);
extern char *get_nonip_string (struct ArgusRecord *ptr);

extern char *RaGetUserDataString (struct ArgusRecord *);

extern int ArgusEncode (const char *, const char *, int, char *, int);
extern int ArgusEncode32 (const char *, int, char *, int);
extern int ArgusEncode64 (const char *, int, char *, int);
extern int ArgusEncodeAscii (const char *, int, char *, int);

#endif 
#endif /* ArgusUtil_h */
