/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */
package org.apache.logging.log4j.core.util;

import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.Test;

import java.io.FileInputStream;
import java.util.Properties;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

/**
 *
 */
public class PropertiesUtilTest {

    @Test
    public void testSubset() throws Exception {
        Properties props = new Properties();
        props.load(new FileInputStream("target/test-classes/log4j2-properties.properties"));
        Properties subset = PropertiesUtil.extractSubset(props, "appender.Stdout.filter.marker");
        assertNotNull("No subset returned", subset);
        assertTrue("Incorrect number of items. Expected 4, actual " + subset.size(), subset.size() == 4);
        assertTrue("Missing propertu", subset.containsKey("type"));
    }
}
