/* Copyright (C) Teemu Suutari */

#ifndef RDCNDECOMPRESSOR_HPP
#define RDCNDECOMPRESSOR_HPP

#include "XPKDecompressor.hpp"

class RDCNDecompressor : public XPKDecompressor
{
public:
	RDCNDecompressor(uint32_t hdr,uint32_t recursionLevel,const Buffer &packedData,std::unique_ptr<XPKDecompressor::State> &state,bool verify);

	virtual ~RDCNDecompressor();

	virtual const std::string &getSubName() const noexcept override final;

	virtual void decompressImpl(Buffer &rawData,const Buffer &previousData,bool verify) override final;

	static bool detectHeaderXPK(uint32_t hdr) noexcept;
	static std::unique_ptr<XPKDecompressor> create(uint32_t hdr,uint32_t recursionLevel,const Buffer &packedData,std::unique_ptr<XPKDecompressor::State> &state,bool verify);

private:
	const Buffer	&_packedData;

	static XPKDecompressor::Registry<RDCNDecompressor> _XPKregistration;
};

#endif
