/*
 *   DIS/x : An implementation of the IEEE 1278.1 protocol
 *
 *   Copyright (C) 1996,1998, Riley Rainey (rainey@netcom.com)
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of either:
 *
 *   a) the GNU Library General Public License as published by the Free
 *   Software Foundation; either version 2 of the License, or (at your
 *   option) any later version.  A description of the terms and conditions
 *   of the GLPL may be found in the "COPYING.LIB" file.
 *
 *   b) the "Artistic License" which comes with this Kit.  Information
 *   about this license may be found in the "Artistic" file.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License or the Artistic License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Information describing how to contact the author can be found in the
 *   README file.
 */
#include <rpc/rpc.h>
#include <dis/dis.h>

void
DISAddPDUSizes(dis_pdu * p)
{
	int       i, j;

	switch (p->hdr.pdu_type) {
	case PDUTypeEmission:
		{
			dis_em_emission_pdu *pdu = (dis_em_emission_pdu *) p;
			dis_em_system_info *s = pdu->system;
			dis_beam_info *b;
			unsigned long len;

			for (i = 0; i < pdu->num_systems; ++i, ++s) {
				b = s->beam;
				len = 0;
				for (j = 0; j < pdu->system[i].num_beams; ++j, ++b) {
					b->beam_data_length = 13 + b->num_targets * 2;
					len += b->beam_data_length;
				}
				s->sys_data_length = (u_char) (5 + len);
			}
		}
		break;

	default:
		break;
	}
}
