; This file was initially generated automatically from legacy documentation
; strings.  See source files in this directory for copyright and license
; information.

(in-package "ACL2")

(include-book "xdoc/top" :dir :system)

(defxdoc normp
  :parents (hons-and-memoization)
  :short "Recognizer of ubdds."
  :long  "<p>
 (NORMP x) returns T or NIL according to whether X is a well-formed
 ubdd, i.e., a rooted, binary tree, in T and NIL, with no node equal
 to '(T . T) or '(NIL . NIL).
 </p>
 
 
 <p>
 </p>")

(defxdoc q-ite
  :parents (hons-and-memoization)
  :short "If-then-else for ubdds."
  :long  "<p>
 (Q-ITE x y z) expects three ubdds, which are to be interpreted at
 the same level.  Informally speaking. Q-ITE returns a single ubdd,
 also at the same level, that is 'equivalent' to (IF x y z).  The two
 theorems Q-ITE-CORRECT and NORMP-Q-ITE express formally what Q-ITE
 returns.
 </p>
 
 
 <p>
 </p>")

(defxdoc qnorm
  :parents (hons-and-memoization)
  :short "Creates ubdds."
  :long  "<p>
 (QNORM term) returns the unique ubdd for TERM, an expression in
   the TO-IF language, with respect to the variable ordering returned
   by (VARS (TO-IF TERM) NIL).</p>
 
 <p>If TERM is a tautology, then QNORM returns T.  If term is
   a contradiction, then QNORM returns NIL.  If term is satisfiable,
   then QNORM returns a CONSP ubdd.
 </p>
 
 
 <p>
 </p>")

(defxdoc qnorm1
  :parents (hons-and-memoization)
  :short "Creates ubdds."
  :long  "<p>
 (QNORM1 term vars) returns the unique ubdd for TERM, an
 IF-expression, with respect to the variable ordering VARS. 
 </p>
 
 
 <p>
 </p>")

(defxdoc to-if
  :parents (hons-and-memoization)
  :short "Recognizer for the TO-IF langauge"
  :long  "<p>
 (TO-IF x) is a recognizer for objects in the TO-IF language, which
 may be used for writing Boolean expressions.  The TO-IF language is
 a subset of the TO-IF2 language.</p>
 
 <p>If X is in the TO-IF language, then (TO-IF x) returns an equivalent
 member of the TO-IF language expressed in the limited vocabulary of
 IF, T, NIL, and variables.  The result returned is not in any
 particular normal form, but it is in the form expected by the
 function QNORM1.</p>
 
 <p>If X is not in the TO-IF language, then (TO-IF x) returns a CONS
 whose CAR is a string that may help explain in what sense X is not
 in the TO-IF language.</p>
 
 <p>Though similar to the language of ACL2, the TO-IF language is NOT
 the same as the ACL2 langauge or the TO-IF2 language, so watch out!</p>
 
 <p>(TERM-EVAL (TO-IF term) vars vals) gives the meaning of (TO-IF
 TERM) with respect to the binding of the variables in VARS to the
 Booleans in VALS.</p>
 
 <p>Informally, in the TO-IF language, T and NIL both are and denote
 the Boolean constants.  All eqlable ACL2 atoms (i.e., symbols,
 integers, rational, complex numbers, characters, but not strings)
 are variables in the TO-IF language.  The variables denote Boolean
 values, i.e., T and NIL.</p>
 
 <p>Merely for emphasis: The integer 2 is a variable in the TO-IF
 language, odd as that may seem at first.</p>
 
 <p>Merelly for emphasis:  The string \"2\" is not a TO-IF variable.</p>
 
 <p>(IF x y z) means what Y means if X means T and means what Z means
 if X means NIL.</p>
 
 <p>(TO-IF `(LET ,x ,y ,z)) is the result of simultaneously replacing
 in (TO-IF z) all the occurrences of the variable x with
 (TO-IF y).  Note that although in Lisp, one might write:
 (let ((x y)) z), the TO-IF 'LET' takes exactly three arguments.</p>
 
 <p>In a TO-IF expression one may also use the unary operator NOT and
 the binary operators AND, OR, IFF, IMPLIES, XOR, NAND, NOR, ANDC1,
 ORC1, and ORC2.</p>
 
 <p>TO-IF does not handle quantifiers such as FORALL nor FORSOME, nor
 does it permit operators to take a variable number of arguments.
 For such features, see TO-IF2.</p>
 
 <p>There are many synonyms for the many familar logical operators.
 Invoke (SAT-HELP) to see them all.  There is no facility
 for a user to extend these synonyms.
  
 </p>
 
 
 <p>
 </p>")

