/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;

class ClassNamePatternParameterConverter {
    private static final Predicate<?> alwaysActivated = object -> true;
    private static final Predicate<?> alwaysDeactivated = object -> false;
    static final String DEACTIVATE_ALL_PATTERN = "*";

    ClassNamePatternParameterConverter() {
    }

    Predicate<?> get(ConfigurationParameters configurationParameters, String key) {
        return configurationParameters.get(key).filter(StringUtils::isNotBlank).map(String::trim).map(patternString -> {
            if (DEACTIVATE_ALL_PATTERN.equals(patternString)) {
                return alwaysDeactivated;
            }
            return this.matchesRegex((String)patternString);
        }).orElse(alwaysActivated);
    }

    private Predicate<?> matchesRegex(String patternString) {
        Pattern pattern = Pattern.compile(this.convertToRegEx(patternString));
        return object -> !pattern.matcher(object.getClass().getName()).matches();
    }

    private String convertToRegEx(String pattern) {
        pattern = Matcher.quoteReplacement(pattern);
        pattern = pattern.replace(".", "[.$]");
        pattern = pattern.replace(DEACTIVATE_ALL_PATTERN, ".+");
        return pattern;
    }
}

