!!****m* ABINIT/interfaces_01manage_mpi
!! NAME
!! interfaces_01manage_mpi
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/01manage_mpi
!!
!! COPYRIGHT
!! Copyright (C) 2005 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: abilint . .
!!             (see util/maintainers/abilint.py)
!!
!! SOURCE

module interfaces_01manage_mpi

 interface
  subroutine clnmpi_fft(dtset, mpi_enreg)
   use defs_datatypes
   type(dataset_type), intent(in) :: dtset
   type(MPI_type), intent(inout) :: mpi_enreg
  end subroutine clnmpi_fft
 end interface

 interface
  subroutine clnmpi_gs(dtset, mpi_enreg)
   use defs_datatypes
   type(dataset_type) :: dtset
   type(MPI_type) :: mpi_enreg
  end subroutine clnmpi_gs
 end interface

 interface
  subroutine distrb2(mband, nband, nkpt, nsppol, mpi_enreg)
   use defs_datatypes
   integer,intent(in) :: mband
   integer,intent(in) :: nkpt
   integer,intent(in) :: nsppol
   type(MPI_type),intent(inout) :: mpi_enreg
   integer,intent(in) :: nband(nkpt*nsppol)
  end subroutine distrb2
 end interface

 interface
  subroutine herald(code_name,code_version,iout)
   integer,intent(in) :: iout
   character(len=24),intent(in) :: code_name
   character(len=6),intent(in) :: code_version
  end subroutine herald
 end interface

 interface
  subroutine initmpi_fft(dtset,mpi_enreg)
   use defs_datatypes
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
  end subroutine initmpi_fft
 end interface

 interface
  subroutine initmpi_gs(dtset,mpi_enreg)
   use defs_datatypes
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
  end subroutine initmpi_gs
 end interface

 interface
  subroutine initmpi_respfn(mpi_enreg, spaceComm)
   use defs_datatypes
   integer :: spaceComm
   type(MPI_type) :: mpi_enreg
  end subroutine initmpi_respfn
 end interface

 interface
  subroutine initmpi_seq(mpi_enreg)
   use defs_datatypes
   type(MPI_type),intent(out) :: mpi_enreg
  end subroutine initmpi_seq
 end interface

 interface
  subroutine leave_new(mode_paral)
   character(len=4),intent(in) :: mode_paral
  end subroutine leave_new
 end interface

 interface
  subroutine leave_test(mpi_enreg)
   use defs_datatypes
   type(MPI_type) :: mpi_enreg
  end subroutine leave_test
 end interface

 interface
  subroutine pre_scatter(array,array_allgather,n1,n2,n3,mpi_enreg,option)
   use defs_basis
   use defs_datatypes
   integer :: n1
   integer :: n2
   integer :: n3
   type(mpi_type) :: mpi_enreg
   character(*) :: option
   real(dp) :: array(n1,n2,n3/mpi_enreg%nproc_fft,1)
   real(dp) :: array_allgather(n1,n2,n3,1)
  end subroutine pre_scatter
 end interface

 interface
  SUBROUTINE construire_grille_scalapack(grille,nbprocs, communicator)
   use defs_scalapack
   INTEGER, INTENT(in) :: communicator
   TYPE(grille_scalapack),INTENT(out) :: grille
   INTEGER,INTENT(in) :: nbprocs
  end subroutine construire_grille_scalapack
 end interface

 interface
  SUBROUTINE construire_processeur_scalapack(processeur,grille,myproc, comm)
   use defs_scalapack
   INTEGER,INTENT(in) :: comm
   TYPE(grille_scalapack),INTENT(in) :: grille
   INTEGER,INTENT(in) :: myproc
   TYPE(processeur_scalapack),INTENT(out) :: processeur
  end subroutine construire_processeur_scalapack
 end interface

 interface
  SUBROUTINE init_scalapack(processeur,communicator)
   use defs_scalapack
   INTEGER, INTENT(in) :: communicator
   TYPE(processeur_scalapack),INTENT(out) :: processeur
  end subroutine init_scalapack
 end interface

 interface
  SUBROUTINE end_scalapack(processeur)
   use defs_scalapack
   TYPE(processeur_scalapack),INTENT(inout) :: processeur
  end subroutine end_scalapack
 end interface

 interface
  SUBROUTINE init_matrice_scalapack(matrice,nbli_global,&  
&  nbco_global,processeur,tbloc)
   use defs_scalapack
   TYPE(matrice_scalapack),INTENT(out) :: matrice
   INTEGER,INTENT(in) :: nbco_global
   INTEGER,INTENT(in) :: nbli_global
   TYPE(processeur_scalapack),INTENT(in),TARGET :: processeur
   INTEGER,INTENT(in),OPTIONAL :: tbloc
  end subroutine init_matrice_scalapack
 end interface

 interface
  SUBROUTINE matrice_copie(source,destination)
   use defs_scalapack
   TYPE(matrice_scalapack),INTENT(out) :: destination
   TYPE(matrice_scalapack),INTENT(in) :: source
  end subroutine matrice_copie
 end interface

 interface
  SUBROUTINE destruction_matrice_scalapack(matrice)
   use defs_scalapack
   TYPE(matrice_scalapack),INTENT(inout) :: matrice
  end subroutine destruction_matrice_scalapack
 end interface

 interface
  FUNCTION matrice_get_local(matrice,i,j)
   use defs_basis
   use defs_scalapack
   INTEGER, INTENT(in) :: i
   INTEGER, INTENT(in) :: j
   TYPE(matrice_scalapack),INTENT(in) :: matrice
   COMPLEX(dp) :: matrice_get_local
  end function matrice_get_local
 end interface

 interface
  SUBROUTINE matrice_set_local(matrice,i,j,valeur)
   use defs_basis
   use defs_scalapack
   INTEGER, INTENT(in) :: i
   INTEGER, INTENT(in) :: j
   TYPE(matrice_scalapack),INTENT(out) :: matrice
   COMPLEX(dp) :: valeur
  end subroutine matrice_set_local
 end interface

 interface
  SUBROUTINE matrice_add_local(matrice,i,j,valeur)
   use defs_basis
   use defs_scalapack
   INTEGER, INTENT(in) :: i
   INTEGER, INTENT(in) :: j
   TYPE(matrice_scalapack),INTENT(out) :: matrice
   COMPLEX(dp) :: valeur
  end subroutine matrice_add_local
 end interface

 interface
  FUNCTION idx_processeur_est_local(matrice,i,j)
   use defs_scalapack
   INTEGER, INTENT(in) :: i
   LOGICAL :: idx_processeur_est_local
   INTEGER, INTENT(in) :: j
   TYPE(matrice_scalapack),INTENT(in) :: matrice
  end function idx_processeur_est_local
 end interface

 interface
  FUNCTION idx_processeur_concerne(matrice,idx,lico)
   use defs_scalapack
   INTEGER, INTENT(in) :: idx
   INTEGER :: idx_processeur_concerne
   INTEGER, INTENT(in) :: lico
   TYPE(matrice_scalapack),INTENT(in) :: matrice
  end function idx_processeur_concerne
 end interface

 interface
  SUBROUTINE idx_loc(matrice,i,j,iloc,jloc)
   use defs_scalapack
   INTEGER, INTENT(in) :: i
   INTEGER, INTENT(out) :: iloc
   INTEGER, INTENT(in) :: j
   INTEGER, INTENT(out) :: jloc
   TYPE(matrice_scalapack),INTENT(in) :: matrice
  end subroutine idx_loc
 end interface

 interface
  FUNCTION glob_loc(matrice,idx,lico)
   use defs_scalapack
   INTEGER :: glob_loc
   INTEGER, INTENT(in) :: idx
   INTEGER, INTENT(in) :: lico
   TYPE(matrice_scalapack),INTENT(in) :: matrice
  end function glob_loc
 end interface

 interface
  SUBROUTINE idx_glob(matrice,iloc,jloc,i,j)
   use defs_scalapack
   INTEGER, INTENT(out) :: i
   INTEGER, INTENT(in) :: iloc
   INTEGER, INTENT(out) :: j
   INTEGER, INTENT(in) :: jloc
   TYPE(matrice_scalapack),INTENT(in) :: matrice
  end subroutine idx_glob
 end interface

 interface
  FUNCTION loc_glob(matrice,proc,idx,lico)
   use defs_scalapack
   INTEGER, INTENT(in) :: idx
   INTEGER, INTENT(in) :: lico
   INTEGER :: loc_glob
   TYPE(matrice_scalapack),INTENT(in) :: matrice
   TYPE(processeur_scalapack),INTENT(in) :: proc
  end function loc_glob
 end interface

 interface
  FUNCTION matrice_get_global(matrice,i,j)
   use defs_basis
   use defs_scalapack
   INTEGER, INTENT(in) :: i
   INTEGER, INTENT(in) :: j
   TYPE(matrice_scalapack),INTENT(in) :: matrice
   COMPLEX(dp) :: matrice_get_global
  end function matrice_get_global
 end interface

 interface
  SUBROUTINE matrice_set_global(matrice,i,j,valeur)
   use defs_basis
   use defs_scalapack
   INTEGER, INTENT(in) :: i
   INTEGER, INTENT(in) :: j
   TYPE(matrice_scalapack),INTENT(inout) :: matrice
   COMPLEX(dp) :: valeur
  end subroutine matrice_set_global
 end interface

 interface
  SUBROUTINE matrice_add_global(matrice,i,j,valeur)
   use defs_basis
   use defs_scalapack
   INTEGER, INTENT(in) :: i
   INTEGER, INTENT(in) :: j
   TYPE(matrice_scalapack),INTENT(inout) :: matrice
   COMPLEX(dp) :: valeur
  end subroutine matrice_add_global
 end interface

 interface
  SUBROUTINE matrice_verification_globale(matrice,reference)
   use defs_basis
   use defs_scalapack
   TYPE(matrice_scalapack),INTENT(in) :: matrice
   COMPLEX(dp),DIMENSION(:,:) :: reference
  end subroutine matrice_verification_globale
 end interface

 interface
  SUBROUTINE matrice_verif_globale_vecteur(matrice,reference,decli,nom)
   use defs_basis
   use defs_scalapack
   INTEGER, OPTIONAL :: decli
   TYPE(matrice_scalapack),INTENT(in) :: matrice
   CHARACTER(len=*),OPTIONAL :: nom
   COMPLEX(dp),DIMENSION(:) :: reference
  end subroutine matrice_verif_globale_vecteur
 end interface

 interface
  SUBROUTINE matrice_from_globale(matrice,reference)
   use defs_basis
   use defs_scalapack
   TYPE(matrice_scalapack),INTENT(inout) :: matrice
   REAL(dp),DIMENSION(:) :: reference
  end subroutine matrice_from_globale
 end interface

 interface
  SUBROUTINE matrice_to_reference(matrice,reference)
   use defs_basis
   use defs_scalapack
   TYPE(matrice_scalapack),INTENT(in) :: matrice
   REAL(dp),DIMENSION(:,:),INTENT(inout) :: reference
  end subroutine matrice_to_reference
 end interface

 interface
  SUBROUTINE matrice_rangement_local_vecteur(matrice,tableau,decli,decco)
   use defs_basis
   use defs_scalapack
   INTEGER, INTENT(in) :: decco
   INTEGER, INTENT(in) :: decli
   TYPE(matrice_scalapack),INTENT(inout) :: matrice
   COMPLEX(dp),DIMENSION(:),INTENT(in) :: tableau
  end subroutine matrice_rangement_local_vecteur
 end interface

 interface
  SUBROUTINE matrice_extraction_vecteur(matrice,tableau,decli,decco,finli)
   use defs_basis
   use defs_scalapack
   INTEGER, INTENT(in) :: decco
   INTEGER, INTENT(in) :: decli
   INTEGER, INTENT(in), OPTIONAL :: finli
   TYPE(matrice_scalapack),INTENT(in) :: matrice
   COMPLEX(dp),DIMENSION(:),INTENT(out) :: tableau
  end subroutine matrice_extraction_vecteur
 end interface

 interface
  SUBROUTINE matrice_pzgetrf(matrice)
   use defs_scalapack
   TYPE(matrice_scalapack),INTENT(inout) :: matrice
  end subroutine matrice_pzgetrf
 end interface

 interface
  SUBROUTINE matrice_pzgetrs(matrice,vecteur)
   use defs_scalapack
   TYPE(matrice_scalapack),INTENT(in) :: matrice
   TYPE(matrice_scalapack),INTENT(inout) :: vecteur
  end subroutine matrice_pzgetrs
 end interface

 interface
  SUBROUTINE matrice_pzpotrf(matrice)
   use defs_scalapack
   TYPE(matrice_scalapack),INTENT(inout) :: matrice
  end subroutine matrice_pzpotrf
 end interface

 interface
  SUBROUTINE matrice_pzpotrs(matrice,vecteur)
   use defs_scalapack
   TYPE(matrice_scalapack),INTENT(in) :: matrice
   TYPE(matrice_scalapack),INTENT(inout) :: vecteur
  end subroutine matrice_pzpotrs
 end interface

 interface
  SUBROUTINE matrice_pzgemm(matrice1,alpha,matrice2,beta,resultat)
   use defs_basis
   use defs_scalapack
   COMPLEX(dp), intent(in) :: alpha
   COMPLEX(dp), intent(in) :: beta
   TYPE(matrice_scalapack),INTENT(in) :: matrice1
   TYPE(matrice_scalapack),INTENT(in) :: matrice2
   TYPE(matrice_scalapack),INTENT(inout) :: resultat
  end subroutine matrice_pzgemm
 end interface

 interface
  SUBROUTINE matrice_pzheevx(processeur,matrice,resultat,eigen,communicateur)
   use defs_scalapack
   INTEGER,INTENT(in) :: communicateur
   TYPE(matrice_scalapack),INTENT(in) :: matrice
   TYPE(processeur_scalapack),INTENT(in) :: processeur
   TYPE(matrice_scalapack),INTENT(inout) :: resultat
   DOUBLE PRECISION,DIMENSION(:),INTENT(inout) :: eigen
  end subroutine matrice_pzheevx
 end interface

 interface
  SUBROUTINE matrice_pzhegvx(processeur,matrice1,matrice2,resultat,eigen,communicateur)
   use defs_scalapack
   INTEGER,INTENT(in) :: communicateur
   TYPE(matrice_scalapack),INTENT(in) :: matrice1
   TYPE(matrice_scalapack),INTENT(in) :: matrice2
   TYPE(processeur_scalapack),INTENT(in) :: processeur
   TYPE(matrice_scalapack),INTENT(inout) :: resultat
   DOUBLE PRECISION,DIMENSION(:),INTENT(inout) :: eigen
  end subroutine matrice_pzhegvx
 end interface

 interface
  subroutine timab(nn,option,tottim)
   use defs_basis
   integer,intent(in) :: nn
   integer,intent(in) :: option
   real(dp),intent(out) :: tottim(2)
  end subroutine timab
 end interface

 interface
  subroutine time_accu(nn,return_ncount,tottim)
   use defs_basis
   integer,intent(in) :: nn
   integer,intent(out) :: return_ncount
   real(dp),intent(out) :: tottim(2)
  end subroutine time_accu
 end interface

 interface
  subroutine timein(cpu,wall)
   use defs_basis
   real(dp),intent(out) :: cpu
   real(dp),intent(out) :: wall
  end subroutine timein
 end interface

 interface
  subroutine wrtout(unit,message,mode_paral)
   integer,intent(in) :: unit
   character(len=500),intent(inout) :: message
   character(len=4),intent(in) :: mode_paral
  end subroutine wrtout
 end interface

end module interfaces_01manage_mpi
!!***
