!{\src2tex{textfont=tt}}
!!****f* ABINIT/setup_hamilt
!! NAME
!! setup_hamilt
!!
!! FUNCTION 
!!  calculate matrix elements of the Hartree potential for the input wavefunctions 
!!
!! COPYRIGHT
!!  Copyright (C) 2005-2007 ABINIT group (FBruneval, MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  nfft= number of FFT grid points 
!!  ngfft1,ngfft2,ngfft3=FFT grid dimensions
!!  npwvec= number of G-vectors  
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  ucvol= volume of the unit cell
!!  mpi_enreg=information about MPI parallelization
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  sp=sigma_parameters (see the definition of this structured datatype)
!!  gvec(3,npwvec)= reduced coordinates of each plane wave in reciprocal space
!!  en(sp%nk,sp%nb,nsppol)= energies per each k-point, band and spin
!!  gmet(3,3)=metrix tensor in G space in Bohr**-2.
!!  kibz(3,sp%nk)= reduced coordinates of the irreducible k-points
!!  occ(sp%nk,sp%nb,nsppol)= occupations numbers for each k-point in the IBZ, band and spin 
!!  wtk(sp%nk)= weights for irreducible k-points
!!  rho(nfft)= density in real space
!!  wfg(sp%npwwfn,sp%nb,sp%nk,nsppol)= wavefunctions in real space
!!  wfr(nfft,sp%nb,sp%nk,nsppol)= wavefunctions in reciprocal space
!!
!! OUTPUT
!!  hhartr(sp%nb,sp%nb,sp%nk,nsppol) contains $\langle b1,k,s | v_{H} | b2,k,s \rangle$
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      zheev
!!
!! SOURCE
!FBruneval 040928
!

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine hartrham(dtset,sp,gmet,ucvol,ngfft1,ngfft2,ngfft3,nfft,&
& npwvec,gvec,kibz,wtk,nsppol,wfr,wfg,rho,occ,en,hhartr,mpi_enreg,min_band_proc,max_band_proc,parallelism_is_on_bands)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_12ffts
 use interfaces_13xc
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!MG why inout intent?
!scalars
 integer,intent(in) :: max_band_proc,min_band_proc,nfft,ngfft1,ngfft2,ngfft3
 integer,intent(in) :: npwvec,nsppol
 real(dp),intent(in) :: ucvol
 logical,intent(in) :: parallelism_is_on_bands
 type(MPI_type),intent(inout) :: mpi_enreg
 type(dataset_type),intent(in) :: dtset
 type(sigma_parameters),intent(in) :: sp
!arrays
 integer,intent(in) :: gvec(3,npwvec)
 real(dp),intent(in) :: en(sp%nk,min_band_proc:max_band_proc,nsppol),gmet(3,3)
 real(dp),intent(in) :: kibz(3,sp%nk)
 real(dp),intent(in) :: occ(sp%nk,min_band_proc:max_band_proc,nsppol)
 real(dp),intent(in) :: wtk(sp%nk)
 real(dp),intent(inout) :: rho(nfft)
 complex,intent(in) :: wfg(sp%npwwfn,min_band_proc:max_band_proc,sp%nk,nsppol)
 complex,intent(in) :: wfr(nfft,min_band_proc:max_band_proc,sp%nk,nsppol)
 complex,intent(out) :: hhartr(sp%nb,sp%nb,sp%nk,nsppol)

!Local variables -------------------------
!scalars
 integer :: ib,ib1,ib2,ier,ig,ig1,ig2,ig3,ik,ir,ir1,ir2,ir3,is,nb,spaceComm
 real(dp) :: eband,ecut,ehartr,ekin,g1,g2,g3,gsq,gsqcut,rtmp
 complex :: ctmp,ctmp1,ctmp2
!arrays
 integer :: ngfft(18)
 real(dp) :: at(3),kinpw(npwvec),qphon(3),rhog(2,nfft),vhartr(nfft)

! *********************************************************************

!DEBUG
!write(6,*)' hartrham : enter '
!ENDDEBUG

 ! Next line added by YP
 ngfft(:)=0
 ngfft(1)=ngfft1
 ngfft(2)=ngfft2
 ngfft(3)=ngfft3
 ngfft(4)=2*(ngfft(1)/2)+1
 ngfft(5)=2*(ngfft(2)/2)+1
 ngfft(6)=ngfft(3)
 ngfft(7)=200
 ngfft(8)=256
 ngfft(9)=0
 ngfft(10)=1
 ngfft(11)=0
 ngfft(12)=ngfft2
 ngfft(13)=ngfft3
 ngfft(14)=0

 gsqcut=-1.0
 do ig=1,npwvec
  g1=real(gvec(1,ig))
  g2=real(gvec(2,ig))
  g3=real(gvec(3,ig))
  gsq=gmet(1,1)*g1**2+gmet(2,2)*g2**2+gmet(3,3)*g3**2+ &
&                2.0*(gmet(1,2)*g1*g2+gmet(1,3)*g1*g3+gmet(2,3)*g2*g3)
  gsqcut=max(gsqcut,gsq)
 end do

 call fourdp(1,rhog,rho,-1,mpi_enreg,nfft,ngfft,4)

!DEBUG
! write(*,*)'DEBUG setup_hamilt *** number of electrons *** ',rhog(1,1)*ucvol
!ENDDEBUG

!calculate band energy
!MG060923 added external loop on spin  
! weights should be normalized before entering the loop
! this part should be optimized by changing the order of the loops and 
! by adding a condition on the occupations
 eband=0
 do is=1,nsppol
  do ik=1,sp%nk
   do ib=1,sp%nb
    if(parallelism_is_on_bands)then
     if(minval(abs(mpi_enreg%proc_distrb(ib,:,:)-mpi_enreg%me))/=0) cycle
    end if
    eband=eband+wtk(ik)/sum(wtk(:))*en(ik,ib,is)*occ(ik,ib,is)
   end do ! ib
  end do ! ik
 end do ! is
 write(*,*) '*** Band Energy  ***',eband

 if(parallelism_is_on_bands) call xsum_mpi_dpv(eband,spaceComm,ier)
  
!hartree potential and energy
 qphon(:)=0._dp
 call hartre(1,gmet,gsqcut,0,mpi_enreg,nfft,ngfft,qphon,rhog,vhartr)
 write(6,*) '*** Hartree Energy *** ',0.5*ucvol/nfft*sum( rho(:)*vhartr(:) )

!MG060923 added external loop on spin
!Also these loops should be optimized
 do is=1,nsppol
  do ik=1,sp%nk
   do ib2=1,sp%nb
    if(parallelism_is_on_bands)then
     if(minval(abs(mpi_enreg%proc_distrb(ib2,:,:)-mpi_enreg%me))/=0) cycle
    end if
    do ib1=1,sp%nb
     if(parallelism_is_on_bands)then
      if(minval(abs(mpi_enreg%proc_distrb(ib1,:,:)-mpi_enreg%me))/=0) cycle
     end if
     hhartr(ib1,ib2,ik,is)=sum(vhartr(:)*conjg(wfr(:,ib1,ik,is))*wfr(:,ib2,ik,is))/nfft
    end do ! ib1
   end do ! ib2
  end do ! ik
 end do ! is

!DEBUG
!check hartree energy a second time
! ehartr=0
! do is=1,nsppol
!  do ik=1,sp%nk
!   do ib1=1,sp%nb
!    ehartr=ehartr+0.5*wtk(ik)/sum(wtk(:))*hhartr(ib1,ib1,ik,is)*occ(ik,ib1,is)
!   end do
!  end do
! end do 
! write(*,*)'DEBUG setup_hamilt hartree2',ehartr
!ENDDEBUG

end subroutine hartrham

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! FUNCTION 
!  Calculate the (approximate) matrix elements of an operator in the quasi-particle basis set.
!  starting from the corresponding matrix elements in the KS representation
!  and the components of the QP wavefunctions along the KS basis  
!
! COPYRIGHT
!  Copyright (C) 2005-2007 ABINIT group (FBruneval, MG)
!  This file is distributed under the terms of the
!  GNU General Public License, see ~abinit/COPYING
!  or http://www.gnu.org/copyleft/gpl.txt .
!
! INPUTS
!  nb=number of bands
!  nk=number of k-points in the IBZ
!  ns=1 for unpolarized, 2 for spin-polarized
!  c(nb,nb,nk,ns)= contains $\langle \psi^{KS}_{n'ks} | \psi^{QP}_{nks} \rangle $
!
! OUTPUT
!  (see side effects)
!
! SIDE EFFECTS
! Input/Output
!  in input  h(nb,nb,nk,ns) contains the matrix elements of the operator in the KS representation
!  in output h(nb,nb,nk,ns) contains the matrix elements in the QP basis set
!
! NOTES
!  The operator whose matrix elements are calculated must be diagonal both in spin
!  and in the crystalline impulsum k 
!
subroutine ham_changebasis(nb,nk,ns,c,h)
 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

 integer,intent(in) :: nb,nk,ns
 complex,intent(in) :: c(nb,nb,nk,ns)
 complex,intent(inout) :: h(nb,nb,nk,ns)
!local variables
!scalars
 integer :: ik,ib1,ib2,ib3,ib4,is,istat
 character(len=500) :: message
!arrays
 complex :: ctmp(nb,nb)
 complex,allocatable :: htmp(:,:,:,:)

 allocate(htmp(nb,nb,nk,ns),stat=istat)
 if (istat/=0) then 
  write(message,'(5a,f10.2,a)')     &
&  ' ham_changebasis: ERROR -',ch10,&
&  ' out of memory in htmp ',ch10,  &
&  ' requiring ',nb*nb*nk*ns*8/(1024._dp**2),' Mb'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

 htmp(:,:,:,:)=h(:,:,:,:)
 h(:,:,:,:)=0

!MG060923 added external loop on spin
 do is=1,ns
  do ik=1,nk
!  do ib4=1,nb
!   do ib3=1,nb
!    do ib2=1,nb
!     do ib1=1,nb
!      h(ib3,ib4,ik)=h(ib3,ib4,ik)+conjg(c(ib1,ib3,ik))*c(ib2,ib4,ik)*htmp(ib1,ib2,ik)
!     end do
!    end do
!   end do
!  end do
   ctmp(:,:)=matmul(htmp(:,:,ik,is),c(:,:,ik,is))
   h(:,:,ik,is)=matmul(conjg(transpose(c(:,:,ik,is))),ctmp(:,:))
  end do
 end do 

end subroutine ham_changebasis

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! INPUTS
!!  minbnd,maxbnd=min and max band index for GW corrections (for this k-point)
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  hhartree(minbnd:maxbnd,minbnd:maxbnd,nsppol)=matrix elements of $T+V_{ext}+V_H$ in the 
!!   quasi-particle basis
!!  sigxme(minbnd:maxbnd,minbnd:maxbnd,nsppol)=matrix elements of $\Sigma_x$
!!  sigcme(minbnd:maxbnd,minbnd:maxbnd,nsppol)=matrix elements of $\Sigma_c(\epsilon_{KS})$
!! OUTPUT
!!  en_qp(minbnd:maxbnd,nsppol)=quasi particle energies obtained diagonalizing $H+\Sigma$
!!  eigvec_qp(minbnd:maxbnd,minbnd:maxbnd,nsppol)=components of the QP wavefunctions

subroutine diago_hamilt(minbnd,maxbnd,nsppol,hhartree,sigxme,sigcme,eigvec_qp,en_qp)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!in/out
 integer,intent(in) :: minbnd,maxbnd,nsppol
 complex,intent(in) :: hhartree(minbnd:maxbnd,minbnd:maxbnd,nsppol)
 complex,intent(in) :: sigxme(minbnd:maxbnd,minbnd:maxbnd,nsppol)
 complex,intent(in) :: sigcme(minbnd:maxbnd,minbnd:maxbnd,nsppol)
 complex,intent(inout) :: eigvec_qp(minbnd:maxbnd,minbnd:maxbnd,nsppol)
 real(dp),intent(out) :: en_qp(minbnd:maxbnd,nsppol)
!local variables
!scalars
 integer :: ib,is,nmatrix
 complex :: htotal(minbnd:maxbnd,minbnd:maxbnd,nsppol)
 integer :: lwork,info
 character(len=500) :: message
!arrays
 complex(dp),allocatable :: hdp(:,:),work(:)
 real(dp),allocatable :: eig(:),rwork(:)

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

#ifdef __VMS
!DEC$ ATTRIBUTES ALIAS:'ZHEEV' :: zheev
#endif

 write(message,'(a)')' diagonalize the QP Hamiltonian'
 call wrtout(6,message,'COLL')

 !size of the matrix
 nmatrix=maxbnd-minbnd+1


!MG added last dimension for spin
  htotal(:,:,:)=hhartree(:,:,:)+sigxme(:,:,:)+sigcme(:,:,:)
 !hermitianize the hamiltonian
 do is=1,nsppol
  htotal(:,:,is)=0.5 * ( htotal(:,:,is) + conjg(transpose(htotal(:,:,is))) )
 end do 

 lwork=2*nmatrix-1
 allocate(hdp(nmatrix,nmatrix),eig(nmatrix),work(lwork),rwork(3*nmatrix-2))

 do is=1,nsppol
  hdp(:,:)=htotal(minbnd:maxbnd,minbnd:maxbnd,is)

  call zheev('v','u',nmatrix,hdp,nmatrix,eig,work,lwork,rwork,info)

  eigvec_qp(minbnd:maxbnd,minbnd:maxbnd,is)=hdp(:,:)
  en_qp(minbnd:maxbnd,is)=eig(:)
 end do 

 deallocate(hdp,eig,work,rwork)

!DEBUG
! do ib=minbnd,maxbnd
!  write(*,'(i3,1x,9(f12.5)))') ib,hhartree(ib,ib)*Ha_eV,real(sigxme(ib,ib))*Ha_eV,&
!&  sigcme(ib,ib)*Ha_eV,htotal(ib,ib)*Ha_eV,en_qp(ib)*Ha_eV,abs(eigvec_qp(ib,ib))
! end do
!ENDDEBUG

end subroutine diago_hamilt

!!***
