!{\src2tex{textfont=tt}}
!!****f* ABINIT/findkp
!! NAME
!! findkp
!!
!! FUNCTION
!! Check if the k-point is in the set of the kbz
!! (subtracting the reciprocal vector g0)
!! and return the index number and the reciprocal vector g0
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  k(3)=k point to be found in the BZ
!!  kbz(3,nkbz)=coordinates of k points in BZ
!!  nkbz=number of k points in BZ
!!
!! OUTPUT
!!  logical function findkp= 1 if found
!!  ik=index of the k opint in BZ
!!  g0=reciprocal vector to be subtracted
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

logical function findkp(nkbz,kbz,ik,k,g0)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_15gw, except_this_one => findkp
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nkbz
 integer,intent(out) :: ik
!arrays
 integer,intent(out) :: g0(3)
 real(dp),intent(in) :: k(3),kbz(3,nkbz)

!Local variables ------------------------------
!scalars
 integer :: ig1,ig2,ig3,ikp
 logical :: yetfound
!arrays
 real(dp) :: kdiff(3),kp(3)

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 integer :: itst0
#endif
!End of the abilint section

 yetfound=.false.
 ik=0 ; g0(:)=0
 do ikp=1,nkbz
   kp(:)=kbz(:,ikp)
!  compute kdiff=k''-k+G0
   do ig1=-2,2
     kdiff=kp(1)-k(1)+ig1
     do ig2=-2,2
       kdiff(2)=kp(2)-k(2)+ig2
       do ig3=-2,2
         kdiff(3)=kp(3)-k(3)+ig3
!        check if kdiff=k''-k+G0 is null
         if(itst0(kdiff)==1) then
!          check if k has been yet found
           if(yetfound) then
             write(6,*) '**error,findkp 1: kp yet found'
             write(6,*) k
             write(6,*) ik,kbz(:,ik),g0
             write(6,*) ikp,kbz(:,ikp),ig1,ig2,ig3
             stop 'kp yet found'
           end if
           yetfound=.true.
           ik=ikp
           g0(1)=ig1
           g0(2)=ig2
           g0(3)=ig3
         end if
       end do
     end do
   end do
 end do
 findkp=yetfound
 return
 end function findkp
!!***
