#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Vampire: The Masquerade - Shadows of New York
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220329.5

# Set game-specific variables

GAME_ID='vampire-the-masquerade-shadows-of-new-york'
GAME_NAME='Vampire the Masquerade - Shadows of New York'

ARCHIVE_BASE_1='vampire_the_masquerade_shadows_of_new_york_1_0_1_51032.sh'
ARCHIVE_BASE_1_MD5='0ec3a59f889b30e7d632f65dcdf0ac6b'
ARCHIVE_BASE_1_TYPE='mojosetup'
ARCHIVE_BASE_1_SIZE='3400000'
ARCHIVE_BASE_1_VERSION='1.0.1-gog51032'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/vampire_the_masquerade_shadows_of_new_york'

ARCHIVE_BASE_0='vampire_the_masquerade_shadows_of_new_york_1_0_0_41075.sh'
ARCHIVE_BASE_0_MD5='e7880d6e417f81f47b079c9cdc4fb907'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='3300000'
ARCHIVE_BASE_0_VERSION='1.0.0-gog41075'

UNITY3D_NAME='Vampire the Masquerade - Shadows of New York'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN_FILES='
Vampire?the?Masquerade?-?Shadows?of?New?York.x86_64
Vampire?the?Masquerade?-?Shadows?of?New?York_Data/MonoBleedingEdge
Vampire?the?Masquerade?-?Shadows?of?New?York_Data/Plugins
UnityPlayer.so'
ARCHIVE_GAME_DATA_FILES='
Vampire?the?Masquerade?-?Shadows?of?New?York_Data'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
