#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Broken Minds
# send your bug reports to contact@dotslashplay.it
###

script_version=20240602.3

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='broken-minds'
GAME_NAME='Broken Minds'

ARCHIVE_BASE_0_NAME='broken-minds-win-osx-linux.zip'
ARCHIVE_BASE_0_MD5='bd76cf6fded5a9712125fdcd73daac28'
ARCHIVE_BASE_0_SIZE='1900000'
ARCHIVE_BASE_0_VERSION='1.0-itch1'
ARCHIVE_BASE_0_URL='https://lockedon.itch.io/broken-minds'

CONTENT_PATH_DEFAULT='BROKEN_MINDS-1.0-market/game'
CONTENT_FONTS_MAIN_PATH="${CONTENT_PATH_DEFAULT}/fonts"
CONTENT_FONTS_MAIN_FILES='
ManicDepressive_new.ttf
Menlo.ttc'
CONTENT_GAME_MAIN_FILES='
ambi
BGS
cache
chars
CTSNES
HUD
map
menus
music
SCENERIOS
sfx
side
UI
Shoko.otf
script_version.txt
*.png
*.rpy
*.rpyc'
CONTENT_DOC_MAIN_PATH='BROKEN_MINDS-1.0-market'
CONTENT_DOC_MAIN_FILES='
README.html'

APP_MAIN_TYPE='renpy'
APP_MAIN_ICON='icon.png'

# Convert the shipped icon into a standard size

SCRIPT_DEPS="${SCRIPT_DEPS:-} convert"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Convert the shipped icon into a standard size.
	icon_source=$(icon_path 'APP_MAIN_ICON')
	convert "$icon_source" -resize 256 "${icon_source}_resized.png"
	mv "${icon_source}_resized.png" "$icon_source"
)

# Include game data

content_inclusion_icons
content_inclusion_default
## The game engine looks for fonts in a hardcoded path.
fonts_destination="$(package_path $(current_package))$(path_game_data)/fonts"
mkdir --parents "$fonts_destination"
ln --symbolic \
	"$(path_fonts_ttf)/ManicDepressive_new.ttf" \
	"$(path_fonts_ttf)/Menlo.ttc" \
	"$fonts_destination"

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
