#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2021, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright (c) 2016-2021, Mopi
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Tidalis
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20210731.5

# Set game-specific variables

GAME_ID='tidalis'
GAME_NAME='Tidalis'

ARCHIVE_BASE_32BIT_0='Tidalis_Linux32_v1.5.zip'
ARCHIVE_BASE_32BIT_0_MD5='c5fd83dd7e6221a5a91e326fc36c9043'
ARCHIVE_BASE_32BIT_0_SIZE='630000'
ARCHIVE_BASE_32BIT_0_VERSION='1.5-humble160517'
ARCHIVE_BASE_32BIT_0_URL='https://www.humblebundle.com/store/tidalis'

ARCHIVE_BASE_64BIT_0='Tidalis_Linux64_v1.5.zip'
ARCHIVE_BASE_64BIT_0_MD5='d5893c3ed40ab2266359c88b361ddb57'
ARCHIVE_BASE_64BIT_0_SIZE='630000'
ARCHIVE_BASE_64BIT_0_VERSION='1.5-humble160517'
ARCHIVE_BASE_64BIT_0_URL='https://www.humblebundle.com/store/tidalis'

ARCHIVE_DOC_PATH='.'
ARCHIVE_DOC_FILES='TidalisLicense.txt *.pdf'

ARCHIVE_GAME_BIN_PATH='.'
ARCHIVE_GAME_BIN_FILES_32BIT='
TidalisLinux.x86
TidalisLinux_Data/Mono/x86
TidalisLinux_Data/Plugins/x86'
ARCHIVE_GAME_BIN_FILES_64BIT='
TidalisLinux.x86_64
TidalisLinux_Data/Mono/x86_64
TidalisLinux_Data/Plugins/x86_64'

ARCHIVE_GAME_DATA_PATH='.'
ARCHIVE_GAME_DATA_FILES='
RuntimeData
Tidalis_Data
sysrequirements.txt
TidalisLinux_Data/mainData
TidalisLinux_Data/Managed
TidalisLinux_Data/PlayerConnectionConfigFile
TidalisLinux_Data/Resources
TidalisLinux_Data/sharedassets0.assets'

APP_MAIN_TYPE='native'
APP_MAIN_EXE_32BIT='TidalisLinux.x86'
APP_MAIN_EXE_64BIT='TidalisLinux.x86_64'
APP_MAIN_ICON='TidalisLinux_Data/Resources/UnityPlayer.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH_32BIT='32'
PKG_BIN_ARCH_64BIT='64'
PKG_BIN_DEPS="$PKG_DATA_ID glibc libstdc++ glx xcursor libGLU.so.1 libX11.so.6"
PKG_BIN_DEPS_ARCH_32BIT='lib32-libxext'
PKG_BIN_DEPS_ARCH_64BIT='libext'
PKG_BIN_DEPS_DEB='libxext6'
PKG_BIN_DEPS_GENTOO_32BIT='x11-libs/libXext[abi_x86_32]'
PKG_BIN_DEPS_GENTOO_64BIT='x11-libs/libXext'

# Load common functions

target_version='2.14'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "${path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
set_standard_permissions "$PLAYIT_WORKDIR/gamedata"
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
APP_MAIN_EXE=$(get_context_specific_value 'archive' 'APP_MAIN_EXE')
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
