#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Morphopolis
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220701.1

GAME_ID='morphopolis'
GAME_NAME='Morphopolis'

ARCHIVE_BASE_0='setup_morphopolis_1.0_(22453).exe'
ARCHIVE_BASE_0_MD5='325f1bbbcc1c7a657530d70db9f1bb1a'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='1.0-gog22453'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/morphopolis'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
irrklang.dll
project.exe
app.config.txt
app.icf'
ARCHIVE_GAME_DATA_PATH='.'
ARCHIVE_GAME_DATA_FILES='
anims
*.xml
font
sounds
textures'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='project.exe'
APP_MAIN_ICON='app/goggame-1559432711.ico'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS="$APP_WINE_LINK_DIRS"'
saves:users/$(id -un)/Application Data/Morphopolis'
DATA_DIRS="$DATA_DIRS ./saves"
CONFIG_FILES='./app.config.txt'

# icotool is used for icon .ico → .png conversion

SCRIPT_DEPS="$SCRIPT_DEPS icotool"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Work around "insufficient image data" issue with convert from imagemagick

icon_extract_png_from_ico() {
	local source_file destination_directory
	source_file="$1"
	destination_directory="$2"
	icotool --extract --output="$destination_directory" "$source_file" 2>/dev/null
}

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
icons_get_from_workdir 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
