/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_LogEntry.h"

CMPIObjectPath* OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_LogEntry& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_LogEntry_classnames[0], OpenDRIM_LogEntry_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_LogEntry& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.RecordFormat_isNULL)
		ci.setProperty("RecordFormat", instance.RecordFormat);

	if (!instance.RecordData_isNULL)
		ci.setProperty("RecordData", instance.RecordData);

	if (!instance.Locale_isNULL)
		ci.setProperty("Locale", instance.Locale);

	if (!instance.LogInstanceID_isNULL)
		ci.setProperty("LogInstanceID", instance.LogInstanceID);

	if (!instance.LogName_isNULL)
		ci.setProperty("LogName", instance.LogName);

	if (!instance.RecordID_isNULL)
		ci.setProperty("RecordID", instance.RecordID);

	if (!instance.CreationTimeStamp_isNULL)
		ci.setPropertyDatetime("CreationTimeStamp", instance.CreationTimeStamp);

	_L_;
	return ci.getHdl();
}

void OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_LogEntry& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_LogEntry& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("RecordFormat", instance.RecordFormat) == OK)
		instance.RecordFormat_isNULL = false;

	if (inst.getProperty("RecordData", instance.RecordData) == OK)
		instance.RecordData_isNULL = false;

	if (inst.getProperty("Locale", instance.Locale) == OK)
		instance.Locale_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("LogInstanceID", instance.LogInstanceID) == OK)
		instance.LogInstanceID_isNULL = false;

	if (inst.getProperty("LogName", instance.LogName) == OK)
		instance.LogName_isNULL = false;

	if (inst.getProperty("RecordID", instance.RecordID) == OK)
		instance.RecordID_isNULL = false;

	if (inst.getPropertyDatetime("CreationTimeStamp", instance.CreationTimeStamp) == OK)
		instance.CreationTimeStamp_isNULL = false;

	_L_;
}

