/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class FileTypeBox
extends JP2Box {
    public FileTypeBox(RandomAccessFile randomAccessFile) {
        super(randomAccessFile);
    }

    public FileTypeBox(RandomAccessFile randomAccessFile, JP2Box jP2Box) {
        super(randomAccessFile);
    }

    @Override
    public boolean readBox() throws IOException {
        String string = this._module.read4Chars(this._dstrm);
        this._module.addProperty(new Property("Brand", PropertyType.STRING, string));
        if (!"jp2 ".equals(string)) {
            this._module.setJP2Compliant(false);
        }
        if (!"jpx ".equals(string)) {
            this._module.setJPXCompliant(false);
        }
        long l = this._module.readUnsignedInt(this._dstrm);
        this._module.addProperty(new Property("MinorVersion", PropertyType.LONG, new Long(l)));
        int n = ((int)this._boxHeader.getLength() - 16) / 4;
        if (n < 1) {
            this._repInfo.setMessage(new ErrorMessage("Empty compatibility list in File Type Box", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(8);
        for (int i = 0; i < n; ++i) {
            String string2 = this._module.read4Chars(this._dstrm);
            char[] cArray = string2.toCharArray();
            boolean bl2 = false;
            for (int j = 0; j < cArray.length; ++j) {
                char c = cArray[j];
                stringBuffer.append(Integer.toHexString(c));
                if (c != '\u0000' && c < '\u007f') continue;
                bl2 = true;
                if (bl) continue;
                bl = true;
                this._repInfo.setValid(false);
                this._repInfo.setMessage(new ErrorMessage("Non-ASCII characters in compatibility item of File Type Box", this._module.getFilePos()));
            }
            if (!bl2) {
                arrayList.add(string2);
                continue;
            }
            arrayList.add(this.hexifyString(string2));
        }
        this._module.addProperty(new Property("Compatibility", PropertyType.STRING, PropertyArity.LIST, arrayList));
        return true;
    }

    private String hexifyString(String string) {
        StringBuffer stringBuffer = new StringBuffer(2 * string.length() + 2);
        stringBuffer.append("0X");
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            String string2 = Integer.toHexString(cArray[i]);
            if (string2.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getSelfPropName() {
        return "File Type Box";
    }
}

