/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.Parser;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import edu.harvard.hul.ois.jhove.module.pdf.StreamTokenizer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public class ObjectStream {
    private PdfStream _ostrm;
    private PdfDictionary _dict;
    private int _numObjects;
    private int _firstOffset;
    private Parser _parser;
    private RandomAccessFile _raf;
    private Map _index;

    public ObjectStream(PdfStream pdfStream, RandomAccessFile randomAccessFile) {
        this._ostrm = pdfStream;
        this._raf = randomAccessFile;
        this._dict = pdfStream.getDict();
        this._parser = new Parser(new StreamTokenizer(randomAccessFile, this._ostrm.getStream()));
    }

    public boolean isValid() {
        try {
            PdfObject pdfObject = this._dict.get("Type");
            String string = null;
            if (pdfObject instanceof PdfSimpleObject) {
                string = ((PdfSimpleObject)pdfObject).getStringValue();
            }
            if (!"ObjStm".equals(string)) {
                return false;
            }
            pdfObject = this._dict.get("N");
            if (!(pdfObject instanceof PdfSimpleObject)) {
                return false;
            }
            this._numObjects = ((PdfSimpleObject)pdfObject).getIntValue();
            pdfObject = this._dict.get("First");
            if (!(pdfObject instanceof PdfSimpleObject)) {
                return false;
            }
            this._firstOffset = ((PdfSimpleObject)pdfObject).getIntValue();
            pdfObject = this._dict.get("Extends");
            if (pdfObject != null) {
                // empty if block
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void readIndex() throws PdfException, IOException {
        Stream stream = this._ostrm.getStream();
        stream.setFilters(this._ostrm.getFilters());
        stream.initRead(this._raf);
        this._index = new HashMap(this._numObjects);
        for (int i = 0; i < this._numObjects; ++i) {
            Integer n = new Integer(stream.readAsciiInt());
            Integer n2 = new Integer(stream.readAsciiInt());
            this._index.put(n, n2);
        }
    }

    public PdfObject getObject(int n) throws PdfException {
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)this._index.get(n2);
        try {
            if (n3 != null) {
                int n4 = n3;
                this._parser.seek(n4 + this._firstOffset);
                return this._parser.readObject();
            }
            return null;
        }
        catch (IOException iOException) {
            throw new PdfMalformedException("Offset out of bounds in object stream");
        }
    }
}

