#!/bin/csh
#
# Copyright (C) 2009-2019 Intel Corporation. All Rights Reserved.
# 
# The source code contained or described herein and all documents
# related to the source code ("Material") are owned by Intel Corporation
# or its suppliers or licensors.  Title to the Material remains with
# Intel Corporation or its suppliers and licensors.  The Material is
# protected by worldwide copyright and trade secret laws and treaty
# provisions.  No part of the Material may be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or
# disclosed in any way without Intel's prior express written permission.
# 
# No license under any patent, copyright, trade secret or other
# intellectual property right is granted to or conferred upon you by
# disclosure or delivery of the Materials, either expressly, by
# implication, inducement, estoppel or otherwise.  Any license under
# such intellectual property rights must be express and approved by
# Intel in writing.

# C Shell script for the Intel(R) Parallel Studio XE 2020 for Linux* OS

set SCRIPTPATH=%INSTALLDIR%
set ROOTPATH=%INSTALLDIR_ROOT%
set INTEL_TARGET_ARCH="intel64"
set ITAC_PARAM=""

while ($#argv > 0)
    set arg=$argv[1]
    if ( x"$arg" != x"" ) then
        switch ($arg)
            case ia32:
                set INTEL_TARGET_ARCH="ia32"
                breaksw
            case intel64:
                set INTEL_TARGET_ARCH="intel64"
                breaksw
            case impi64:
                set ITAC_PARAM="$arg"
                breaksw
        endsw
    endif
    shift
end

echo "Intel(R) Parallel Studio XE 2020 for Linux*"
echo "Copyright (C) 2009-2019 Intel Corporation. All rights reserved."

if ( -f "$SCRIPTPATH/compilers_and_libraries_2020/linux/bin/compilervars.csh" ) then
    source "$SCRIPTPATH/compilers_and_libraries_2020/linux/bin/compilervars.csh" "$INTEL_TARGET_ARCH"
endif

if ( x"$INTEL_TARGET_ARCH" == x"intel64" ) then
    if ( -f "$SCRIPTPATH/clck_2019/bin/clckvars.csh" ) then
        source "$SCRIPTPATH/clck_2019/bin/clckvars.csh"
    endif
endif

if ( -f "$SCRIPTPATH/itac_2020/bin/itacvars.csh" ) then
    source "$SCRIPTPATH/itac_2020/bin/itacvars.csh" "$ITAC_PARAM"
endif

if ( -f "$SCRIPTPATH/vtune_profiler_2020/vtune-vars.csh" ) then
    source "$SCRIPTPATH/vtune_profiler_2020/vtune-vars.csh" quiet
endif

if ( -f "$SCRIPTPATH/inspector_2020/inspxe-vars.csh" ) then
    source "$SCRIPTPATH/inspector_2020/inspxe-vars.csh" quiet
endif

if ( -f "$SCRIPTPATH/advisor_2020/advixe-vars.csh" ) then
    source "$SCRIPTPATH/advisor_2020/advixe-vars.csh" quiet
endif

if ( -f "$ROOTPATH/intelpython3/bin/activate" ) then
    setenv SETVARS_CALL 1
    if !($?PATH) then
        setenv PATH "$ROOTPATH/intelpython3/bin"
    else
        setenv PATH "$ROOTPATH/intelpython3/bin:${PATH}"
    endif
    setenv SETVARS_CALL
endif

set path = ($path "$SCRIPTPATH/bin")

if !($?INTEL_LICENSE_FILE) then
    setenv INTEL_LICENSE_FILE "$ROOTPATH/licenses"
else
    setenv INTEL_LICENSE_FILE "$ROOTPATH/licenses:${INTEL_LICENSE_FILE}"
endif
