/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.ComparatorContext;
import java.io.File;
import java.util.Comparator;

public class AlphanumFileComparator
implements Comparator<File> {
    private boolean _caseSensitive;
    public static final ComparatorContext CONTEXT = new ComparatorContext("Alphanum");
    public static final ComparatorContext CONTEXT_IGNORE_CASE = new ComparatorContext("Alphanum_Ignorecase");

    public AlphanumFileComparator() {
        this(true);
    }

    public AlphanumFileComparator(boolean bl) {
        this._caseSensitive = bl;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private String getChunk(CharSequence charSequence, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = charSequence.charAt(n2);
        stringBuilder.append(c);
        ++n2;
        if (this.isDigit(c)) {
            while (n2 < n && this.isDigit(c = charSequence.charAt(n2))) {
                stringBuilder.append(c);
                ++n2;
            }
        } else {
            while (n2 < n && !this.isDigit(c = charSequence.charAt(n2))) {
                stringBuilder.append(c);
                ++n2;
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int compare(File file, File file2) {
        int n = 0;
        int n2 = 0;
        String string = file.getName();
        String string2 = file2.getName();
        int n3 = string.length();
        int n4 = string2.length();
        while (n < n3 && n2 < n4) {
            int n5;
            String string3 = this.getChunk(string, n3, n);
            n += string3.length();
            String string4 = this.getChunk(string2, n4, n2);
            n2 += string4.length();
            if (this.isDigit(string3.charAt(0)) && this.isDigit(string4.charAt(0))) {
                int n6 = string3.length();
                n5 = n6 - string4.length();
                if (n5 == 0) {
                    for (int i = 0; i < n6; ++i) {
                        n5 = string3.charAt(i) - string4.charAt(i);
                        if (n5 == 0) continue;
                        return n5;
                    }
                }
            } else {
                int n7 = n5 = this.isCaseSensitive() ? string3.compareTo(string4) : string3.compareToIgnoreCase(string4);
            }
            if (n5 == 0) continue;
            return n5;
        }
        return n3 - n4;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }
}

