/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import net.sf.picard.illumina.parser.readers.BinaryFileIterator;
import net.sf.picard.illumina.parser.readers.MMapBackedIteratorFactory;
import net.sf.picard.util.UnsignedTypeUtil;

public class LocsFileReader
extends AbstractIlluminaPositionFileReader {
    private static final int HEADER_SIZE = 12;
    private static final int BYTES_1_TO_4 = 1;
    private static final float VERSION = 1.0f;
    private BinaryFileIterator<Float> bbIterator;
    private final long numClusters;
    private int nextCluster;

    public LocsFileReader(File file) {
        super(file);
        this.bbIterator = MMapBackedIteratorFactory.getFloatIterator(12, file);
        ByteBuffer headerBuf = this.bbIterator.getHeaderBytes();
        int firstValue = headerBuf.getInt();
        if (firstValue != 1) {
            throw new PicardException("First header byte of locs files should be 1 value found(" + firstValue + ")");
        }
        float versionNumber = headerBuf.getFloat();
        if (versionNumber != 1.0f) {
            throw new PicardException("First header byte of locs files should be 1.0 value found(" + firstValue + ")");
        }
        this.numClusters = UnsignedTypeUtil.uIntToLong(headerBuf.getInt());
        this.bbIterator.assertTotalElementsEqual(this.numClusters * 2L);
    }

    @Override
    protected AbstractIlluminaPositionFileReader.PositionInfo unsafeNextInfo() {
        float xVal = this.bbIterator.next().floatValue();
        float yVal = this.bbIterator.next().floatValue();
        ++this.nextCluster;
        return new AbstractIlluminaPositionFileReader.PositionInfo(xVal, yVal, this.getLane(), this.getTile());
    }

    @Override
    protected String makeExceptionMsg() {
        return "LocsFileReader(file=" + this.getFile().getAbsolutePath() + ", numClusters=" + this.numClusters + ") ";
    }

    @Override
    public boolean hasNext() {
        return (long)this.nextCluster < this.numClusters;
    }

    public void close() {
        this.bbIterator = null;
    }
}

