(** Media Sizes *)

(** A paper size consists of its unit, width and height. *)
type papersize

(** Make a paper size given its unit, width and height. *)
val make : Units.unit -> float -> float -> papersize

(** Project the unit from a paper size *)
val unit : papersize -> Units.unit

(** Project the width from a paper size. *)
val width : papersize -> float

(** Project the height from a paper size. *)
val height : papersize -> float

(** Flip a paper size between landscape and portrait, swapping its dimensions. *)
val landscape : papersize -> papersize

val a0 : papersize
val a1 : papersize
val a2 : papersize
val a3 : papersize
val a4 : papersize
val a5 : papersize
val a6 : papersize
val a7 : papersize
val a8 : papersize
(** ISO A series paper sizes, portrait. *)

val usletter : papersize
val uslegal : papersize
(** United States paper sizes. portrait. *)

