/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.dom.client.DOMImplTrident;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageSrcIE6;
import com.google.gwt.dom.client.Style;

class DOMImplIE6
extends DOMImplTrident {
    private static boolean isIE6;
    private static boolean isIE6Detected;

    DOMImplIE6() {
    }

    static boolean isIE6() {
        if (!isIE6Detected) {
            isIE6 = DOMImplIE6.isIE6Impl();
            isIE6Detected = true;
        }
        return isIE6;
    }

    private static native boolean isIE6Impl();

    public native void cssClearOpacity(Style var1);

    public native void cssSetOpacity(Style var1, double var2);

    public int getAbsoluteLeft(Element elem) {
        Document doc = elem.getOwnerDocument();
        return (int)Math.floor((double)this.getBoundingClientRectLeft(elem) / this.getZoomMultiple(doc) + (double)doc.getScrollLeft());
    }

    public int getAbsoluteTop(Element elem) {
        Document doc = elem.getOwnerDocument();
        return (int)Math.floor((double)this.getBoundingClientRectTop(elem) / this.getZoomMultiple(doc) + (double)doc.getScrollTop());
    }

    public int getScrollLeft(Element elem) {
        if (this.isRTL(elem)) {
            return super.getScrollLeft(elem) - (elem.getScrollWidth() - elem.getClientWidth());
        }
        return super.getScrollLeft(elem);
    }

    public String imgGetSrc(Element img) {
        if (DOMImplIE6.isIE6()) {
            return ImageSrcIE6.getImgSrc(img);
        }
        return super.imgGetSrc(img);
    }

    public void imgSetSrc(Element img, String src) {
        if (DOMImplIE6.isIE6()) {
            ImageSrcIE6.setImgSrc(img, src);
        } else {
            super.imgSetSrc(img, src);
        }
    }

    public void setScrollLeft(Element elem, int left) {
        if (this.isRTL(elem)) {
            left += elem.getScrollWidth() - elem.getClientWidth();
        }
        super.setScrollLeft(elem, left);
    }

    private double getZoomMultiple(Document doc) {
        if (doc.getCompatMode().equals("CSS1Compat")) {
            return 1.0;
        }
        int bodyOffset = doc.getBody().getOffsetWidth();
        return bodyOffset == 0 ? 1.0 : (double)(doc.getBody().getParentElement().getOffsetWidth() / bodyOffset);
    }
}

