/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright 2022 Collabora Ltd.
 *
 * AUTOMATICALLY GENERATED BY v4l2-tracer-gen.pl DO NOT EDIT
 */

#include "v4l2-tracer-common.h"

struct v4l2_ctrl_h264_sps *retrace_v4l2_ctrl_h264_sps_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_h264_sps *p = (struct v4l2_ctrl_h264_sps *) calloc(1, sizeof(v4l2_ctrl_h264_sps));
	json_object *v4l2_ctrl_h264_sps_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_h264_sps", &v4l2_ctrl_h264_sps_obj))
		v4l2_ctrl_h264_sps_obj = ctrl_obj;

	json_object *profile_idc_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "profile_idc", &profile_idc_obj))
		p->profile_idc = (__u8) json_object_get_int(profile_idc_obj);

	json_object *constraint_set_flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "constraint_set_flags", &constraint_set_flags_obj))
		p->constraint_set_flags = (__u8) s2flags(json_object_get_string(constraint_set_flags_obj), v4l2_h264_sps_flag_def);

	json_object *level_idc_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "level_idc", &level_idc_obj))
		p->level_idc = (__u8) json_object_get_int(level_idc_obj);

	json_object *seq_parameter_set_id_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "seq_parameter_set_id", &seq_parameter_set_id_obj))
		p->seq_parameter_set_id = (__u8) json_object_get_int(seq_parameter_set_id_obj);

	json_object *chroma_format_idc_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "chroma_format_idc", &chroma_format_idc_obj))
		p->chroma_format_idc = (__u8) json_object_get_int(chroma_format_idc_obj);

	json_object *bit_depth_luma_minus8_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "bit_depth_luma_minus8", &bit_depth_luma_minus8_obj))
		p->bit_depth_luma_minus8 = (__u8) json_object_get_int(bit_depth_luma_minus8_obj);

	json_object *bit_depth_chroma_minus8_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "bit_depth_chroma_minus8", &bit_depth_chroma_minus8_obj))
		p->bit_depth_chroma_minus8 = (__u8) json_object_get_int(bit_depth_chroma_minus8_obj);

	json_object *log2_max_frame_num_minus4_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "log2_max_frame_num_minus4", &log2_max_frame_num_minus4_obj))
		p->log2_max_frame_num_minus4 = (__u8) json_object_get_int(log2_max_frame_num_minus4_obj);

	json_object *pic_order_cnt_type_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "pic_order_cnt_type", &pic_order_cnt_type_obj))
		p->pic_order_cnt_type = (__u8) json_object_get_int(pic_order_cnt_type_obj);

	json_object *log2_max_pic_order_cnt_lsb_minus4_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "log2_max_pic_order_cnt_lsb_minus4", &log2_max_pic_order_cnt_lsb_minus4_obj))
		p->log2_max_pic_order_cnt_lsb_minus4 = (__u8) json_object_get_int(log2_max_pic_order_cnt_lsb_minus4_obj);

	json_object *max_num_ref_frames_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "max_num_ref_frames", &max_num_ref_frames_obj))
		p->max_num_ref_frames = (__u8) json_object_get_int(max_num_ref_frames_obj);

	json_object *num_ref_frames_in_pic_order_cnt_cycle_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "num_ref_frames_in_pic_order_cnt_cycle", &num_ref_frames_in_pic_order_cnt_cycle_obj))
		p->num_ref_frames_in_pic_order_cnt_cycle = (__u8) json_object_get_int(num_ref_frames_in_pic_order_cnt_cycle_obj);

	/* __s32 offset_for_ref_frame[255] */
	json_object *offset_for_ref_frame_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "offset_for_ref_frame", &offset_for_ref_frame_obj)) {
		for (size_t i = 0; i < 255; i++) {
			if (json_object_array_get_idx(offset_for_ref_frame_obj, i))
				p->offset_for_ref_frame[i] = (__s32) json_object_get_int(json_object_array_get_idx(offset_for_ref_frame_obj, i));
		}
	}

	json_object *offset_for_non_ref_pic_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "offset_for_non_ref_pic", &offset_for_non_ref_pic_obj))
		p->offset_for_non_ref_pic = (__s32) json_object_get_int(offset_for_non_ref_pic_obj);

	json_object *offset_for_top_to_bottom_field_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "offset_for_top_to_bottom_field", &offset_for_top_to_bottom_field_obj))
		p->offset_for_top_to_bottom_field = (__s32) json_object_get_int(offset_for_top_to_bottom_field_obj);

	json_object *pic_width_in_mbs_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "pic_width_in_mbs_minus1", &pic_width_in_mbs_minus1_obj))
		p->pic_width_in_mbs_minus1 = (__u16) json_object_get_int(pic_width_in_mbs_minus1_obj);

	json_object *pic_height_in_map_units_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "pic_height_in_map_units_minus1", &pic_height_in_map_units_minus1_obj))
		p->pic_height_in_map_units_minus1 = (__u16) json_object_get_int(pic_height_in_map_units_minus1_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_sps_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_h264_sps_flag_def);

	return p;
}

struct v4l2_ctrl_h264_pps *retrace_v4l2_ctrl_h264_pps_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_h264_pps *p = (struct v4l2_ctrl_h264_pps *) calloc(1, sizeof(v4l2_ctrl_h264_pps));
	json_object *v4l2_ctrl_h264_pps_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_h264_pps", &v4l2_ctrl_h264_pps_obj))
		v4l2_ctrl_h264_pps_obj = ctrl_obj;

	json_object *pic_parameter_set_id_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "pic_parameter_set_id", &pic_parameter_set_id_obj))
		p->pic_parameter_set_id = (__u8) json_object_get_int(pic_parameter_set_id_obj);

	json_object *seq_parameter_set_id_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "seq_parameter_set_id", &seq_parameter_set_id_obj))
		p->seq_parameter_set_id = (__u8) json_object_get_int(seq_parameter_set_id_obj);

	json_object *num_slice_groups_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "num_slice_groups_minus1", &num_slice_groups_minus1_obj))
		p->num_slice_groups_minus1 = (__u8) json_object_get_int(num_slice_groups_minus1_obj);

	json_object *num_ref_idx_l0_default_active_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "num_ref_idx_l0_default_active_minus1", &num_ref_idx_l0_default_active_minus1_obj))
		p->num_ref_idx_l0_default_active_minus1 = (__u8) json_object_get_int(num_ref_idx_l0_default_active_minus1_obj);

	json_object *num_ref_idx_l1_default_active_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "num_ref_idx_l1_default_active_minus1", &num_ref_idx_l1_default_active_minus1_obj))
		p->num_ref_idx_l1_default_active_minus1 = (__u8) json_object_get_int(num_ref_idx_l1_default_active_minus1_obj);

	json_object *weighted_bipred_idc_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "weighted_bipred_idc", &weighted_bipred_idc_obj))
		p->weighted_bipred_idc = (__u8) json_object_get_int(weighted_bipred_idc_obj);

	json_object *pic_init_qp_minus26_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "pic_init_qp_minus26", &pic_init_qp_minus26_obj))
		p->pic_init_qp_minus26 = (__s8) json_object_get_int(pic_init_qp_minus26_obj);

	json_object *pic_init_qs_minus26_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "pic_init_qs_minus26", &pic_init_qs_minus26_obj))
		p->pic_init_qs_minus26 = (__s8) json_object_get_int(pic_init_qs_minus26_obj);

	json_object *chroma_qp_index_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "chroma_qp_index_offset", &chroma_qp_index_offset_obj))
		p->chroma_qp_index_offset = (__s8) json_object_get_int(chroma_qp_index_offset_obj);

	json_object *second_chroma_qp_index_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "second_chroma_qp_index_offset", &second_chroma_qp_index_offset_obj))
		p->second_chroma_qp_index_offset = (__s8) json_object_get_int(second_chroma_qp_index_offset_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pps_obj, "flags", &flags_obj))
		p->flags = (__u16) s2flags(json_object_get_string(flags_obj), v4l2_h264_pps_flag_def);

	return p;
}

struct v4l2_ctrl_h264_scaling_matrix *retrace_v4l2_ctrl_h264_scaling_matrix_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_h264_scaling_matrix *p = (struct v4l2_ctrl_h264_scaling_matrix *) calloc(1, sizeof(v4l2_ctrl_h264_scaling_matrix));
	json_object *v4l2_ctrl_h264_scaling_matrix_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_h264_scaling_matrix", &v4l2_ctrl_h264_scaling_matrix_obj))
		v4l2_ctrl_h264_scaling_matrix_obj = ctrl_obj;

	/* __u8 scaling_list_4x4[6][16] */
	int count_scaling_list_4x4 = 0;
	json_object *scaling_list_4x4_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_scaling_matrix_obj, "scaling_list_4x4", &scaling_list_4x4_obj)) {
		for (size_t i = 0; i < 6; i++) {
			for (size_t j = 0; j < 16; j++) {
				if (json_object_array_get_idx(scaling_list_4x4_obj, count_scaling_list_4x4))
					p->scaling_list_4x4[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(scaling_list_4x4_obj, count_scaling_list_4x4++));
			}
		}
	}

	/* __u8 scaling_list_8x8[6][64] */
	int count_scaling_list_8x8 = 0;
	json_object *scaling_list_8x8_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_scaling_matrix_obj, "scaling_list_8x8", &scaling_list_8x8_obj)) {
		for (size_t i = 0; i < 6; i++) {
			for (size_t j = 0; j < 64; j++) {
				if (json_object_array_get_idx(scaling_list_8x8_obj, count_scaling_list_8x8))
					p->scaling_list_8x8[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(scaling_list_8x8_obj, count_scaling_list_8x8++));
			}
		}
	}

	return p;
}

struct v4l2_h264_weight_factors *retrace_v4l2_h264_weight_factors_gen(json_object *ctrl_obj)
{
	struct v4l2_h264_weight_factors *p = (struct v4l2_h264_weight_factors *) calloc(1, sizeof(v4l2_h264_weight_factors));
	json_object *v4l2_h264_weight_factors_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_h264_weight_factors", &v4l2_h264_weight_factors_obj))
		v4l2_h264_weight_factors_obj = ctrl_obj;

	/* __s16 luma_weight[32] */
	json_object *luma_weight_obj;
	if (json_object_object_get_ex(v4l2_h264_weight_factors_obj, "luma_weight", &luma_weight_obj)) {
		for (size_t i = 0; i < 32; i++) {
			if (json_object_array_get_idx(luma_weight_obj, i))
				p->luma_weight[i] = (__s16) json_object_get_int(json_object_array_get_idx(luma_weight_obj, i));
		}
	}

	/* __s16 luma_offset[32] */
	json_object *luma_offset_obj;
	if (json_object_object_get_ex(v4l2_h264_weight_factors_obj, "luma_offset", &luma_offset_obj)) {
		for (size_t i = 0; i < 32; i++) {
			if (json_object_array_get_idx(luma_offset_obj, i))
				p->luma_offset[i] = (__s16) json_object_get_int(json_object_array_get_idx(luma_offset_obj, i));
		}
	}

	/* __s16 chroma_weight[32][2] */
	int count_chroma_weight = 0;
	json_object *chroma_weight_obj;
	if (json_object_object_get_ex(v4l2_h264_weight_factors_obj, "chroma_weight", &chroma_weight_obj)) {
		for (size_t i = 0; i < 32; i++) {
			for (size_t j = 0; j < 2; j++) {
				if (json_object_array_get_idx(chroma_weight_obj, count_chroma_weight))
					p->chroma_weight[i][j] = (__s16) json_object_get_int(json_object_array_get_idx(chroma_weight_obj, count_chroma_weight++));
			}
		}
	}

	/* __s16 chroma_offset[32][2] */
	int count_chroma_offset = 0;
	json_object *chroma_offset_obj;
	if (json_object_object_get_ex(v4l2_h264_weight_factors_obj, "chroma_offset", &chroma_offset_obj)) {
		for (size_t i = 0; i < 32; i++) {
			for (size_t j = 0; j < 2; j++) {
				if (json_object_array_get_idx(chroma_offset_obj, count_chroma_offset))
					p->chroma_offset[i][j] = (__s16) json_object_get_int(json_object_array_get_idx(chroma_offset_obj, count_chroma_offset++));
			}
		}
	}

	return p;
}

struct v4l2_ctrl_h264_pred_weights *retrace_v4l2_ctrl_h264_pred_weights_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_h264_pred_weights *p = (struct v4l2_ctrl_h264_pred_weights *) calloc(1, sizeof(v4l2_ctrl_h264_pred_weights));
	json_object *v4l2_ctrl_h264_pred_weights_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_h264_pred_weights", &v4l2_ctrl_h264_pred_weights_obj))
		v4l2_ctrl_h264_pred_weights_obj = ctrl_obj;

	json_object *luma_log2_weight_denom_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pred_weights_obj, "luma_log2_weight_denom", &luma_log2_weight_denom_obj))
		p->luma_log2_weight_denom = (__u16) json_object_get_int(luma_log2_weight_denom_obj);

	json_object *chroma_log2_weight_denom_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pred_weights_obj, "chroma_log2_weight_denom", &chroma_log2_weight_denom_obj))
		p->chroma_log2_weight_denom = (__u16) json_object_get_int(chroma_log2_weight_denom_obj);

	/* struct v4l2_h264_weight_factors weight_factors[2] */
	json_object *weight_factors_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_pred_weights_obj, "weight_factors", &weight_factors_obj)) {
		for (size_t i = 0; i < 2; i++) {
			void *weight_factors_ptr = (void *) retrace_v4l2_h264_weight_factors_gen(json_object_array_get_idx(weight_factors_obj, i));
			p->weight_factors[i] = *static_cast<struct v4l2_h264_weight_factors*>(weight_factors_ptr);
			free(weight_factors_ptr);
		}
	}

	return p;
}

struct v4l2_h264_reference *retrace_v4l2_h264_reference_gen(json_object *ctrl_obj)
{
	struct v4l2_h264_reference *p = (struct v4l2_h264_reference *) calloc(1, sizeof(v4l2_h264_reference));
	json_object *v4l2_h264_reference_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_h264_reference", &v4l2_h264_reference_obj))
		v4l2_h264_reference_obj = ctrl_obj;

	json_object *fields_obj;
	if (json_object_object_get_ex(v4l2_h264_reference_obj, "fields", &fields_obj))
		p->fields = (__u8) json_object_get_int(fields_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_h264_reference_obj, "index", &index_obj))
		p->index = (__u8) json_object_get_int(index_obj);

	return p;
}

struct v4l2_ctrl_h264_slice_params *retrace_v4l2_ctrl_h264_slice_params_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_h264_slice_params *p = (struct v4l2_ctrl_h264_slice_params *) calloc(1, sizeof(v4l2_ctrl_h264_slice_params));
	json_object *v4l2_ctrl_h264_slice_params_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_h264_slice_params", &v4l2_ctrl_h264_slice_params_obj))
		v4l2_ctrl_h264_slice_params_obj = ctrl_obj;

	json_object *header_bit_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "header_bit_size", &header_bit_size_obj))
		p->header_bit_size = (__u32) json_object_get_int64(header_bit_size_obj);

	json_object *first_mb_in_slice_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "first_mb_in_slice", &first_mb_in_slice_obj))
		p->first_mb_in_slice = (__u32) json_object_get_int64(first_mb_in_slice_obj);

	json_object *slice_type_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "slice_type", &slice_type_obj))
		p->slice_type = (__u8) json_object_get_int(slice_type_obj);

	json_object *colour_plane_id_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "colour_plane_id", &colour_plane_id_obj))
		p->colour_plane_id = (__u8) json_object_get_int(colour_plane_id_obj);

	json_object *redundant_pic_cnt_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "redundant_pic_cnt", &redundant_pic_cnt_obj))
		p->redundant_pic_cnt = (__u8) json_object_get_int(redundant_pic_cnt_obj);

	json_object *cabac_init_idc_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "cabac_init_idc", &cabac_init_idc_obj))
		p->cabac_init_idc = (__u8) json_object_get_int(cabac_init_idc_obj);

	json_object *slice_qp_delta_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "slice_qp_delta", &slice_qp_delta_obj))
		p->slice_qp_delta = (__s8) json_object_get_int(slice_qp_delta_obj);

	json_object *slice_qs_delta_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "slice_qs_delta", &slice_qs_delta_obj))
		p->slice_qs_delta = (__s8) json_object_get_int(slice_qs_delta_obj);

	json_object *disable_deblocking_filter_idc_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "disable_deblocking_filter_idc", &disable_deblocking_filter_idc_obj))
		p->disable_deblocking_filter_idc = (__u8) json_object_get_int(disable_deblocking_filter_idc_obj);

	json_object *slice_alpha_c0_offset_div2_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "slice_alpha_c0_offset_div2", &slice_alpha_c0_offset_div2_obj))
		p->slice_alpha_c0_offset_div2 = (__s8) json_object_get_int(slice_alpha_c0_offset_div2_obj);

	json_object *slice_beta_offset_div2_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "slice_beta_offset_div2", &slice_beta_offset_div2_obj))
		p->slice_beta_offset_div2 = (__s8) json_object_get_int(slice_beta_offset_div2_obj);

	json_object *num_ref_idx_l0_active_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "num_ref_idx_l0_active_minus1", &num_ref_idx_l0_active_minus1_obj))
		p->num_ref_idx_l0_active_minus1 = (__u8) json_object_get_int(num_ref_idx_l0_active_minus1_obj);

	json_object *num_ref_idx_l1_active_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "num_ref_idx_l1_active_minus1", &num_ref_idx_l1_active_minus1_obj))
		p->num_ref_idx_l1_active_minus1 = (__u8) json_object_get_int(num_ref_idx_l1_active_minus1_obj);

	/* struct v4l2_h264_reference ref_pic_list0[V4L2_H264_REF_LIST_LEN] */
	json_object *ref_pic_list0_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "ref_pic_list0", &ref_pic_list0_obj)) {
		for (size_t i = 0; i < V4L2_H264_REF_LIST_LEN; i++) {
			void *ref_pic_list0_ptr = (void *) retrace_v4l2_h264_reference_gen(json_object_array_get_idx(ref_pic_list0_obj, i));
			p->ref_pic_list0[i] = *static_cast<struct v4l2_h264_reference*>(ref_pic_list0_ptr);
			free(ref_pic_list0_ptr);
		}
	}

	/* struct v4l2_h264_reference ref_pic_list1[V4L2_H264_REF_LIST_LEN] */
	json_object *ref_pic_list1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "ref_pic_list1", &ref_pic_list1_obj)) {
		for (size_t i = 0; i < V4L2_H264_REF_LIST_LEN; i++) {
			void *ref_pic_list1_ptr = (void *) retrace_v4l2_h264_reference_gen(json_object_array_get_idx(ref_pic_list1_obj, i));
			p->ref_pic_list1[i] = *static_cast<struct v4l2_h264_reference*>(ref_pic_list1_ptr);
			free(ref_pic_list1_ptr);
		}
	}

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_slice_params_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_h264_slice_flag_def);

	return p;
}

struct v4l2_h264_dpb_entry *retrace_v4l2_h264_dpb_entry_gen(json_object *ctrl_obj)
{
	struct v4l2_h264_dpb_entry *p = (struct v4l2_h264_dpb_entry *) calloc(1, sizeof(v4l2_h264_dpb_entry));
	json_object *v4l2_h264_dpb_entry_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_h264_dpb_entry", &v4l2_h264_dpb_entry_obj))
		v4l2_h264_dpb_entry_obj = ctrl_obj;

	json_object *reference_ts_obj;
	if (json_object_object_get_ex(v4l2_h264_dpb_entry_obj, "reference_ts", &reference_ts_obj))
		p->reference_ts = (__u64) json_object_get_uint64(reference_ts_obj);

	json_object *pic_num_obj;
	if (json_object_object_get_ex(v4l2_h264_dpb_entry_obj, "pic_num", &pic_num_obj))
		p->pic_num = (__u32) json_object_get_int64(pic_num_obj);

	json_object *frame_num_obj;
	if (json_object_object_get_ex(v4l2_h264_dpb_entry_obj, "frame_num", &frame_num_obj))
		p->frame_num = (__u16) json_object_get_int(frame_num_obj);

	json_object *fields_obj;
	if (json_object_object_get_ex(v4l2_h264_dpb_entry_obj, "fields", &fields_obj))
		p->fields = (__u8) json_object_get_int(fields_obj);

	json_object *top_field_order_cnt_obj;
	if (json_object_object_get_ex(v4l2_h264_dpb_entry_obj, "top_field_order_cnt", &top_field_order_cnt_obj))
		p->top_field_order_cnt = (__s32) json_object_get_int(top_field_order_cnt_obj);

	json_object *bottom_field_order_cnt_obj;
	if (json_object_object_get_ex(v4l2_h264_dpb_entry_obj, "bottom_field_order_cnt", &bottom_field_order_cnt_obj))
		p->bottom_field_order_cnt = (__s32) json_object_get_int(bottom_field_order_cnt_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_h264_dpb_entry_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_h264_dpb_entry_flag_def);

	return p;
}

struct v4l2_ctrl_h264_decode_params *retrace_v4l2_ctrl_h264_decode_params_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_h264_decode_params *p = (struct v4l2_ctrl_h264_decode_params *) calloc(1, sizeof(v4l2_ctrl_h264_decode_params));
	json_object *v4l2_ctrl_h264_decode_params_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_h264_decode_params", &v4l2_ctrl_h264_decode_params_obj))
		v4l2_ctrl_h264_decode_params_obj = ctrl_obj;

	/* struct v4l2_h264_dpb_entry dpb[V4L2_H264_NUM_DPB_ENTRIES] */
	json_object *dpb_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "dpb", &dpb_obj)) {
		for (size_t i = 0; i < V4L2_H264_NUM_DPB_ENTRIES; i++) {
			void *dpb_ptr = (void *) retrace_v4l2_h264_dpb_entry_gen(json_object_array_get_idx(dpb_obj, i));
			p->dpb[i] = *static_cast<struct v4l2_h264_dpb_entry*>(dpb_ptr);
			free(dpb_ptr);
		}
	}

	json_object *nal_ref_idc_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "nal_ref_idc", &nal_ref_idc_obj))
		p->nal_ref_idc = (__u16) json_object_get_int(nal_ref_idc_obj);

	json_object *frame_num_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "frame_num", &frame_num_obj))
		p->frame_num = (__u16) json_object_get_int(frame_num_obj);

	json_object *top_field_order_cnt_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "top_field_order_cnt", &top_field_order_cnt_obj))
		p->top_field_order_cnt = (__s32) json_object_get_int(top_field_order_cnt_obj);

	json_object *bottom_field_order_cnt_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "bottom_field_order_cnt", &bottom_field_order_cnt_obj))
		p->bottom_field_order_cnt = (__s32) json_object_get_int(bottom_field_order_cnt_obj);

	json_object *idr_pic_id_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "idr_pic_id", &idr_pic_id_obj))
		p->idr_pic_id = (__u16) json_object_get_int(idr_pic_id_obj);

	json_object *pic_order_cnt_lsb_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "pic_order_cnt_lsb", &pic_order_cnt_lsb_obj))
		p->pic_order_cnt_lsb = (__u16) json_object_get_int(pic_order_cnt_lsb_obj);

	json_object *delta_pic_order_cnt_bottom_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "delta_pic_order_cnt_bottom", &delta_pic_order_cnt_bottom_obj))
		p->delta_pic_order_cnt_bottom = (__s32) json_object_get_int(delta_pic_order_cnt_bottom_obj);

	json_object *delta_pic_order_cnt0_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "delta_pic_order_cnt0", &delta_pic_order_cnt0_obj))
		p->delta_pic_order_cnt0 = (__s32) json_object_get_int(delta_pic_order_cnt0_obj);

	json_object *delta_pic_order_cnt1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "delta_pic_order_cnt1", &delta_pic_order_cnt1_obj))
		p->delta_pic_order_cnt1 = (__s32) json_object_get_int(delta_pic_order_cnt1_obj);

	json_object *dec_ref_pic_marking_bit_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "dec_ref_pic_marking_bit_size", &dec_ref_pic_marking_bit_size_obj))
		p->dec_ref_pic_marking_bit_size = (__u32) json_object_get_int64(dec_ref_pic_marking_bit_size_obj);

	json_object *pic_order_cnt_bit_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "pic_order_cnt_bit_size", &pic_order_cnt_bit_size_obj))
		p->pic_order_cnt_bit_size = (__u32) json_object_get_int64(pic_order_cnt_bit_size_obj);

	json_object *slice_group_change_cycle_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "slice_group_change_cycle", &slice_group_change_cycle_obj))
		p->slice_group_change_cycle = (__u32) json_object_get_int64(slice_group_change_cycle_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_h264_decode_params_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_h264_decode_param_flag_def);

	return p;
}

struct v4l2_ctrl_fwht_params *retrace_v4l2_ctrl_fwht_params_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_fwht_params *p = (struct v4l2_ctrl_fwht_params *) calloc(1, sizeof(v4l2_ctrl_fwht_params));
	json_object *v4l2_ctrl_fwht_params_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_fwht_params", &v4l2_ctrl_fwht_params_obj))
		v4l2_ctrl_fwht_params_obj = ctrl_obj;

	json_object *backward_ref_ts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_fwht_params_obj, "backward_ref_ts", &backward_ref_ts_obj))
		p->backward_ref_ts = (__u64) json_object_get_uint64(backward_ref_ts_obj);

	json_object *version_obj;
	if (json_object_object_get_ex(v4l2_ctrl_fwht_params_obj, "version", &version_obj))
		p->version = (__u32) json_object_get_int64(version_obj);

	json_object *width_obj;
	if (json_object_object_get_ex(v4l2_ctrl_fwht_params_obj, "width", &width_obj))
		p->width = (__u32) json_object_get_int64(width_obj);

	json_object *height_obj;
	if (json_object_object_get_ex(v4l2_ctrl_fwht_params_obj, "height", &height_obj))
		p->height = (__u32) json_object_get_int64(height_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_fwht_params_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags_fwht(json_object_get_string(flags_obj));

	json_object *colorspace_obj;
	if (json_object_object_get_ex(v4l2_ctrl_fwht_params_obj, "colorspace", &colorspace_obj))
		p->colorspace = (__u32) s2val(json_object_get_string(colorspace_obj), v4l2_colorspace_val_def);

	json_object *xfer_func_obj;
	if (json_object_object_get_ex(v4l2_ctrl_fwht_params_obj, "xfer_func", &xfer_func_obj))
		p->xfer_func = (__u32) s2val(json_object_get_string(xfer_func_obj), v4l2_xfer_func_val_def);

	json_object *ycbcr_enc_obj;
	if (json_object_object_get_ex(v4l2_ctrl_fwht_params_obj, "ycbcr_enc", &ycbcr_enc_obj))
		p->ycbcr_enc = (__u32) s2val(json_object_get_string(ycbcr_enc_obj), v4l2_ycbcr_encoding_val_def);

	json_object *quantization_obj;
	if (json_object_object_get_ex(v4l2_ctrl_fwht_params_obj, "quantization", &quantization_obj))
		p->quantization = (__u32) s2val(json_object_get_string(quantization_obj), v4l2_quantization_val_def);

	return p;
}

struct v4l2_vp8_segment *retrace_v4l2_vp8_segment_gen(json_object *ctrl_obj)
{
	struct v4l2_vp8_segment *p = (struct v4l2_vp8_segment *) calloc(1, sizeof(v4l2_vp8_segment));
	json_object *v4l2_vp8_segment_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_vp8_segment", &v4l2_vp8_segment_obj))
		v4l2_vp8_segment_obj = ctrl_obj;

	/* __s8 quant_update[4] */
	json_object *quant_update_obj;
	if (json_object_object_get_ex(v4l2_vp8_segment_obj, "quant_update", &quant_update_obj)) {
		for (size_t i = 0; i < 4; i++) {
			if (json_object_array_get_idx(quant_update_obj, i))
				p->quant_update[i] = (__s8) json_object_get_int(json_object_array_get_idx(quant_update_obj, i));
		}
	}

	/* __s8 lf_update[4] */
	json_object *lf_update_obj;
	if (json_object_object_get_ex(v4l2_vp8_segment_obj, "lf_update", &lf_update_obj)) {
		for (size_t i = 0; i < 4; i++) {
			if (json_object_array_get_idx(lf_update_obj, i))
				p->lf_update[i] = (__s8) json_object_get_int(json_object_array_get_idx(lf_update_obj, i));
		}
	}

	/* __u8 segment_probs[3] */
	json_object *segment_probs_obj;
	if (json_object_object_get_ex(v4l2_vp8_segment_obj, "segment_probs", &segment_probs_obj)) {
		for (size_t i = 0; i < 3; i++) {
			if (json_object_array_get_idx(segment_probs_obj, i))
				p->segment_probs[i] = (__u8) json_object_get_int(json_object_array_get_idx(segment_probs_obj, i));
		}
	}

	json_object *padding_obj;
	if (json_object_object_get_ex(v4l2_vp8_segment_obj, "padding", &padding_obj))
		p->padding = (__u8) json_object_get_int(padding_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_vp8_segment_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_vp8_segment_flag_def);

	return p;
}

struct v4l2_vp8_loop_filter *retrace_v4l2_vp8_loop_filter_gen(json_object *ctrl_obj)
{
	struct v4l2_vp8_loop_filter *p = (struct v4l2_vp8_loop_filter *) calloc(1, sizeof(v4l2_vp8_loop_filter));
	json_object *v4l2_vp8_loop_filter_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_vp8_loop_filter", &v4l2_vp8_loop_filter_obj))
		v4l2_vp8_loop_filter_obj = ctrl_obj;

	/* __s8 ref_frm_delta[4] */
	json_object *ref_frm_delta_obj;
	if (json_object_object_get_ex(v4l2_vp8_loop_filter_obj, "ref_frm_delta", &ref_frm_delta_obj)) {
		for (size_t i = 0; i < 4; i++) {
			if (json_object_array_get_idx(ref_frm_delta_obj, i))
				p->ref_frm_delta[i] = (__s8) json_object_get_int(json_object_array_get_idx(ref_frm_delta_obj, i));
		}
	}

	/* __s8 mb_mode_delta[4] */
	json_object *mb_mode_delta_obj;
	if (json_object_object_get_ex(v4l2_vp8_loop_filter_obj, "mb_mode_delta", &mb_mode_delta_obj)) {
		for (size_t i = 0; i < 4; i++) {
			if (json_object_array_get_idx(mb_mode_delta_obj, i))
				p->mb_mode_delta[i] = (__s8) json_object_get_int(json_object_array_get_idx(mb_mode_delta_obj, i));
		}
	}

	json_object *sharpness_level_obj;
	if (json_object_object_get_ex(v4l2_vp8_loop_filter_obj, "sharpness_level", &sharpness_level_obj))
		p->sharpness_level = (__u8) json_object_get_int(sharpness_level_obj);

	json_object *level_obj;
	if (json_object_object_get_ex(v4l2_vp8_loop_filter_obj, "level", &level_obj))
		p->level = (__u8) json_object_get_int(level_obj);

	json_object *padding_obj;
	if (json_object_object_get_ex(v4l2_vp8_loop_filter_obj, "padding", &padding_obj))
		p->padding = (__u16) json_object_get_int(padding_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_vp8_loop_filter_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_vp8_loop_filter_flag_def);

	return p;
}

struct v4l2_vp8_quantization *retrace_v4l2_vp8_quantization_gen(json_object *ctrl_obj)
{
	struct v4l2_vp8_quantization *p = (struct v4l2_vp8_quantization *) calloc(1, sizeof(v4l2_vp8_quantization));
	json_object *v4l2_vp8_quantization_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_vp8_quantization", &v4l2_vp8_quantization_obj))
		v4l2_vp8_quantization_obj = ctrl_obj;

	json_object *y_ac_qi_obj;
	if (json_object_object_get_ex(v4l2_vp8_quantization_obj, "y_ac_qi", &y_ac_qi_obj))
		p->y_ac_qi = (__u8) json_object_get_int(y_ac_qi_obj);

	json_object *y_dc_delta_obj;
	if (json_object_object_get_ex(v4l2_vp8_quantization_obj, "y_dc_delta", &y_dc_delta_obj))
		p->y_dc_delta = (__s8) json_object_get_int(y_dc_delta_obj);

	json_object *y2_dc_delta_obj;
	if (json_object_object_get_ex(v4l2_vp8_quantization_obj, "y2_dc_delta", &y2_dc_delta_obj))
		p->y2_dc_delta = (__s8) json_object_get_int(y2_dc_delta_obj);

	json_object *y2_ac_delta_obj;
	if (json_object_object_get_ex(v4l2_vp8_quantization_obj, "y2_ac_delta", &y2_ac_delta_obj))
		p->y2_ac_delta = (__s8) json_object_get_int(y2_ac_delta_obj);

	json_object *uv_dc_delta_obj;
	if (json_object_object_get_ex(v4l2_vp8_quantization_obj, "uv_dc_delta", &uv_dc_delta_obj))
		p->uv_dc_delta = (__s8) json_object_get_int(uv_dc_delta_obj);

	json_object *uv_ac_delta_obj;
	if (json_object_object_get_ex(v4l2_vp8_quantization_obj, "uv_ac_delta", &uv_ac_delta_obj))
		p->uv_ac_delta = (__s8) json_object_get_int(uv_ac_delta_obj);

	json_object *padding_obj;
	if (json_object_object_get_ex(v4l2_vp8_quantization_obj, "padding", &padding_obj))
		p->padding = (__u16) json_object_get_int(padding_obj);

	return p;
}

struct v4l2_vp8_entropy *retrace_v4l2_vp8_entropy_gen(json_object *ctrl_obj)
{
	struct v4l2_vp8_entropy *p = (struct v4l2_vp8_entropy *) calloc(1, sizeof(v4l2_vp8_entropy));
	json_object *v4l2_vp8_entropy_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_vp8_entropy", &v4l2_vp8_entropy_obj))
		v4l2_vp8_entropy_obj = ctrl_obj;

	/* __u8 coeff_probs[4][8][3][V4L2_VP8_COEFF_PROB_CNT] */
	int count_coeff_probs = 0;
	json_object *coeff_probs_obj;
	if (json_object_object_get_ex(v4l2_vp8_entropy_obj, "coeff_probs", &coeff_probs_obj)) {
		for (size_t i = 0; i < 4; i++) {
			for (size_t j = 0; j < 8; j++) {
				for (size_t k = 0; k < 3; k++) {
					for (size_t l = 0; l < V4L2_VP8_COEFF_PROB_CNT; l++) {
						if (json_object_array_get_idx(coeff_probs_obj, count_coeff_probs))
							p->coeff_probs[i][j][k][l] = (__u8) json_object_get_int(json_object_array_get_idx(coeff_probs_obj, count_coeff_probs++));
					}
				}
			}
		}
	}

	/* __u8 y_mode_probs[4] */
	json_object *y_mode_probs_obj;
	if (json_object_object_get_ex(v4l2_vp8_entropy_obj, "y_mode_probs", &y_mode_probs_obj)) {
		for (size_t i = 0; i < 4; i++) {
			if (json_object_array_get_idx(y_mode_probs_obj, i))
				p->y_mode_probs[i] = (__u8) json_object_get_int(json_object_array_get_idx(y_mode_probs_obj, i));
		}
	}

	/* __u8 uv_mode_probs[3] */
	json_object *uv_mode_probs_obj;
	if (json_object_object_get_ex(v4l2_vp8_entropy_obj, "uv_mode_probs", &uv_mode_probs_obj)) {
		for (size_t i = 0; i < 3; i++) {
			if (json_object_array_get_idx(uv_mode_probs_obj, i))
				p->uv_mode_probs[i] = (__u8) json_object_get_int(json_object_array_get_idx(uv_mode_probs_obj, i));
		}
	}

	/* __u8 mv_probs[2][V4L2_VP8_MV_PROB_CNT] */
	int count_mv_probs = 0;
	json_object *mv_probs_obj;
	if (json_object_object_get_ex(v4l2_vp8_entropy_obj, "mv_probs", &mv_probs_obj)) {
		for (size_t i = 0; i < 2; i++) {
			for (size_t j = 0; j < V4L2_VP8_MV_PROB_CNT; j++) {
				if (json_object_array_get_idx(mv_probs_obj, count_mv_probs))
					p->mv_probs[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(mv_probs_obj, count_mv_probs++));
			}
		}
	}

	/* __u8 padding[3] */
	json_object *padding_obj;
	if (json_object_object_get_ex(v4l2_vp8_entropy_obj, "padding", &padding_obj)) {
		for (size_t i = 0; i < 3; i++) {
			if (json_object_array_get_idx(padding_obj, i))
				p->padding[i] = (__u8) json_object_get_int(json_object_array_get_idx(padding_obj, i));
		}
	}

	return p;
}

struct v4l2_vp8_entropy_coder_state *retrace_v4l2_vp8_entropy_coder_state_gen(json_object *ctrl_obj)
{
	struct v4l2_vp8_entropy_coder_state *p = (struct v4l2_vp8_entropy_coder_state *) calloc(1, sizeof(v4l2_vp8_entropy_coder_state));
	json_object *v4l2_vp8_entropy_coder_state_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_vp8_entropy_coder_state", &v4l2_vp8_entropy_coder_state_obj))
		v4l2_vp8_entropy_coder_state_obj = ctrl_obj;

	json_object *range_obj;
	if (json_object_object_get_ex(v4l2_vp8_entropy_coder_state_obj, "range", &range_obj))
		p->range = (__u8) json_object_get_int(range_obj);

	json_object *value_obj;
	if (json_object_object_get_ex(v4l2_vp8_entropy_coder_state_obj, "value", &value_obj))
		p->value = (__u8) json_object_get_int(value_obj);

	json_object *bit_count_obj;
	if (json_object_object_get_ex(v4l2_vp8_entropy_coder_state_obj, "bit_count", &bit_count_obj))
		p->bit_count = (__u8) json_object_get_int(bit_count_obj);

	json_object *padding_obj;
	if (json_object_object_get_ex(v4l2_vp8_entropy_coder_state_obj, "padding", &padding_obj))
		p->padding = (__u8) json_object_get_int(padding_obj);

	return p;
}

struct v4l2_ctrl_vp8_frame *retrace_v4l2_ctrl_vp8_frame_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_vp8_frame *p = (struct v4l2_ctrl_vp8_frame *) calloc(1, sizeof(v4l2_ctrl_vp8_frame));
	json_object *v4l2_ctrl_vp8_frame_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_vp8_frame", &v4l2_ctrl_vp8_frame_obj))
		v4l2_ctrl_vp8_frame_obj = ctrl_obj;

	/* struct v4l2_vp8_segment segment */
	json_object *segment_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "v4l2_vp8_segment", &segment_obj))
		return p;
	void *segment_ptr = (void *) retrace_v4l2_vp8_segment_gen(segment_obj);
	p->segment = *static_cast<struct v4l2_vp8_segment*>(segment_ptr);
	free(segment_ptr);

	/* struct v4l2_vp8_loop_filter lf */
	json_object *lf_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "v4l2_vp8_loop_filter", &lf_obj))
		return p;
	void *lf_ptr = (void *) retrace_v4l2_vp8_loop_filter_gen(lf_obj);
	p->lf = *static_cast<struct v4l2_vp8_loop_filter*>(lf_ptr);
	free(lf_ptr);

	/* struct v4l2_vp8_quantization quant */
	json_object *quant_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "v4l2_vp8_quantization", &quant_obj))
		return p;
	void *quant_ptr = (void *) retrace_v4l2_vp8_quantization_gen(quant_obj);
	p->quant = *static_cast<struct v4l2_vp8_quantization*>(quant_ptr);
	free(quant_ptr);

	/* struct v4l2_vp8_entropy entropy */
	json_object *entropy_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "v4l2_vp8_entropy", &entropy_obj))
		return p;
	void *entropy_ptr = (void *) retrace_v4l2_vp8_entropy_gen(entropy_obj);
	p->entropy = *static_cast<struct v4l2_vp8_entropy*>(entropy_ptr);
	free(entropy_ptr);

	/* struct v4l2_vp8_entropy_coder_state coder_state */
	json_object *coder_state_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "v4l2_vp8_entropy_coder_state", &coder_state_obj))
		return p;
	void *coder_state_ptr = (void *) retrace_v4l2_vp8_entropy_coder_state_gen(coder_state_obj);
	p->coder_state = *static_cast<struct v4l2_vp8_entropy_coder_state*>(coder_state_ptr);
	free(coder_state_ptr);

	json_object *width_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "width", &width_obj))
		p->width = (__u16) json_object_get_int(width_obj);

	json_object *height_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "height", &height_obj))
		p->height = (__u16) json_object_get_int(height_obj);

	json_object *horizontal_scale_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "horizontal_scale", &horizontal_scale_obj))
		p->horizontal_scale = (__u8) json_object_get_int(horizontal_scale_obj);

	json_object *vertical_scale_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "vertical_scale", &vertical_scale_obj))
		p->vertical_scale = (__u8) json_object_get_int(vertical_scale_obj);

	json_object *version_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "version", &version_obj))
		p->version = (__u8) json_object_get_int(version_obj);

	json_object *prob_skip_false_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "prob_skip_false", &prob_skip_false_obj))
		p->prob_skip_false = (__u8) json_object_get_int(prob_skip_false_obj);

	json_object *prob_intra_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "prob_intra", &prob_intra_obj))
		p->prob_intra = (__u8) json_object_get_int(prob_intra_obj);

	json_object *prob_last_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "prob_last", &prob_last_obj))
		p->prob_last = (__u8) json_object_get_int(prob_last_obj);

	json_object *prob_gf_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "prob_gf", &prob_gf_obj))
		p->prob_gf = (__u8) json_object_get_int(prob_gf_obj);

	json_object *num_dct_parts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "num_dct_parts", &num_dct_parts_obj))
		p->num_dct_parts = (__u8) json_object_get_int(num_dct_parts_obj);

	json_object *first_part_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "first_part_size", &first_part_size_obj))
		p->first_part_size = (__u32) json_object_get_int64(first_part_size_obj);

	json_object *first_part_header_bits_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "first_part_header_bits", &first_part_header_bits_obj))
		p->first_part_header_bits = (__u32) json_object_get_int64(first_part_header_bits_obj);

	/* __u32 dct_part_sizes[8] */
	json_object *dct_part_sizes_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "dct_part_sizes", &dct_part_sizes_obj)) {
		for (size_t i = 0; i < 8; i++) {
			if (json_object_array_get_idx(dct_part_sizes_obj, i))
				p->dct_part_sizes[i] = (__u32) json_object_get_int64(json_object_array_get_idx(dct_part_sizes_obj, i));
		}
	}

	json_object *last_frame_ts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "last_frame_ts", &last_frame_ts_obj))
		p->last_frame_ts = (__u64) json_object_get_uint64(last_frame_ts_obj);

	json_object *golden_frame_ts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "golden_frame_ts", &golden_frame_ts_obj))
		p->golden_frame_ts = (__u64) json_object_get_uint64(golden_frame_ts_obj);

	json_object *alt_frame_ts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "alt_frame_ts", &alt_frame_ts_obj))
		p->alt_frame_ts = (__u64) json_object_get_uint64(alt_frame_ts_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp8_frame_obj, "flags", &flags_obj))
		p->flags = (__u64) s2flags(json_object_get_string(flags_obj), v4l2_vp8_frame_flag_def);

	return p;
}

struct v4l2_ctrl_mpeg2_sequence *retrace_v4l2_ctrl_mpeg2_sequence_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_mpeg2_sequence *p = (struct v4l2_ctrl_mpeg2_sequence *) calloc(1, sizeof(v4l2_ctrl_mpeg2_sequence));
	json_object *v4l2_ctrl_mpeg2_sequence_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_mpeg2_sequence", &v4l2_ctrl_mpeg2_sequence_obj))
		v4l2_ctrl_mpeg2_sequence_obj = ctrl_obj;

	json_object *horizontal_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_sequence_obj, "horizontal_size", &horizontal_size_obj))
		p->horizontal_size = (__u16) json_object_get_int(horizontal_size_obj);

	json_object *vertical_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_sequence_obj, "vertical_size", &vertical_size_obj))
		p->vertical_size = (__u16) json_object_get_int(vertical_size_obj);

	json_object *vbv_buffer_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_sequence_obj, "vbv_buffer_size", &vbv_buffer_size_obj))
		p->vbv_buffer_size = (__u32) json_object_get_int64(vbv_buffer_size_obj);

	json_object *profile_and_level_indication_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_sequence_obj, "profile_and_level_indication", &profile_and_level_indication_obj))
		p->profile_and_level_indication = (__u16) json_object_get_int(profile_and_level_indication_obj);

	json_object *chroma_format_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_sequence_obj, "chroma_format", &chroma_format_obj))
		p->chroma_format = (__u8) json_object_get_int(chroma_format_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_sequence_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_mpeg2_seq_flag_def);

	return p;
}

struct v4l2_ctrl_mpeg2_picture *retrace_v4l2_ctrl_mpeg2_picture_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_mpeg2_picture *p = (struct v4l2_ctrl_mpeg2_picture *) calloc(1, sizeof(v4l2_ctrl_mpeg2_picture));
	json_object *v4l2_ctrl_mpeg2_picture_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_mpeg2_picture", &v4l2_ctrl_mpeg2_picture_obj))
		v4l2_ctrl_mpeg2_picture_obj = ctrl_obj;

	json_object *backward_ref_ts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_picture_obj, "backward_ref_ts", &backward_ref_ts_obj))
		p->backward_ref_ts = (__u64) json_object_get_uint64(backward_ref_ts_obj);

	json_object *forward_ref_ts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_picture_obj, "forward_ref_ts", &forward_ref_ts_obj))
		p->forward_ref_ts = (__u64) json_object_get_uint64(forward_ref_ts_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_picture_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_mpeg2_pic_flag_def);

	/* __u8	f_code[2][2] */
	int count_f_code = 0;
	json_object *f_code_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_picture_obj, "f_code", &f_code_obj)) {
		for (size_t i = 0; i < 2; i++) {
			for (size_t j = 0; j < 2; j++) {
				if (json_object_array_get_idx(f_code_obj, count_f_code))
					p->f_code[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(f_code_obj, count_f_code++));
			}
		}
	}

	json_object *picture_coding_type_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_picture_obj, "picture_coding_type", &picture_coding_type_obj))
		p->picture_coding_type = (__u8) json_object_get_int(picture_coding_type_obj);

	json_object *picture_structure_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_picture_obj, "picture_structure", &picture_structure_obj))
		p->picture_structure = (__u8) json_object_get_int(picture_structure_obj);

	json_object *intra_dc_precision_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_picture_obj, "intra_dc_precision", &intra_dc_precision_obj))
		p->intra_dc_precision = (__u8) json_object_get_int(intra_dc_precision_obj);

	return p;
}

struct v4l2_ctrl_mpeg2_quantisation *retrace_v4l2_ctrl_mpeg2_quantisation_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_mpeg2_quantisation *p = (struct v4l2_ctrl_mpeg2_quantisation *) calloc(1, sizeof(v4l2_ctrl_mpeg2_quantisation));
	json_object *v4l2_ctrl_mpeg2_quantisation_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_mpeg2_quantisation", &v4l2_ctrl_mpeg2_quantisation_obj))
		v4l2_ctrl_mpeg2_quantisation_obj = ctrl_obj;

	/* __u8	intra_quantiser_matrix[64] */
	json_object *intra_quantiser_matrix_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_quantisation_obj, "intra_quantiser_matrix", &intra_quantiser_matrix_obj)) {
		for (size_t i = 0; i < 64; i++) {
			if (json_object_array_get_idx(intra_quantiser_matrix_obj, i))
				p->intra_quantiser_matrix[i] = (__u8) json_object_get_int(json_object_array_get_idx(intra_quantiser_matrix_obj, i));
		}
	}

	/* __u8	non_intra_quantiser_matrix[64] */
	json_object *non_intra_quantiser_matrix_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_quantisation_obj, "non_intra_quantiser_matrix", &non_intra_quantiser_matrix_obj)) {
		for (size_t i = 0; i < 64; i++) {
			if (json_object_array_get_idx(non_intra_quantiser_matrix_obj, i))
				p->non_intra_quantiser_matrix[i] = (__u8) json_object_get_int(json_object_array_get_idx(non_intra_quantiser_matrix_obj, i));
		}
	}

	/* __u8	chroma_intra_quantiser_matrix[64] */
	json_object *chroma_intra_quantiser_matrix_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_quantisation_obj, "chroma_intra_quantiser_matrix", &chroma_intra_quantiser_matrix_obj)) {
		for (size_t i = 0; i < 64; i++) {
			if (json_object_array_get_idx(chroma_intra_quantiser_matrix_obj, i))
				p->chroma_intra_quantiser_matrix[i] = (__u8) json_object_get_int(json_object_array_get_idx(chroma_intra_quantiser_matrix_obj, i));
		}
	}

	/* __u8	chroma_non_intra_quantiser_matrix[64] */
	json_object *chroma_non_intra_quantiser_matrix_obj;
	if (json_object_object_get_ex(v4l2_ctrl_mpeg2_quantisation_obj, "chroma_non_intra_quantiser_matrix", &chroma_non_intra_quantiser_matrix_obj)) {
		for (size_t i = 0; i < 64; i++) {
			if (json_object_array_get_idx(chroma_non_intra_quantiser_matrix_obj, i))
				p->chroma_non_intra_quantiser_matrix[i] = (__u8) json_object_get_int(json_object_array_get_idx(chroma_non_intra_quantiser_matrix_obj, i));
		}
	}

	return p;
}

struct v4l2_ctrl_hevc_sps *retrace_v4l2_ctrl_hevc_sps_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_hevc_sps *p = (struct v4l2_ctrl_hevc_sps *) calloc(1, sizeof(v4l2_ctrl_hevc_sps));
	json_object *v4l2_ctrl_hevc_sps_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_hevc_sps", &v4l2_ctrl_hevc_sps_obj))
		v4l2_ctrl_hevc_sps_obj = ctrl_obj;

	json_object *video_parameter_set_id_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "video_parameter_set_id", &video_parameter_set_id_obj))
		p->video_parameter_set_id = (__u8) json_object_get_int(video_parameter_set_id_obj);

	json_object *seq_parameter_set_id_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "seq_parameter_set_id", &seq_parameter_set_id_obj))
		p->seq_parameter_set_id = (__u8) json_object_get_int(seq_parameter_set_id_obj);

	json_object *pic_width_in_luma_samples_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "pic_width_in_luma_samples", &pic_width_in_luma_samples_obj))
		p->pic_width_in_luma_samples = (__u16) json_object_get_int(pic_width_in_luma_samples_obj);

	json_object *pic_height_in_luma_samples_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "pic_height_in_luma_samples", &pic_height_in_luma_samples_obj))
		p->pic_height_in_luma_samples = (__u16) json_object_get_int(pic_height_in_luma_samples_obj);

	json_object *bit_depth_luma_minus8_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "bit_depth_luma_minus8", &bit_depth_luma_minus8_obj))
		p->bit_depth_luma_minus8 = (__u8) json_object_get_int(bit_depth_luma_minus8_obj);

	json_object *bit_depth_chroma_minus8_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "bit_depth_chroma_minus8", &bit_depth_chroma_minus8_obj))
		p->bit_depth_chroma_minus8 = (__u8) json_object_get_int(bit_depth_chroma_minus8_obj);

	json_object *log2_max_pic_order_cnt_lsb_minus4_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "log2_max_pic_order_cnt_lsb_minus4", &log2_max_pic_order_cnt_lsb_minus4_obj))
		p->log2_max_pic_order_cnt_lsb_minus4 = (__u8) json_object_get_int(log2_max_pic_order_cnt_lsb_minus4_obj);

	json_object *sps_max_dec_pic_buffering_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "sps_max_dec_pic_buffering_minus1", &sps_max_dec_pic_buffering_minus1_obj))
		p->sps_max_dec_pic_buffering_minus1 = (__u8) json_object_get_int(sps_max_dec_pic_buffering_minus1_obj);

	json_object *sps_max_num_reorder_pics_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "sps_max_num_reorder_pics", &sps_max_num_reorder_pics_obj))
		p->sps_max_num_reorder_pics = (__u8) json_object_get_int(sps_max_num_reorder_pics_obj);

	json_object *sps_max_latency_increase_plus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "sps_max_latency_increase_plus1", &sps_max_latency_increase_plus1_obj))
		p->sps_max_latency_increase_plus1 = (__u8) json_object_get_int(sps_max_latency_increase_plus1_obj);

	json_object *log2_min_luma_coding_block_size_minus3_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "log2_min_luma_coding_block_size_minus3", &log2_min_luma_coding_block_size_minus3_obj))
		p->log2_min_luma_coding_block_size_minus3 = (__u8) json_object_get_int(log2_min_luma_coding_block_size_minus3_obj);

	json_object *log2_diff_max_min_luma_coding_block_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "log2_diff_max_min_luma_coding_block_size", &log2_diff_max_min_luma_coding_block_size_obj))
		p->log2_diff_max_min_luma_coding_block_size = (__u8) json_object_get_int(log2_diff_max_min_luma_coding_block_size_obj);

	json_object *log2_min_luma_transform_block_size_minus2_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "log2_min_luma_transform_block_size_minus2", &log2_min_luma_transform_block_size_minus2_obj))
		p->log2_min_luma_transform_block_size_minus2 = (__u8) json_object_get_int(log2_min_luma_transform_block_size_minus2_obj);

	json_object *log2_diff_max_min_luma_transform_block_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "log2_diff_max_min_luma_transform_block_size", &log2_diff_max_min_luma_transform_block_size_obj))
		p->log2_diff_max_min_luma_transform_block_size = (__u8) json_object_get_int(log2_diff_max_min_luma_transform_block_size_obj);

	json_object *max_transform_hierarchy_depth_inter_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "max_transform_hierarchy_depth_inter", &max_transform_hierarchy_depth_inter_obj))
		p->max_transform_hierarchy_depth_inter = (__u8) json_object_get_int(max_transform_hierarchy_depth_inter_obj);

	json_object *max_transform_hierarchy_depth_intra_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "max_transform_hierarchy_depth_intra", &max_transform_hierarchy_depth_intra_obj))
		p->max_transform_hierarchy_depth_intra = (__u8) json_object_get_int(max_transform_hierarchy_depth_intra_obj);

	json_object *pcm_sample_bit_depth_luma_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "pcm_sample_bit_depth_luma_minus1", &pcm_sample_bit_depth_luma_minus1_obj))
		p->pcm_sample_bit_depth_luma_minus1 = (__u8) json_object_get_int(pcm_sample_bit_depth_luma_minus1_obj);

	json_object *pcm_sample_bit_depth_chroma_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "pcm_sample_bit_depth_chroma_minus1", &pcm_sample_bit_depth_chroma_minus1_obj))
		p->pcm_sample_bit_depth_chroma_minus1 = (__u8) json_object_get_int(pcm_sample_bit_depth_chroma_minus1_obj);

	json_object *log2_min_pcm_luma_coding_block_size_minus3_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "log2_min_pcm_luma_coding_block_size_minus3", &log2_min_pcm_luma_coding_block_size_minus3_obj))
		p->log2_min_pcm_luma_coding_block_size_minus3 = (__u8) json_object_get_int(log2_min_pcm_luma_coding_block_size_minus3_obj);

	json_object *log2_diff_max_min_pcm_luma_coding_block_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "log2_diff_max_min_pcm_luma_coding_block_size", &log2_diff_max_min_pcm_luma_coding_block_size_obj))
		p->log2_diff_max_min_pcm_luma_coding_block_size = (__u8) json_object_get_int(log2_diff_max_min_pcm_luma_coding_block_size_obj);

	json_object *num_short_term_ref_pic_sets_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "num_short_term_ref_pic_sets", &num_short_term_ref_pic_sets_obj))
		p->num_short_term_ref_pic_sets = (__u8) json_object_get_int(num_short_term_ref_pic_sets_obj);

	json_object *num_long_term_ref_pics_sps_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "num_long_term_ref_pics_sps", &num_long_term_ref_pics_sps_obj))
		p->num_long_term_ref_pics_sps = (__u8) json_object_get_int(num_long_term_ref_pics_sps_obj);

	json_object *chroma_format_idc_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "chroma_format_idc", &chroma_format_idc_obj))
		p->chroma_format_idc = (__u8) json_object_get_int(chroma_format_idc_obj);

	json_object *sps_max_sub_layers_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "sps_max_sub_layers_minus1", &sps_max_sub_layers_minus1_obj))
		p->sps_max_sub_layers_minus1 = (__u8) json_object_get_int(sps_max_sub_layers_minus1_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_sps_obj, "flags", &flags_obj))
		p->flags = (__u64) s2flags(json_object_get_string(flags_obj), v4l2_hevc_sps_flag_def);

	return p;
}

struct v4l2_ctrl_hevc_pps *retrace_v4l2_ctrl_hevc_pps_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_hevc_pps *p = (struct v4l2_ctrl_hevc_pps *) calloc(1, sizeof(v4l2_ctrl_hevc_pps));
	json_object *v4l2_ctrl_hevc_pps_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_hevc_pps", &v4l2_ctrl_hevc_pps_obj))
		v4l2_ctrl_hevc_pps_obj = ctrl_obj;

	json_object *pic_parameter_set_id_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "pic_parameter_set_id", &pic_parameter_set_id_obj))
		p->pic_parameter_set_id = (__u8) json_object_get_int(pic_parameter_set_id_obj);

	json_object *num_extra_slice_header_bits_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "num_extra_slice_header_bits", &num_extra_slice_header_bits_obj))
		p->num_extra_slice_header_bits = (__u8) json_object_get_int(num_extra_slice_header_bits_obj);

	json_object *num_ref_idx_l0_default_active_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "num_ref_idx_l0_default_active_minus1", &num_ref_idx_l0_default_active_minus1_obj))
		p->num_ref_idx_l0_default_active_minus1 = (__u8) json_object_get_int(num_ref_idx_l0_default_active_minus1_obj);

	json_object *num_ref_idx_l1_default_active_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "num_ref_idx_l1_default_active_minus1", &num_ref_idx_l1_default_active_minus1_obj))
		p->num_ref_idx_l1_default_active_minus1 = (__u8) json_object_get_int(num_ref_idx_l1_default_active_minus1_obj);

	json_object *init_qp_minus26_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "init_qp_minus26", &init_qp_minus26_obj))
		p->init_qp_minus26 = (__s8) json_object_get_int(init_qp_minus26_obj);

	json_object *diff_cu_qp_delta_depth_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "diff_cu_qp_delta_depth", &diff_cu_qp_delta_depth_obj))
		p->diff_cu_qp_delta_depth = (__u8) json_object_get_int(diff_cu_qp_delta_depth_obj);

	json_object *pps_cb_qp_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "pps_cb_qp_offset", &pps_cb_qp_offset_obj))
		p->pps_cb_qp_offset = (__s8) json_object_get_int(pps_cb_qp_offset_obj);

	json_object *pps_cr_qp_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "pps_cr_qp_offset", &pps_cr_qp_offset_obj))
		p->pps_cr_qp_offset = (__s8) json_object_get_int(pps_cr_qp_offset_obj);

	json_object *num_tile_columns_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "num_tile_columns_minus1", &num_tile_columns_minus1_obj))
		p->num_tile_columns_minus1 = (__u8) json_object_get_int(num_tile_columns_minus1_obj);

	json_object *num_tile_rows_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "num_tile_rows_minus1", &num_tile_rows_minus1_obj))
		p->num_tile_rows_minus1 = (__u8) json_object_get_int(num_tile_rows_minus1_obj);

	/* __u8	column_width_minus1[20] */
	json_object *column_width_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "column_width_minus1", &column_width_minus1_obj)) {
		for (size_t i = 0; i < 20; i++) {
			if (json_object_array_get_idx(column_width_minus1_obj, i))
				p->column_width_minus1[i] = (__u8) json_object_get_int(json_object_array_get_idx(column_width_minus1_obj, i));
		}
	}

	/* __u8	row_height_minus1[22] */
	json_object *row_height_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "row_height_minus1", &row_height_minus1_obj)) {
		for (size_t i = 0; i < 22; i++) {
			if (json_object_array_get_idx(row_height_minus1_obj, i))
				p->row_height_minus1[i] = (__u8) json_object_get_int(json_object_array_get_idx(row_height_minus1_obj, i));
		}
	}

	json_object *pps_beta_offset_div2_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "pps_beta_offset_div2", &pps_beta_offset_div2_obj))
		p->pps_beta_offset_div2 = (__s8) json_object_get_int(pps_beta_offset_div2_obj);

	json_object *pps_tc_offset_div2_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "pps_tc_offset_div2", &pps_tc_offset_div2_obj))
		p->pps_tc_offset_div2 = (__s8) json_object_get_int(pps_tc_offset_div2_obj);

	json_object *log2_parallel_merge_level_minus2_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "log2_parallel_merge_level_minus2", &log2_parallel_merge_level_minus2_obj))
		p->log2_parallel_merge_level_minus2 = (__u8) json_object_get_int(log2_parallel_merge_level_minus2_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_pps_obj, "flags", &flags_obj))
		p->flags = (__u64) s2flags(json_object_get_string(flags_obj), v4l2_hevc_pps_flag_def);

	return p;
}

struct v4l2_hevc_dpb_entry *retrace_v4l2_hevc_dpb_entry_gen(json_object *ctrl_obj)
{
	struct v4l2_hevc_dpb_entry *p = (struct v4l2_hevc_dpb_entry *) calloc(1, sizeof(v4l2_hevc_dpb_entry));
	json_object *v4l2_hevc_dpb_entry_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_hevc_dpb_entry", &v4l2_hevc_dpb_entry_obj))
		v4l2_hevc_dpb_entry_obj = ctrl_obj;

	json_object *timestamp_obj;
	if (json_object_object_get_ex(v4l2_hevc_dpb_entry_obj, "timestamp", &timestamp_obj))
		p->timestamp = (__u64) json_object_get_uint64(timestamp_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_hevc_dpb_entry_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_hevc_pps_flag_def);

	json_object *field_pic_obj;
	if (json_object_object_get_ex(v4l2_hevc_dpb_entry_obj, "field_pic", &field_pic_obj))
		p->field_pic = (__u8) json_object_get_int(field_pic_obj);

	json_object *pic_order_cnt_val_obj;
	if (json_object_object_get_ex(v4l2_hevc_dpb_entry_obj, "pic_order_cnt_val", &pic_order_cnt_val_obj))
		p->pic_order_cnt_val = (__s32) json_object_get_int(pic_order_cnt_val_obj);

	return p;
}

struct v4l2_hevc_pred_weight_table *retrace_v4l2_hevc_pred_weight_table_gen(json_object *ctrl_obj)
{
	struct v4l2_hevc_pred_weight_table *p = (struct v4l2_hevc_pred_weight_table *) calloc(1, sizeof(v4l2_hevc_pred_weight_table));
	json_object *v4l2_hevc_pred_weight_table_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_hevc_pred_weight_table", &v4l2_hevc_pred_weight_table_obj))
		v4l2_hevc_pred_weight_table_obj = ctrl_obj;

	/* __s8	delta_luma_weight_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *delta_luma_weight_l0_obj;
	if (json_object_object_get_ex(v4l2_hevc_pred_weight_table_obj, "delta_luma_weight_l0", &delta_luma_weight_l0_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			if (json_object_array_get_idx(delta_luma_weight_l0_obj, i))
				p->delta_luma_weight_l0[i] = (__s8) json_object_get_int(json_object_array_get_idx(delta_luma_weight_l0_obj, i));
		}
	}

	/* __s8	luma_offset_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *luma_offset_l0_obj;
	if (json_object_object_get_ex(v4l2_hevc_pred_weight_table_obj, "luma_offset_l0", &luma_offset_l0_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			if (json_object_array_get_idx(luma_offset_l0_obj, i))
				p->luma_offset_l0[i] = (__s8) json_object_get_int(json_object_array_get_idx(luma_offset_l0_obj, i));
		}
	}

	/* __s8	delta_chroma_weight_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2] */
	int count_delta_chroma_weight_l0 = 0;
	json_object *delta_chroma_weight_l0_obj;
	if (json_object_object_get_ex(v4l2_hevc_pred_weight_table_obj, "delta_chroma_weight_l0", &delta_chroma_weight_l0_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			for (size_t j = 0; j < 2; j++) {
				if (json_object_array_get_idx(delta_chroma_weight_l0_obj, count_delta_chroma_weight_l0))
					p->delta_chroma_weight_l0[i][j] = (__s8) json_object_get_int(json_object_array_get_idx(delta_chroma_weight_l0_obj, count_delta_chroma_weight_l0++));
			}
		}
	}

	/* __s8	chroma_offset_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2] */
	int count_chroma_offset_l0 = 0;
	json_object *chroma_offset_l0_obj;
	if (json_object_object_get_ex(v4l2_hevc_pred_weight_table_obj, "chroma_offset_l0", &chroma_offset_l0_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			for (size_t j = 0; j < 2; j++) {
				if (json_object_array_get_idx(chroma_offset_l0_obj, count_chroma_offset_l0))
					p->chroma_offset_l0[i][j] = (__s8) json_object_get_int(json_object_array_get_idx(chroma_offset_l0_obj, count_chroma_offset_l0++));
			}
		}
	}

	/* __s8	delta_luma_weight_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *delta_luma_weight_l1_obj;
	if (json_object_object_get_ex(v4l2_hevc_pred_weight_table_obj, "delta_luma_weight_l1", &delta_luma_weight_l1_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			if (json_object_array_get_idx(delta_luma_weight_l1_obj, i))
				p->delta_luma_weight_l1[i] = (__s8) json_object_get_int(json_object_array_get_idx(delta_luma_weight_l1_obj, i));
		}
	}

	/* __s8	luma_offset_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *luma_offset_l1_obj;
	if (json_object_object_get_ex(v4l2_hevc_pred_weight_table_obj, "luma_offset_l1", &luma_offset_l1_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			if (json_object_array_get_idx(luma_offset_l1_obj, i))
				p->luma_offset_l1[i] = (__s8) json_object_get_int(json_object_array_get_idx(luma_offset_l1_obj, i));
		}
	}

	/* __s8	delta_chroma_weight_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2] */
	int count_delta_chroma_weight_l1 = 0;
	json_object *delta_chroma_weight_l1_obj;
	if (json_object_object_get_ex(v4l2_hevc_pred_weight_table_obj, "delta_chroma_weight_l1", &delta_chroma_weight_l1_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			for (size_t j = 0; j < 2; j++) {
				if (json_object_array_get_idx(delta_chroma_weight_l1_obj, count_delta_chroma_weight_l1))
					p->delta_chroma_weight_l1[i][j] = (__s8) json_object_get_int(json_object_array_get_idx(delta_chroma_weight_l1_obj, count_delta_chroma_weight_l1++));
			}
		}
	}

	/* __s8	chroma_offset_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2] */
	int count_chroma_offset_l1 = 0;
	json_object *chroma_offset_l1_obj;
	if (json_object_object_get_ex(v4l2_hevc_pred_weight_table_obj, "chroma_offset_l1", &chroma_offset_l1_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			for (size_t j = 0; j < 2; j++) {
				if (json_object_array_get_idx(chroma_offset_l1_obj, count_chroma_offset_l1))
					p->chroma_offset_l1[i][j] = (__s8) json_object_get_int(json_object_array_get_idx(chroma_offset_l1_obj, count_chroma_offset_l1++));
			}
		}
	}

	json_object *luma_log2_weight_denom_obj;
	if (json_object_object_get_ex(v4l2_hevc_pred_weight_table_obj, "luma_log2_weight_denom", &luma_log2_weight_denom_obj))
		p->luma_log2_weight_denom = (__u8) json_object_get_int(luma_log2_weight_denom_obj);

	json_object *delta_chroma_log2_weight_denom_obj;
	if (json_object_object_get_ex(v4l2_hevc_pred_weight_table_obj, "delta_chroma_log2_weight_denom", &delta_chroma_log2_weight_denom_obj))
		p->delta_chroma_log2_weight_denom = (__s8) json_object_get_int(delta_chroma_log2_weight_denom_obj);

	return p;
}

struct v4l2_ctrl_hevc_slice_params *retrace_v4l2_ctrl_hevc_slice_params_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_hevc_slice_params *p = (struct v4l2_ctrl_hevc_slice_params *) calloc(1, sizeof(v4l2_ctrl_hevc_slice_params));
	json_object *v4l2_ctrl_hevc_slice_params_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_hevc_slice_params", &v4l2_ctrl_hevc_slice_params_obj))
		v4l2_ctrl_hevc_slice_params_obj = ctrl_obj;

	json_object *bit_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "bit_size", &bit_size_obj))
		p->bit_size = (__u32) json_object_get_int64(bit_size_obj);

	json_object *data_byte_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "data_byte_offset", &data_byte_offset_obj))
		p->data_byte_offset = (__u32) json_object_get_int64(data_byte_offset_obj);

	json_object *num_entry_point_offsets_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "num_entry_point_offsets", &num_entry_point_offsets_obj))
		p->num_entry_point_offsets = (__u32) json_object_get_int64(num_entry_point_offsets_obj);

	json_object *nal_unit_type_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "nal_unit_type", &nal_unit_type_obj))
		p->nal_unit_type = (__u8) json_object_get_int(nal_unit_type_obj);

	json_object *nuh_temporal_id_plus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "nuh_temporal_id_plus1", &nuh_temporal_id_plus1_obj))
		p->nuh_temporal_id_plus1 = (__u8) json_object_get_int(nuh_temporal_id_plus1_obj);

	json_object *slice_type_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_type", &slice_type_obj))
		p->slice_type = (__u8) json_object_get_int(slice_type_obj);

	json_object *colour_plane_id_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "colour_plane_id", &colour_plane_id_obj))
		p->colour_plane_id = (__u8) json_object_get_int(colour_plane_id_obj);

	json_object *slice_pic_order_cnt_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_pic_order_cnt", &slice_pic_order_cnt_obj))
		p->slice_pic_order_cnt = (__s32) json_object_get_int(slice_pic_order_cnt_obj);

	json_object *num_ref_idx_l0_active_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "num_ref_idx_l0_active_minus1", &num_ref_idx_l0_active_minus1_obj))
		p->num_ref_idx_l0_active_minus1 = (__u8) json_object_get_int(num_ref_idx_l0_active_minus1_obj);

	json_object *num_ref_idx_l1_active_minus1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "num_ref_idx_l1_active_minus1", &num_ref_idx_l1_active_minus1_obj))
		p->num_ref_idx_l1_active_minus1 = (__u8) json_object_get_int(num_ref_idx_l1_active_minus1_obj);

	json_object *collocated_ref_idx_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "collocated_ref_idx", &collocated_ref_idx_obj))
		p->collocated_ref_idx = (__u8) json_object_get_int(collocated_ref_idx_obj);

	json_object *five_minus_max_num_merge_cand_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "five_minus_max_num_merge_cand", &five_minus_max_num_merge_cand_obj))
		p->five_minus_max_num_merge_cand = (__u8) json_object_get_int(five_minus_max_num_merge_cand_obj);

	json_object *slice_qp_delta_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_qp_delta", &slice_qp_delta_obj))
		p->slice_qp_delta = (__s8) json_object_get_int(slice_qp_delta_obj);

	json_object *slice_cb_qp_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_cb_qp_offset", &slice_cb_qp_offset_obj))
		p->slice_cb_qp_offset = (__s8) json_object_get_int(slice_cb_qp_offset_obj);

	json_object *slice_cr_qp_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_cr_qp_offset", &slice_cr_qp_offset_obj))
		p->slice_cr_qp_offset = (__s8) json_object_get_int(slice_cr_qp_offset_obj);

	json_object *slice_act_y_qp_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_act_y_qp_offset", &slice_act_y_qp_offset_obj))
		p->slice_act_y_qp_offset = (__s8) json_object_get_int(slice_act_y_qp_offset_obj);

	json_object *slice_act_cb_qp_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_act_cb_qp_offset", &slice_act_cb_qp_offset_obj))
		p->slice_act_cb_qp_offset = (__s8) json_object_get_int(slice_act_cb_qp_offset_obj);

	json_object *slice_act_cr_qp_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_act_cr_qp_offset", &slice_act_cr_qp_offset_obj))
		p->slice_act_cr_qp_offset = (__s8) json_object_get_int(slice_act_cr_qp_offset_obj);

	json_object *slice_beta_offset_div2_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_beta_offset_div2", &slice_beta_offset_div2_obj))
		p->slice_beta_offset_div2 = (__s8) json_object_get_int(slice_beta_offset_div2_obj);

	json_object *slice_tc_offset_div2_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_tc_offset_div2", &slice_tc_offset_div2_obj))
		p->slice_tc_offset_div2 = (__s8) json_object_get_int(slice_tc_offset_div2_obj);

	json_object *pic_struct_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "pic_struct", &pic_struct_obj))
		p->pic_struct = (__u8) json_object_get_int(pic_struct_obj);

	json_object *slice_segment_addr_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "slice_segment_addr", &slice_segment_addr_obj))
		p->slice_segment_addr = (__u32) json_object_get_int64(slice_segment_addr_obj);

	/* __u8	ref_idx_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *ref_idx_l0_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "ref_idx_l0", &ref_idx_l0_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			if (json_object_array_get_idx(ref_idx_l0_obj, i))
				p->ref_idx_l0[i] = (__u8) json_object_get_int(json_object_array_get_idx(ref_idx_l0_obj, i));
		}
	}

	/* __u8	ref_idx_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *ref_idx_l1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "ref_idx_l1", &ref_idx_l1_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			if (json_object_array_get_idx(ref_idx_l1_obj, i))
				p->ref_idx_l1[i] = (__u8) json_object_get_int(json_object_array_get_idx(ref_idx_l1_obj, i));
		}
	}

	json_object *short_term_ref_pic_set_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "short_term_ref_pic_set_size", &short_term_ref_pic_set_size_obj))
		p->short_term_ref_pic_set_size = (__u16) json_object_get_int(short_term_ref_pic_set_size_obj);

	json_object *long_term_ref_pic_set_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "long_term_ref_pic_set_size", &long_term_ref_pic_set_size_obj))
		p->long_term_ref_pic_set_size = (__u16) json_object_get_int(long_term_ref_pic_set_size_obj);

	/* struct v4l2_hevc_pred_weight_table pred_weight_table */
	json_object *pred_weight_table_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "v4l2_hevc_pred_weight_table", &pred_weight_table_obj))
		return p;
	void *pred_weight_table_ptr = (void *) retrace_v4l2_hevc_pred_weight_table_gen(pred_weight_table_obj);
	p->pred_weight_table = *static_cast<struct v4l2_hevc_pred_weight_table*>(pred_weight_table_ptr);
	free(pred_weight_table_ptr);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_slice_params_obj, "flags", &flags_obj))
		p->flags = (__u64) s2flags(json_object_get_string(flags_obj), v4l2_hevc_slice_params_flag_def);

	return p;
}

struct v4l2_ctrl_hevc_decode_params *retrace_v4l2_ctrl_hevc_decode_params_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_hevc_decode_params *p = (struct v4l2_ctrl_hevc_decode_params *) calloc(1, sizeof(v4l2_ctrl_hevc_decode_params));
	json_object *v4l2_ctrl_hevc_decode_params_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_hevc_decode_params", &v4l2_ctrl_hevc_decode_params_obj))
		v4l2_ctrl_hevc_decode_params_obj = ctrl_obj;

	json_object *pic_order_cnt_val_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "pic_order_cnt_val", &pic_order_cnt_val_obj))
		p->pic_order_cnt_val = (__s32) json_object_get_int(pic_order_cnt_val_obj);

	json_object *short_term_ref_pic_set_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "short_term_ref_pic_set_size", &short_term_ref_pic_set_size_obj))
		p->short_term_ref_pic_set_size = (__u16) json_object_get_int(short_term_ref_pic_set_size_obj);

	json_object *long_term_ref_pic_set_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "long_term_ref_pic_set_size", &long_term_ref_pic_set_size_obj))
		p->long_term_ref_pic_set_size = (__u16) json_object_get_int(long_term_ref_pic_set_size_obj);

	json_object *num_active_dpb_entries_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "num_active_dpb_entries", &num_active_dpb_entries_obj))
		p->num_active_dpb_entries = (__u8) json_object_get_int(num_active_dpb_entries_obj);

	json_object *num_poc_st_curr_before_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "num_poc_st_curr_before", &num_poc_st_curr_before_obj))
		p->num_poc_st_curr_before = (__u8) json_object_get_int(num_poc_st_curr_before_obj);

	json_object *num_poc_st_curr_after_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "num_poc_st_curr_after", &num_poc_st_curr_after_obj))
		p->num_poc_st_curr_after = (__u8) json_object_get_int(num_poc_st_curr_after_obj);

	json_object *num_poc_lt_curr_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "num_poc_lt_curr", &num_poc_lt_curr_obj))
		p->num_poc_lt_curr = (__u8) json_object_get_int(num_poc_lt_curr_obj);

	/* __u8	poc_st_curr_before[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *poc_st_curr_before_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "poc_st_curr_before", &poc_st_curr_before_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			if (json_object_array_get_idx(poc_st_curr_before_obj, i))
				p->poc_st_curr_before[i] = (__u8) json_object_get_int(json_object_array_get_idx(poc_st_curr_before_obj, i));
		}
	}

	/* __u8	poc_st_curr_after[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *poc_st_curr_after_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "poc_st_curr_after", &poc_st_curr_after_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			if (json_object_array_get_idx(poc_st_curr_after_obj, i))
				p->poc_st_curr_after[i] = (__u8) json_object_get_int(json_object_array_get_idx(poc_st_curr_after_obj, i));
		}
	}

	/* __u8	poc_lt_curr[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *poc_lt_curr_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "poc_lt_curr", &poc_lt_curr_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			if (json_object_array_get_idx(poc_lt_curr_obj, i))
				p->poc_lt_curr[i] = (__u8) json_object_get_int(json_object_array_get_idx(poc_lt_curr_obj, i));
		}
	}

	json_object *num_delta_pocs_of_ref_rps_idx_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "num_delta_pocs_of_ref_rps_idx", &num_delta_pocs_of_ref_rps_idx_obj))
		p->num_delta_pocs_of_ref_rps_idx = (__u8) json_object_get_int(num_delta_pocs_of_ref_rps_idx_obj);

	/* struct	v4l2_hevc_dpb_entry dpb[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *dpb_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "dpb", &dpb_obj)) {
		for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
			void *dpb_ptr = (void *) retrace_v4l2_hevc_dpb_entry_gen(json_object_array_get_idx(dpb_obj, i));
			p->dpb[i] = *static_cast<struct v4l2_hevc_dpb_entry*>(dpb_ptr);
			free(dpb_ptr);
		}
	}

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_decode_params_obj, "flags", &flags_obj))
		p->flags = (__u64) s2flags(json_object_get_string(flags_obj), v4l2_hevc_decode_param_flag_def);

	return p;
}

struct v4l2_ctrl_hevc_scaling_matrix *retrace_v4l2_ctrl_hevc_scaling_matrix_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_hevc_scaling_matrix *p = (struct v4l2_ctrl_hevc_scaling_matrix *) calloc(1, sizeof(v4l2_ctrl_hevc_scaling_matrix));
	json_object *v4l2_ctrl_hevc_scaling_matrix_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_hevc_scaling_matrix", &v4l2_ctrl_hevc_scaling_matrix_obj))
		v4l2_ctrl_hevc_scaling_matrix_obj = ctrl_obj;

	/* __u8	scaling_list_4x4[6][16] */
	int count_scaling_list_4x4 = 0;
	json_object *scaling_list_4x4_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_4x4", &scaling_list_4x4_obj)) {
		for (size_t i = 0; i < 6; i++) {
			for (size_t j = 0; j < 16; j++) {
				if (json_object_array_get_idx(scaling_list_4x4_obj, count_scaling_list_4x4))
					p->scaling_list_4x4[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(scaling_list_4x4_obj, count_scaling_list_4x4++));
			}
		}
	}

	/* __u8	scaling_list_8x8[6][64] */
	int count_scaling_list_8x8 = 0;
	json_object *scaling_list_8x8_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_8x8", &scaling_list_8x8_obj)) {
		for (size_t i = 0; i < 6; i++) {
			for (size_t j = 0; j < 64; j++) {
				if (json_object_array_get_idx(scaling_list_8x8_obj, count_scaling_list_8x8))
					p->scaling_list_8x8[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(scaling_list_8x8_obj, count_scaling_list_8x8++));
			}
		}
	}

	/* __u8	scaling_list_16x16[6][64] */
	int count_scaling_list_16x16 = 0;
	json_object *scaling_list_16x16_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_16x16", &scaling_list_16x16_obj)) {
		for (size_t i = 0; i < 6; i++) {
			for (size_t j = 0; j < 64; j++) {
				if (json_object_array_get_idx(scaling_list_16x16_obj, count_scaling_list_16x16))
					p->scaling_list_16x16[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(scaling_list_16x16_obj, count_scaling_list_16x16++));
			}
		}
	}

	/* __u8	scaling_list_32x32[2][64] */
	int count_scaling_list_32x32 = 0;
	json_object *scaling_list_32x32_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_32x32", &scaling_list_32x32_obj)) {
		for (size_t i = 0; i < 2; i++) {
			for (size_t j = 0; j < 64; j++) {
				if (json_object_array_get_idx(scaling_list_32x32_obj, count_scaling_list_32x32))
					p->scaling_list_32x32[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(scaling_list_32x32_obj, count_scaling_list_32x32++));
			}
		}
	}

	/* __u8	scaling_list_dc_coef_16x16[6] */
	json_object *scaling_list_dc_coef_16x16_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_dc_coef_16x16", &scaling_list_dc_coef_16x16_obj)) {
		for (size_t i = 0; i < 6; i++) {
			if (json_object_array_get_idx(scaling_list_dc_coef_16x16_obj, i))
				p->scaling_list_dc_coef_16x16[i] = (__u8) json_object_get_int(json_object_array_get_idx(scaling_list_dc_coef_16x16_obj, i));
		}
	}

	/* __u8	scaling_list_dc_coef_32x32[2] */
	json_object *scaling_list_dc_coef_32x32_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_dc_coef_32x32", &scaling_list_dc_coef_32x32_obj)) {
		for (size_t i = 0; i < 2; i++) {
			if (json_object_array_get_idx(scaling_list_dc_coef_32x32_obj, i))
				p->scaling_list_dc_coef_32x32[i] = (__u8) json_object_get_int(json_object_array_get_idx(scaling_list_dc_coef_32x32_obj, i));
		}
	}

	return p;
}

struct v4l2_ctrl_hdr10_cll_info *retrace_v4l2_ctrl_hdr10_cll_info_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_hdr10_cll_info *p = (struct v4l2_ctrl_hdr10_cll_info *) calloc(1, sizeof(v4l2_ctrl_hdr10_cll_info));
	json_object *v4l2_ctrl_hdr10_cll_info_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_hdr10_cll_info", &v4l2_ctrl_hdr10_cll_info_obj))
		v4l2_ctrl_hdr10_cll_info_obj = ctrl_obj;

	json_object *max_content_light_level_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hdr10_cll_info_obj, "max_content_light_level", &max_content_light_level_obj))
		p->max_content_light_level = (__u16) json_object_get_int(max_content_light_level_obj);

	json_object *max_pic_average_light_level_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hdr10_cll_info_obj, "max_pic_average_light_level", &max_pic_average_light_level_obj))
		p->max_pic_average_light_level = (__u16) json_object_get_int(max_pic_average_light_level_obj);

	return p;
}

struct v4l2_ctrl_hdr10_mastering_display *retrace_v4l2_ctrl_hdr10_mastering_display_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_hdr10_mastering_display *p = (struct v4l2_ctrl_hdr10_mastering_display *) calloc(1, sizeof(v4l2_ctrl_hdr10_mastering_display));
	json_object *v4l2_ctrl_hdr10_mastering_display_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_hdr10_mastering_display", &v4l2_ctrl_hdr10_mastering_display_obj))
		v4l2_ctrl_hdr10_mastering_display_obj = ctrl_obj;

	/* __u16 display_primaries_x[3] */
	json_object *display_primaries_x_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hdr10_mastering_display_obj, "display_primaries_x", &display_primaries_x_obj)) {
		for (size_t i = 0; i < 3; i++) {
			if (json_object_array_get_idx(display_primaries_x_obj, i))
				p->display_primaries_x[i] = (__u16) json_object_get_int(json_object_array_get_idx(display_primaries_x_obj, i));
		}
	}

	/* __u16 display_primaries_y[3] */
	json_object *display_primaries_y_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hdr10_mastering_display_obj, "display_primaries_y", &display_primaries_y_obj)) {
		for (size_t i = 0; i < 3; i++) {
			if (json_object_array_get_idx(display_primaries_y_obj, i))
				p->display_primaries_y[i] = (__u16) json_object_get_int(json_object_array_get_idx(display_primaries_y_obj, i));
		}
	}

	json_object *white_point_x_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hdr10_mastering_display_obj, "white_point_x", &white_point_x_obj))
		p->white_point_x = (__u16) json_object_get_int(white_point_x_obj);

	json_object *white_point_y_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hdr10_mastering_display_obj, "white_point_y", &white_point_y_obj))
		p->white_point_y = (__u16) json_object_get_int(white_point_y_obj);

	json_object *max_display_mastering_luminance_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hdr10_mastering_display_obj, "max_display_mastering_luminance", &max_display_mastering_luminance_obj))
		p->max_display_mastering_luminance = (__u32) json_object_get_int64(max_display_mastering_luminance_obj);

	json_object *min_display_mastering_luminance_obj;
	if (json_object_object_get_ex(v4l2_ctrl_hdr10_mastering_display_obj, "min_display_mastering_luminance", &min_display_mastering_luminance_obj))
		p->min_display_mastering_luminance = (__u32) json_object_get_int64(min_display_mastering_luminance_obj);

	return p;
}

struct v4l2_vp9_loop_filter *retrace_v4l2_vp9_loop_filter_gen(json_object *ctrl_obj)
{
	struct v4l2_vp9_loop_filter *p = (struct v4l2_vp9_loop_filter *) calloc(1, sizeof(v4l2_vp9_loop_filter));
	json_object *v4l2_vp9_loop_filter_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_vp9_loop_filter", &v4l2_vp9_loop_filter_obj))
		v4l2_vp9_loop_filter_obj = ctrl_obj;

	/* __s8 ref_deltas[4] */
	json_object *ref_deltas_obj;
	if (json_object_object_get_ex(v4l2_vp9_loop_filter_obj, "ref_deltas", &ref_deltas_obj)) {
		for (size_t i = 0; i < 4; i++) {
			if (json_object_array_get_idx(ref_deltas_obj, i))
				p->ref_deltas[i] = (__s8) json_object_get_int(json_object_array_get_idx(ref_deltas_obj, i));
		}
	}

	/* __s8 mode_deltas[2] */
	json_object *mode_deltas_obj;
	if (json_object_object_get_ex(v4l2_vp9_loop_filter_obj, "mode_deltas", &mode_deltas_obj)) {
		for (size_t i = 0; i < 2; i++) {
			if (json_object_array_get_idx(mode_deltas_obj, i))
				p->mode_deltas[i] = (__s8) json_object_get_int(json_object_array_get_idx(mode_deltas_obj, i));
		}
	}

	json_object *level_obj;
	if (json_object_object_get_ex(v4l2_vp9_loop_filter_obj, "level", &level_obj))
		p->level = (__u8) json_object_get_int(level_obj);

	json_object *sharpness_obj;
	if (json_object_object_get_ex(v4l2_vp9_loop_filter_obj, "sharpness", &sharpness_obj))
		p->sharpness = (__u8) json_object_get_int(sharpness_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_vp9_loop_filter_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_vp9_loop_filter_flag_def);

	return p;
}

struct v4l2_vp9_quantization *retrace_v4l2_vp9_quantization_gen(json_object *ctrl_obj)
{
	struct v4l2_vp9_quantization *p = (struct v4l2_vp9_quantization *) calloc(1, sizeof(v4l2_vp9_quantization));
	json_object *v4l2_vp9_quantization_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_vp9_quantization", &v4l2_vp9_quantization_obj))
		v4l2_vp9_quantization_obj = ctrl_obj;

	json_object *base_q_idx_obj;
	if (json_object_object_get_ex(v4l2_vp9_quantization_obj, "base_q_idx", &base_q_idx_obj))
		p->base_q_idx = (__u8) json_object_get_int(base_q_idx_obj);

	json_object *delta_q_y_dc_obj;
	if (json_object_object_get_ex(v4l2_vp9_quantization_obj, "delta_q_y_dc", &delta_q_y_dc_obj))
		p->delta_q_y_dc = (__s8) json_object_get_int(delta_q_y_dc_obj);

	json_object *delta_q_uv_dc_obj;
	if (json_object_object_get_ex(v4l2_vp9_quantization_obj, "delta_q_uv_dc", &delta_q_uv_dc_obj))
		p->delta_q_uv_dc = (__s8) json_object_get_int(delta_q_uv_dc_obj);

	json_object *delta_q_uv_ac_obj;
	if (json_object_object_get_ex(v4l2_vp9_quantization_obj, "delta_q_uv_ac", &delta_q_uv_ac_obj))
		p->delta_q_uv_ac = (__s8) json_object_get_int(delta_q_uv_ac_obj);

	return p;
}

struct v4l2_vp9_segmentation *retrace_v4l2_vp9_segmentation_gen(json_object *ctrl_obj)
{
	struct v4l2_vp9_segmentation *p = (struct v4l2_vp9_segmentation *) calloc(1, sizeof(v4l2_vp9_segmentation));
	json_object *v4l2_vp9_segmentation_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_vp9_segmentation", &v4l2_vp9_segmentation_obj))
		v4l2_vp9_segmentation_obj = ctrl_obj;

	/* __s16 feature_data[8][4] */
	int count_feature_data = 0;
	json_object *feature_data_obj;
	if (json_object_object_get_ex(v4l2_vp9_segmentation_obj, "feature_data", &feature_data_obj)) {
		for (size_t i = 0; i < 8; i++) {
			for (size_t j = 0; j < 4; j++) {
				if (json_object_array_get_idx(feature_data_obj, count_feature_data))
					p->feature_data[i][j] = (__s16) json_object_get_int(json_object_array_get_idx(feature_data_obj, count_feature_data++));
			}
		}
	}

	/* __u8 feature_enabled[8] */
	json_object *feature_enabled_obj;
	if (json_object_object_get_ex(v4l2_vp9_segmentation_obj, "feature_enabled", &feature_enabled_obj)) {
		for (size_t i = 0; i < 8; i++) {
			if (json_object_array_get_idx(feature_enabled_obj, i))
				p->feature_enabled[i] = (__u8) json_object_get_int(json_object_array_get_idx(feature_enabled_obj, i));
		}
	}

	/* __u8 tree_probs[7] */
	json_object *tree_probs_obj;
	if (json_object_object_get_ex(v4l2_vp9_segmentation_obj, "tree_probs", &tree_probs_obj)) {
		for (size_t i = 0; i < 7; i++) {
			if (json_object_array_get_idx(tree_probs_obj, i))
				p->tree_probs[i] = (__u8) json_object_get_int(json_object_array_get_idx(tree_probs_obj, i));
		}
	}

	/* __u8 pred_probs[3] */
	json_object *pred_probs_obj;
	if (json_object_object_get_ex(v4l2_vp9_segmentation_obj, "pred_probs", &pred_probs_obj)) {
		for (size_t i = 0; i < 3; i++) {
			if (json_object_array_get_idx(pred_probs_obj, i))
				p->pred_probs[i] = (__u8) json_object_get_int(json_object_array_get_idx(pred_probs_obj, i));
		}
	}

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_vp9_segmentation_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_vp9_segmentation_flag_def);

	return p;
}

struct v4l2_ctrl_vp9_frame *retrace_v4l2_ctrl_vp9_frame_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_vp9_frame *p = (struct v4l2_ctrl_vp9_frame *) calloc(1, sizeof(v4l2_ctrl_vp9_frame));
	json_object *v4l2_ctrl_vp9_frame_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_vp9_frame", &v4l2_ctrl_vp9_frame_obj))
		v4l2_ctrl_vp9_frame_obj = ctrl_obj;

	/* struct v4l2_vp9_loop_filter lf */
	json_object *lf_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "v4l2_vp9_loop_filter", &lf_obj))
		return p;
	void *lf_ptr = (void *) retrace_v4l2_vp9_loop_filter_gen(lf_obj);
	p->lf = *static_cast<struct v4l2_vp9_loop_filter*>(lf_ptr);
	free(lf_ptr);

	/* struct v4l2_vp9_quantization quant */
	json_object *quant_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "v4l2_vp9_quantization", &quant_obj))
		return p;
	void *quant_ptr = (void *) retrace_v4l2_vp9_quantization_gen(quant_obj);
	p->quant = *static_cast<struct v4l2_vp9_quantization*>(quant_ptr);
	free(quant_ptr);

	/* struct v4l2_vp9_segmentation seg */
	json_object *seg_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "v4l2_vp9_segmentation", &seg_obj))
		return p;
	void *seg_ptr = (void *) retrace_v4l2_vp9_segmentation_gen(seg_obj);
	p->seg = *static_cast<struct v4l2_vp9_segmentation*>(seg_ptr);
	free(seg_ptr);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_vp9_frame_flag_def);

	json_object *compressed_header_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "compressed_header_size", &compressed_header_size_obj))
		p->compressed_header_size = (__u16) json_object_get_int(compressed_header_size_obj);

	json_object *uncompressed_header_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "uncompressed_header_size", &uncompressed_header_size_obj))
		p->uncompressed_header_size = (__u16) json_object_get_int(uncompressed_header_size_obj);

	json_object *frame_width_minus_1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "frame_width_minus_1", &frame_width_minus_1_obj))
		p->frame_width_minus_1 = (__u16) json_object_get_int(frame_width_minus_1_obj);

	json_object *frame_height_minus_1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "frame_height_minus_1", &frame_height_minus_1_obj))
		p->frame_height_minus_1 = (__u16) json_object_get_int(frame_height_minus_1_obj);

	json_object *render_width_minus_1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "render_width_minus_1", &render_width_minus_1_obj))
		p->render_width_minus_1 = (__u16) json_object_get_int(render_width_minus_1_obj);

	json_object *render_height_minus_1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "render_height_minus_1", &render_height_minus_1_obj))
		p->render_height_minus_1 = (__u16) json_object_get_int(render_height_minus_1_obj);

	json_object *last_frame_ts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "last_frame_ts", &last_frame_ts_obj))
		p->last_frame_ts = (__u64) json_object_get_uint64(last_frame_ts_obj);

	json_object *golden_frame_ts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "golden_frame_ts", &golden_frame_ts_obj))
		p->golden_frame_ts = (__u64) json_object_get_uint64(golden_frame_ts_obj);

	json_object *alt_frame_ts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "alt_frame_ts", &alt_frame_ts_obj))
		p->alt_frame_ts = (__u64) json_object_get_uint64(alt_frame_ts_obj);

	json_object *ref_frame_sign_bias_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "ref_frame_sign_bias", &ref_frame_sign_bias_obj))
		p->ref_frame_sign_bias = (__u8) json_object_get_int(ref_frame_sign_bias_obj);

	json_object *reset_frame_context_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "reset_frame_context", &reset_frame_context_obj))
		p->reset_frame_context = (__u8) json_object_get_int(reset_frame_context_obj);

	json_object *frame_context_idx_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "frame_context_idx", &frame_context_idx_obj))
		p->frame_context_idx = (__u8) json_object_get_int(frame_context_idx_obj);

	json_object *profile_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "profile", &profile_obj))
		p->profile = (__u8) json_object_get_int(profile_obj);

	json_object *bit_depth_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "bit_depth", &bit_depth_obj))
		p->bit_depth = (__u8) json_object_get_int(bit_depth_obj);

	json_object *interpolation_filter_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "interpolation_filter", &interpolation_filter_obj))
		p->interpolation_filter = (__u8) json_object_get_int(interpolation_filter_obj);

	json_object *tile_cols_log2_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "tile_cols_log2", &tile_cols_log2_obj))
		p->tile_cols_log2 = (__u8) json_object_get_int(tile_cols_log2_obj);

	json_object *tile_rows_log2_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "tile_rows_log2", &tile_rows_log2_obj))
		p->tile_rows_log2 = (__u8) json_object_get_int(tile_rows_log2_obj);

	json_object *reference_mode_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_frame_obj, "reference_mode", &reference_mode_obj))
		p->reference_mode = (__u8) json_object_get_int(reference_mode_obj);

	return p;
}

struct v4l2_vp9_mv_probs *retrace_v4l2_vp9_mv_probs_gen(json_object *ctrl_obj)
{
	struct v4l2_vp9_mv_probs *p = (struct v4l2_vp9_mv_probs *) calloc(1, sizeof(v4l2_vp9_mv_probs));
	json_object *v4l2_vp9_mv_probs_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_vp9_mv_probs", &v4l2_vp9_mv_probs_obj))
		v4l2_vp9_mv_probs_obj = ctrl_obj;

	/* __u8 joint[3] */
	json_object *joint_obj;
	if (json_object_object_get_ex(v4l2_vp9_mv_probs_obj, "joint", &joint_obj)) {
		for (size_t i = 0; i < 3; i++) {
			if (json_object_array_get_idx(joint_obj, i))
				p->joint[i] = (__u8) json_object_get_int(json_object_array_get_idx(joint_obj, i));
		}
	}

	/* __u8 sign[2] */
	json_object *sign_obj;
	if (json_object_object_get_ex(v4l2_vp9_mv_probs_obj, "sign", &sign_obj)) {
		for (size_t i = 0; i < 2; i++) {
			if (json_object_array_get_idx(sign_obj, i))
				p->sign[i] = (__u8) json_object_get_int(json_object_array_get_idx(sign_obj, i));
		}
	}

	/* __u8 classes[2][10] */
	int count_classes = 0;
	json_object *classes_obj;
	if (json_object_object_get_ex(v4l2_vp9_mv_probs_obj, "classes", &classes_obj)) {
		for (size_t i = 0; i < 2; i++) {
			for (size_t j = 0; j < 10; j++) {
				if (json_object_array_get_idx(classes_obj, count_classes))
					p->classes[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(classes_obj, count_classes++));
			}
		}
	}

	/* __u8 class0_bit[2] */
	json_object *class0_bit_obj;
	if (json_object_object_get_ex(v4l2_vp9_mv_probs_obj, "class0_bit", &class0_bit_obj)) {
		for (size_t i = 0; i < 2; i++) {
			if (json_object_array_get_idx(class0_bit_obj, i))
				p->class0_bit[i] = (__u8) json_object_get_int(json_object_array_get_idx(class0_bit_obj, i));
		}
	}

	/* __u8 bits[2][10] */
	int count_bits = 0;
	json_object *bits_obj;
	if (json_object_object_get_ex(v4l2_vp9_mv_probs_obj, "bits", &bits_obj)) {
		for (size_t i = 0; i < 2; i++) {
			for (size_t j = 0; j < 10; j++) {
				if (json_object_array_get_idx(bits_obj, count_bits))
					p->bits[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(bits_obj, count_bits++));
			}
		}
	}

	/* __u8 class0_fr[2][2][3] */
	int count_class0_fr = 0;
	json_object *class0_fr_obj;
	if (json_object_object_get_ex(v4l2_vp9_mv_probs_obj, "class0_fr", &class0_fr_obj)) {
		for (size_t i = 0; i < 2; i++) {
			for (size_t j = 0; j < 2; j++) {
				for (size_t k = 0; k < 3; k++) {
					if (json_object_array_get_idx(class0_fr_obj, count_class0_fr))
						p->class0_fr[i][j][k] = (__u8) json_object_get_int(json_object_array_get_idx(class0_fr_obj, count_class0_fr++));
				}
			}
		}
	}

	/* __u8 fr[2][3] */
	int count_fr = 0;
	json_object *fr_obj;
	if (json_object_object_get_ex(v4l2_vp9_mv_probs_obj, "fr", &fr_obj)) {
		for (size_t i = 0; i < 2; i++) {
			for (size_t j = 0; j < 3; j++) {
				if (json_object_array_get_idx(fr_obj, count_fr))
					p->fr[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(fr_obj, count_fr++));
			}
		}
	}

	/* __u8 class0_hp[2] */
	json_object *class0_hp_obj;
	if (json_object_object_get_ex(v4l2_vp9_mv_probs_obj, "class0_hp", &class0_hp_obj)) {
		for (size_t i = 0; i < 2; i++) {
			if (json_object_array_get_idx(class0_hp_obj, i))
				p->class0_hp[i] = (__u8) json_object_get_int(json_object_array_get_idx(class0_hp_obj, i));
		}
	}

	/* __u8 hp[2] */
	json_object *hp_obj;
	if (json_object_object_get_ex(v4l2_vp9_mv_probs_obj, "hp", &hp_obj)) {
		for (size_t i = 0; i < 2; i++) {
			if (json_object_array_get_idx(hp_obj, i))
				p->hp[i] = (__u8) json_object_get_int(json_object_array_get_idx(hp_obj, i));
		}
	}

	return p;
}

struct v4l2_ctrl_vp9_compressed_hdr *retrace_v4l2_ctrl_vp9_compressed_hdr_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_vp9_compressed_hdr *p = (struct v4l2_ctrl_vp9_compressed_hdr *) calloc(1, sizeof(v4l2_ctrl_vp9_compressed_hdr));
	json_object *v4l2_ctrl_vp9_compressed_hdr_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_vp9_compressed_hdr", &v4l2_ctrl_vp9_compressed_hdr_obj))
		v4l2_ctrl_vp9_compressed_hdr_obj = ctrl_obj;

	json_object *tx_mode_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "tx_mode", &tx_mode_obj))
		p->tx_mode = (__u8) json_object_get_int(tx_mode_obj);

	/* __u8 tx8[2][1] */
	int count_tx8 = 0;
	json_object *tx8_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "tx8", &tx8_obj)) {
		for (size_t i = 0; i < 2; i++) {
			for (size_t j = 0; j < 1; j++) {
				if (json_object_array_get_idx(tx8_obj, count_tx8))
					p->tx8[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(tx8_obj, count_tx8++));
			}
		}
	}

	/* __u8 tx16[2][2] */
	int count_tx16 = 0;
	json_object *tx16_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "tx16", &tx16_obj)) {
		for (size_t i = 0; i < 2; i++) {
			for (size_t j = 0; j < 2; j++) {
				if (json_object_array_get_idx(tx16_obj, count_tx16))
					p->tx16[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(tx16_obj, count_tx16++));
			}
		}
	}

	/* __u8 tx32[2][3] */
	int count_tx32 = 0;
	json_object *tx32_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "tx32", &tx32_obj)) {
		for (size_t i = 0; i < 2; i++) {
			for (size_t j = 0; j < 3; j++) {
				if (json_object_array_get_idx(tx32_obj, count_tx32))
					p->tx32[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(tx32_obj, count_tx32++));
			}
		}
	}

	/* __u8 coef[4][2][2][6][6][3] */
	int count_coef = 0;
	json_object *coef_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "coef", &coef_obj)) {
		for (size_t i = 0; i < 4; i++) {
			for (size_t j = 0; j < 2; j++) {
				for (size_t k = 0; k < 2; k++) {
					for (size_t l = 0; l < 6; l++) {
						for (size_t m = 0; m < 6; m++) {
							for (size_t n = 0; n < 3; n++) {
								if (json_object_array_get_idx(coef_obj, count_coef))
									p->coef[i][j][k][l][m][n] = (__u8) json_object_get_int(json_object_array_get_idx(coef_obj, count_coef++));
							}
						}
					}
				}
			}
		}
	}

	/* __u8 skip[3] */
	json_object *skip_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "skip", &skip_obj)) {
		for (size_t i = 0; i < 3; i++) {
			if (json_object_array_get_idx(skip_obj, i))
				p->skip[i] = (__u8) json_object_get_int(json_object_array_get_idx(skip_obj, i));
		}
	}

	/* __u8 inter_mode[7][3] */
	int count_inter_mode = 0;
	json_object *inter_mode_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "inter_mode", &inter_mode_obj)) {
		for (size_t i = 0; i < 7; i++) {
			for (size_t j = 0; j < 3; j++) {
				if (json_object_array_get_idx(inter_mode_obj, count_inter_mode))
					p->inter_mode[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(inter_mode_obj, count_inter_mode++));
			}
		}
	}

	/* __u8 interp_filter[4][2] */
	int count_interp_filter = 0;
	json_object *interp_filter_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "interp_filter", &interp_filter_obj)) {
		for (size_t i = 0; i < 4; i++) {
			for (size_t j = 0; j < 2; j++) {
				if (json_object_array_get_idx(interp_filter_obj, count_interp_filter))
					p->interp_filter[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(interp_filter_obj, count_interp_filter++));
			}
		}
	}

	/* __u8 is_inter[4] */
	json_object *is_inter_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "is_inter", &is_inter_obj)) {
		for (size_t i = 0; i < 4; i++) {
			if (json_object_array_get_idx(is_inter_obj, i))
				p->is_inter[i] = (__u8) json_object_get_int(json_object_array_get_idx(is_inter_obj, i));
		}
	}

	/* __u8 comp_mode[5] */
	json_object *comp_mode_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "comp_mode", &comp_mode_obj)) {
		for (size_t i = 0; i < 5; i++) {
			if (json_object_array_get_idx(comp_mode_obj, i))
				p->comp_mode[i] = (__u8) json_object_get_int(json_object_array_get_idx(comp_mode_obj, i));
		}
	}

	/* __u8 single_ref[5][2] */
	int count_single_ref = 0;
	json_object *single_ref_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "single_ref", &single_ref_obj)) {
		for (size_t i = 0; i < 5; i++) {
			for (size_t j = 0; j < 2; j++) {
				if (json_object_array_get_idx(single_ref_obj, count_single_ref))
					p->single_ref[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(single_ref_obj, count_single_ref++));
			}
		}
	}

	/* __u8 comp_ref[5] */
	json_object *comp_ref_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "comp_ref", &comp_ref_obj)) {
		for (size_t i = 0; i < 5; i++) {
			if (json_object_array_get_idx(comp_ref_obj, i))
				p->comp_ref[i] = (__u8) json_object_get_int(json_object_array_get_idx(comp_ref_obj, i));
		}
	}

	/* __u8 y_mode[4][9] */
	int count_y_mode = 0;
	json_object *y_mode_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "y_mode", &y_mode_obj)) {
		for (size_t i = 0; i < 4; i++) {
			for (size_t j = 0; j < 9; j++) {
				if (json_object_array_get_idx(y_mode_obj, count_y_mode))
					p->y_mode[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(y_mode_obj, count_y_mode++));
			}
		}
	}

	/* __u8 uv_mode[10][9] */
	int count_uv_mode = 0;
	json_object *uv_mode_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "uv_mode", &uv_mode_obj)) {
		for (size_t i = 0; i < 10; i++) {
			for (size_t j = 0; j < 9; j++) {
				if (json_object_array_get_idx(uv_mode_obj, count_uv_mode))
					p->uv_mode[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(uv_mode_obj, count_uv_mode++));
			}
		}
	}

	/* __u8 partition[16][3] */
	int count_partition = 0;
	json_object *partition_obj;
	if (json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "partition", &partition_obj)) {
		for (size_t i = 0; i < 16; i++) {
			for (size_t j = 0; j < 3; j++) {
				if (json_object_array_get_idx(partition_obj, count_partition))
					p->partition[i][j] = (__u8) json_object_get_int(json_object_array_get_idx(partition_obj, count_partition++));
			}
		}
	}

	/* struct v4l2_vp9_mv_probs mv */
	json_object *mv_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_vp9_compressed_hdr_obj, "v4l2_vp9_mv_probs", &mv_obj))
		return p;
	void *mv_ptr = (void *) retrace_v4l2_vp9_mv_probs_gen(mv_obj);
	p->mv = *static_cast<struct v4l2_vp9_mv_probs*>(mv_ptr);
	free(mv_ptr);

	return p;
}

struct v4l2_ctrl_av1_sequence *retrace_v4l2_ctrl_av1_sequence_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_av1_sequence *p = (struct v4l2_ctrl_av1_sequence *) calloc(1, sizeof(v4l2_ctrl_av1_sequence));
	json_object *v4l2_ctrl_av1_sequence_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_av1_sequence", &v4l2_ctrl_av1_sequence_obj))
		v4l2_ctrl_av1_sequence_obj = ctrl_obj;

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_sequence_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_av1_sequence_flag_def);

	json_object *seq_profile_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_sequence_obj, "seq_profile", &seq_profile_obj))
		p->seq_profile = (__u8) json_object_get_int(seq_profile_obj);

	json_object *order_hint_bits_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_sequence_obj, "order_hint_bits", &order_hint_bits_obj))
		p->order_hint_bits = (__u8) json_object_get_int(order_hint_bits_obj);

	json_object *bit_depth_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_sequence_obj, "bit_depth", &bit_depth_obj))
		p->bit_depth = (__u8) json_object_get_int(bit_depth_obj);

	json_object *max_frame_width_minus_1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_sequence_obj, "max_frame_width_minus_1", &max_frame_width_minus_1_obj))
		p->max_frame_width_minus_1 = (__u16) json_object_get_int(max_frame_width_minus_1_obj);

	json_object *max_frame_height_minus_1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_sequence_obj, "max_frame_height_minus_1", &max_frame_height_minus_1_obj))
		p->max_frame_height_minus_1 = (__u16) json_object_get_int(max_frame_height_minus_1_obj);

	return p;
}

struct v4l2_ctrl_av1_tile_group_entry *retrace_v4l2_ctrl_av1_tile_group_entry_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_av1_tile_group_entry *p = (struct v4l2_ctrl_av1_tile_group_entry *) calloc(1, sizeof(v4l2_ctrl_av1_tile_group_entry));
	json_object *v4l2_ctrl_av1_tile_group_entry_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_av1_tile_group_entry", &v4l2_ctrl_av1_tile_group_entry_obj))
		v4l2_ctrl_av1_tile_group_entry_obj = ctrl_obj;

	json_object *tile_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_tile_group_entry_obj, "tile_offset", &tile_offset_obj))
		p->tile_offset = (__u32) json_object_get_int64(tile_offset_obj);

	json_object *tile_size_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_tile_group_entry_obj, "tile_size", &tile_size_obj))
		p->tile_size = (__u32) json_object_get_int64(tile_size_obj);

	json_object *tile_row_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_tile_group_entry_obj, "tile_row", &tile_row_obj))
		p->tile_row = (__u32) json_object_get_int64(tile_row_obj);

	json_object *tile_col_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_tile_group_entry_obj, "tile_col", &tile_col_obj))
		p->tile_col = (__u32) json_object_get_int64(tile_col_obj);

	return p;
}

struct v4l2_av1_global_motion *retrace_v4l2_av1_global_motion_gen(json_object *ctrl_obj)
{
	struct v4l2_av1_global_motion *p = (struct v4l2_av1_global_motion *) calloc(1, sizeof(v4l2_av1_global_motion));
	json_object *v4l2_av1_global_motion_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_av1_global_motion", &v4l2_av1_global_motion_obj))
		v4l2_av1_global_motion_obj = ctrl_obj;

	/* __u8 flags[V4L2_AV1_TOTAL_REFS_PER_FRAME] */
	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_av1_global_motion_obj, "flags", &flags_obj)) {
		for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
			if (json_object_array_get_idx(flags_obj, i))
				p->flags[i] = (__u8) json_object_get_int(json_object_array_get_idx(flags_obj, i));
		}
	}

	/* enum v4l2_av1_warp_model type[V4L2_AV1_TOTAL_REFS_PER_FRAME] */
	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_av1_global_motion_obj, "type", &type_obj)) {
		for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
			if (json_object_array_get_idx(type_obj, i))
				p->type[i] = (v4l2_av1_warp_model) json_object_get_int(json_object_array_get_idx(type_obj, i));
		}
	}

	/* __s32 params[V4L2_AV1_TOTAL_REFS_PER_FRAME][6] */
	int count_params = 0;
	json_object *params_obj;
	if (json_object_object_get_ex(v4l2_av1_global_motion_obj, "params", &params_obj)) {
		for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
			for (size_t j = 0; j < 6; j++) {
				if (json_object_array_get_idx(params_obj, count_params))
					p->params[i][j] = (__s32) json_object_get_int(json_object_array_get_idx(params_obj, count_params++));
			}
		}
	}

	json_object *invalid_obj;
	if (json_object_object_get_ex(v4l2_av1_global_motion_obj, "invalid", &invalid_obj))
		p->invalid = (__u8) json_object_get_int(invalid_obj);

	return p;
}

struct v4l2_av1_loop_restoration *retrace_v4l2_av1_loop_restoration_gen(json_object *ctrl_obj)
{
	struct v4l2_av1_loop_restoration *p = (struct v4l2_av1_loop_restoration *) calloc(1, sizeof(v4l2_av1_loop_restoration));
	json_object *v4l2_av1_loop_restoration_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_av1_loop_restoration", &v4l2_av1_loop_restoration_obj))
		v4l2_av1_loop_restoration_obj = ctrl_obj;

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_restoration_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_av1_loop_restoration_flag_def);

	json_object *lr_unit_shift_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_restoration_obj, "lr_unit_shift", &lr_unit_shift_obj))
		p->lr_unit_shift = (__u8) json_object_get_int(lr_unit_shift_obj);

	json_object *lr_uv_shift_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_restoration_obj, "lr_uv_shift", &lr_uv_shift_obj))
		p->lr_uv_shift = (__u8) json_object_get_int(lr_uv_shift_obj);

	/* enum v4l2_av1_frame_restoration_type frame_restoration_type[V4L2_AV1_NUM_PLANES_MAX] */
	json_object *frame_restoration_type_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_restoration_obj, "frame_restoration_type", &frame_restoration_type_obj)) {
		for (size_t i = 0; i < V4L2_AV1_NUM_PLANES_MAX; i++) {
			if (json_object_array_get_idx(frame_restoration_type_obj, i))
				p->frame_restoration_type[i] = (v4l2_av1_frame_restoration_type) json_object_get_int(json_object_array_get_idx(frame_restoration_type_obj, i));
		}
	}

	/* __u32 loop_restoration_size[V4L2_AV1_MAX_NUM_PLANES] */
	json_object *loop_restoration_size_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_restoration_obj, "loop_restoration_size", &loop_restoration_size_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_NUM_PLANES; i++) {
			if (json_object_array_get_idx(loop_restoration_size_obj, i))
				p->loop_restoration_size[i] = (__u32) json_object_get_int64(json_object_array_get_idx(loop_restoration_size_obj, i));
		}
	}

	return p;
}

struct v4l2_av1_cdef *retrace_v4l2_av1_cdef_gen(json_object *ctrl_obj)
{
	struct v4l2_av1_cdef *p = (struct v4l2_av1_cdef *) calloc(1, sizeof(v4l2_av1_cdef));
	json_object *v4l2_av1_cdef_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_av1_cdef", &v4l2_av1_cdef_obj))
		v4l2_av1_cdef_obj = ctrl_obj;

	json_object *damping_minus_3_obj;
	if (json_object_object_get_ex(v4l2_av1_cdef_obj, "damping_minus_3", &damping_minus_3_obj))
		p->damping_minus_3 = (__u8) json_object_get_int(damping_minus_3_obj);

	json_object *bits_obj;
	if (json_object_object_get_ex(v4l2_av1_cdef_obj, "bits", &bits_obj))
		p->bits = (__u8) json_object_get_int(bits_obj);

	/* __u8 y_pri_strength[V4L2_AV1_CDEF_MAX] */
	json_object *y_pri_strength_obj;
	if (json_object_object_get_ex(v4l2_av1_cdef_obj, "y_pri_strength", &y_pri_strength_obj)) {
		for (size_t i = 0; i < V4L2_AV1_CDEF_MAX; i++) {
			if (json_object_array_get_idx(y_pri_strength_obj, i))
				p->y_pri_strength[i] = (__u8) json_object_get_int(json_object_array_get_idx(y_pri_strength_obj, i));
		}
	}

	/* __u8 y_sec_strength[V4L2_AV1_CDEF_MAX] */
	json_object *y_sec_strength_obj;
	if (json_object_object_get_ex(v4l2_av1_cdef_obj, "y_sec_strength", &y_sec_strength_obj)) {
		for (size_t i = 0; i < V4L2_AV1_CDEF_MAX; i++) {
			if (json_object_array_get_idx(y_sec_strength_obj, i))
				p->y_sec_strength[i] = (__u8) json_object_get_int(json_object_array_get_idx(y_sec_strength_obj, i));
		}
	}

	/* __u8 uv_pri_strength[V4L2_AV1_CDEF_MAX] */
	json_object *uv_pri_strength_obj;
	if (json_object_object_get_ex(v4l2_av1_cdef_obj, "uv_pri_strength", &uv_pri_strength_obj)) {
		for (size_t i = 0; i < V4L2_AV1_CDEF_MAX; i++) {
			if (json_object_array_get_idx(uv_pri_strength_obj, i))
				p->uv_pri_strength[i] = (__u8) json_object_get_int(json_object_array_get_idx(uv_pri_strength_obj, i));
		}
	}

	/* __u8 uv_sec_strength[V4L2_AV1_CDEF_MAX] */
	json_object *uv_sec_strength_obj;
	if (json_object_object_get_ex(v4l2_av1_cdef_obj, "uv_sec_strength", &uv_sec_strength_obj)) {
		for (size_t i = 0; i < V4L2_AV1_CDEF_MAX; i++) {
			if (json_object_array_get_idx(uv_sec_strength_obj, i))
				p->uv_sec_strength[i] = (__u8) json_object_get_int(json_object_array_get_idx(uv_sec_strength_obj, i));
		}
	}

	return p;
}

struct v4l2_av1_segmentation *retrace_v4l2_av1_segmentation_gen(json_object *ctrl_obj)
{
	struct v4l2_av1_segmentation *p = (struct v4l2_av1_segmentation *) calloc(1, sizeof(v4l2_av1_segmentation));
	json_object *v4l2_av1_segmentation_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_av1_segmentation", &v4l2_av1_segmentation_obj))
		v4l2_av1_segmentation_obj = ctrl_obj;

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_av1_segmentation_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_av1_segmentation_flag_def);

	json_object *last_active_seg_id_obj;
	if (json_object_object_get_ex(v4l2_av1_segmentation_obj, "last_active_seg_id", &last_active_seg_id_obj))
		p->last_active_seg_id = (__u8) json_object_get_int(last_active_seg_id_obj);

	/* __u8 feature_enabled[V4L2_AV1_MAX_SEGMENTS] */
	json_object *feature_enabled_obj;
	if (json_object_object_get_ex(v4l2_av1_segmentation_obj, "feature_enabled", &feature_enabled_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_SEGMENTS; i++) {
			if (json_object_array_get_idx(feature_enabled_obj, i))
				p->feature_enabled[i] = (__u8) json_object_get_int(json_object_array_get_idx(feature_enabled_obj, i));
		}
	}

	/* __s16 feature_data[V4L2_AV1_MAX_SEGMENTS][V4L2_AV1_SEG_LVL_MAX] */
	int count_feature_data = 0;
	json_object *feature_data_obj;
	if (json_object_object_get_ex(v4l2_av1_segmentation_obj, "feature_data", &feature_data_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_SEGMENTS; i++) {
			for (size_t j = 0; j < V4L2_AV1_SEG_LVL_MAX; j++) {
				if (json_object_array_get_idx(feature_data_obj, count_feature_data))
					p->feature_data[i][j] = (__s16) json_object_get_int(json_object_array_get_idx(feature_data_obj, count_feature_data++));
			}
		}
	}

	return p;
}

struct v4l2_av1_loop_filter *retrace_v4l2_av1_loop_filter_gen(json_object *ctrl_obj)
{
	struct v4l2_av1_loop_filter *p = (struct v4l2_av1_loop_filter *) calloc(1, sizeof(v4l2_av1_loop_filter));
	json_object *v4l2_av1_loop_filter_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_av1_loop_filter", &v4l2_av1_loop_filter_obj))
		v4l2_av1_loop_filter_obj = ctrl_obj;

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_filter_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_av1_loop_filter_flag_def);

	/* __u8 level[4] */
	json_object *level_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_filter_obj, "level", &level_obj)) {
		for (size_t i = 0; i < 4; i++) {
			if (json_object_array_get_idx(level_obj, i))
				p->level[i] = (__u8) json_object_get_int(json_object_array_get_idx(level_obj, i));
		}
	}

	json_object *sharpness_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_filter_obj, "sharpness", &sharpness_obj))
		p->sharpness = (__u8) json_object_get_int(sharpness_obj);

	/* __s8 ref_deltas[V4L2_AV1_TOTAL_REFS_PER_FRAME] */
	json_object *ref_deltas_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_filter_obj, "ref_deltas", &ref_deltas_obj)) {
		for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
			if (json_object_array_get_idx(ref_deltas_obj, i))
				p->ref_deltas[i] = (__s8) json_object_get_int(json_object_array_get_idx(ref_deltas_obj, i));
		}
	}

	/* __s8 mode_deltas[2] */
	json_object *mode_deltas_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_filter_obj, "mode_deltas", &mode_deltas_obj)) {
		for (size_t i = 0; i < 2; i++) {
			if (json_object_array_get_idx(mode_deltas_obj, i))
				p->mode_deltas[i] = (__s8) json_object_get_int(json_object_array_get_idx(mode_deltas_obj, i));
		}
	}

	json_object *delta_lf_res_obj;
	if (json_object_object_get_ex(v4l2_av1_loop_filter_obj, "delta_lf_res", &delta_lf_res_obj))
		p->delta_lf_res = (__u8) json_object_get_int(delta_lf_res_obj);

	return p;
}

struct v4l2_av1_quantization *retrace_v4l2_av1_quantization_gen(json_object *ctrl_obj)
{
	struct v4l2_av1_quantization *p = (struct v4l2_av1_quantization *) calloc(1, sizeof(v4l2_av1_quantization));
	json_object *v4l2_av1_quantization_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_av1_quantization", &v4l2_av1_quantization_obj))
		v4l2_av1_quantization_obj = ctrl_obj;

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_av1_quantization_flag_def);

	json_object *base_q_idx_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "base_q_idx", &base_q_idx_obj))
		p->base_q_idx = (__u8) json_object_get_int(base_q_idx_obj);

	json_object *delta_q_y_dc_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "delta_q_y_dc", &delta_q_y_dc_obj))
		p->delta_q_y_dc = (__s8) json_object_get_int(delta_q_y_dc_obj);

	json_object *delta_q_u_dc_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "delta_q_u_dc", &delta_q_u_dc_obj))
		p->delta_q_u_dc = (__s8) json_object_get_int(delta_q_u_dc_obj);

	json_object *delta_q_u_ac_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "delta_q_u_ac", &delta_q_u_ac_obj))
		p->delta_q_u_ac = (__s8) json_object_get_int(delta_q_u_ac_obj);

	json_object *delta_q_v_dc_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "delta_q_v_dc", &delta_q_v_dc_obj))
		p->delta_q_v_dc = (__s8) json_object_get_int(delta_q_v_dc_obj);

	json_object *delta_q_v_ac_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "delta_q_v_ac", &delta_q_v_ac_obj))
		p->delta_q_v_ac = (__s8) json_object_get_int(delta_q_v_ac_obj);

	json_object *qm_y_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "qm_y", &qm_y_obj))
		p->qm_y = (__u8) json_object_get_int(qm_y_obj);

	json_object *qm_u_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "qm_u", &qm_u_obj))
		p->qm_u = (__u8) json_object_get_int(qm_u_obj);

	json_object *qm_v_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "qm_v", &qm_v_obj))
		p->qm_v = (__u8) json_object_get_int(qm_v_obj);

	json_object *delta_q_res_obj;
	if (json_object_object_get_ex(v4l2_av1_quantization_obj, "delta_q_res", &delta_q_res_obj))
		p->delta_q_res = (__u8) json_object_get_int(delta_q_res_obj);

	return p;
}

struct v4l2_av1_tile_info *retrace_v4l2_av1_tile_info_gen(json_object *ctrl_obj)
{
	struct v4l2_av1_tile_info *p = (struct v4l2_av1_tile_info *) calloc(1, sizeof(v4l2_av1_tile_info));
	json_object *v4l2_av1_tile_info_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_av1_tile_info", &v4l2_av1_tile_info_obj))
		v4l2_av1_tile_info_obj = ctrl_obj;

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_av1_tile_info_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_av1_tile_info_flag_def);

	json_object *context_update_tile_id_obj;
	if (json_object_object_get_ex(v4l2_av1_tile_info_obj, "context_update_tile_id", &context_update_tile_id_obj))
		p->context_update_tile_id = (__u8) json_object_get_int(context_update_tile_id_obj);

	json_object *tile_cols_obj;
	if (json_object_object_get_ex(v4l2_av1_tile_info_obj, "tile_cols", &tile_cols_obj))
		p->tile_cols = (__u8) json_object_get_int(tile_cols_obj);

	json_object *tile_rows_obj;
	if (json_object_object_get_ex(v4l2_av1_tile_info_obj, "tile_rows", &tile_rows_obj))
		p->tile_rows = (__u8) json_object_get_int(tile_rows_obj);

	/* __u32 mi_col_starts[V4L2_AV1_MAX_TILE_COLS + 1] */
	json_object *mi_col_starts_obj;
	if (json_object_object_get_ex(v4l2_av1_tile_info_obj, "mi_col_starts", &mi_col_starts_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_TILE_COLS + 1; i++) {
			if (json_object_array_get_idx(mi_col_starts_obj, i))
				p->mi_col_starts[i] = (__u32) json_object_get_int64(json_object_array_get_idx(mi_col_starts_obj, i));
		}
	}

	/* __u32 mi_row_starts[V4L2_AV1_MAX_TILE_ROWS + 1] */
	json_object *mi_row_starts_obj;
	if (json_object_object_get_ex(v4l2_av1_tile_info_obj, "mi_row_starts", &mi_row_starts_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_TILE_ROWS + 1; i++) {
			if (json_object_array_get_idx(mi_row_starts_obj, i))
				p->mi_row_starts[i] = (__u32) json_object_get_int64(json_object_array_get_idx(mi_row_starts_obj, i));
		}
	}

	/* __u32 width_in_sbs_minus_1[V4L2_AV1_MAX_TILE_COLS] */
	json_object *width_in_sbs_minus_1_obj;
	if (json_object_object_get_ex(v4l2_av1_tile_info_obj, "width_in_sbs_minus_1", &width_in_sbs_minus_1_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_TILE_COLS; i++) {
			if (json_object_array_get_idx(width_in_sbs_minus_1_obj, i))
				p->width_in_sbs_minus_1[i] = (__u32) json_object_get_int64(json_object_array_get_idx(width_in_sbs_minus_1_obj, i));
		}
	}

	/* __u32 height_in_sbs_minus_1[V4L2_AV1_MAX_TILE_ROWS] */
	json_object *height_in_sbs_minus_1_obj;
	if (json_object_object_get_ex(v4l2_av1_tile_info_obj, "height_in_sbs_minus_1", &height_in_sbs_minus_1_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_TILE_ROWS; i++) {
			if (json_object_array_get_idx(height_in_sbs_minus_1_obj, i))
				p->height_in_sbs_minus_1[i] = (__u32) json_object_get_int64(json_object_array_get_idx(height_in_sbs_minus_1_obj, i));
		}
	}

	json_object *tile_size_bytes_obj;
	if (json_object_object_get_ex(v4l2_av1_tile_info_obj, "tile_size_bytes", &tile_size_bytes_obj))
		p->tile_size_bytes = (__u8) json_object_get_int(tile_size_bytes_obj);

	return p;
}

struct v4l2_ctrl_av1_frame *retrace_v4l2_ctrl_av1_frame_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_av1_frame *p = (struct v4l2_ctrl_av1_frame *) calloc(1, sizeof(v4l2_ctrl_av1_frame));
	json_object *v4l2_ctrl_av1_frame_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_av1_frame", &v4l2_ctrl_av1_frame_obj))
		v4l2_ctrl_av1_frame_obj = ctrl_obj;

	/* struct v4l2_av1_tile_info tile_info */
	json_object *tile_info_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "v4l2_av1_tile_info", &tile_info_obj))
		return p;
	void *tile_info_ptr = (void *) retrace_v4l2_av1_tile_info_gen(tile_info_obj);
	p->tile_info = *static_cast<struct v4l2_av1_tile_info*>(tile_info_ptr);
	free(tile_info_ptr);

	/* struct v4l2_av1_quantization quantization */
	json_object *quantization_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "v4l2_av1_quantization", &quantization_obj))
		return p;
	void *quantization_ptr = (void *) retrace_v4l2_av1_quantization_gen(quantization_obj);
	p->quantization = *static_cast<struct v4l2_av1_quantization*>(quantization_ptr);
	free(quantization_ptr);

	json_object *superres_denom_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "superres_denom", &superres_denom_obj))
		p->superres_denom = (__u8) json_object_get_int(superres_denom_obj);

	/* struct v4l2_av1_segmentation segmentation */
	json_object *segmentation_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "v4l2_av1_segmentation", &segmentation_obj))
		return p;
	void *segmentation_ptr = (void *) retrace_v4l2_av1_segmentation_gen(segmentation_obj);
	p->segmentation = *static_cast<struct v4l2_av1_segmentation*>(segmentation_ptr);
	free(segmentation_ptr);

	/* struct v4l2_av1_loop_filter loop_filter */
	json_object *loop_filter_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "v4l2_av1_loop_filter", &loop_filter_obj))
		return p;
	void *loop_filter_ptr = (void *) retrace_v4l2_av1_loop_filter_gen(loop_filter_obj);
	p->loop_filter = *static_cast<struct v4l2_av1_loop_filter*>(loop_filter_ptr);
	free(loop_filter_ptr);

	/* struct v4l2_av1_cdef cdef */
	json_object *cdef_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "v4l2_av1_cdef", &cdef_obj))
		return p;
	void *cdef_ptr = (void *) retrace_v4l2_av1_cdef_gen(cdef_obj);
	p->cdef = *static_cast<struct v4l2_av1_cdef*>(cdef_ptr);
	free(cdef_ptr);

	/* __u8 skip_mode_frame[2] */
	json_object *skip_mode_frame_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "skip_mode_frame", &skip_mode_frame_obj)) {
		for (size_t i = 0; i < 2; i++) {
			if (json_object_array_get_idx(skip_mode_frame_obj, i))
				p->skip_mode_frame[i] = (__u8) json_object_get_int(json_object_array_get_idx(skip_mode_frame_obj, i));
		}
	}

	json_object *primary_ref_frame_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "primary_ref_frame", &primary_ref_frame_obj))
		p->primary_ref_frame = (__u8) json_object_get_int(primary_ref_frame_obj);

	/* struct v4l2_av1_loop_restoration loop_restoration */
	json_object *loop_restoration_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "v4l2_av1_loop_restoration", &loop_restoration_obj))
		return p;
	void *loop_restoration_ptr = (void *) retrace_v4l2_av1_loop_restoration_gen(loop_restoration_obj);
	p->loop_restoration = *static_cast<struct v4l2_av1_loop_restoration*>(loop_restoration_ptr);
	free(loop_restoration_ptr);

	/* struct v4l2_av1_global_motion global_motion */
	json_object *global_motion_obj;
	if (!json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "v4l2_av1_global_motion", &global_motion_obj))
		return p;
	void *global_motion_ptr = (void *) retrace_v4l2_av1_global_motion_gen(global_motion_obj);
	p->global_motion = *static_cast<struct v4l2_av1_global_motion*>(global_motion_ptr);
	free(global_motion_ptr);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_av1_frame_flag_def);

	json_object *frame_type_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "frame_type", &frame_type_obj))
		p->frame_type = (v4l2_av1_frame_type) json_object_get_int(frame_type_obj);

	json_object *order_hint_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "order_hint", &order_hint_obj))
		p->order_hint = (__u32) json_object_get_int64(order_hint_obj);

	json_object *upscaled_width_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "upscaled_width", &upscaled_width_obj))
		p->upscaled_width = (__u32) json_object_get_int64(upscaled_width_obj);

	json_object *interpolation_filter_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "interpolation_filter", &interpolation_filter_obj))
		p->interpolation_filter = (v4l2_av1_interpolation_filter) json_object_get_int(interpolation_filter_obj);

	json_object *tx_mode_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "tx_mode", &tx_mode_obj))
		p->tx_mode = (v4l2_av1_tx_mode) json_object_get_int(tx_mode_obj);

	json_object *frame_width_minus_1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "frame_width_minus_1", &frame_width_minus_1_obj))
		p->frame_width_minus_1 = (__u32) json_object_get_int64(frame_width_minus_1_obj);

	json_object *frame_height_minus_1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "frame_height_minus_1", &frame_height_minus_1_obj))
		p->frame_height_minus_1 = (__u32) json_object_get_int64(frame_height_minus_1_obj);

	json_object *render_width_minus_1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "render_width_minus_1", &render_width_minus_1_obj))
		p->render_width_minus_1 = (__u16) json_object_get_int(render_width_minus_1_obj);

	json_object *render_height_minus_1_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "render_height_minus_1", &render_height_minus_1_obj))
		p->render_height_minus_1 = (__u16) json_object_get_int(render_height_minus_1_obj);

	json_object *current_frame_id_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "current_frame_id", &current_frame_id_obj))
		p->current_frame_id = (__u32) json_object_get_int64(current_frame_id_obj);

	/* __u32 buffer_removal_time[V4L2_AV1_MAX_OPERATING_POINTS] */
	json_object *buffer_removal_time_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "buffer_removal_time", &buffer_removal_time_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_OPERATING_POINTS; i++) {
			if (json_object_array_get_idx(buffer_removal_time_obj, i))
				p->buffer_removal_time[i] = (__u32) json_object_get_int64(json_object_array_get_idx(buffer_removal_time_obj, i));
		}
	}

	/* __u32 order_hints[V4L2_AV1_TOTAL_REFS_PER_FRAME] */
	json_object *order_hints_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "order_hints", &order_hints_obj)) {
		for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
			if (json_object_array_get_idx(order_hints_obj, i))
				p->order_hints[i] = (__u32) json_object_get_int64(json_object_array_get_idx(order_hints_obj, i));
		}
	}

	/* __u64 reference_frame_ts[V4L2_AV1_TOTAL_REFS_PER_FRAME] */
	json_object *reference_frame_ts_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "reference_frame_ts", &reference_frame_ts_obj)) {
		for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
			if (json_object_array_get_idx(reference_frame_ts_obj, i))
				p->reference_frame_ts[i] = (__u64) json_object_get_uint64(json_object_array_get_idx(reference_frame_ts_obj, i));
		}
	}

	/* __s8 ref_frame_idx[V4L2_AV1_REFS_PER_FRAME] */
	json_object *ref_frame_idx_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "ref_frame_idx", &ref_frame_idx_obj)) {
		for (size_t i = 0; i < V4L2_AV1_REFS_PER_FRAME; i++) {
			if (json_object_array_get_idx(ref_frame_idx_obj, i))
				p->ref_frame_idx[i] = (__s8) json_object_get_int(json_object_array_get_idx(ref_frame_idx_obj, i));
		}
	}

	json_object *refresh_frame_flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_frame_obj, "refresh_frame_flags", &refresh_frame_flags_obj))
		p->refresh_frame_flags = (__u8) s2flags(json_object_get_string(refresh_frame_flags_obj), v4l2_av1_frame_flag_def);

	return p;
}

struct v4l2_ctrl_av1_film_grain *retrace_v4l2_ctrl_av1_film_grain_gen(json_object *ctrl_obj)
{
	struct v4l2_ctrl_av1_film_grain *p = (struct v4l2_ctrl_av1_film_grain *) calloc(1, sizeof(v4l2_ctrl_av1_film_grain));
	json_object *v4l2_ctrl_av1_film_grain_obj;
	if (!json_object_object_get_ex(ctrl_obj, "v4l2_ctrl_av1_film_grain", &v4l2_ctrl_av1_film_grain_obj))
		v4l2_ctrl_av1_film_grain_obj = ctrl_obj;

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_av1_film_grain_flag_def);

	json_object *cr_mult_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "cr_mult", &cr_mult_obj))
		p->cr_mult = (__u8) json_object_get_int(cr_mult_obj);

	json_object *grain_seed_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "grain_seed", &grain_seed_obj))
		p->grain_seed = (__u16) json_object_get_int(grain_seed_obj);

	json_object *film_grain_params_ref_idx_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "film_grain_params_ref_idx", &film_grain_params_ref_idx_obj))
		p->film_grain_params_ref_idx = (__u8) json_object_get_int(film_grain_params_ref_idx_obj);

	json_object *num_y_points_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "num_y_points", &num_y_points_obj))
		p->num_y_points = (__u8) json_object_get_int(num_y_points_obj);

	/* __u8 point_y_value[V4L2_AV1_MAX_NUM_Y_POINTS] */
	json_object *point_y_value_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "point_y_value", &point_y_value_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_NUM_Y_POINTS; i++) {
			if (json_object_array_get_idx(point_y_value_obj, i))
				p->point_y_value[i] = (__u8) json_object_get_int(json_object_array_get_idx(point_y_value_obj, i));
		}
	}

	/* __u8 point_y_scaling[V4L2_AV1_MAX_NUM_Y_POINTS] */
	json_object *point_y_scaling_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "point_y_scaling", &point_y_scaling_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_NUM_Y_POINTS; i++) {
			if (json_object_array_get_idx(point_y_scaling_obj, i))
				p->point_y_scaling[i] = (__u8) json_object_get_int(json_object_array_get_idx(point_y_scaling_obj, i));
		}
	}

	json_object *num_cb_points_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "num_cb_points", &num_cb_points_obj))
		p->num_cb_points = (__u8) json_object_get_int(num_cb_points_obj);

	/* __u8 point_cb_value[V4L2_AV1_MAX_NUM_CB_POINTS] */
	json_object *point_cb_value_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "point_cb_value", &point_cb_value_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_NUM_CB_POINTS; i++) {
			if (json_object_array_get_idx(point_cb_value_obj, i))
				p->point_cb_value[i] = (__u8) json_object_get_int(json_object_array_get_idx(point_cb_value_obj, i));
		}
	}

	/* __u8 point_cb_scaling[V4L2_AV1_MAX_NUM_CB_POINTS] */
	json_object *point_cb_scaling_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "point_cb_scaling", &point_cb_scaling_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_NUM_CB_POINTS; i++) {
			if (json_object_array_get_idx(point_cb_scaling_obj, i))
				p->point_cb_scaling[i] = (__u8) json_object_get_int(json_object_array_get_idx(point_cb_scaling_obj, i));
		}
	}

	json_object *num_cr_points_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "num_cr_points", &num_cr_points_obj))
		p->num_cr_points = (__u8) json_object_get_int(num_cr_points_obj);

	/* __u8 point_cr_value[V4L2_AV1_MAX_NUM_CR_POINTS] */
	json_object *point_cr_value_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "point_cr_value", &point_cr_value_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_NUM_CR_POINTS; i++) {
			if (json_object_array_get_idx(point_cr_value_obj, i))
				p->point_cr_value[i] = (__u8) json_object_get_int(json_object_array_get_idx(point_cr_value_obj, i));
		}
	}

	/* __u8 point_cr_scaling[V4L2_AV1_MAX_NUM_CR_POINTS] */
	json_object *point_cr_scaling_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "point_cr_scaling", &point_cr_scaling_obj)) {
		for (size_t i = 0; i < V4L2_AV1_MAX_NUM_CR_POINTS; i++) {
			if (json_object_array_get_idx(point_cr_scaling_obj, i))
				p->point_cr_scaling[i] = (__u8) json_object_get_int(json_object_array_get_idx(point_cr_scaling_obj, i));
		}
	}

	json_object *grain_scaling_minus_8_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "grain_scaling_minus_8", &grain_scaling_minus_8_obj))
		p->grain_scaling_minus_8 = (__u8) json_object_get_int(grain_scaling_minus_8_obj);

	json_object *ar_coeff_lag_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "ar_coeff_lag", &ar_coeff_lag_obj))
		p->ar_coeff_lag = (__u8) json_object_get_int(ar_coeff_lag_obj);

	/* __u8 ar_coeffs_y_plus_128[V4L2_AV1_AR_COEFFS_SIZE] */
	json_object *ar_coeffs_y_plus_128_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "ar_coeffs_y_plus_128", &ar_coeffs_y_plus_128_obj)) {
		for (size_t i = 0; i < V4L2_AV1_AR_COEFFS_SIZE; i++) {
			if (json_object_array_get_idx(ar_coeffs_y_plus_128_obj, i))
				p->ar_coeffs_y_plus_128[i] = (__u8) json_object_get_int(json_object_array_get_idx(ar_coeffs_y_plus_128_obj, i));
		}
	}

	/* __u8 ar_coeffs_cb_plus_128[V4L2_AV1_AR_COEFFS_SIZE] */
	json_object *ar_coeffs_cb_plus_128_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "ar_coeffs_cb_plus_128", &ar_coeffs_cb_plus_128_obj)) {
		for (size_t i = 0; i < V4L2_AV1_AR_COEFFS_SIZE; i++) {
			if (json_object_array_get_idx(ar_coeffs_cb_plus_128_obj, i))
				p->ar_coeffs_cb_plus_128[i] = (__u8) json_object_get_int(json_object_array_get_idx(ar_coeffs_cb_plus_128_obj, i));
		}
	}

	/* __u8 ar_coeffs_cr_plus_128[V4L2_AV1_AR_COEFFS_SIZE] */
	json_object *ar_coeffs_cr_plus_128_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "ar_coeffs_cr_plus_128", &ar_coeffs_cr_plus_128_obj)) {
		for (size_t i = 0; i < V4L2_AV1_AR_COEFFS_SIZE; i++) {
			if (json_object_array_get_idx(ar_coeffs_cr_plus_128_obj, i))
				p->ar_coeffs_cr_plus_128[i] = (__u8) json_object_get_int(json_object_array_get_idx(ar_coeffs_cr_plus_128_obj, i));
		}
	}

	json_object *ar_coeff_shift_minus_6_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "ar_coeff_shift_minus_6", &ar_coeff_shift_minus_6_obj))
		p->ar_coeff_shift_minus_6 = (__u8) json_object_get_int(ar_coeff_shift_minus_6_obj);

	json_object *grain_scale_shift_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "grain_scale_shift", &grain_scale_shift_obj))
		p->grain_scale_shift = (__u8) json_object_get_int(grain_scale_shift_obj);

	json_object *cb_mult_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "cb_mult", &cb_mult_obj))
		p->cb_mult = (__u8) json_object_get_int(cb_mult_obj);

	json_object *cb_luma_mult_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "cb_luma_mult", &cb_luma_mult_obj))
		p->cb_luma_mult = (__u8) json_object_get_int(cb_luma_mult_obj);

	json_object *cr_luma_mult_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "cr_luma_mult", &cr_luma_mult_obj))
		p->cr_luma_mult = (__u8) json_object_get_int(cr_luma_mult_obj);

	json_object *cb_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "cb_offset", &cb_offset_obj))
		p->cb_offset = (__u16) json_object_get_int(cb_offset_obj);

	json_object *cr_offset_obj;
	if (json_object_object_get_ex(v4l2_ctrl_av1_film_grain_obj, "cr_offset", &cr_offset_obj))
		p->cr_offset = (__u16) json_object_get_int(cr_offset_obj);

	return p;
}

struct v4l2_rect *retrace_v4l2_rect_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_rect *p = (struct v4l2_rect *) calloc(1, sizeof(v4l2_rect));

	json_object *v4l2_rect_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_rect", &v4l2_rect_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_rect_obj);

	json_object *left_obj;
	if (json_object_object_get_ex(v4l2_rect_obj, "left", &left_obj))
		p->left = (__s32) json_object_get_int(left_obj);

	json_object *top_obj;
	if (json_object_object_get_ex(v4l2_rect_obj, "top", &top_obj))
		p->top = (__s32) json_object_get_int(top_obj);

	json_object *width_obj;
	if (json_object_object_get_ex(v4l2_rect_obj, "width", &width_obj))
		p->width = (__u32) json_object_get_int64(width_obj);

	json_object *height_obj;
	if (json_object_object_get_ex(v4l2_rect_obj, "height", &height_obj))
		p->height = (__u32) json_object_get_int64(height_obj);

	return p;
}
struct v4l2_fract *retrace_v4l2_fract_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_fract *p = (struct v4l2_fract *) calloc(1, sizeof(v4l2_fract));

	json_object *v4l2_fract_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_fract", &v4l2_fract_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_fract_obj);

	json_object *numerator_obj;
	if (json_object_object_get_ex(v4l2_fract_obj, "numerator", &numerator_obj))
		p->numerator = (__u32) json_object_get_int64(numerator_obj);

	json_object *denominator_obj;
	if (json_object_object_get_ex(v4l2_fract_obj, "denominator", &denominator_obj))
		p->denominator = (__u32) json_object_get_int64(denominator_obj);

	return p;
}
struct v4l2_area *retrace_v4l2_area_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_area *p = (struct v4l2_area *) calloc(1, sizeof(v4l2_area));

	json_object *v4l2_area_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_area", &v4l2_area_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_area_obj);

	json_object *width_obj;
	if (json_object_object_get_ex(v4l2_area_obj, "width", &width_obj))
		p->width = (__u32) json_object_get_int64(width_obj);

	json_object *height_obj;
	if (json_object_object_get_ex(v4l2_area_obj, "height", &height_obj))
		p->height = (__u32) json_object_get_int64(height_obj);

	return p;
}
struct v4l2_capability *retrace_v4l2_capability_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_capability *p = (struct v4l2_capability *) calloc(1, sizeof(v4l2_capability));

	json_object *v4l2_capability_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_capability", &v4l2_capability_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_capability_obj);

	json_object *driver_obj;
	if (json_object_object_get_ex(v4l2_capability_obj, "driver", &driver_obj))
		if (json_object_get_string(driver_obj) != nullptr)
			memcpy(p->driver, json_object_get_string(driver_obj), 16);

	json_object *card_obj;
	if (json_object_object_get_ex(v4l2_capability_obj, "card", &card_obj))
		if (json_object_get_string(card_obj) != nullptr)
			memcpy(p->card, json_object_get_string(card_obj), 32);

	json_object *bus_info_obj;
	if (json_object_object_get_ex(v4l2_capability_obj, "bus_info", &bus_info_obj))
		if (json_object_get_string(bus_info_obj) != nullptr)
			memcpy(p->bus_info, json_object_get_string(bus_info_obj), 32);

	json_object *version_obj;
	if (json_object_object_get_ex(v4l2_capability_obj, "version", &version_obj))
		memset(&p->version, 0, sizeof(p->version));

	json_object *capabilities_obj;
	if (json_object_object_get_ex(v4l2_capability_obj, "capabilities", &capabilities_obj))
		p->capabilities = (__u32) s2flags(json_object_get_string(capabilities_obj), v4l2_cap_flag_def);

	json_object *device_caps_obj;
	if (json_object_object_get_ex(v4l2_capability_obj, "device_caps", &device_caps_obj))
		p->device_caps = (__u32) s2flags(json_object_get_string(device_caps_obj), v4l2_cap_flag_def);

	return p;
}
struct v4l2_pix_format *retrace_v4l2_pix_format_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_pix_format *p = (struct v4l2_pix_format *) calloc(1, sizeof(v4l2_pix_format));

	json_object *v4l2_pix_format_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_pix_format", &v4l2_pix_format_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_pix_format_obj);

	json_object *width_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "width", &width_obj))
		p->width = (__u32) json_object_get_int64(width_obj);

	json_object *height_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "height", &height_obj))
		p->height = (__u32) json_object_get_int64(height_obj);

	json_object *pixelformat_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "pixelformat", &pixelformat_obj))
		p->pixelformat = (__u32) s2val(json_object_get_string(pixelformat_obj), v4l2_pix_fmt_val_def);
	json_object *field_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "field", &field_obj))
		p->field = (__u32) s2val(json_object_get_string(field_obj), v4l2_field_val_def);
	json_object *bytesperline_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "bytesperline", &bytesperline_obj))
		p->bytesperline = (__u32) json_object_get_int64(bytesperline_obj);

	json_object *sizeimage_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "sizeimage", &sizeimage_obj))
		p->sizeimage = (__u32) json_object_get_int64(sizeimage_obj);

	json_object *colorspace_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "colorspace", &colorspace_obj))
		p->colorspace = (__u32) s2val(json_object_get_string(colorspace_obj), v4l2_colorspace_val_def);
	json_object *priv_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "priv", &priv_obj)) {
		if (json_object_get_string(priv_obj) == nullptr)
			return p;
		std::string priv_str = json_object_get_string(priv_obj);
		if (!priv_str.empty())
			p->priv = V4L2_PIX_FMT_PRIV_MAGIC;
	}
	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_pix_fmt_flag_def);

	//union
	json_object *ycbcr_enc_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "ycbcr_enc", &ycbcr_enc_obj))
		p->ycbcr_enc = (__u32) s2val(json_object_get_string(ycbcr_enc_obj), v4l2_ycbcr_encoding_val_def);
	json_object *hsv_enc_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "hsv_enc", &hsv_enc_obj))
		p->hsv_enc = (__u32) json_object_get_int64(hsv_enc_obj);

	//end of union 	};
	json_object *quantization_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "quantization", &quantization_obj))
		p->quantization = (__u32) s2val(json_object_get_string(quantization_obj), v4l2_quantization_val_def);
	json_object *xfer_func_obj;
	if (json_object_object_get_ex(v4l2_pix_format_obj, "xfer_func", &xfer_func_obj))
		p->xfer_func = (__u32) s2val(json_object_get_string(xfer_func_obj), v4l2_xfer_func_val_def);
	return p;
}
struct v4l2_fmtdesc *retrace_v4l2_fmtdesc_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_fmtdesc *p = (struct v4l2_fmtdesc *) calloc(1, sizeof(v4l2_fmtdesc));

	json_object *v4l2_fmtdesc_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_fmtdesc", &v4l2_fmtdesc_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_fmtdesc_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_fmtdesc_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_fmtdesc_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_buf_type_val_def);
	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_fmtdesc_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_fmt_flag_def);

	json_object *description_obj;
	if (json_object_object_get_ex(v4l2_fmtdesc_obj, "description", &description_obj))
		if (json_object_get_string(description_obj) != nullptr)
			memcpy(p->description, json_object_get_string(description_obj), 32);

	json_object *pixelformat_obj;
	if (json_object_object_get_ex(v4l2_fmtdesc_obj, "pixelformat", &pixelformat_obj))
		p->pixelformat = (__u32) s2val(json_object_get_string(pixelformat_obj), v4l2_pix_fmt_val_def);
	json_object *mbus_code_obj;
	if (json_object_object_get_ex(v4l2_fmtdesc_obj, "mbus_code", &mbus_code_obj))
		p->mbus_code = (__u32) json_object_get_int64(mbus_code_obj);

	return p;
}
struct v4l2_frmsize_discrete *retrace_v4l2_frmsize_discrete_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_frmsize_discrete *p = (struct v4l2_frmsize_discrete *) calloc(1, sizeof(v4l2_frmsize_discrete));

	json_object *v4l2_frmsize_discrete_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_frmsize_discrete", &v4l2_frmsize_discrete_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_frmsize_discrete_obj);

	json_object *width_obj;
	if (json_object_object_get_ex(v4l2_frmsize_discrete_obj, "width", &width_obj))
		p->width = (__u32) json_object_get_int64(width_obj);

	json_object *height_obj;
	if (json_object_object_get_ex(v4l2_frmsize_discrete_obj, "height", &height_obj))
		p->height = (__u32) json_object_get_int64(height_obj);

	return p;
}
struct v4l2_frmsize_stepwise *retrace_v4l2_frmsize_stepwise_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_frmsize_stepwise *p = (struct v4l2_frmsize_stepwise *) calloc(1, sizeof(v4l2_frmsize_stepwise));

	json_object *v4l2_frmsize_stepwise_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_frmsize_stepwise", &v4l2_frmsize_stepwise_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_frmsize_stepwise_obj);

	json_object *min_width_obj;
	if (json_object_object_get_ex(v4l2_frmsize_stepwise_obj, "min_width", &min_width_obj))
		p->min_width = (__u32) json_object_get_int64(min_width_obj);

	json_object *max_width_obj;
	if (json_object_object_get_ex(v4l2_frmsize_stepwise_obj, "max_width", &max_width_obj))
		p->max_width = (__u32) json_object_get_int64(max_width_obj);

	json_object *step_width_obj;
	if (json_object_object_get_ex(v4l2_frmsize_stepwise_obj, "step_width", &step_width_obj))
		p->step_width = (__u32) json_object_get_int64(step_width_obj);

	json_object *min_height_obj;
	if (json_object_object_get_ex(v4l2_frmsize_stepwise_obj, "min_height", &min_height_obj))
		p->min_height = (__u32) json_object_get_int64(min_height_obj);

	json_object *max_height_obj;
	if (json_object_object_get_ex(v4l2_frmsize_stepwise_obj, "max_height", &max_height_obj))
		p->max_height = (__u32) json_object_get_int64(max_height_obj);

	json_object *step_height_obj;
	if (json_object_object_get_ex(v4l2_frmsize_stepwise_obj, "step_height", &step_height_obj))
		p->step_height = (__u32) json_object_get_int64(step_height_obj);

	return p;
}
struct v4l2_frmsizeenum *retrace_v4l2_frmsizeenum_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_frmsizeenum *p = (struct v4l2_frmsizeenum *) calloc(1, sizeof(v4l2_frmsizeenum));

	json_object *v4l2_frmsizeenum_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_frmsizeenum", &v4l2_frmsizeenum_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_frmsizeenum_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_frmsizeenum_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *pixel_format_obj;
	if (json_object_object_get_ex(v4l2_frmsizeenum_obj, "pixel_format", &pixel_format_obj))
		p->pixel_format = (__u32) s2val(json_object_get_string(pixel_format_obj), v4l2_pix_fmt_val_def);
	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_frmsizeenum_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_frmsizetypes_val_def);
	//union
	//struct v4l2_frmsize_discrete	discrete;
	//struct v4l2_frmsize_stepwise	stepwise;
	//end of union 	};
	return p;
}
struct v4l2_frmival_stepwise *retrace_v4l2_frmival_stepwise_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_frmival_stepwise *p = (struct v4l2_frmival_stepwise *) calloc(1, sizeof(v4l2_frmival_stepwise));

	json_object *v4l2_frmival_stepwise_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_frmival_stepwise", &v4l2_frmival_stepwise_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_frmival_stepwise_obj);

	//struct v4l2_fract	min;
	void *min_ptr = (void *) retrace_v4l2_fract_gen(v4l2_frmival_stepwise_obj, "min");
	p->min = *static_cast<struct v4l2_fract*>(min_ptr);
	free(min_ptr);

	//struct v4l2_fract	max;
	void *max_ptr = (void *) retrace_v4l2_fract_gen(v4l2_frmival_stepwise_obj, "max");
	p->max = *static_cast<struct v4l2_fract*>(max_ptr);
	free(max_ptr);

	//struct v4l2_fract	step;
	void *step_ptr = (void *) retrace_v4l2_fract_gen(v4l2_frmival_stepwise_obj, "step");
	p->step = *static_cast<struct v4l2_fract*>(step_ptr);
	free(step_ptr);

	return p;
}
struct v4l2_frmivalenum *retrace_v4l2_frmivalenum_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_frmivalenum *p = (struct v4l2_frmivalenum *) calloc(1, sizeof(v4l2_frmivalenum));

	json_object *v4l2_frmivalenum_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_frmivalenum", &v4l2_frmivalenum_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_frmivalenum_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_frmivalenum_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *pixel_format_obj;
	if (json_object_object_get_ex(v4l2_frmivalenum_obj, "pixel_format", &pixel_format_obj))
		p->pixel_format = (__u32) s2val(json_object_get_string(pixel_format_obj), v4l2_pix_fmt_val_def);
	json_object *width_obj;
	if (json_object_object_get_ex(v4l2_frmivalenum_obj, "width", &width_obj))
		p->width = (__u32) json_object_get_int64(width_obj);

	json_object *height_obj;
	if (json_object_object_get_ex(v4l2_frmivalenum_obj, "height", &height_obj))
		p->height = (__u32) json_object_get_int64(height_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_frmivalenum_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_frmivaltypes_val_def);
	//union
	//struct v4l2_fract		discrete;
	//struct v4l2_frmival_stepwise	stepwise;
	//end of union 	};
	return p;
}
struct v4l2_timecode *retrace_v4l2_timecode_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_timecode *p = (struct v4l2_timecode *) calloc(1, sizeof(v4l2_timecode));

	json_object *v4l2_timecode_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_timecode", &v4l2_timecode_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_timecode_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_timecode_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), nullptr);
	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_timecode_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	json_object *frames_obj;
	if (json_object_object_get_ex(v4l2_timecode_obj, "frames", &frames_obj))
		p->frames = (__u8) json_object_get_int(frames_obj);

	json_object *seconds_obj;
	if (json_object_object_get_ex(v4l2_timecode_obj, "seconds", &seconds_obj))
		p->seconds = (__u8) json_object_get_int(seconds_obj);

	json_object *minutes_obj;
	if (json_object_object_get_ex(v4l2_timecode_obj, "minutes", &minutes_obj))
		p->minutes = (__u8) json_object_get_int(minutes_obj);

	json_object *hours_obj;
	if (json_object_object_get_ex(v4l2_timecode_obj, "hours", &hours_obj))
		p->hours = (__u8) json_object_get_int(hours_obj);

	json_object *userbits_obj;
	if (json_object_object_get_ex(v4l2_timecode_obj, "userbits", &userbits_obj))
		if (json_object_get_string(userbits_obj) != nullptr)
			memcpy(p->userbits, json_object_get_string(userbits_obj), 4);

	return p;
}
struct v4l2_jpegcompression *retrace_v4l2_jpegcompression_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_jpegcompression *p = (struct v4l2_jpegcompression *) calloc(1, sizeof(v4l2_jpegcompression));

	json_object *v4l2_jpegcompression_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_jpegcompression", &v4l2_jpegcompression_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_jpegcompression_obj);

	json_object *quality_obj;
	if (json_object_object_get_ex(v4l2_jpegcompression_obj, "quality", &quality_obj))
		p->quality = (int) json_object_get_int(quality_obj);

	json_object *APPn_obj;
	if (json_object_object_get_ex(v4l2_jpegcompression_obj, "APPn", &APPn_obj))
		p->APPn = (int) json_object_get_int(APPn_obj);

	json_object *APP_len_obj;
	if (json_object_object_get_ex(v4l2_jpegcompression_obj, "APP_len", &APP_len_obj))
		p->APP_len = (int) json_object_get_int(APP_len_obj);

	json_object *APP_data_obj;
	if (json_object_object_get_ex(v4l2_jpegcompression_obj, "APP_data", &APP_data_obj))
		if (json_object_get_string(APP_data_obj) != nullptr)
			memcpy(p->APP_data, json_object_get_string(APP_data_obj), 60);

	json_object *COM_len_obj;
	if (json_object_object_get_ex(v4l2_jpegcompression_obj, "COM_len", &COM_len_obj))
		p->COM_len = (int) json_object_get_int(COM_len_obj);

	json_object *COM_data_obj;
	if (json_object_object_get_ex(v4l2_jpegcompression_obj, "COM_data", &COM_data_obj))
		if (json_object_get_string(COM_data_obj) != nullptr)
			memcpy(p->COM_data, json_object_get_string(COM_data_obj), 60);

	json_object *jpeg_markers_obj;
	if (json_object_object_get_ex(v4l2_jpegcompression_obj, "jpeg_markers", &jpeg_markers_obj))
		p->jpeg_markers = (__u32) json_object_get_int64(jpeg_markers_obj);

	return p;
}
struct v4l2_requestbuffers *retrace_v4l2_requestbuffers_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_requestbuffers *p = (struct v4l2_requestbuffers *) calloc(1, sizeof(v4l2_requestbuffers));

	json_object *v4l2_requestbuffers_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_requestbuffers", &v4l2_requestbuffers_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_requestbuffers_obj);

	json_object *count_obj;
	if (json_object_object_get_ex(v4l2_requestbuffers_obj, "count", &count_obj))
		p->count = (__u32) json_object_get_int64(count_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_requestbuffers_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_buf_type_val_def);
	json_object *memory_obj;
	if (json_object_object_get_ex(v4l2_requestbuffers_obj, "memory", &memory_obj))
		p->memory = (__u32) s2val(json_object_get_string(memory_obj), v4l2_memory_val_def);
	json_object *capabilities_obj;
	if (json_object_object_get_ex(v4l2_requestbuffers_obj, "capabilities", &capabilities_obj))
		p->capabilities = (__u32) s2flags(json_object_get_string(capabilities_obj), v4l2_buf_cap_flag_def);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_requestbuffers_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_memory_flag_def);

	return p;
}
struct v4l2_plane *retrace_v4l2_plane_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_plane *p = (struct v4l2_plane *) calloc(1, sizeof(v4l2_plane));

	json_object *v4l2_plane_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_plane", &v4l2_plane_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_plane_obj);

	json_object *bytesused_obj;
	if (json_object_object_get_ex(v4l2_plane_obj, "bytesused", &bytesused_obj))
		p->bytesused = (__u32) json_object_get_int64(bytesused_obj);

	json_object *length_obj;
	if (json_object_object_get_ex(v4l2_plane_obj, "length", &length_obj))
		p->length = (__u32) json_object_get_int64(length_obj);

	//union
	//__u32		mem_offset;
	//unsigned long	userptr;
	//__s32		fd;
	//end of union 	} m;
	json_object *data_offset_obj;
	if (json_object_object_get_ex(v4l2_plane_obj, "data_offset", &data_offset_obj))
		p->data_offset = (__u32) json_object_get_int64(data_offset_obj);

	return p;
}
struct v4l2_buffer *retrace_v4l2_buffer_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_buffer *p = (struct v4l2_buffer *) calloc(1, sizeof(v4l2_buffer));

	json_object *v4l2_buffer_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_buffer", &v4l2_buffer_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_buffer_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_buffer_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_buffer_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_buf_type_val_def);
	json_object *bytesused_obj;
	if (json_object_object_get_ex(v4l2_buffer_obj, "bytesused", &bytesused_obj))
		p->bytesused = (__u32) json_object_get_int64(bytesused_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_buffer_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags_buffer(json_object_get_string(flags_obj));

	json_object *field_obj;
	if (json_object_object_get_ex(v4l2_buffer_obj, "field", &field_obj))
		p->field = (__u32) s2val(json_object_get_string(field_obj), v4l2_field_val_def);
	//struct timeval		timestamp;
	//struct v4l2_timecode	timecode;
	void *timecode_ptr = (void *) retrace_v4l2_timecode_gen(v4l2_buffer_obj, "timecode");
	p->timecode = *static_cast<struct v4l2_timecode*>(timecode_ptr);
	free(timecode_ptr);

	json_object *sequence_obj;
	if (json_object_object_get_ex(v4l2_buffer_obj, "sequence", &sequence_obj))
		p->sequence = (__u32) json_object_get_int64(sequence_obj);

	json_object *memory_obj;
	if (json_object_object_get_ex(v4l2_buffer_obj, "memory", &memory_obj))
		p->memory = (__u32) s2val(json_object_get_string(memory_obj), v4l2_memory_val_def);
	//union
	//__u32           offset;
	//unsigned long   userptr;
	//struct v4l2_plane *planes;
	//__s32		fd;
	//end of union 	} m;
	json_object *length_obj;
	if (json_object_object_get_ex(v4l2_buffer_obj, "length", &length_obj))
		p->length = (__u32) json_object_get_int64(length_obj);

	//union
	//__s32		request_fd;
	//end of union 	};
	return p;
}
struct v4l2_exportbuffer *retrace_v4l2_exportbuffer_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_exportbuffer *p = (struct v4l2_exportbuffer *) calloc(1, sizeof(v4l2_exportbuffer));

	json_object *v4l2_exportbuffer_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_exportbuffer", &v4l2_exportbuffer_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_exportbuffer_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_exportbuffer_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_buf_type_val_def);
	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_exportbuffer_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *plane_obj;
	if (json_object_object_get_ex(v4l2_exportbuffer_obj, "plane", &plane_obj))
		p->plane = (__u32) json_object_get_int64(plane_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_exportbuffer_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	json_object *fd_obj;
	if (json_object_object_get_ex(v4l2_exportbuffer_obj, "fd", &fd_obj))
		p->fd = (__s32) json_object_get_int(fd_obj);

	return p;
}
struct v4l2_framebuffer *retrace_v4l2_framebuffer_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_framebuffer *p = (struct v4l2_framebuffer *) calloc(1, sizeof(v4l2_framebuffer));

	json_object *v4l2_framebuffer_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_framebuffer", &v4l2_framebuffer_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_framebuffer_obj);

	json_object *capability_obj;
	if (json_object_object_get_ex(v4l2_framebuffer_obj, "capability", &capability_obj))
		p->capability = (__u32) json_object_get_int64(capability_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_framebuffer_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	//void                    *base;
	//struct {
	//__u32		width;
	//__u32		height;
	//__u32		pixelformat;
	//__u32		field;
	//__u32		bytesperline;
	//__u32		sizeimage;
	//__u32		colorspace;
	//__u32		priv;
	//end of struct 	} fmt;
	return p;
}
struct v4l2_clip *retrace_v4l2_clip_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_clip *p = (struct v4l2_clip *) calloc(1, sizeof(v4l2_clip));

	json_object *v4l2_clip_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_clip", &v4l2_clip_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_clip_obj);

	//struct v4l2_rect        c;
	void *c_ptr = (void *) retrace_v4l2_rect_gen(v4l2_clip_obj, "c");
	p->c = *static_cast<struct v4l2_rect*>(c_ptr);
	free(c_ptr);

	//struct v4l2_clip	*next;
	return p;
}
struct v4l2_window *retrace_v4l2_window_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_window *p = (struct v4l2_window *) calloc(1, sizeof(v4l2_window));

	json_object *v4l2_window_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_window", &v4l2_window_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_window_obj);

	//struct v4l2_rect        w;
	void *w_ptr = (void *) retrace_v4l2_rect_gen(v4l2_window_obj, "w");
	p->w = *static_cast<struct v4l2_rect*>(w_ptr);
	free(w_ptr);

	json_object *field_obj;
	if (json_object_object_get_ex(v4l2_window_obj, "field", &field_obj))
		p->field = (__u32) s2val(json_object_get_string(field_obj), v4l2_field_val_def);
	json_object *chromakey_obj;
	if (json_object_object_get_ex(v4l2_window_obj, "chromakey", &chromakey_obj))
		p->chromakey = (__u32) json_object_get_int64(chromakey_obj);

	//struct v4l2_clip	*clips;
	json_object *clipcount_obj;
	if (json_object_object_get_ex(v4l2_window_obj, "clipcount", &clipcount_obj))
		p->clipcount = (__u32) json_object_get_int64(clipcount_obj);

	//void			*bitmap;
	json_object *global_alpha_obj;
	if (json_object_object_get_ex(v4l2_window_obj, "global_alpha", &global_alpha_obj))
		p->global_alpha = (__u8) json_object_get_int(global_alpha_obj);

	return p;
}
struct v4l2_captureparm *retrace_v4l2_captureparm_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_captureparm *p = (struct v4l2_captureparm *) calloc(1, sizeof(v4l2_captureparm));

	json_object *v4l2_captureparm_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_captureparm", &v4l2_captureparm_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_captureparm_obj);

	json_object *capability_obj;
	if (json_object_object_get_ex(v4l2_captureparm_obj, "capability", &capability_obj))
		p->capability = (__u32) s2val(json_object_get_string(capability_obj), streamparm_val_def);
	json_object *capturemode_obj;
	if (json_object_object_get_ex(v4l2_captureparm_obj, "capturemode", &capturemode_obj))
		p->capturemode = (__u32) s2val(json_object_get_string(capturemode_obj), streamparm_val_def);
	//struct v4l2_fract  timeperframe;
	void *timeperframe_ptr = (void *) retrace_v4l2_fract_gen(v4l2_captureparm_obj, "timeperframe");
	p->timeperframe = *static_cast<struct v4l2_fract*>(timeperframe_ptr);
	free(timeperframe_ptr);

	json_object *extendedmode_obj;
	if (json_object_object_get_ex(v4l2_captureparm_obj, "extendedmode", &extendedmode_obj))
		p->extendedmode = (__u32) json_object_get_int64(extendedmode_obj);

	json_object *readbuffers_obj;
	if (json_object_object_get_ex(v4l2_captureparm_obj, "readbuffers", &readbuffers_obj))
		p->readbuffers = (__u32) json_object_get_int64(readbuffers_obj);

	return p;
}
struct v4l2_outputparm *retrace_v4l2_outputparm_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_outputparm *p = (struct v4l2_outputparm *) calloc(1, sizeof(v4l2_outputparm));

	json_object *v4l2_outputparm_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_outputparm", &v4l2_outputparm_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_outputparm_obj);

	json_object *capability_obj;
	if (json_object_object_get_ex(v4l2_outputparm_obj, "capability", &capability_obj))
		p->capability = (__u32) s2val(json_object_get_string(capability_obj), streamparm_val_def);
	json_object *outputmode_obj;
	if (json_object_object_get_ex(v4l2_outputparm_obj, "outputmode", &outputmode_obj))
		p->outputmode = (__u32) s2val(json_object_get_string(outputmode_obj), streamparm_val_def);
	//struct v4l2_fract  timeperframe;
	void *timeperframe_ptr = (void *) retrace_v4l2_fract_gen(v4l2_outputparm_obj, "timeperframe");
	p->timeperframe = *static_cast<struct v4l2_fract*>(timeperframe_ptr);
	free(timeperframe_ptr);

	json_object *extendedmode_obj;
	if (json_object_object_get_ex(v4l2_outputparm_obj, "extendedmode", &extendedmode_obj))
		p->extendedmode = (__u32) json_object_get_int64(extendedmode_obj);

	json_object *writebuffers_obj;
	if (json_object_object_get_ex(v4l2_outputparm_obj, "writebuffers", &writebuffers_obj))
		p->writebuffers = (__u32) json_object_get_int64(writebuffers_obj);

	return p;
}
struct v4l2_cropcap *retrace_v4l2_cropcap_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_cropcap *p = (struct v4l2_cropcap *) calloc(1, sizeof(v4l2_cropcap));

	json_object *v4l2_cropcap_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_cropcap", &v4l2_cropcap_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_cropcap_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_cropcap_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_buf_type_val_def);
	//struct v4l2_rect        bounds;
	void *bounds_ptr = (void *) retrace_v4l2_rect_gen(v4l2_cropcap_obj, "bounds");
	p->bounds = *static_cast<struct v4l2_rect*>(bounds_ptr);
	free(bounds_ptr);

	//struct v4l2_rect        defrect;
	void *defrect_ptr = (void *) retrace_v4l2_rect_gen(v4l2_cropcap_obj, "defrect");
	p->defrect = *static_cast<struct v4l2_rect*>(defrect_ptr);
	free(defrect_ptr);

	//struct v4l2_fract       pixelaspect;
	void *pixelaspect_ptr = (void *) retrace_v4l2_fract_gen(v4l2_cropcap_obj, "pixelaspect");
	p->pixelaspect = *static_cast<struct v4l2_fract*>(pixelaspect_ptr);
	free(pixelaspect_ptr);

	return p;
}
struct v4l2_crop *retrace_v4l2_crop_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_crop *p = (struct v4l2_crop *) calloc(1, sizeof(v4l2_crop));

	json_object *v4l2_crop_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_crop", &v4l2_crop_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_crop_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_crop_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_buf_type_val_def);
	//struct v4l2_rect        c;
	void *c_ptr = (void *) retrace_v4l2_rect_gen(v4l2_crop_obj, "c");
	p->c = *static_cast<struct v4l2_rect*>(c_ptr);
	free(c_ptr);

	return p;
}
struct v4l2_selection *retrace_v4l2_selection_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_selection *p = (struct v4l2_selection *) calloc(1, sizeof(v4l2_selection));

	json_object *v4l2_selection_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_selection", &v4l2_selection_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_selection_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_selection_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_buf_type_val_def);
	json_object *target_obj;
	if (json_object_object_get_ex(v4l2_selection_obj, "target", &target_obj))
		p->target = (__u32) s2val(json_object_get_string(target_obj), selection_target_val_def);
	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_selection_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_sel_flag_def);

	//struct v4l2_rect        r;
	void *r_ptr = (void *) retrace_v4l2_rect_gen(v4l2_selection_obj, "r");
	p->r = *static_cast<struct v4l2_rect*>(r_ptr);
	free(r_ptr);

	return p;
}
struct v4l2_standard *retrace_v4l2_standard_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_standard *p = (struct v4l2_standard *) calloc(1, sizeof(v4l2_standard));

	json_object *v4l2_standard_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_standard", &v4l2_standard_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_standard_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_standard_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(v4l2_standard_obj, "id", &id_obj))
		p->id = (v4l2_std_id) s2val(json_object_get_string(id_obj), nullptr);
	json_object *name_obj;
	if (json_object_object_get_ex(v4l2_standard_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 24);

	//struct v4l2_fract    frameperiod;
	void *frameperiod_ptr = (void *) retrace_v4l2_fract_gen(v4l2_standard_obj, "frameperiod");
	p->frameperiod = *static_cast<struct v4l2_fract*>(frameperiod_ptr);
	free(frameperiod_ptr);

	json_object *framelines_obj;
	if (json_object_object_get_ex(v4l2_standard_obj, "framelines", &framelines_obj))
		p->framelines = (__u32) json_object_get_int64(framelines_obj);

	return p;
}
struct v4l2_bt_timings *retrace_v4l2_bt_timings_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_bt_timings *p = (struct v4l2_bt_timings *) calloc(1, sizeof(v4l2_bt_timings));

	json_object *v4l2_bt_timings_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_bt_timings", &v4l2_bt_timings_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_bt_timings_obj);

	json_object *width_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "width", &width_obj))
		p->width = (__u32) json_object_get_int64(width_obj);

	json_object *height_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "height", &height_obj))
		p->height = (__u32) json_object_get_int64(height_obj);

	json_object *interlaced_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "interlaced", &interlaced_obj))
		p->interlaced = (__u32) json_object_get_int64(interlaced_obj);

	json_object *polarities_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "polarities", &polarities_obj))
		p->polarities = (__u32) json_object_get_int64(polarities_obj);

	json_object *pixelclock_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "pixelclock", &pixelclock_obj))
		p->pixelclock = (__u64) json_object_get_uint64(pixelclock_obj);

	json_object *hfrontporch_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "hfrontporch", &hfrontporch_obj))
		p->hfrontporch = (__u32) json_object_get_int64(hfrontporch_obj);

	json_object *hsync_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "hsync", &hsync_obj))
		p->hsync = (__u32) json_object_get_int64(hsync_obj);

	json_object *hbackporch_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "hbackporch", &hbackporch_obj))
		p->hbackporch = (__u32) json_object_get_int64(hbackporch_obj);

	json_object *vfrontporch_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "vfrontporch", &vfrontporch_obj))
		p->vfrontporch = (__u32) json_object_get_int64(vfrontporch_obj);

	json_object *vsync_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "vsync", &vsync_obj))
		p->vsync = (__u32) json_object_get_int64(vsync_obj);

	json_object *vbackporch_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "vbackporch", &vbackporch_obj))
		p->vbackporch = (__u32) json_object_get_int64(vbackporch_obj);

	json_object *il_vfrontporch_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "il_vfrontporch", &il_vfrontporch_obj))
		p->il_vfrontporch = (__u32) json_object_get_int64(il_vfrontporch_obj);

	json_object *il_vsync_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "il_vsync", &il_vsync_obj))
		p->il_vsync = (__u32) json_object_get_int64(il_vsync_obj);

	json_object *il_vbackporch_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "il_vbackporch", &il_vbackporch_obj))
		p->il_vbackporch = (__u32) json_object_get_int64(il_vbackporch_obj);

	json_object *standards_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "standards", &standards_obj))
		p->standards = (__u32) json_object_get_int64(standards_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	//struct v4l2_fract picture_aspect;
	void *picture_aspect_ptr = (void *) retrace_v4l2_fract_gen(v4l2_bt_timings_obj, "picture_aspect");
	p->picture_aspect = *static_cast<struct v4l2_fract*>(picture_aspect_ptr);
	free(picture_aspect_ptr);

	json_object *cea861_vic_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "cea861_vic", &cea861_vic_obj))
		p->cea861_vic = (__u8) json_object_get_int(cea861_vic_obj);

	json_object *hdmi_vic_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_obj, "hdmi_vic", &hdmi_vic_obj))
		p->hdmi_vic = (__u8) json_object_get_int(hdmi_vic_obj);

	return p;
}
struct v4l2_dv_timings *retrace_v4l2_dv_timings_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_dv_timings *p = (struct v4l2_dv_timings *) calloc(1, sizeof(v4l2_dv_timings));

	json_object *v4l2_dv_timings_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_dv_timings", &v4l2_dv_timings_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_dv_timings_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_dv_timings_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), nullptr);
	//union
	//struct v4l2_bt_timings	bt;
	//end of union 	};
	return p;
}
struct v4l2_enum_dv_timings *retrace_v4l2_enum_dv_timings_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_enum_dv_timings *p = (struct v4l2_enum_dv_timings *) calloc(1, sizeof(v4l2_enum_dv_timings));

	json_object *v4l2_enum_dv_timings_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_enum_dv_timings", &v4l2_enum_dv_timings_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_enum_dv_timings_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_enum_dv_timings_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *pad_obj;
	if (json_object_object_get_ex(v4l2_enum_dv_timings_obj, "pad", &pad_obj))
		p->pad = (__u32) json_object_get_int64(pad_obj);

	//struct v4l2_dv_timings timings;
	void *timings_ptr = (void *) retrace_v4l2_dv_timings_gen(v4l2_enum_dv_timings_obj, "timings");
	p->timings = *static_cast<struct v4l2_dv_timings*>(timings_ptr);
	free(timings_ptr);

	return p;
}
struct v4l2_bt_timings_cap *retrace_v4l2_bt_timings_cap_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_bt_timings_cap *p = (struct v4l2_bt_timings_cap *) calloc(1, sizeof(v4l2_bt_timings_cap));

	json_object *v4l2_bt_timings_cap_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_bt_timings_cap", &v4l2_bt_timings_cap_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_bt_timings_cap_obj);

	json_object *min_width_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_cap_obj, "min_width", &min_width_obj))
		p->min_width = (__u32) json_object_get_int64(min_width_obj);

	json_object *max_width_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_cap_obj, "max_width", &max_width_obj))
		p->max_width = (__u32) json_object_get_int64(max_width_obj);

	json_object *min_height_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_cap_obj, "min_height", &min_height_obj))
		p->min_height = (__u32) json_object_get_int64(min_height_obj);

	json_object *max_height_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_cap_obj, "max_height", &max_height_obj))
		p->max_height = (__u32) json_object_get_int64(max_height_obj);

	json_object *min_pixelclock_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_cap_obj, "min_pixelclock", &min_pixelclock_obj))
		p->min_pixelclock = (__u64) json_object_get_uint64(min_pixelclock_obj);

	json_object *max_pixelclock_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_cap_obj, "max_pixelclock", &max_pixelclock_obj))
		p->max_pixelclock = (__u64) json_object_get_uint64(max_pixelclock_obj);

	json_object *standards_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_cap_obj, "standards", &standards_obj))
		p->standards = (__u32) json_object_get_int64(standards_obj);

	json_object *capabilities_obj;
	if (json_object_object_get_ex(v4l2_bt_timings_cap_obj, "capabilities", &capabilities_obj))
		p->capabilities = (__u32) json_object_get_int64(capabilities_obj);

	return p;
}
struct v4l2_dv_timings_cap *retrace_v4l2_dv_timings_cap_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_dv_timings_cap *p = (struct v4l2_dv_timings_cap *) calloc(1, sizeof(v4l2_dv_timings_cap));

	json_object *v4l2_dv_timings_cap_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_dv_timings_cap", &v4l2_dv_timings_cap_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_dv_timings_cap_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_dv_timings_cap_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), nullptr);
	json_object *pad_obj;
	if (json_object_object_get_ex(v4l2_dv_timings_cap_obj, "pad", &pad_obj))
		p->pad = (__u32) json_object_get_int64(pad_obj);

	//union
	//struct v4l2_bt_timings_cap bt;
	//end of union 	};
	return p;
}
struct v4l2_input *retrace_v4l2_input_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_input *p = (struct v4l2_input *) calloc(1, sizeof(v4l2_input));

	json_object *v4l2_input_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_input", &v4l2_input_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_input_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_input_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *name_obj;
	if (json_object_object_get_ex(v4l2_input_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 32);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_input_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), input_type_val_def);
	json_object *audioset_obj;
	if (json_object_object_get_ex(v4l2_input_obj, "audioset", &audioset_obj))
		p->audioset = (__u32) json_object_get_int64(audioset_obj);

	json_object *tuner_obj;
	if (json_object_object_get_ex(v4l2_input_obj, "tuner", &tuner_obj))
		p->tuner = (__u32) json_object_get_int64(tuner_obj);

	json_object *std_obj;
	if (json_object_object_get_ex(v4l2_input_obj, "std", &std_obj))
		p->std = (v4l2_std_id) json_object_get_uint64(std_obj);

	json_object *status_obj;
	if (json_object_object_get_ex(v4l2_input_obj, "status", &status_obj))
		p->status = (__u32) json_object_get_int64(status_obj);

	json_object *capabilities_obj;
	if (json_object_object_get_ex(v4l2_input_obj, "capabilities", &capabilities_obj))
		p->capabilities = (__u32) json_object_get_int64(capabilities_obj);

	return p;
}
struct v4l2_output *retrace_v4l2_output_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_output *p = (struct v4l2_output *) calloc(1, sizeof(v4l2_output));

	json_object *v4l2_output_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_output", &v4l2_output_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_output_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_output_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *name_obj;
	if (json_object_object_get_ex(v4l2_output_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 32);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_output_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), output_type_val_def);
	json_object *audioset_obj;
	if (json_object_object_get_ex(v4l2_output_obj, "audioset", &audioset_obj))
		p->audioset = (__u32) json_object_get_int64(audioset_obj);

	json_object *modulator_obj;
	if (json_object_object_get_ex(v4l2_output_obj, "modulator", &modulator_obj))
		p->modulator = (__u32) json_object_get_int64(modulator_obj);

	json_object *std_obj;
	if (json_object_object_get_ex(v4l2_output_obj, "std", &std_obj))
		p->std = (v4l2_std_id) json_object_get_uint64(std_obj);

	json_object *capabilities_obj;
	if (json_object_object_get_ex(v4l2_output_obj, "capabilities", &capabilities_obj))
		p->capabilities = (__u32) json_object_get_int64(capabilities_obj);

	return p;
}
struct v4l2_control *retrace_v4l2_control_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_control *p = (struct v4l2_control *) calloc(1, sizeof(v4l2_control));

	json_object *v4l2_control_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_control", &v4l2_control_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_control_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(v4l2_control_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), control_val_def);
	json_object *value_obj;
	if (json_object_object_get_ex(v4l2_control_obj, "value", &value_obj))
		p->value = (__s32) json_object_get_int(value_obj);

	return p;
}
struct v4l2_ext_control *retrace_v4l2_ext_control_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_ext_control *p = (struct v4l2_ext_control *) calloc(1, sizeof(v4l2_ext_control));

	json_object *v4l2_ext_control_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_ext_control", &v4l2_ext_control_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_ext_control_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(v4l2_ext_control_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), control_val_def);
	json_object *size_obj;
	if (json_object_object_get_ex(v4l2_ext_control_obj, "size", &size_obj))
		p->size = (__u32) json_object_get_int64(size_obj);

	//union
	//__s32 value;
	//__s64 value64;
	//char *string;
	//__u8 *p_u8;
	//__u16 *p_u16;
	//__u32 *p_u32;
	//__s32 *p_s32;
	//__s64 *p_s64;
	//struct v4l2_area *p_area;
	//struct v4l2_ctrl_h264_sps *p_h264_sps;
	//struct v4l2_ctrl_h264_pps *p_h264_pps;
	//struct v4l2_ctrl_h264_scaling_matrix *p_h264_scaling_matrix;
	//struct v4l2_ctrl_h264_pred_weights *p_h264_pred_weights;
	//struct v4l2_ctrl_h264_slice_params *p_h264_slice_params;
	//struct v4l2_ctrl_h264_decode_params *p_h264_decode_params;
	//struct v4l2_ctrl_fwht_params *p_fwht_params;
	//struct v4l2_ctrl_vp8_frame *p_vp8_frame;
	//struct v4l2_ctrl_mpeg2_sequence *p_mpeg2_sequence;
	//struct v4l2_ctrl_mpeg2_picture *p_mpeg2_picture;
	//struct v4l2_ctrl_mpeg2_quantisation *p_mpeg2_quantisation;
	//struct v4l2_ctrl_vp9_compressed_hdr *p_vp9_compressed_hdr_probs;
	//struct v4l2_ctrl_vp9_frame *p_vp9_frame;
	//struct v4l2_ctrl_hevc_sps *p_hevc_sps;
	//struct v4l2_ctrl_hevc_pps *p_hevc_pps;
	//struct v4l2_ctrl_hevc_slice_params *p_hevc_slice_params;
	//struct v4l2_ctrl_hevc_scaling_matrix *p_hevc_scaling_matrix;
	//struct v4l2_ctrl_hevc_decode_params *p_hevc_decode_params;
	//struct v4l2_ctrl_av1_sequence *p_av1_sequence;
	//struct v4l2_ctrl_av1_tile_group_entry *p_av1_tile_group_entry;
	//struct v4l2_ctrl_av1_frame *p_av1_frame;
	//struct v4l2_ctrl_av1_film_grain *p_av1_film_grain;
	//struct v4l2_ctrl_hdr10_cll_info *p_hdr10_cll_info;
	//struct v4l2_ctrl_hdr10_mastering_display *p_hdr10_mastering_display;
	//void *ptr;
	//end of union 	} __attribute__ ((packed));
	return p;
}
struct v4l2_ext_controls *retrace_v4l2_ext_controls_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_ext_controls *p = (struct v4l2_ext_controls *) calloc(1, sizeof(v4l2_ext_controls));

	json_object *v4l2_ext_controls_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_ext_controls", &v4l2_ext_controls_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_ext_controls_obj);

	//union
	//__u32 ctrl_class;
	//__u32 which;
	//end of union 	};
	json_object *count_obj;
	if (json_object_object_get_ex(v4l2_ext_controls_obj, "count", &count_obj))
		p->count = (__u32) json_object_get_int64(count_obj);

	json_object *error_idx_obj;
	if (json_object_object_get_ex(v4l2_ext_controls_obj, "error_idx", &error_idx_obj))
		p->error_idx = (__u32) json_object_get_int64(error_idx_obj);

	json_object *request_fd_obj;
	if (json_object_object_get_ex(v4l2_ext_controls_obj, "request_fd", &request_fd_obj))
		p->request_fd = (__s32) json_object_get_int(request_fd_obj);

	//struct v4l2_ext_control *controls;
	return p;
}
struct v4l2_queryctrl *retrace_v4l2_queryctrl_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_queryctrl *p = (struct v4l2_queryctrl *) calloc(1, sizeof(v4l2_queryctrl));

	json_object *v4l2_queryctrl_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_queryctrl", &v4l2_queryctrl_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_queryctrl_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(v4l2_queryctrl_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), control_val_def);
	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_queryctrl_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_ctrl_type_val_def);
	json_object *name_obj;
	if (json_object_object_get_ex(v4l2_queryctrl_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 32);

	json_object *minimum_obj;
	if (json_object_object_get_ex(v4l2_queryctrl_obj, "minimum", &minimum_obj))
		p->minimum = (__s32) json_object_get_int(minimum_obj);

	json_object *maximum_obj;
	if (json_object_object_get_ex(v4l2_queryctrl_obj, "maximum", &maximum_obj))
		p->maximum = (__s32) json_object_get_int(maximum_obj);

	json_object *step_obj;
	if (json_object_object_get_ex(v4l2_queryctrl_obj, "step", &step_obj))
		p->step = (__s32) json_object_get_int(step_obj);

	json_object *default_value_obj;
	if (json_object_object_get_ex(v4l2_queryctrl_obj, "default_value", &default_value_obj))
		p->default_value = (__s32) json_object_get_int(default_value_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_queryctrl_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_ctrl_flag_def);

	return p;
}
struct v4l2_query_ext_ctrl *retrace_v4l2_query_ext_ctrl_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_query_ext_ctrl *p = (struct v4l2_query_ext_ctrl *) calloc(1, sizeof(v4l2_query_ext_ctrl));

	json_object *v4l2_query_ext_ctrl_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_query_ext_ctrl", &v4l2_query_ext_ctrl_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_query_ext_ctrl_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), control_val_def);
	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_ctrl_type_val_def);
	json_object *name_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 32);

	json_object *minimum_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "minimum", &minimum_obj))
		p->minimum = (__s64) json_object_get_int64(minimum_obj);

	json_object *maximum_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "maximum", &maximum_obj))
		p->maximum = (__s64) json_object_get_int64(maximum_obj);

	json_object *step_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "step", &step_obj))
		p->step = (__u64) json_object_get_uint64(step_obj);

	json_object *default_value_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "default_value", &default_value_obj))
		p->default_value = (__s64) json_object_get_int64(default_value_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_ctrl_flag_def);

	json_object *elem_size_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "elem_size", &elem_size_obj))
		p->elem_size = (__u32) json_object_get_int64(elem_size_obj);

	json_object *elems_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "elems", &elems_obj))
		p->elems = (__u32) json_object_get_int64(elems_obj);

	json_object *nr_of_dims_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "nr_of_dims", &nr_of_dims_obj))
		p->nr_of_dims = (__u32) json_object_get_int64(nr_of_dims_obj);

	/* __u32                dims[V4L2_CTRL_MAX_DIMS]; */
	json_object *dims_obj;
	if (json_object_object_get_ex(v4l2_query_ext_ctrl_obj, "dims", &dims_obj)) {
		for (int i = 0; i < (std::min((int) p->nr_of_dims, V4L2_CTRL_MAX_DIMS)); i++) {
			if (json_object_array_get_idx(dims_obj, i))
				p->dims[i] = (__u32) json_object_get_int64(json_object_array_get_idx(dims_obj, i));
		}
	}
	return p;
}
struct v4l2_querymenu *retrace_v4l2_querymenu_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_querymenu *p = (struct v4l2_querymenu *) calloc(1, sizeof(v4l2_querymenu));

	json_object *v4l2_querymenu_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_querymenu", &v4l2_querymenu_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_querymenu_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(v4l2_querymenu_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), control_val_def);
	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_querymenu_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	//union
	//__u8	name[32];
	//__s64	value;
	//end of union 	};
	return p;
}
struct v4l2_tuner *retrace_v4l2_tuner_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_tuner *p = (struct v4l2_tuner *) calloc(1, sizeof(v4l2_tuner));

	json_object *v4l2_tuner_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_tuner", &v4l2_tuner_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_tuner_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_tuner_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *name_obj;
	if (json_object_object_get_ex(v4l2_tuner_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 32);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_tuner_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_tuner_type_val_def);
	json_object *capability_obj;
	if (json_object_object_get_ex(v4l2_tuner_obj, "capability", &capability_obj))
		p->capability = (__u32) s2flags(json_object_get_string(capability_obj), tuner_cap_flag_def);

	json_object *rangelow_obj;
	if (json_object_object_get_ex(v4l2_tuner_obj, "rangelow", &rangelow_obj))
		p->rangelow = (__u32) json_object_get_int64(rangelow_obj);

	json_object *rangehigh_obj;
	if (json_object_object_get_ex(v4l2_tuner_obj, "rangehigh", &rangehigh_obj))
		p->rangehigh = (__u32) json_object_get_int64(rangehigh_obj);

	json_object *rxsubchans_obj;
	if (json_object_object_get_ex(v4l2_tuner_obj, "rxsubchans", &rxsubchans_obj))
		p->rxsubchans = (__u32) s2flags(json_object_get_string(rxsubchans_obj), tuner_rxsub_flag_def);

	json_object *audmode_obj;
	if (json_object_object_get_ex(v4l2_tuner_obj, "audmode", &audmode_obj))
		p->audmode = (__u32) s2val(json_object_get_string(audmode_obj), tuner_audmode_val_def);
	json_object *signal_obj;
	if (json_object_object_get_ex(v4l2_tuner_obj, "signal", &signal_obj))
		p->signal = (__s32) json_object_get_int(signal_obj);

	json_object *afc_obj;
	if (json_object_object_get_ex(v4l2_tuner_obj, "afc", &afc_obj))
		p->afc = (__s32) json_object_get_int(afc_obj);

	return p;
}
struct v4l2_modulator *retrace_v4l2_modulator_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_modulator *p = (struct v4l2_modulator *) calloc(1, sizeof(v4l2_modulator));

	json_object *v4l2_modulator_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_modulator", &v4l2_modulator_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_modulator_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_modulator_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *name_obj;
	if (json_object_object_get_ex(v4l2_modulator_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 32);

	json_object *capability_obj;
	if (json_object_object_get_ex(v4l2_modulator_obj, "capability", &capability_obj))
		p->capability = (__u32) json_object_get_int64(capability_obj);

	json_object *rangelow_obj;
	if (json_object_object_get_ex(v4l2_modulator_obj, "rangelow", &rangelow_obj))
		p->rangelow = (__u32) json_object_get_int64(rangelow_obj);

	json_object *rangehigh_obj;
	if (json_object_object_get_ex(v4l2_modulator_obj, "rangehigh", &rangehigh_obj))
		p->rangehigh = (__u32) json_object_get_int64(rangehigh_obj);

	json_object *txsubchans_obj;
	if (json_object_object_get_ex(v4l2_modulator_obj, "txsubchans", &txsubchans_obj))
		p->txsubchans = (__u32) json_object_get_int64(txsubchans_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_modulator_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), nullptr);
	return p;
}
struct v4l2_frequency *retrace_v4l2_frequency_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_frequency *p = (struct v4l2_frequency *) calloc(1, sizeof(v4l2_frequency));

	json_object *v4l2_frequency_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_frequency", &v4l2_frequency_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_frequency_obj);

	json_object *tuner_obj;
	if (json_object_object_get_ex(v4l2_frequency_obj, "tuner", &tuner_obj))
		p->tuner = (__u32) json_object_get_int64(tuner_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_frequency_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_tuner_type_val_def);
	json_object *frequency_obj;
	if (json_object_object_get_ex(v4l2_frequency_obj, "frequency", &frequency_obj))
		p->frequency = (__u32) json_object_get_int64(frequency_obj);

	return p;
}
struct v4l2_frequency_band *retrace_v4l2_frequency_band_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_frequency_band *p = (struct v4l2_frequency_band *) calloc(1, sizeof(v4l2_frequency_band));

	json_object *v4l2_frequency_band_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_frequency_band", &v4l2_frequency_band_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_frequency_band_obj);

	json_object *tuner_obj;
	if (json_object_object_get_ex(v4l2_frequency_band_obj, "tuner", &tuner_obj))
		p->tuner = (__u32) json_object_get_int64(tuner_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_frequency_band_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), nullptr);
	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_frequency_band_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *capability_obj;
	if (json_object_object_get_ex(v4l2_frequency_band_obj, "capability", &capability_obj))
		p->capability = (__u32) json_object_get_int64(capability_obj);

	json_object *rangelow_obj;
	if (json_object_object_get_ex(v4l2_frequency_band_obj, "rangelow", &rangelow_obj))
		p->rangelow = (__u32) json_object_get_int64(rangelow_obj);

	json_object *rangehigh_obj;
	if (json_object_object_get_ex(v4l2_frequency_band_obj, "rangehigh", &rangehigh_obj))
		p->rangehigh = (__u32) json_object_get_int64(rangehigh_obj);

	json_object *modulation_obj;
	if (json_object_object_get_ex(v4l2_frequency_band_obj, "modulation", &modulation_obj))
		p->modulation = (__u32) json_object_get_int64(modulation_obj);

	return p;
}
struct v4l2_hw_freq_seek *retrace_v4l2_hw_freq_seek_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_hw_freq_seek *p = (struct v4l2_hw_freq_seek *) calloc(1, sizeof(v4l2_hw_freq_seek));

	json_object *v4l2_hw_freq_seek_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_hw_freq_seek", &v4l2_hw_freq_seek_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_hw_freq_seek_obj);

	json_object *tuner_obj;
	if (json_object_object_get_ex(v4l2_hw_freq_seek_obj, "tuner", &tuner_obj))
		p->tuner = (__u32) json_object_get_int64(tuner_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_hw_freq_seek_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), nullptr);
	json_object *seek_upward_obj;
	if (json_object_object_get_ex(v4l2_hw_freq_seek_obj, "seek_upward", &seek_upward_obj))
		p->seek_upward = (__u32) json_object_get_int64(seek_upward_obj);

	json_object *wrap_around_obj;
	if (json_object_object_get_ex(v4l2_hw_freq_seek_obj, "wrap_around", &wrap_around_obj))
		p->wrap_around = (__u32) json_object_get_int64(wrap_around_obj);

	json_object *spacing_obj;
	if (json_object_object_get_ex(v4l2_hw_freq_seek_obj, "spacing", &spacing_obj))
		p->spacing = (__u32) json_object_get_int64(spacing_obj);

	json_object *rangelow_obj;
	if (json_object_object_get_ex(v4l2_hw_freq_seek_obj, "rangelow", &rangelow_obj))
		p->rangelow = (__u32) json_object_get_int64(rangelow_obj);

	json_object *rangehigh_obj;
	if (json_object_object_get_ex(v4l2_hw_freq_seek_obj, "rangehigh", &rangehigh_obj))
		p->rangehigh = (__u32) json_object_get_int64(rangehigh_obj);

	return p;
}
struct v4l2_rds_data *retrace_v4l2_rds_data_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_rds_data *p = (struct v4l2_rds_data *) calloc(1, sizeof(v4l2_rds_data));

	json_object *v4l2_rds_data_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_rds_data", &v4l2_rds_data_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_rds_data_obj);

	json_object *lsb_obj;
	if (json_object_object_get_ex(v4l2_rds_data_obj, "lsb", &lsb_obj))
		p->lsb = (__u8) json_object_get_int(lsb_obj);

	json_object *msb_obj;
	if (json_object_object_get_ex(v4l2_rds_data_obj, "msb", &msb_obj))
		p->msb = (__u8) json_object_get_int(msb_obj);

	json_object *block_obj;
	if (json_object_object_get_ex(v4l2_rds_data_obj, "block", &block_obj))
		p->block = (__u8) json_object_get_int(block_obj);

	return p;
}
struct v4l2_audio *retrace_v4l2_audio_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_audio *p = (struct v4l2_audio *) calloc(1, sizeof(v4l2_audio));

	json_object *v4l2_audio_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_audio", &v4l2_audio_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_audio_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_audio_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *name_obj;
	if (json_object_object_get_ex(v4l2_audio_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 32);

	json_object *capability_obj;
	if (json_object_object_get_ex(v4l2_audio_obj, "capability", &capability_obj))
		p->capability = (__u32) json_object_get_int64(capability_obj);

	json_object *mode_obj;
	if (json_object_object_get_ex(v4l2_audio_obj, "mode", &mode_obj))
		p->mode = (__u32) json_object_get_int64(mode_obj);

	return p;
}
struct v4l2_audioout *retrace_v4l2_audioout_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_audioout *p = (struct v4l2_audioout *) calloc(1, sizeof(v4l2_audioout));

	json_object *v4l2_audioout_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_audioout", &v4l2_audioout_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_audioout_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_audioout_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *name_obj;
	if (json_object_object_get_ex(v4l2_audioout_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 32);

	json_object *capability_obj;
	if (json_object_object_get_ex(v4l2_audioout_obj, "capability", &capability_obj))
		p->capability = (__u32) json_object_get_int64(capability_obj);

	json_object *mode_obj;
	if (json_object_object_get_ex(v4l2_audioout_obj, "mode", &mode_obj))
		p->mode = (__u32) json_object_get_int64(mode_obj);

	return p;
}
struct v4l2_enc_idx_entry *retrace_v4l2_enc_idx_entry_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_enc_idx_entry *p = (struct v4l2_enc_idx_entry *) calloc(1, sizeof(v4l2_enc_idx_entry));

	json_object *v4l2_enc_idx_entry_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_enc_idx_entry", &v4l2_enc_idx_entry_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_enc_idx_entry_obj);

	json_object *offset_obj;
	if (json_object_object_get_ex(v4l2_enc_idx_entry_obj, "offset", &offset_obj))
		p->offset = (__u64) json_object_get_uint64(offset_obj);

	json_object *pts_obj;
	if (json_object_object_get_ex(v4l2_enc_idx_entry_obj, "pts", &pts_obj))
		p->pts = (__u64) json_object_get_uint64(pts_obj);

	json_object *length_obj;
	if (json_object_object_get_ex(v4l2_enc_idx_entry_obj, "length", &length_obj))
		p->length = (__u32) json_object_get_int64(length_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_enc_idx_entry_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	return p;
}
struct v4l2_enc_idx *retrace_v4l2_enc_idx_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_enc_idx *p = (struct v4l2_enc_idx *) calloc(1, sizeof(v4l2_enc_idx));

	json_object *v4l2_enc_idx_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_enc_idx", &v4l2_enc_idx_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_enc_idx_obj);

	json_object *entries_obj;
	if (json_object_object_get_ex(v4l2_enc_idx_obj, "entries", &entries_obj))
		p->entries = (__u32) json_object_get_int64(entries_obj);

	json_object *entries_cap_obj;
	if (json_object_object_get_ex(v4l2_enc_idx_obj, "entries_cap", &entries_cap_obj))
		p->entries_cap = (__u32) json_object_get_int64(entries_cap_obj);

	//struct v4l2_enc_idx_entry entry[V4L2_ENC_IDX_ENTRIES];
	return p;
}
struct v4l2_encoder_cmd *retrace_v4l2_encoder_cmd_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_encoder_cmd *p = (struct v4l2_encoder_cmd *) calloc(1, sizeof(v4l2_encoder_cmd));

	json_object *v4l2_encoder_cmd_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_encoder_cmd", &v4l2_encoder_cmd_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_encoder_cmd_obj);

	json_object *cmd_obj;
	if (json_object_object_get_ex(v4l2_encoder_cmd_obj, "cmd", &cmd_obj))
		p->cmd = (__u32) s2val(json_object_get_string(cmd_obj), encoder_cmd_val_def);
	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_encoder_cmd_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	//union
	//struct {
	//__u32 data[8];
	//end of union 		} raw;
	return p;
}
struct v4l2_decoder_cmd *retrace_v4l2_decoder_cmd_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_decoder_cmd *p = (struct v4l2_decoder_cmd *) calloc(1, sizeof(v4l2_decoder_cmd));

	json_object *v4l2_decoder_cmd_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_decoder_cmd", &v4l2_decoder_cmd_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_decoder_cmd_obj);

	json_object *cmd_obj;
	if (json_object_object_get_ex(v4l2_decoder_cmd_obj, "cmd", &cmd_obj))
		p->cmd = (__u32) s2val(json_object_get_string(cmd_obj), decoder_cmd_val_def);
	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_decoder_cmd_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	//union
	//struct {
	//__u64 pts;
	//end of union 		} stop;
	//struct {
	//__s32 speed;
	//__u32 format;
	//end of struct 		} start;
	//struct {
	//__u32 data[16];
	//end of struct 		} raw;
	return p;
}
struct v4l2_vbi_format *retrace_v4l2_vbi_format_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_vbi_format *p = (struct v4l2_vbi_format *) calloc(1, sizeof(v4l2_vbi_format));

	json_object *v4l2_vbi_format_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_vbi_format", &v4l2_vbi_format_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_vbi_format_obj);

	json_object *sampling_rate_obj;
	if (json_object_object_get_ex(v4l2_vbi_format_obj, "sampling_rate", &sampling_rate_obj))
		p->sampling_rate = (__u32) json_object_get_int64(sampling_rate_obj);

	json_object *offset_obj;
	if (json_object_object_get_ex(v4l2_vbi_format_obj, "offset", &offset_obj))
		p->offset = (__u32) json_object_get_int64(offset_obj);

	json_object *samples_per_line_obj;
	if (json_object_object_get_ex(v4l2_vbi_format_obj, "samples_per_line", &samples_per_line_obj))
		p->samples_per_line = (__u32) json_object_get_int64(samples_per_line_obj);

	json_object *sample_format_obj;
	if (json_object_object_get_ex(v4l2_vbi_format_obj, "sample_format", &sample_format_obj))
		p->sample_format = (__u32) json_object_get_int64(sample_format_obj);

	json_object *start_obj;
	if (json_object_object_get_ex(v4l2_vbi_format_obj, "start", &start_obj))
		if (json_object_get_string(start_obj) != nullptr)
			memcpy(p->start, json_object_get_string(start_obj), 2);

	json_object *count_obj;
	if (json_object_object_get_ex(v4l2_vbi_format_obj, "count", &count_obj))
		if (json_object_get_string(count_obj) != nullptr)
			memcpy(p->count, json_object_get_string(count_obj), 2);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_vbi_format_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	return p;
}
struct v4l2_sliced_vbi_format *retrace_v4l2_sliced_vbi_format_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_sliced_vbi_format *p = (struct v4l2_sliced_vbi_format *) calloc(1, sizeof(v4l2_sliced_vbi_format));

	json_object *v4l2_sliced_vbi_format_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_sliced_vbi_format", &v4l2_sliced_vbi_format_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_sliced_vbi_format_obj);

	json_object *service_set_obj;
	if (json_object_object_get_ex(v4l2_sliced_vbi_format_obj, "service_set", &service_set_obj))
		p->service_set = (__u16) json_object_get_int(service_set_obj);

	//__u16   service_lines[2][24];
	json_object *io_size_obj;
	if (json_object_object_get_ex(v4l2_sliced_vbi_format_obj, "io_size", &io_size_obj))
		p->io_size = (__u32) json_object_get_int64(io_size_obj);

	return p;
}
struct v4l2_sliced_vbi_cap *retrace_v4l2_sliced_vbi_cap_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_sliced_vbi_cap *p = (struct v4l2_sliced_vbi_cap *) calloc(1, sizeof(v4l2_sliced_vbi_cap));

	json_object *v4l2_sliced_vbi_cap_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_sliced_vbi_cap", &v4l2_sliced_vbi_cap_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_sliced_vbi_cap_obj);

	json_object *service_set_obj;
	if (json_object_object_get_ex(v4l2_sliced_vbi_cap_obj, "service_set", &service_set_obj))
		p->service_set = (__u16) json_object_get_int(service_set_obj);

	//__u16   service_lines[2][24];
	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_sliced_vbi_cap_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_buf_type_val_def);
	return p;
}
struct v4l2_sliced_vbi_data *retrace_v4l2_sliced_vbi_data_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_sliced_vbi_data *p = (struct v4l2_sliced_vbi_data *) calloc(1, sizeof(v4l2_sliced_vbi_data));

	json_object *v4l2_sliced_vbi_data_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_sliced_vbi_data", &v4l2_sliced_vbi_data_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_sliced_vbi_data_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(v4l2_sliced_vbi_data_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), nullptr);
	json_object *field_obj;
	if (json_object_object_get_ex(v4l2_sliced_vbi_data_obj, "field", &field_obj))
		p->field = (__u32) s2val(json_object_get_string(field_obj), nullptr);
	json_object *line_obj;
	if (json_object_object_get_ex(v4l2_sliced_vbi_data_obj, "line", &line_obj))
		p->line = (__u32) json_object_get_int64(line_obj);

	json_object *data_obj;
	if (json_object_object_get_ex(v4l2_sliced_vbi_data_obj, "data", &data_obj))
		if (json_object_get_string(data_obj) != nullptr)
			memcpy(p->data, json_object_get_string(data_obj), 48);

	return p;
}
struct v4l2_mpeg_vbi_itv0_line *retrace_v4l2_mpeg_vbi_itv0_line_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_mpeg_vbi_itv0_line *p = (struct v4l2_mpeg_vbi_itv0_line *) calloc(1, sizeof(v4l2_mpeg_vbi_itv0_line));

	json_object *v4l2_mpeg_vbi_itv0_line_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_mpeg_vbi_itv0_line", &v4l2_mpeg_vbi_itv0_line_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_mpeg_vbi_itv0_line_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(v4l2_mpeg_vbi_itv0_line_obj, "id", &id_obj))
		p->id = (__u8) s2val(json_object_get_string(id_obj), nullptr);
	json_object *data_obj;
	if (json_object_object_get_ex(v4l2_mpeg_vbi_itv0_line_obj, "data", &data_obj))
		if (json_object_get_string(data_obj) != nullptr)
			memcpy(p->data, json_object_get_string(data_obj), 42);

	return p;
}
struct v4l2_mpeg_vbi_itv0 *retrace_v4l2_mpeg_vbi_itv0_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_mpeg_vbi_itv0 *p = (struct v4l2_mpeg_vbi_itv0 *) calloc(1, sizeof(v4l2_mpeg_vbi_itv0));

	json_object *v4l2_mpeg_vbi_itv0_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_mpeg_vbi_itv0", &v4l2_mpeg_vbi_itv0_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_mpeg_vbi_itv0_obj);

	json_object *linemask_obj;
	if (json_object_object_get_ex(v4l2_mpeg_vbi_itv0_obj, "linemask", &linemask_obj))
		if (json_object_get_string(linemask_obj) != nullptr)
			memcpy(p->linemask, json_object_get_string(linemask_obj), 2);

	//struct v4l2_mpeg_vbi_itv0_line line[35];
	return p;
}
struct v4l2_mpeg_vbi_fmt_ivtv *retrace_v4l2_mpeg_vbi_fmt_ivtv_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_mpeg_vbi_fmt_ivtv *p = (struct v4l2_mpeg_vbi_fmt_ivtv *) calloc(1, sizeof(v4l2_mpeg_vbi_fmt_ivtv));

	json_object *v4l2_mpeg_vbi_fmt_ivtv_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_mpeg_vbi_fmt_ivtv", &v4l2_mpeg_vbi_fmt_ivtv_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_mpeg_vbi_fmt_ivtv_obj);

	json_object *magic_obj;
	if (json_object_object_get_ex(v4l2_mpeg_vbi_fmt_ivtv_obj, "magic", &magic_obj))
		if (json_object_get_string(magic_obj) != nullptr)
			memcpy(p->magic, json_object_get_string(magic_obj), 4);

	//union
	//struct v4l2_mpeg_vbi_itv0 itv0;
	//struct v4l2_mpeg_vbi_ITV0 ITV0;
	//end of union 	};
	return p;
}
struct v4l2_plane_pix_format *retrace_v4l2_plane_pix_format_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_plane_pix_format *p = (struct v4l2_plane_pix_format *) calloc(1, sizeof(v4l2_plane_pix_format));

	json_object *v4l2_plane_pix_format_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_plane_pix_format", &v4l2_plane_pix_format_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_plane_pix_format_obj);

	json_object *sizeimage_obj;
	if (json_object_object_get_ex(v4l2_plane_pix_format_obj, "sizeimage", &sizeimage_obj))
		p->sizeimage = (__u32) json_object_get_int64(sizeimage_obj);

	json_object *bytesperline_obj;
	if (json_object_object_get_ex(v4l2_plane_pix_format_obj, "bytesperline", &bytesperline_obj))
		p->bytesperline = (__u32) json_object_get_int64(bytesperline_obj);

	return p;
}
struct v4l2_pix_format_mplane *retrace_v4l2_pix_format_mplane_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_pix_format_mplane *p = (struct v4l2_pix_format_mplane *) calloc(1, sizeof(v4l2_pix_format_mplane));

	json_object *v4l2_pix_format_mplane_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_pix_format_mplane", &v4l2_pix_format_mplane_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_pix_format_mplane_obj);

	json_object *width_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "width", &width_obj))
		p->width = (__u32) json_object_get_int64(width_obj);

	json_object *height_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "height", &height_obj))
		p->height = (__u32) json_object_get_int64(height_obj);

	json_object *pixelformat_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "pixelformat", &pixelformat_obj))
		p->pixelformat = (__u32) s2val(json_object_get_string(pixelformat_obj), v4l2_pix_fmt_val_def);
	json_object *field_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "field", &field_obj))
		p->field = (__u32) s2val(json_object_get_string(field_obj), v4l2_field_val_def);
	json_object *colorspace_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "colorspace", &colorspace_obj))
		p->colorspace = (__u32) s2val(json_object_get_string(colorspace_obj), v4l2_colorspace_val_def);
	//struct v4l2_plane_pix_format	plane_fmt[VIDEO_MAX_PLANES];
	json_object *num_planes_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "num_planes", &num_planes_obj))
		p->num_planes = (__u8) json_object_get_int(num_planes_obj);

	json_object *plane_fmt_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "plane_fmt", &plane_fmt_obj)) {
		for (int i = 0; i < (std::min((int) p->num_planes, VIDEO_MAX_PLANES)); i++) {
			if (json_object_array_get_idx(plane_fmt_obj, i)) {
				json_object *element_obj = json_object_new_object();
				json_object_object_add(element_obj, "v4l2_plane_pix_format", json_object_array_get_idx(plane_fmt_obj, i));
				void *ptr = (void *) retrace_v4l2_plane_pix_format_gen(element_obj);
				p->plane_fmt[i] = *static_cast<struct v4l2_plane_pix_format *>(ptr);
				free(ptr);
			}
		}
	}

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "flags", &flags_obj))
		p->flags = (__u8) s2flags(json_object_get_string(flags_obj), v4l2_pix_fmt_flag_def);

	//union
	json_object *ycbcr_enc_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "ycbcr_enc", &ycbcr_enc_obj))
		p->ycbcr_enc = (__u8) s2val(json_object_get_string(ycbcr_enc_obj), v4l2_ycbcr_encoding_val_def);
	json_object *hsv_enc_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "hsv_enc", &hsv_enc_obj))
		p->hsv_enc = (__u8) json_object_get_int(hsv_enc_obj);

	//end of union 	};
	json_object *quantization_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "quantization", &quantization_obj))
		p->quantization = (__u8) s2val(json_object_get_string(quantization_obj), v4l2_quantization_val_def);
	json_object *xfer_func_obj;
	if (json_object_object_get_ex(v4l2_pix_format_mplane_obj, "xfer_func", &xfer_func_obj))
		p->xfer_func = (__u8) s2val(json_object_get_string(xfer_func_obj), v4l2_xfer_func_val_def);
	return p;
}
struct v4l2_sdr_format *retrace_v4l2_sdr_format_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_sdr_format *p = (struct v4l2_sdr_format *) calloc(1, sizeof(v4l2_sdr_format));

	json_object *v4l2_sdr_format_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_sdr_format", &v4l2_sdr_format_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_sdr_format_obj);

	json_object *pixelformat_obj;
	if (json_object_object_get_ex(v4l2_sdr_format_obj, "pixelformat", &pixelformat_obj))
		p->pixelformat = (__u32) s2val(json_object_get_string(pixelformat_obj), v4l2_pix_fmt_val_def);
	json_object *buffersize_obj;
	if (json_object_object_get_ex(v4l2_sdr_format_obj, "buffersize", &buffersize_obj))
		p->buffersize = (__u32) json_object_get_int64(buffersize_obj);

	return p;
}
struct v4l2_meta_format *retrace_v4l2_meta_format_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_meta_format *p = (struct v4l2_meta_format *) calloc(1, sizeof(v4l2_meta_format));

	json_object *v4l2_meta_format_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_meta_format", &v4l2_meta_format_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_meta_format_obj);

	json_object *dataformat_obj;
	if (json_object_object_get_ex(v4l2_meta_format_obj, "dataformat", &dataformat_obj))
		p->dataformat = (__u32) json_object_get_int64(dataformat_obj);

	json_object *buffersize_obj;
	if (json_object_object_get_ex(v4l2_meta_format_obj, "buffersize", &buffersize_obj))
		p->buffersize = (__u32) json_object_get_int64(buffersize_obj);

	json_object *width_obj;
	if (json_object_object_get_ex(v4l2_meta_format_obj, "width", &width_obj))
		p->width = (__u32) json_object_get_int64(width_obj);

	json_object *height_obj;
	if (json_object_object_get_ex(v4l2_meta_format_obj, "height", &height_obj))
		p->height = (__u32) json_object_get_int64(height_obj);

	json_object *bytesperline_obj;
	if (json_object_object_get_ex(v4l2_meta_format_obj, "bytesperline", &bytesperline_obj))
		p->bytesperline = (__u32) json_object_get_int64(bytesperline_obj);

	return p;
}
struct v4l2_format *retrace_v4l2_format_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_format *p = (struct v4l2_format *) calloc(1, sizeof(v4l2_format));

	json_object *v4l2_format_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_format", &v4l2_format_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_format_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_format_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_buf_type_val_def);
	//union
	switch (p->type) {
	case V4L2_BUF_TYPE_VIDEO_CAPTURE:
	case V4L2_BUF_TYPE_VIDEO_OUTPUT: {
		void *pix_ptr = (void *) retrace_v4l2_pix_format_gen(v4l2_format_obj);
		p->fmt.pix = *static_cast<struct v4l2_pix_format*>(pix_ptr);
		free(pix_ptr);
		break;
	}
	case V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE:
	case V4L2_BUF_TYPE_VIDEO_OUTPUT_MPLANE: {
		void *pix_mp_ptr = (void *) retrace_v4l2_pix_format_mplane_gen(v4l2_format_obj);
		p->fmt.pix_mp = *static_cast<struct v4l2_pix_format_mplane*>(pix_mp_ptr);
		free(pix_mp_ptr);
		break;
	}
	default:
		break;
	}
	//struct v4l2_pix_format		pix;
	//struct v4l2_pix_format_mplane	pix_mp;
	//struct v4l2_window		win;
	//struct v4l2_vbi_format		vbi;
	//struct v4l2_sliced_vbi_format	sliced;
	//struct v4l2_sdr_format		sdr;
	//struct v4l2_meta_format		meta;
	//end of union 	} fmt;
	return p;
}
struct v4l2_streamparm *retrace_v4l2_streamparm_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_streamparm *p = (struct v4l2_streamparm *) calloc(1, sizeof(v4l2_streamparm));

	json_object *v4l2_streamparm_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_streamparm", &v4l2_streamparm_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_streamparm_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_streamparm_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_buf_type_val_def);
	//union
	//struct v4l2_captureparm	capture;
	//struct v4l2_outputparm	output;
	//end of union 	} parm;
	return p;
}
struct v4l2_event_vsync *retrace_v4l2_event_vsync_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_event_vsync *p = (struct v4l2_event_vsync *) calloc(1, sizeof(v4l2_event_vsync));

	json_object *v4l2_event_vsync_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_event_vsync", &v4l2_event_vsync_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_event_vsync_obj);

	json_object *field_obj;
	if (json_object_object_get_ex(v4l2_event_vsync_obj, "field", &field_obj))
		p->field = (__u8) s2val(json_object_get_string(field_obj), v4l2_field_val_def);
	return p;
}
struct v4l2_event_ctrl *retrace_v4l2_event_ctrl_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_event_ctrl *p = (struct v4l2_event_ctrl *) calloc(1, sizeof(v4l2_event_ctrl));

	json_object *v4l2_event_ctrl_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_event_ctrl", &v4l2_event_ctrl_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_event_ctrl_obj);

	json_object *changes_obj;
	if (json_object_object_get_ex(v4l2_event_ctrl_obj, "changes", &changes_obj))
		p->changes = (__u32) s2flags(json_object_get_string(changes_obj), v4l2_event_ctrl_ch_flag_def);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_event_ctrl_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), v4l2_ctrl_type_val_def);
	//union
	//__s32 value;
	//__s64 value64;
	//end of union 	};
	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_event_ctrl_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_ctrl_flag_def);

	json_object *minimum_obj;
	if (json_object_object_get_ex(v4l2_event_ctrl_obj, "minimum", &minimum_obj))
		p->minimum = (__s32) json_object_get_int(minimum_obj);

	json_object *maximum_obj;
	if (json_object_object_get_ex(v4l2_event_ctrl_obj, "maximum", &maximum_obj))
		p->maximum = (__s32) json_object_get_int(maximum_obj);

	json_object *step_obj;
	if (json_object_object_get_ex(v4l2_event_ctrl_obj, "step", &step_obj))
		p->step = (__s32) json_object_get_int(step_obj);

	json_object *default_value_obj;
	if (json_object_object_get_ex(v4l2_event_ctrl_obj, "default_value", &default_value_obj))
		p->default_value = (__s32) json_object_get_int(default_value_obj);

	return p;
}
struct v4l2_event_frame_sync *retrace_v4l2_event_frame_sync_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_event_frame_sync *p = (struct v4l2_event_frame_sync *) calloc(1, sizeof(v4l2_event_frame_sync));

	json_object *v4l2_event_frame_sync_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_event_frame_sync", &v4l2_event_frame_sync_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_event_frame_sync_obj);

	json_object *frame_sequence_obj;
	if (json_object_object_get_ex(v4l2_event_frame_sync_obj, "frame_sequence", &frame_sequence_obj))
		p->frame_sequence = (__u32) json_object_get_int64(frame_sequence_obj);

	return p;
}
struct v4l2_event_src_change *retrace_v4l2_event_src_change_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_event_src_change *p = (struct v4l2_event_src_change *) calloc(1, sizeof(v4l2_event_src_change));

	json_object *v4l2_event_src_change_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_event_src_change", &v4l2_event_src_change_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_event_src_change_obj);

	json_object *changes_obj;
	if (json_object_object_get_ex(v4l2_event_src_change_obj, "changes", &changes_obj))
		p->changes = (__u32) json_object_get_int64(changes_obj);

	return p;
}
struct v4l2_event_motion_det *retrace_v4l2_event_motion_det_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_event_motion_det *p = (struct v4l2_event_motion_det *) calloc(1, sizeof(v4l2_event_motion_det));

	json_object *v4l2_event_motion_det_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_event_motion_det", &v4l2_event_motion_det_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_event_motion_det_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_event_motion_det_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	json_object *frame_sequence_obj;
	if (json_object_object_get_ex(v4l2_event_motion_det_obj, "frame_sequence", &frame_sequence_obj))
		p->frame_sequence = (__u32) json_object_get_int64(frame_sequence_obj);

	json_object *region_mask_obj;
	if (json_object_object_get_ex(v4l2_event_motion_det_obj, "region_mask", &region_mask_obj))
		p->region_mask = (__u32) json_object_get_int64(region_mask_obj);

	return p;
}
struct v4l2_event *retrace_v4l2_event_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_event *p = (struct v4l2_event *) calloc(1, sizeof(v4l2_event));

	json_object *v4l2_event_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_event", &v4l2_event_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_event_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_event_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), event_val_def);
	//union
	//struct v4l2_event_vsync		vsync;
	//struct v4l2_event_ctrl		ctrl;
	//struct v4l2_event_frame_sync	frame_sync;
	//struct v4l2_event_src_change	src_change;
	//struct v4l2_event_motion_det	motion_det;
	//__u8				data[64];
	//end of union 	} u;
	json_object *pending_obj;
	if (json_object_object_get_ex(v4l2_event_obj, "pending", &pending_obj))
		p->pending = (__u32) json_object_get_int64(pending_obj);

	json_object *sequence_obj;
	if (json_object_object_get_ex(v4l2_event_obj, "sequence", &sequence_obj))
		p->sequence = (__u32) json_object_get_int64(sequence_obj);

	//struct timespec			timestamp;
	json_object *id_obj;
	if (json_object_object_get_ex(v4l2_event_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), nullptr);
	return p;
}
struct v4l2_event_subscription *retrace_v4l2_event_subscription_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_event_subscription *p = (struct v4l2_event_subscription *) calloc(1, sizeof(v4l2_event_subscription));

	json_object *v4l2_event_subscription_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_event_subscription", &v4l2_event_subscription_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_event_subscription_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_event_subscription_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), event_val_def);
	json_object *id_obj;
	if (json_object_object_get_ex(v4l2_event_subscription_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), nullptr);
	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_event_subscription_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_event_sub_flag_def);

	return p;
}
struct v4l2_dbg_match *retrace_v4l2_dbg_match_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_dbg_match *p = (struct v4l2_dbg_match *) calloc(1, sizeof(v4l2_dbg_match));

	json_object *v4l2_dbg_match_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_dbg_match", &v4l2_dbg_match_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_dbg_match_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_dbg_match_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), nullptr);
	//union
	//__u32 addr;
	//char name[32];
	//end of union 	};
	return p;
}
struct v4l2_dbg_register *retrace_v4l2_dbg_register_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_dbg_register *p = (struct v4l2_dbg_register *) calloc(1, sizeof(v4l2_dbg_register));

	json_object *v4l2_dbg_register_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_dbg_register", &v4l2_dbg_register_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_dbg_register_obj);

	//struct v4l2_dbg_match match;
	void *match_ptr = (void *) retrace_v4l2_dbg_match_gen(v4l2_dbg_register_obj, "match");
	p->match = *static_cast<struct v4l2_dbg_match*>(match_ptr);
	free(match_ptr);

	json_object *size_obj;
	if (json_object_object_get_ex(v4l2_dbg_register_obj, "size", &size_obj))
		p->size = (__u32) json_object_get_int64(size_obj);

	json_object *reg_obj;
	if (json_object_object_get_ex(v4l2_dbg_register_obj, "reg", &reg_obj))
		p->reg = (__u64) json_object_get_uint64(reg_obj);

	json_object *val_obj;
	if (json_object_object_get_ex(v4l2_dbg_register_obj, "val", &val_obj))
		p->val = (__u64) json_object_get_uint64(val_obj);

	return p;
}
struct v4l2_dbg_chip_info *retrace_v4l2_dbg_chip_info_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_dbg_chip_info *p = (struct v4l2_dbg_chip_info *) calloc(1, sizeof(v4l2_dbg_chip_info));

	json_object *v4l2_dbg_chip_info_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_dbg_chip_info", &v4l2_dbg_chip_info_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_dbg_chip_info_obj);

	//struct v4l2_dbg_match match;
	void *match_ptr = (void *) retrace_v4l2_dbg_match_gen(v4l2_dbg_chip_info_obj, "match");
	p->match = *static_cast<struct v4l2_dbg_match*>(match_ptr);
	free(match_ptr);

	json_object *name_obj;
	if (json_object_object_get_ex(v4l2_dbg_chip_info_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 32);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_dbg_chip_info_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	return p;
}
struct v4l2_create_buffers *retrace_v4l2_create_buffers_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_create_buffers *p = (struct v4l2_create_buffers *) calloc(1, sizeof(v4l2_create_buffers));

	json_object *v4l2_create_buffers_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_create_buffers", &v4l2_create_buffers_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_create_buffers_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_create_buffers_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *count_obj;
	if (json_object_object_get_ex(v4l2_create_buffers_obj, "count", &count_obj))
		p->count = (__u32) json_object_get_int64(count_obj);

	json_object *memory_obj;
	if (json_object_object_get_ex(v4l2_create_buffers_obj, "memory", &memory_obj))
		p->memory = (__u32) s2val(json_object_get_string(memory_obj), v4l2_memory_val_def);
	//struct v4l2_format	format;
	void *format_ptr = (void *) retrace_v4l2_format_gen(v4l2_create_buffers_obj, "format");
	p->format = *static_cast<struct v4l2_format*>(format_ptr);
	free(format_ptr);

	json_object *capabilities_obj;
	if (json_object_object_get_ex(v4l2_create_buffers_obj, "capabilities", &capabilities_obj))
		p->capabilities = (__u32) s2flags(json_object_get_string(capabilities_obj), v4l2_buf_cap_flag_def);

	json_object *flags_obj;
	if (json_object_object_get_ex(v4l2_create_buffers_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), v4l2_memory_flag_def);

	json_object *max_num_buffers_obj;
	if (json_object_object_get_ex(v4l2_create_buffers_obj, "max_num_buffers", &max_num_buffers_obj))
		p->max_num_buffers = (__u32) json_object_get_int64(max_num_buffers_obj);

	return p;
}
struct v4l2_remove_buffers *retrace_v4l2_remove_buffers_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_remove_buffers *p = (struct v4l2_remove_buffers *) calloc(1, sizeof(v4l2_remove_buffers));

	json_object *v4l2_remove_buffers_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_remove_buffers", &v4l2_remove_buffers_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_remove_buffers_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(v4l2_remove_buffers_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	json_object *count_obj;
	if (json_object_object_get_ex(v4l2_remove_buffers_obj, "count", &count_obj))
		p->count = (__u32) json_object_get_int64(count_obj);

	json_object *type_obj;
	if (json_object_object_get_ex(v4l2_remove_buffers_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), nullptr);
	return p;
}
struct media_device_info *retrace_media_device_info_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_device_info *p = (struct media_device_info *) calloc(1, sizeof(media_device_info));

	json_object *media_device_info_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_device_info", &media_device_info_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_device_info_obj);

	json_object *driver_obj;
	if (json_object_object_get_ex(media_device_info_obj, "driver", &driver_obj))
		if (json_object_get_string(driver_obj) != nullptr)
			memcpy(p->driver, json_object_get_string(driver_obj), 16);

	json_object *model_obj;
	if (json_object_object_get_ex(media_device_info_obj, "model", &model_obj))
		if (json_object_get_string(model_obj) != nullptr)
			memcpy(p->model, json_object_get_string(model_obj), 32);

	json_object *serial_obj;
	if (json_object_object_get_ex(media_device_info_obj, "serial", &serial_obj))
		if (json_object_get_string(serial_obj) != nullptr)
			memcpy(p->serial, json_object_get_string(serial_obj), 40);

	json_object *bus_info_obj;
	if (json_object_object_get_ex(media_device_info_obj, "bus_info", &bus_info_obj))
		if (json_object_get_string(bus_info_obj) != nullptr)
			memcpy(p->bus_info, json_object_get_string(bus_info_obj), 32);

	json_object *media_version_obj;
	if (json_object_object_get_ex(media_device_info_obj, "media_version", &media_version_obj))
		memset(&p->media_version, 0, sizeof(p->media_version));

	json_object *hw_revision_obj;
	if (json_object_object_get_ex(media_device_info_obj, "hw_revision", &hw_revision_obj))
		p->hw_revision = (__u32) json_object_get_int64(hw_revision_obj);

	json_object *driver_version_obj;
	if (json_object_object_get_ex(media_device_info_obj, "driver_version", &driver_version_obj))
		memset(&p->driver_version, 0, sizeof(p->driver_version));

	return p;
}
struct media_entity_desc *retrace_media_entity_desc_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_entity_desc *p = (struct media_entity_desc *) calloc(1, sizeof(media_entity_desc));

	json_object *media_entity_desc_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_entity_desc", &media_entity_desc_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_entity_desc_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(media_entity_desc_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), nullptr);
	json_object *name_obj;
	if (json_object_object_get_ex(media_entity_desc_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 32);

	json_object *type_obj;
	if (json_object_object_get_ex(media_entity_desc_obj, "type", &type_obj))
		p->type = (__u32) s2val(json_object_get_string(type_obj), nullptr);
	json_object *revision_obj;
	if (json_object_object_get_ex(media_entity_desc_obj, "revision", &revision_obj))
		p->revision = (__u32) json_object_get_int64(revision_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(media_entity_desc_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	json_object *group_id_obj;
	if (json_object_object_get_ex(media_entity_desc_obj, "group_id", &group_id_obj))
		p->group_id = (__u32) json_object_get_int64(group_id_obj);

	json_object *pads_obj;
	if (json_object_object_get_ex(media_entity_desc_obj, "pads", &pads_obj))
		p->pads = (__u16) json_object_get_int(pads_obj);

	json_object *links_obj;
	if (json_object_object_get_ex(media_entity_desc_obj, "links", &links_obj))
		p->links = (__u16) json_object_get_int(links_obj);

	//union
	//struct {
	//__u32 major;
	//__u32 minor;
	//end of union 		} dev;
	//struct {
	//__u32 card;
	//__u32 device;
	//__u32 subdevice;
	//end of struct 		} alsa;
	//struct {
	//__u32 major;
	//__u32 minor;
	//end of struct 		} v4l;
	//struct {
	//__u32 major;
	//__u32 minor;
	//end of struct 		} fb;
	json_object *dvb_obj;
	if (json_object_object_get_ex(media_entity_desc_obj, "dvb", &dvb_obj))
		p->dvb = (int) json_object_get_int(dvb_obj);

	json_object *raw_obj;
	if (json_object_object_get_ex(media_entity_desc_obj, "raw", &raw_obj))
		if (json_object_get_string(raw_obj) != nullptr)
			memcpy(p->raw, json_object_get_string(raw_obj), 184);

	return p;
}
struct media_pad_desc *retrace_media_pad_desc_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_pad_desc *p = (struct media_pad_desc *) calloc(1, sizeof(media_pad_desc));

	json_object *media_pad_desc_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_pad_desc", &media_pad_desc_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_pad_desc_obj);

	json_object *entity_obj;
	if (json_object_object_get_ex(media_pad_desc_obj, "entity", &entity_obj))
		p->entity = (__u32) json_object_get_int64(entity_obj);

	json_object *index_obj;
	if (json_object_object_get_ex(media_pad_desc_obj, "index", &index_obj))
		p->index = (__u16) json_object_get_int(index_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(media_pad_desc_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	return p;
}
struct media_link_desc *retrace_media_link_desc_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_link_desc *p = (struct media_link_desc *) calloc(1, sizeof(media_link_desc));

	json_object *media_link_desc_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_link_desc", &media_link_desc_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_link_desc_obj);

	//struct media_pad_desc source;
	void *source_ptr = (void *) retrace_media_pad_desc_gen(media_link_desc_obj, "source");
	p->source = *static_cast<struct media_pad_desc*>(source_ptr);
	free(source_ptr);

	//struct media_pad_desc sink;
	void *sink_ptr = (void *) retrace_media_pad_desc_gen(media_link_desc_obj, "sink");
	p->sink = *static_cast<struct media_pad_desc*>(sink_ptr);
	free(sink_ptr);

	json_object *flags_obj;
	if (json_object_object_get_ex(media_link_desc_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	return p;
}
struct media_links_enum *retrace_media_links_enum_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_links_enum *p = (struct media_links_enum *) calloc(1, sizeof(media_links_enum));

	json_object *media_links_enum_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_links_enum", &media_links_enum_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_links_enum_obj);

	json_object *entity_obj;
	if (json_object_object_get_ex(media_links_enum_obj, "entity", &entity_obj))
		p->entity = (__u32) json_object_get_int64(entity_obj);

	//struct media_pad_desc *pads;
	//struct media_link_desc *links;
	return p;
}
struct media_v2_entity *retrace_media_v2_entity_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_v2_entity *p = (struct media_v2_entity *) calloc(1, sizeof(media_v2_entity));

	json_object *media_v2_entity_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_v2_entity", &media_v2_entity_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_v2_entity_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(media_v2_entity_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), nullptr);
	json_object *name_obj;
	if (json_object_object_get_ex(media_v2_entity_obj, "name", &name_obj))
		if (json_object_get_string(name_obj) != nullptr)
			memcpy(p->name, json_object_get_string(name_obj), 64);

	json_object *function_obj;
	if (json_object_object_get_ex(media_v2_entity_obj, "function", &function_obj))
		p->function = (__u32) json_object_get_int64(function_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(media_v2_entity_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	return p;
}
struct media_v2_intf_devnode *retrace_media_v2_intf_devnode_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_v2_intf_devnode *p = (struct media_v2_intf_devnode *) calloc(1, sizeof(media_v2_intf_devnode));

	json_object *media_v2_intf_devnode_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_v2_intf_devnode", &media_v2_intf_devnode_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_v2_intf_devnode_obj);

	json_object *major_obj;
	if (json_object_object_get_ex(media_v2_intf_devnode_obj, "major", &major_obj))
		p->major = (__u32) json_object_get_int64(major_obj);

	json_object *minor_obj;
	if (json_object_object_get_ex(media_v2_intf_devnode_obj, "minor", &minor_obj))
		p->minor = (__u32) json_object_get_int64(minor_obj);

	return p;
}
struct media_v2_interface *retrace_media_v2_interface_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_v2_interface *p = (struct media_v2_interface *) calloc(1, sizeof(media_v2_interface));

	json_object *media_v2_interface_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_v2_interface", &media_v2_interface_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_v2_interface_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(media_v2_interface_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), nullptr);
	json_object *intf_type_obj;
	if (json_object_object_get_ex(media_v2_interface_obj, "intf_type", &intf_type_obj))
		p->intf_type = (__u32) json_object_get_int64(intf_type_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(media_v2_interface_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	//union
	//struct media_v2_intf_devnode devnode;
	//__u32 raw[16];
	//end of union 	};
	return p;
}
struct media_v2_pad *retrace_media_v2_pad_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_v2_pad *p = (struct media_v2_pad *) calloc(1, sizeof(media_v2_pad));

	json_object *media_v2_pad_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_v2_pad", &media_v2_pad_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_v2_pad_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(media_v2_pad_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), nullptr);
	json_object *entity_id_obj;
	if (json_object_object_get_ex(media_v2_pad_obj, "entity_id", &entity_id_obj))
		p->entity_id = (__u32) json_object_get_int64(entity_id_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(media_v2_pad_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	json_object *index_obj;
	if (json_object_object_get_ex(media_v2_pad_obj, "index", &index_obj))
		p->index = (__u32) json_object_get_int64(index_obj);

	return p;
}
struct media_v2_link *retrace_media_v2_link_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_v2_link *p = (struct media_v2_link *) calloc(1, sizeof(media_v2_link));

	json_object *media_v2_link_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_v2_link", &media_v2_link_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_v2_link_obj);

	json_object *id_obj;
	if (json_object_object_get_ex(media_v2_link_obj, "id", &id_obj))
		p->id = (__u32) s2val(json_object_get_string(id_obj), nullptr);
	json_object *source_id_obj;
	if (json_object_object_get_ex(media_v2_link_obj, "source_id", &source_id_obj))
		p->source_id = (__u32) json_object_get_int64(source_id_obj);

	json_object *sink_id_obj;
	if (json_object_object_get_ex(media_v2_link_obj, "sink_id", &sink_id_obj))
		p->sink_id = (__u32) json_object_get_int64(sink_id_obj);

	json_object *flags_obj;
	if (json_object_object_get_ex(media_v2_link_obj, "flags", &flags_obj))
		p->flags = (__u32) s2flags(json_object_get_string(flags_obj), nullptr);

	return p;
}
struct media_v2_topology *retrace_media_v2_topology_gen(json_object *parent_obj, std::string key_name = "")
{
	struct media_v2_topology *p = (struct media_v2_topology *) calloc(1, sizeof(media_v2_topology));

	json_object *media_v2_topology_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "media_v2_topology", &media_v2_topology_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &media_v2_topology_obj);

	json_object *topology_version_obj;
	if (json_object_object_get_ex(media_v2_topology_obj, "topology_version", &topology_version_obj))
		memset(&p->topology_version, 0, sizeof(p->topology_version));

	json_object *num_entities_obj;
	if (json_object_object_get_ex(media_v2_topology_obj, "num_entities", &num_entities_obj))
		p->num_entities = (__u32) json_object_get_int64(num_entities_obj);

	json_object *ptr_entities_obj;
	if (json_object_object_get_ex(media_v2_topology_obj, "ptr_entities", &ptr_entities_obj))
		p->ptr_entities = (__u64) json_object_get_uint64(ptr_entities_obj);

	json_object *num_interfaces_obj;
	if (json_object_object_get_ex(media_v2_topology_obj, "num_interfaces", &num_interfaces_obj))
		p->num_interfaces = (__u32) json_object_get_int64(num_interfaces_obj);

	json_object *ptr_interfaces_obj;
	if (json_object_object_get_ex(media_v2_topology_obj, "ptr_interfaces", &ptr_interfaces_obj))
		p->ptr_interfaces = (__u64) json_object_get_uint64(ptr_interfaces_obj);

	json_object *num_pads_obj;
	if (json_object_object_get_ex(media_v2_topology_obj, "num_pads", &num_pads_obj))
		p->num_pads = (__u32) json_object_get_int64(num_pads_obj);

	json_object *ptr_pads_obj;
	if (json_object_object_get_ex(media_v2_topology_obj, "ptr_pads", &ptr_pads_obj))
		p->ptr_pads = (__u64) json_object_get_uint64(ptr_pads_obj);

	json_object *num_links_obj;
	if (json_object_object_get_ex(media_v2_topology_obj, "num_links", &num_links_obj))
		p->num_links = (__u32) json_object_get_int64(num_links_obj);

	json_object *ptr_links_obj;
	if (json_object_object_get_ex(media_v2_topology_obj, "ptr_links", &ptr_links_obj))
		p->ptr_links = (__u64) json_object_get_uint64(ptr_links_obj);

	return p;
}
struct v4l2_edid *retrace_v4l2_edid_gen(json_object *parent_obj, std::string key_name = "")
{
	struct v4l2_edid *p = (struct v4l2_edid *) calloc(1, sizeof(v4l2_edid));

	json_object *v4l2_edid_obj;
	if (key_name.empty())
		json_object_object_get_ex(parent_obj, "v4l2_edid", &v4l2_edid_obj);
	else
		json_object_object_get_ex(parent_obj, key_name.c_str(), &v4l2_edid_obj);

	json_object *pad_obj;
	if (json_object_object_get_ex(v4l2_edid_obj, "pad", &pad_obj))
		p->pad = (__u32) json_object_get_int64(pad_obj);

	json_object *start_block_obj;
	if (json_object_object_get_ex(v4l2_edid_obj, "start_block", &start_block_obj))
		p->start_block = (__u32) json_object_get_int64(start_block_obj);

	json_object *blocks_obj;
	if (json_object_object_get_ex(v4l2_edid_obj, "blocks", &blocks_obj))
		p->blocks = (__u32) json_object_get_int64(blocks_obj);

	//__u8  *edid;
	return p;
}
