/**
 * Results file used for BASE-CREATEX_* TESTS.
 */

enum {
	CXD_CREATEX = 0,
	CXD_FILE_READ = 1,
	CXD_DIR_ENUMERATE = 1,
	CXD_FILE_WRITE = 2,
	CXD_DIR_CREATE_CHILD = 2,
	CXD_FILE_EXECUTE = 3,
	CXD_DIR_TRAVERSE = 3,
	CXD_MAX,
} cxd_results;

enum cxd_test {
	CXD_TEST_CREATEX_ACCESS            = 0,
	CXD_TEST_CREATEX_ACCESS_EXHAUSTIVE = 1,
	CXD_TEST_CREATEX_SHAREMODE         = 2,
	CXD_TEST_CREATEX_SHAREMODE_EXTENDED = 3,
};

enum cxd_flags {
	CXD_FLAGS_DIRECTORY             = 0x1,
	CXD_FLAGS_MAKE_BEFORE_CREATEX   = 0x2,

	CXD_FLAGS_MASK                  = 0x3,
	CXD_FLAGS_COUNT                 = CXD_FLAGS_MASK + 1,
};

/**
 * CXD.
 */
struct createx_data {
	/* In. */
	enum cxd_test   cxd_test;
	enum cxd_flags  cxd_flags;
	uint32_t        cxd_access1;
	uint32_t        cxd_sharemode1;
	uint32_t        cxd_access2;
	uint32_t        cxd_sharemode2;

	/* Out. */
	NTSTATUS        cxd_result[CXD_MAX];
	NTSTATUS        cxd_result2[CXD_MAX];
};

/**
 * Known CXD results, for CREATEX_ACCESS and CREATEX_SHAREMODE.
 * Taken by running against a Windows XP Pro 2002 Edition, Service Pack 2.
 */
static const struct createx_data cxd_known[] = {
/**
 * CXD_TEST_CREATEX_ACCESS data.
 */
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =        0x1, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000001, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000001, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =        0x2, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000002, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000002, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =        0x4, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000004, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000004, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =        0x8, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000008, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000008, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =       0x10, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000010, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000010, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =       0x20, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000020, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000020, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =       0x40, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000040, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000040, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =       0x80, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000080, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000080, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =      0x100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =      0x200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =      0x400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =      0x800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =     0x1000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2001000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3001000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =     0x2000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2002000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3002000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =     0x4000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2004000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3004000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =     0x8000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2008000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3008000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =    0x10000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2010000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3010000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =    0x20000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2020000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3020000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =    0x40000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2040000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3040000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =    0x80000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2080000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3080000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =   0x800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x1000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x2000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x4000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x6000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x7000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0x8000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0xa000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 =  0xb000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x10000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x12000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x13000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x20000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x22000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x23000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x40000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x42000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x43000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x80000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x82000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags =   0, .cxd_access1 = 0x83000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =        0x1, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000001, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000001, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =        0x2, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000002, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000002, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =        0x4, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000004, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000004, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =        0x8, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000008, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000008, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =       0x10, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000010, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000010, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =       0x20, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000020, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000020, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =       0x40, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000040, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000040, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =       0x80, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000080, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000080, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =      0x100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =      0x200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =      0x400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =      0x800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =     0x1000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2001000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3001000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =     0x2000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2002000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3002000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =     0x4000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2004000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3004000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =     0x8000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2008000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3008000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =    0x10000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2010000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3010000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =    0x20000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2020000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3020000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =    0x40000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2040000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3040000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =    0x80000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2080000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3080000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =   0x800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x1000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x2000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x4000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x6000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x7000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0x8000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0xa000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 =  0xb000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x10000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x12000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x13000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x20000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x22000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x23000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x40000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x42000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x43000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x80000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x82000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x1, .cxd_access1 = 0x83000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =        0x1, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000001, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000001, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =        0x2, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000002, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000002, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =        0x4, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000004, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000004, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =        0x8, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000008, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000008, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =       0x10, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000010, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000010, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =       0x20, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000020, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000020, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =       0x40, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000040, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000040, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =       0x80, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000080, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000080, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =      0x100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =      0x200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =      0x400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =      0x800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =     0x1000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2001000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3001000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =     0x2000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2002000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3002000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =     0x4000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2004000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3004000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =     0x8000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2008000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3008000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =    0x10000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2010000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3010000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =    0x20000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2020000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3020000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =    0x40000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2040000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3040000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =    0x80000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2080000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3080000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =   0x800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x1000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x2000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x4000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x6000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x7000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0x8000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0xa000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 =  0xb000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x10000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x12000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x13000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x20000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x22000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x23000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x40000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x42000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x43000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x80000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x82000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x2, .cxd_access1 = 0x83000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =        0x1, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000001, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000001, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =        0x2, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000002, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000002, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =        0x4, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000004, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000004, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =        0x8, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000008, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000008, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =       0x10, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000010, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000010, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =       0x20, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000020, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000020, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =       0x40, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000040, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000040, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =       0x80, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000080, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000080, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =      0x100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000100, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =      0x200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000200, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =      0x400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000400, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =      0x800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000800, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =     0x1000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2001000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3001000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =     0x2000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2002000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3002000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =     0x4000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2004000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3004000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =     0x8000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2008000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3008000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =    0x10000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2010000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3010000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =    0x20000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2020000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3020000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =    0x40000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2040000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3040000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =    0x80000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2080000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3080000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3100000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3200000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3400000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =   0x800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3800000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x1000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x2000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x3000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x4000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x6000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x7000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0x8000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0xa000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 =  0xb000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x10000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x12000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x13000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x20000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x22000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x23000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x40000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x42000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x43000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x80000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x82000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 0, .cxd_flags = 0x3, .cxd_access1 = 0x83000000, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
/**
 * CXD_TEST_CREATEX_SHAREMODE (file, non extended)
 */
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=0, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=1, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=2, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=3, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=         0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120089, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x120116, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x12019f, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a0, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1200a9, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201b6, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=4, .cxd_access2=  0x1201bf, .cxd_sharemode2=7, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=0, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=1, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=2, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=3, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=4, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201bf, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=5, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =          0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120089, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x120116, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x12019f, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a0, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120089, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x120116, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x12019f, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1200a9, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201b6, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1200a9, .cxd_sharemode1=5, .cxd_access2=  0x1201bf, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, NT_STATUS_OK, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x1201b6, .cxd_sharemode1=5, .cxd_access2=         0, .cxd_sharemode2=6, .cxd_result = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_OK, NT_STATUS_OK, }, .cxd_result2 = { NT_STATUS_OK, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, NT_STATUS_ACCESS_DENIED, }},
  { .cxd_test = 2, .cxd_flags =   0, .cxd_access1 =   0x