// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Emoji_Keycap_Sequence` (property of strings)
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes, regexp-v-flag]
includes: [regExpUtils.js]
---*/

testPropertyOfStrings({
  regExp: /^\p{Emoji_Keycap_Sequence}+$/v,
  expression: "\\p{Emoji_Keycap_Sequence}",
  matchStrings: [
    "#\uFE0F\u20E3",
    "*\uFE0F\u20E3",
    "0\uFE0F\u20E3",
    "1\uFE0F\u20E3",
    "2\uFE0F\u20E3",
    "3\uFE0F\u20E3",
    "4\uFE0F\u20E3",
    "5\uFE0F\u20E3",
    "6\uFE0F\u20E3",
    "7\uFE0F\u20E3",
    "8\uFE0F\u20E3",
    "9\uFE0F\u20E3"
  ],
  nonMatchStrings: [
    "\uFE0F\u20E3",
    "#\uFE0F",
    "#\u20E3",
    "\uFE0F\u20E3",
    "*\uFE0F",
    "*\u20E3",
    "\uFE0F\u20E3",
    "0\uFE0F",
    "0\u20E3",
    "\uFE0F\u20E3",
    "1\uFE0F",
    "1\u20E3",
    "\uFE0F\u20E3",
    "2\uFE0F",
    "2\u20E3"
  ],
});

reportCompare(0, 0);
