/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.figures.RoundRectangleFigure;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

class RadiusHandle
extends AbstractHandle {
    private static final int OFFSET = 4;

    public RadiusHandle(RoundRectangleFigure roundRectangleFigure) {
        super(roundRectangleFigure);
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.setUndoActivity(this.createUndoActivity(drawingView));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        ((UndoActivity)this.getUndoActivity()).setOldRadius(((RoundRectangleFigure)this.owner()).getArc());
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        RoundRectangleFigure roundRectangleFigure = (RoundRectangleFigure)this.owner();
        Rectangle rectangle = roundRectangleFigure.displayBox();
        Point point = ((UndoActivity)this.getUndoActivity()).getOldRadius();
        int n7 = Geom.range(0, rectangle.width, 2 * (point.x / 2 + n5));
        int n8 = Geom.range(0, rectangle.height, 2 * (point.y / 2 + n6));
        roundRectangleFigure.setArc(n7, n8);
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Point point = ((RoundRectangleFigure)this.owner()).getArc();
        Point point2 = ((UndoActivity)this.getUndoActivity()).getOldRadius();
        if (point.x == point2.x && point.y == point2.y) {
            this.setUndoActivity(null);
        }
    }

    public Point locate() {
        RoundRectangleFigure roundRectangleFigure = (RoundRectangleFigure)this.owner();
        Point point = roundRectangleFigure.getArc();
        Rectangle rectangle = roundRectangleFigure.displayBox();
        return new Point(rectangle.x + point.x / 2 + 4, rectangle.y + point.y / 2 + 4);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Undoable createUndoActivity(DrawingView drawingView) {
        return new UndoActivity(drawingView);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Point myOldRadius;

        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            return this.resetRadius();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            return this.resetRadius();
        }

        protected boolean resetRadius() {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            if (!figureEnumeration.hasNextFigure()) {
                return false;
            }
            RoundRectangleFigure roundRectangleFigure = (RoundRectangleFigure)figureEnumeration.nextFigure();
            Point point = roundRectangleFigure.getArc();
            roundRectangleFigure.setArc(this.getOldRadius().x, this.getOldRadius().y);
            this.setOldRadius(point);
            return true;
        }

        protected void setOldRadius(Point point) {
            this.myOldRadius = point;
        }

        public Point getOldRadius() {
            return this.myOldRadius;
        }
    }
}

