; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128:n8:16:32:64"

define i32 @test1(i32 %A, i1 %b) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    ret i32 [[A:%.*]]
; CHECK:       BB2:
; CHECK-NEXT:    ret i32 [[A]]
;
BB0:
  br i1 %b, label %BB1, label %BB2

BB1:
  ; Combine away one argument PHI nodes
  %B = phi i32 [ %A, %BB0 ]
  ret i32 %B

BB2:
  ret i32 %A
}

define i32 @test2(i32 %A, i1 %b) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       BB2:
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
BB0:
  br i1 %b, label %BB1, label %BB2

BB1:
  br label %BB2

BB2:
  ; Combine away PHI nodes with same values
  %B = phi i32 [ %A, %BB0 ], [ %A, %BB1 ]
  ret i32 %B
}

define i32 @test3(i32 %A, i1 %b) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
BB0:
  br label %Loop

Loop:
  ; PHI has same value always.
  %B = phi i32 [ %A, %BB0 ], [ %B, %Loop ]
  br i1 %b, label %Loop, label %Exit

Exit:
  ret i32 %B
}

define i32 @test4(i1 %b) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    ret i32 7
; CHECK:       Loop:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[L2:%.*]], label [[LOOP:%.*]]
; CHECK:       L2:
; CHECK-NEXT:    br label [[LOOP]]
;
BB0:
  ; Loop is unreachable
  ret i32 7

Loop:           ; preds = %L2, %Loop
  ; PHI has same value always.
  %B = phi i32 [ %B, %L2 ], [ %B, %Loop ]
  br i1 %b, label %L2, label %Loop

L2:             ; preds = %Loop
  br label %Loop
}

define i32 @test5_undef(i32 %A, i1 %cond) {
; CHECK-LABEL: @test5_undef(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
BB0:
  br label %Loop

Loop:           ; preds = %Loop, %BB0
  ; PHI has same value always.
  %B = phi i32 [ %A, %BB0 ], [ undef, %Loop ]
  br i1 %cond, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i32 %B
}

define i32 @test5_poison(i32 %A, i1 %cond) {
; CHECK-LABEL: @test5_poison(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
BB0:
  br label %Loop

Loop:           ; preds = %Loop, %BB0
  ; PHI has same value always.
  %B = phi i32 [ %A, %BB0 ], [ poison, %Loop ]
  br i1 %cond, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i32 %B
}

define i32 @test6(i16 %A, i1 %b) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       BB2:
; CHECK-NEXT:    [[C:%.*]] = zext i16 [[A:%.*]] to i32
; CHECK-NEXT:    ret i32 [[C]]
;
BB0:
  %X = zext i16 %A to i32
  br i1 %b, label %BB1, label %BB2

BB1:
  %Y = zext i16 %A to i32
  br label %BB2

BB2:
  ;; Suck casts into phi
  %c = phi i32 [ %X, %BB0 ], [ %Y, %BB1 ]
  ret i32 %c
}

define i32 @test_dead_cycle(i32 %A, i1 %cond) {
; CHECK-LABEL: @test_dead_cycle(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 0
;
BB0:
  br label %Loop

Loop:           ; preds = %Loop, %BB0
  %B = phi i32 [ %A, %BB0 ], [ %C, %Loop ]
  %C = add i32 %B, 123
  br i1 %cond, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i32 0
}

define i32 @test_dead_UnaryOp_cycle(double %A, i1 %cond) {
; CHECK-LABEL: @test_dead_UnaryOp_cycle(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 0
;
BB0:
  br label %Loop

Loop:           ; preds = %Loop, %BB0
  %B = phi double [ %A, %BB0 ], [ %C, %Loop ]
  %C = fneg double %B
  br i1 %cond, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i32 0
}

define i32 @test_dead_cycle_two_insts(i32 %A, i1 %cond) {
; CHECK-LABEL: @test_dead_cycle_two_insts(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    [[B:%.*]] = phi i32 [ [[A:%.*]], [[BB0:%.*]] ], [ [[D:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[C:%.*]] = add i32 [[B]], 123
; CHECK-NEXT:    [[D]] = lshr i32 [[C]], 1
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 0
;
BB0:
  br label %Loop

Loop:           ; preds = %Loop, %BB0
  %B = phi i32 [ %A, %BB0 ], [ %D, %Loop ]
  %C = add i32 %B, 123
  %D = lshr i32 %C, 1
  br i1 %cond, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i32 0
}

declare i32 @llvm.uadd.sat.i32(i32, i32)

define i32 @test_dead_cycle_intrin(i32 %A, i1 %cond) {
; CHECK-LABEL: @test_dead_cycle_intrin(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    [[B:%.*]] = phi i32 [ [[A:%.*]], [[BB0:%.*]] ], [ [[C:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[C]] = call i32 @llvm.uadd.sat.i32(i32 [[B]], i32 123)
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 0
;
BB0:
  br label %Loop

Loop:           ; preds = %Loop, %BB0
  %B = phi i32 [ %A, %BB0 ], [ %C, %Loop ]
  %C = call i32 @llvm.uadd.sat.i32(i32 %B, i32 123)
  br i1 %cond, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i32 0
}

define ptr @test8(ptr %A, i1 %b) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       BB2:
; CHECK-NEXT:    [[C:%.*]] = getelementptr i8, ptr [[A:%.*]], i64 4
; CHECK-NEXT:    ret ptr [[C]]
;
BB0:
  %X = getelementptr inbounds { i32, i32 }, ptr %A, i32 0, i32 1
  br i1 %b, label %BB1, label %BB2

BB1:
  %Y = getelementptr { i32, i32 }, ptr %A, i32 0, i32 1
  br label %BB2

BB2:
  ;; Suck GEPs into phi
  %c = phi ptr [ %X, %BB0 ], [ %Y, %BB1 ]
  ret ptr %c
}

define i32 @test9(ptr %A, ptr %B) {
; CHECK-LABEL: @test9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[A:%.*]], null
; CHECK-NEXT:    br i1 [[C]], label [[BB1:%.*]], label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    br label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[E_IN:%.*]] = phi ptr [ [[B:%.*]], [[BB]] ], [ [[A]], [[BB1]] ]
; CHECK-NEXT:    [[E:%.*]] = load i32, ptr [[E_IN]], align 1
; CHECK-NEXT:    ret i32 [[E]]
;
entry:
  %c = icmp eq ptr %A, null
  br i1 %c, label %bb1, label %bb

bb:
  %C = load i32, ptr %B, align 1
  br label %bb2

bb1:
  %D = load i32, ptr %A, align 1
  br label %bb2

bb2:
  %E = phi i32 [ %C, %bb ], [ %D, %bb1 ]
  ret i32 %E

}

define i32 @test10(ptr %A, ptr %B) {
; CHECK-LABEL: @test10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[A:%.*]], null
; CHECK-NEXT:    br i1 [[C]], label [[BB1:%.*]], label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    br label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[E_IN:%.*]] = phi ptr [ [[B:%.*]], [[BB]] ], [ [[A]], [[BB1]] ]
; CHECK-NEXT:    [[E:%.*]] = load i32, ptr [[E_IN]], align 16
; CHECK-NEXT:    ret i32 [[E]]
;
entry:
  %c = icmp eq ptr %A, null
  br i1 %c, label %bb1, label %bb

bb:
  %C = load i32, ptr %B, align 16
  br label %bb2

bb1:
  %D = load i32, ptr %A, align 32
  br label %bb2

bb2:
  %E = phi i32 [ %C, %bb ], [ %D, %bb1 ]
  ret i32 %E
}


; PR1777
declare i1 @test11a()

define i1 @test11() {
; CHECK-LABEL: @test11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = call i1 @test11a()
; CHECK-NEXT:    br i1 [[B]], label [[ONE:%.*]], label [[TWO:%.*]]
; CHECK:       one:
; CHECK-NEXT:    [[C:%.*]] = call i1 @test11a()
; CHECK-NEXT:    br i1 [[C]], label [[TWO]], label [[END:%.*]]
; CHECK:       two:
; CHECK-NEXT:    [[D:%.*]] = call i1 @test11a()
; CHECK-NEXT:    br i1 [[D]], label [[ONE]], label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[Z:%.*]] = call i1 @test11a()
; CHECK-NEXT:    ret i1 [[Z]]
;
entry:
  %a = alloca i32
  %i = ptrtoint ptr %a to i64
  %b = call i1 @test11a()
  br i1 %b, label %one, label %two

one:
  %x = phi i64 [%i, %entry], [%y, %two]
  %c = call i1 @test11a()
  br i1 %c, label %two, label %end

two:
  %y = phi i64 [%i, %entry], [%x, %one]
  %d = call i1 @test11a()
  br i1 %d, label %one, label %end

end:
  %f = phi i64 [ %x, %one], [%y, %two]
  ; Change the %f to %i, and the optimizer suddenly becomes a lot smarter
  ; even though %f must equal %i at this point
  %g = inttoptr i64 %f to ptr
  store i32 10, ptr %g
  %z = call i1 @test11a()
  ret i1 %z
}


define i64 @test12(i1 %cond, ptr %Ptr, i64 %Val) {
; CHECK-LABEL: @test12(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[END:%.*]], label [[TWO:%.*]]
; CHECK:       two:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[T869_0_OFF64:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[VAL:%.*]], [[TWO]] ]
; CHECK-NEXT:    [[T41:%.*]] = ptrtoint ptr [[PTR:%.*]] to i64
; CHECK-NEXT:    [[T2:%.*]] = add i64 [[T869_0_OFF64]], [[T41]]
; CHECK-NEXT:    ret i64 [[T2]]
;
entry:
  %t41 = ptrtoint ptr %Ptr to i64
  %t42 = zext i64 %t41 to i128
  br i1 %cond, label %end, label %two

two:
  %t36 = zext i64 %Val to i128            ; <i128> [#uses=1]
  %t37 = shl i128 %t36, 64                    ; <i128> [#uses=1]
  %ins39 = or i128 %t42, %t37                 ; <i128> [#uses=1]
  br label %end

end:
  %t869.0 = phi i128 [ %t42, %entry ], [ %ins39, %two ]
  %t32 = trunc i128 %t869.0 to i64            ; <i64> [#uses=1]
  %t29 = lshr i128 %t869.0, 64                ; <i128> [#uses=1]
  %t30 = trunc i128 %t29 to i64               ; <i64> [#uses=1]

  %t2 = add i64 %t32, %t30
  ret i64 %t2
}

declare void @test13f(double, i32)

define void @test13(i1 %cond, i32 %V1, double %Vald) {
; CHECK-LABEL: @test13(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[END:%.*]], label [[TWO:%.*]]
; CHECK:       two:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[T31:%.*]] = phi double [ 0.000000e+00, [[ENTRY:%.*]] ], [ [[VALD:%.*]], [[TWO]] ]
; CHECK-NEXT:    call void @test13f(double [[T31]], i32 [[V1:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  %t42 = zext i32 %V1 to i128
  br i1 %cond, label %end, label %two

two:
  %Val = bitcast double %Vald to i64
  %t36 = zext i64 %Val to i128            ; <i128> [#uses=1]
  %t37 = shl i128 %t36, 64                    ; <i128> [#uses=1]
  %ins39 = or i128 %t42, %t37                 ; <i128> [#uses=1]
  br label %end

end:
  %t869.0 = phi i128 [ %t42, %entry ], [ %ins39, %two ]
  %t32 = trunc i128 %t869.0 to i32
  %t29 = lshr i128 %t869.0, 64                ; <i128> [#uses=1]
  %t30 = trunc i128 %t29 to i64               ; <i64> [#uses=1]
  %t31 = bitcast i64 %t30 to double

  call void @test13f(double %t31, i32 %t32)
  ret void
}

define i640 @test14a(i320 %A, i320 %B, i1 %b1) {
; CHECK-LABEL: @test14a(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    [[C_IN:%.*]] = phi i320 [ [[A:%.*]], [[BB0:%.*]] ], [ [[B:%.*]], [[LOOP]] ]
; CHECK-NEXT:    br i1 [[B1:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    [[C:%.*]] = zext i320 [[C_IN]] to i640
; CHECK-NEXT:    ret i640 [[C]]
;
BB0:
  %a = zext i320 %A to i640
  %b = zext i320 %B to i640
  br label %Loop

Loop:
  %C = phi i640 [ %a, %BB0 ], [ %b, %Loop ]
  br i1 %b1, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i640 %C
}

define i160 @test14b(i320 %pA, i320 %pB, i1 %b1) {
; CHECK-LABEL: @test14b(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    [[A:%.*]] = trunc i320 [[PA:%.*]] to i160
; CHECK-NEXT:    [[B:%.*]] = trunc i320 [[PB:%.*]] to i160
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    [[C:%.*]] = phi i160 [ [[A]], [[BB0:%.*]] ], [ [[B]], [[LOOP]] ]
; CHECK-NEXT:    br i1 [[B1:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i160 [[C]]
;
BB0:
  %a = trunc i320 %pA to i160
  %b = trunc i320 %pB to i160
  br label %Loop

Loop:
  %C = phi i160 [ %a, %BB0 ], [ %b, %Loop ]
  br i1 %b1, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i160 %C
}

declare i64 @test15a(i64)

define i64 @test15b(i64 %A, i1 %b) {
; CHECK-LABEL: @test15b(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[ONE:%.*]], label [[TWO:%.*]]
; CHECK:       one:
; CHECK-NEXT:    [[X_OFF64:%.*]] = phi i64 [ [[A:%.*]], [[ENTRY:%.*]] ], [ [[Y_OFF64:%.*]], [[TWO]] ]
; CHECK-NEXT:    [[C:%.*]] = call i64 @test15a(i64 [[X_OFF64]])
; CHECK-NEXT:    br label [[TWO]]
; CHECK:       two:
; CHECK-NEXT:    [[Y_OFF0:%.*]] = phi i64 [ [[A]], [[ENTRY]] ], [ [[C]], [[ONE]] ]
; CHECK-NEXT:    [[Y_OFF64]] = phi i64 [ [[A]], [[ENTRY]] ], [ 0, [[ONE]] ]
; CHECK-NEXT:    [[D:%.*]] = call i64 @test15a(i64 [[Y_OFF64]])
; CHECK-NEXT:    [[D1:%.*]] = trunc i64 [[D]] to i1
; CHECK-NEXT:    br i1 [[D1]], label [[ONE]], label [[END:%.*]]
; CHECK:       end:
; CHECK-NEXT:    ret i64 [[Y_OFF0]]
;
entry:
  %i0 = zext i64 %A to i128
  %i1 = shl i128 %i0, 64
  %i = or i128 %i1, %i0
  br i1 %b, label %one, label %two

one:
  %x = phi i128 [%i, %entry], [%y, %two]
  %x1 = lshr i128 %x, 64
  %x2 = trunc i128 %x1 to i64
  %c = call i64 @test15a(i64 %x2)
  %c1 = zext i64 %c to i128
  br label %two


two:
  %y = phi i128 [%i, %entry], [%c1, %one]
  %y1 = lshr i128 %y, 64
  %y2 = trunc i128 %y1 to i64
  %d = call i64 @test15a(i64 %y2)
  %d1 = trunc i64 %d to i1
  br i1 %d1, label %one, label %end


end:
  %g = trunc i128 %y to i64
  ret i64 %g
}

; PR6512 - Shouldn't merge loads from different addr spaces.
define i32 @test16(ptr addrspace(1) %pointer1, i32 %flag, ptr %pointer2)
; CHECK-LABEL: @test16(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[POINTER1_ADDR:%.*]] = alloca ptr addrspace(1), align 4
; CHECK-NEXT:    [[POINTER2_ADDR:%.*]] = alloca ptr, align 4
; CHECK-NEXT:    store ptr addrspace(1) [[POINTER1:%.*]], ptr [[POINTER1_ADDR]], align 8
; CHECK-NEXT:    store ptr [[POINTER2:%.*]], ptr [[POINTER2_ADDR]], align 8
; CHECK-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[FLAG:%.*]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_NOT]], label [[IF_ELSE:%.*]], label [[IF_THEN:%.*]]
; CHECK:       return:
; CHECK-NEXT:    [[T7:%.*]] = load i32, ptr [[RETVAL]], align 4
; CHECK-NEXT:    ret i32 [[T7]]
; CHECK:       if.end:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi i32 [ [[T5:%.*]], [[IF_ELSE]] ], [ [[T2:%.*]], [[IF_THEN]] ]
; CHECK-NEXT:    store i32 [[STOREMERGE]], ptr [[RETVAL]], align 4
; CHECK-NEXT:    br label [[RETURN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[T1:%.*]] = load ptr addrspace(1), ptr [[POINTER1_ADDR]], align 8
; CHECK-NEXT:    [[T2]] = load i32, ptr addrspace(1) [[T1]], align 4
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    [[T3:%.*]] = load ptr, ptr [[POINTER2_ADDR]], align 8
; CHECK-NEXT:    [[T5]] = load i32, ptr [[T3]], align 4
; CHECK-NEXT:    br label [[IF_END]]
;
nounwind {
entry:
  %retval = alloca i32, align 4                   ; <ptr> [#uses=2]
  %pointer1.addr = alloca ptr addrspace(1), align 4 ; <ptr>
  %flag.addr = alloca i32, align 4                ; <ptr> [#uses=2]
  %pointer2.addr = alloca ptr, align 4           ; <ptr> [#uses=2]
  %res = alloca i32, align 4                      ; <ptr> [#uses=4]
  store ptr addrspace(1) %pointer1, ptr %pointer1.addr
  store i32 %flag, ptr %flag.addr
  store ptr %pointer2, ptr %pointer2.addr
  store i32 10, ptr %res
  %t = load i32, ptr %flag.addr                     ; <i32> [#uses=1]
  %tobool = icmp ne i32 %t, 0                   ; <i1> [#uses=1]
  br i1 %tobool, label %if.then, label %if.else

return:                                           ; preds = %if.end
  %t7 = load i32, ptr %retval                       ; <i32> [#uses=1]
  ret i32 %t7

if.end:                                           ; preds = %if.else, %if.then
  %t6 = load i32, ptr %res                          ; <i32> [#uses=1]
  store i32 %t6, ptr %retval
  br label %return

if.then:                                          ; preds = %entry
  %t1 = load ptr addrspace(1), ptr %pointer1.addr  ; <ptr addrspace(1)>
  %arrayidx = getelementptr i32, ptr addrspace(1) %t1, i32 0 ; <ptr addrspace(1)> [#uses=1]
  %t2 = load i32, ptr addrspace(1) %arrayidx        ; <i32> [#uses=1]
  store i32 %t2, ptr %res
  br label %if.end

if.else:                                          ; preds = %entry
  %t3 = load ptr, ptr %pointer2.addr               ; <ptr> [#uses=1]
  %arrayidx4 = getelementptr i32, ptr %t3, i32 0    ; <ptr> [#uses=1]
  %t5 = load i32, ptr %arrayidx4                    ; <i32> [#uses=1]
  store i32 %t5, ptr %res
  br label %if.end
}

; PR4413
declare i32 @ext()
define i32 @test17(i1 %a) {
; CHECK-LABEL: @test17(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[A:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[TMP0:%.*]] = tail call i32 @ext()
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ [[TMP0]], [[BB1]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  br i1 %a, label %bb1, label %bb2

bb1:        ; preds = %entry
  %0 = tail call i32 @ext()        ; <i32> [#uses=1]
  br label %bb2

bb2:        ; preds = %bb1, %entry
  %cond = phi i1 [ true, %bb1 ], [ false, %entry ]        ; <i1> [#uses=1]
  %val = phi i32 [ %0, %bb1 ], [ 0, %entry ]        ; <i32> [#uses=1]
  %res = select i1 %cond, i32 %val, i32 0        ; <i32> [#uses=1]
  ret i32 %res
}

; Atomic and non-atomic loads should not be combined.
define i32 @PR51435(ptr %ptr, ptr %atomic_ptr, i1 %c) {
; CHECK-LABEL: @PR51435(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[Y:%.*]] = load atomic i32, ptr [[ATOMIC_PTR:%.*]] acquire, align 4
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[X]], [[ENTRY:%.*]] ], [ [[Y]], [[IF]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %x = load i32, ptr %ptr, align 4
  br i1 %c, label %if, label %end

if:
  %y = load atomic i32, ptr %atomic_ptr acquire, align 4
  br label %end

end:
  %cond = phi i32 [ %x, %entry ], [ %y, %if ]
  ret i32 %cond
}

define i1 @test18(i1 %cond) {
; CHECK-LABEL: @test18(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    br label [[RET:%.*]]
; CHECK:       false:
; CHECK-NEXT:    br label [[RET]]
; CHECK:       ret:
; CHECK-NEXT:    ret i1 false
;
  %zero = alloca i32
  %one = alloca i32
  br i1 %cond, label %true, label %false
true:
  br label %ret
false:
  br label %ret
ret:
  %ptr = phi ptr [ %zero, %true ] , [ %one, %false ]
  %isnull = icmp eq ptr %ptr, null
  ret i1 %isnull
}

define i1 @test19(i1 %cond, double %x) {
; CHECK-LABEL: @test19(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    br label [[RET:%.*]]
; CHECK:       false:
; CHECK-NEXT:    br label [[RET]]
; CHECK:       ret:
; CHECK-NEXT:    ret i1 true
;
  br i1 %cond, label %true, label %false
true:
  br label %ret
false:
  br label %ret
ret:
  %p = phi double [ %x, %true ], [ 0x7FF0000000000000, %false ]; RHS = +infty
  %cmp = fcmp ule double %x, %p
  ret i1 %cmp
}

define i1 @test20(i1 %cond) {
; CHECK-LABEL: @test20(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    br label [[RET:%.*]]
; CHECK:       false:
; CHECK-NEXT:    br label [[RET]]
; CHECK:       ret:
; CHECK-NEXT:    ret i1 false
;
  %a = alloca i32
  %b = alloca i32
  %c = alloca i32
  br i1 %cond, label %true, label %false
true:
  br label %ret
false:
  br label %ret
ret:
  %p = phi ptr [ %a, %true ], [ %b, %false ]
  %r = icmp eq ptr %p, %c
  ret i1 %r
}

define i1 @test21(i1 %c1, i1 %c2) {
; CHECK-LABEL: @test21(
; CHECK-NEXT:    br i1 [[C1:%.*]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       false:
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       loop:
; CHECK-NEXT:    br i1 [[C2:%.*]], label [[RET:%.*]], label [[LOOP]]
; CHECK:       ret:
; CHECK-NEXT:    ret i1 false
;
  %a = alloca i32
  %b = alloca i32
  %c = alloca i32
  br i1 %c1, label %true, label %false
true:
  br label %loop
false:
  br label %loop
loop:
  %p = phi ptr [ %a, %true ], [ %b, %false ], [ %p, %loop ]
  %r = icmp eq ptr %p, %c
  br i1 %c2, label %ret, label %loop
ret:
  ret i1 %r
}

define void @test22() {
; CHECK-LABEL: @test22(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[Y:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[Y]] = add i32 [[PHI]], 1
; CHECK-NEXT:    [[O:%.*]] = or i32 [[Y]], [[PHI]]
; CHECK-NEXT:    [[E:%.*]] = icmp eq i32 [[O]], [[Y]]
; CHECK-NEXT:    br i1 [[E]], label [[LOOP]], label [[RET:%.*]]
; CHECK:       ret:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %phi = phi i32 [ 0, %entry ], [ %y, %loop ]
  %y = add i32 %phi, 1
  %o = or i32 %y, %phi
  %e = icmp eq i32 %o, %y
  br i1 %e, label %loop, label %ret
ret:
  ret void
}

define i32 @test23(i32 %A, i1 %pb, ptr %P) {
; CHECK-LABEL: @test23(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[A:%.*]], 19
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    [[B:%.*]] = phi i32 [ [[TMP0]], [[BB0:%.*]] ], [ 61, [[LOOP]] ]
; CHECK-NEXT:    store i32 [[B]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    br i1 [[PB:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 [[B]]
;
BB0:
  br label %Loop

Loop:           ; preds = %Loop, %BB0
  ; PHI has same value always.
  %B = phi i32 [ %A, %BB0 ], [ 42, %Loop ]
  %D = add i32 %B, 19
  store i32 %D, ptr %P
  br i1 %pb, label %Loop, label %Exit

Exit:           ; preds = %Loop
  %E = add i32 %B, 19
  ret i32 %E
}

define i32 @test24(i32 %A, i1 %cond) {
; CHECK-LABEL: @test24(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       BB2:
; CHECK-NEXT:    [[C:%.*]] = add nuw i32 [[A:%.*]], 1
; CHECK-NEXT:    ret i32 [[C]]
;
BB0:
  %X = add nuw nsw i32 %A, 1
  br i1 %cond, label %BB1, label %BB2

BB1:
  %Y = add nuw i32 %A, 1
  br label %BB2

BB2:
  %C = phi i32 [ %X, %BB0 ], [ %Y, %BB1 ]
  ret i32 %C
}

; Same as test11, but used to be missed due to a bug.
declare i1 @test25a()

define i1 @test25() {
; CHECK-LABEL: @test25(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = call i1 @test25a()
; CHECK-NEXT:    br i1 [[B]], label [[ONE:%.*]], label [[TWO:%.*]]
; CHECK:       one:
; CHECK-NEXT:    [[C:%.*]] = call i1 @test25a()
; CHECK-NEXT:    br i1 [[C]], label [[TWO]], label [[END:%.*]]
; CHECK:       two:
; CHECK-NEXT:    [[D:%.*]] = call i1 @test25a()
; CHECK-NEXT:    br i1 [[D]], label [[ONE]], label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[Z:%.*]] = call i1 @test25a()
; CHECK-NEXT:    ret i1 [[Z]]
;
entry:
  %a = alloca i32
  %i = ptrtoint ptr %a to i64
  %b = call i1 @test25a()
  br i1 %b, label %one, label %two

one:
  %x = phi i64 [%y, %two], [%i, %entry]
  %c = call i1 @test25a()
  br i1 %c, label %two, label %end

two:
  %y = phi i64 [%x, %one], [%i, %entry]
  %d = call i1 @test25a()
  br i1 %d, label %one, label %end

end:
  %f = phi i64 [ %x, %one], [%y, %two]
  ; Change the %f to %i, and the optimizer suddenly becomes a lot smarter
  ; even though %f must equal %i at this point
  %g = inttoptr i64 %f to ptr
  store i32 10, ptr %g
  %z = call i1 @test25a()
  ret i1 %z
}

; Same as above, but the input is also a phi
define i1 @test25b(i1 %ci, i64 %ai, i64 %bi) {
; CHECK-LABEL: @test25b(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[CI:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    br label [[ELSE]]
; CHECK:       else:
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[AI:%.*]], [[ENTRY:%.*]] ], [ [[BI:%.*]], [[THEN]] ]
; CHECK-NEXT:    [[B:%.*]] = call i1 @test25a()
; CHECK-NEXT:    br i1 [[B]], label [[ONE:%.*]], label [[TWO:%.*]]
; CHECK:       one:
; CHECK-NEXT:    [[C:%.*]] = call i1 @test25a()
; CHECK-NEXT:    br i1 [[C]], label [[TWO]], label [[END:%.*]]
; CHECK:       two:
; CHECK-NEXT:    [[D:%.*]] = call i1 @test25a()
; CHECK-NEXT:    br i1 [[D]], label [[ONE]], label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[G:%.*]] = inttoptr i64 [[I]] to ptr
; CHECK-NEXT:    store i32 10, ptr [[G]], align 4
; CHECK-NEXT:    [[Z:%.*]] = call i1 @test25a()
; CHECK-NEXT:    ret i1 [[Z]]
;
entry:
  br i1 %ci, label %then, label %else

then:
  br label %else

else:
  %i = phi i64 [ %ai, %entry ], [ %bi, %then ]
  %b = call i1 @test25a()
  br i1 %b, label %one, label %two

one:
  %x = phi i64 [%y, %two], [%i, %else]
  %c = call i1 @test25a()
  br i1 %c, label %two, label %end

two:
  %y = phi i64 [%x, %one], [%i, %else]
  %d = call i1 @test25a()
  br i1 %d, label %one, label %end

end:
  %f = phi i64 [ %x, %one], [%y, %two]
  ; Change the %f to %i, and the optimizer suddenly becomes a lot smarter
  ; even though %f must equal %i at this point
  %g = inttoptr i64 %f to ptr
  store i32 10, ptr %g
  %z = call i1 @test25a()
  ret i1 %z
}

declare i1 @test26a()

define i1 @test26(i32 %n) {
; CHECK-LABEL: @test26(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = call i1 @test26a()
; CHECK-NEXT:    br label [[ONE:%.*]]
; CHECK:       one:
; CHECK-NEXT:    [[C:%.*]] = call i1 @test26a()
; CHECK-NEXT:    switch i32 [[N:%.*]], label [[END:%.*]] [
; CHECK-NEXT:      i32 2, label [[TWO:%.*]]
; CHECK-NEXT:      i32 3, label [[THREE:%.*]]
; CHECK-NEXT:    ]
; CHECK:       two:
; CHECK-NEXT:    [[D:%.*]] = call i1 @test26a()
; CHECK-NEXT:    switch i32 [[N]], label [[END]] [
; CHECK-NEXT:      i32 10, label [[ONE]]
; CHECK-NEXT:      i32 30, label [[THREE]]
; CHECK-NEXT:    ]
; CHECK:       three:
; CHECK-NEXT:    [[E:%.*]] = call i1 @test26a()
; CHECK-NEXT:    br i1 [[E]], label [[ONE]], label [[TWO]]
; CHECK:       end:
; CHECK-NEXT:    [[Z:%.*]] = call i1 @test26a()
; CHECK-NEXT:    ret i1 [[Z]]
;
entry:
  %a = alloca i32
  %i = ptrtoint ptr %a to i64
  %b = call i1 @test26a()
  br label %one

one:
  %x = phi i64 [%y, %two], [%w, %three], [%i, %entry]
  %c = call i1 @test26a()
  switch i32 %n, label %end [
  i32 2, label %two
  i32 3, label %three
  ]

two:
  %y = phi i64 [%x, %one], [%w, %three]
  %d = call i1 @test26a()
  switch i32 %n, label %end [
  i32 10, label %one
  i32 30, label %three
  ]

three:
  %w = phi i64 [%y, %two], [%x, %one]
  %e = call i1 @test26a()
  br i1 %e, label %one, label %two

end:
  %f = phi i64 [ %x, %one], [%y, %two]
  ; Change the %f to %i, and the optimizer suddenly becomes a lot smarter
  ; even though %f must equal %i at this point
  %g = inttoptr i64 %f to ptr
  store i32 10, ptr %g
  %z = call i1 @test26a()
  ret i1 %z
}

define i32 @test27(i1 %b) {
; CHECK-LABEL: @test27(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[DONE:%.*]]
; CHECK:       done:
; CHECK-NEXT:    ret i32 undef
;
entry:
  br label %done
done:
  %y = phi i32 [ undef, %entry ]
  ret i32 %y
}

; We should be able to fold the zexts to the other side of the phi
; even though there's a constant value input to the phi. This is
; because we can shrink that constant to the smaller phi type.

define i1 @PR24766(i8 %x1, i8 %x2, i8 %condition) {
; CHECK-LABEL: @PR24766(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i8 [[CONDITION:%.*]], label [[EPILOG:%.*]] [
; CHECK-NEXT:      i8 0, label [[SW1:%.*]]
; CHECK-NEXT:      i8 1, label [[SW2:%.*]]
; CHECK-NEXT:    ]
; CHECK:       sw1:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[X1:%.*]], [[X2:%.*]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       sw2:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sle i8 [[X1]], [[X2]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       epilog:
; CHECK-NEXT:    [[CONDITIONMET_SHRUNK:%.*]] = phi i1 [ false, [[ENTRY:%.*]] ], [ [[CMP2]], [[SW2]] ], [ [[CMP1]], [[SW1]] ]
; CHECK-NEXT:    ret i1 [[CONDITIONMET_SHRUNK]]
;
entry:
  %conv = sext i8 %condition to i32
  switch i32 %conv, label %epilog [
  i32 0, label %sw1
  i32 1, label %sw2
  ]

sw1:
  %cmp1 = icmp eq i8 %x1, %x2
  %frombool1 = zext i1 %cmp1 to i8
  br label %epilog

sw2:
  %cmp2 = icmp sle i8 %x1, %x2
  %frombool2 = zext i1 %cmp2 to i8
  br label %epilog

epilog:
  %conditionMet = phi i8 [ 0, %entry ], [ %frombool2, %sw2 ], [ %frombool1, %sw1 ]
  %tobool = icmp ne i8 %conditionMet, 0
  ret i1 %tobool

}

; Same as above (a phi with more than 2 operands), but no constants

define i1 @PR24766_no_constants(i8 %x1, i8 %x2, i8 %condition, i1 %another_condition) {
; CHECK-LABEL: @PR24766_no_constants(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i8 [[CONDITION:%.*]], label [[EPILOG:%.*]] [
; CHECK-NEXT:      i8 0, label [[SW1:%.*]]
; CHECK-NEXT:      i8 1, label [[SW2:%.*]]
; CHECK-NEXT:    ]
; CHECK:       sw1:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[X1:%.*]], [[X2:%.*]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       sw2:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sle i8 [[X1]], [[X2]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       epilog:
; CHECK-NEXT:    [[CONDITIONMET_IN:%.*]] = phi i1 [ [[ANOTHER_CONDITION:%.*]], [[ENTRY:%.*]] ], [ [[CMP2]], [[SW2]] ], [ [[CMP1]], [[SW1]] ]
; CHECK-NEXT:    ret i1 [[CONDITIONMET_IN]]
;
entry:
  %frombool0 = zext i1 %another_condition to i8
  %conv = sext i8 %condition to i32
  switch i32 %conv, label %epilog [
  i32 0, label %sw1
  i32 1, label %sw2
  ]

sw1:
  %cmp1 = icmp eq i8 %x1, %x2
  %frombool1 = zext i1 %cmp1 to i8
  br label %epilog

sw2:
  %cmp2 = icmp sle i8 %x1, %x2
  %frombool2 = zext i1 %cmp2 to i8
  br label %epilog

epilog:
  %conditionMet = phi i8 [ %frombool0, %entry ], [ %frombool2, %sw2 ], [ %frombool1, %sw1 ]
  %tobool = icmp ne i8 %conditionMet, 0
  ret i1 %tobool

}

; Same as above (a phi with more than 2 operands), but two constants

define i1 @PR24766_two_constants(i8 %x1, i8 %x2, i8 %condition) {
; CHECK-LABEL: @PR24766_two_constants(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i8 [[CONDITION:%.*]], label [[EPILOG:%.*]] [
; CHECK-NEXT:      i8 0, label [[SW1:%.*]]
; CHECK-NEXT:      i8 1, label [[SW2:%.*]]
; CHECK-NEXT:    ]
; CHECK:       sw1:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[X1:%.*]], [[X2:%.*]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       sw2:
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       epilog:
; CHECK-NEXT:    [[CONDITIONMET:%.*]] = phi i1 [ false, [[ENTRY:%.*]] ], [ true, [[SW2]] ], [ [[CMP1]], [[SW1]] ]
; CHECK-NEXT:    ret i1 [[CONDITIONMET]]
;
entry:
  %conv = sext i8 %condition to i32
  switch i32 %conv, label %epilog [
  i32 0, label %sw1
  i32 1, label %sw2
  ]

sw1:
  %cmp1 = icmp eq i8 %x1, %x2
  %frombool1 = zext i1 %cmp1 to i8
  br label %epilog

sw2:
  %cmp2 = icmp sle i8 %x1, %x2
  %frombool2 = zext i1 %cmp2 to i8
  br label %epilog

epilog:
  %conditionMet = phi i8 [ 0, %entry ], [ 1, %sw2 ], [ %frombool1, %sw1 ]
  %tobool = icmp ne i8 %conditionMet, 0
  ret i1 %tobool

}

; Same as above (a phi with more than 2 operands), but two constants and two variables

define i1 @PR24766_two_constants_two_var(i8 %x1, i8 %x2, i8 %condition) {
; CHECK-LABEL: @PR24766_two_constants_two_var(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i8 [[CONDITION:%.*]], label [[EPILOG:%.*]] [
; CHECK-NEXT:      i8 0, label [[SW1:%.*]]
; CHECK-NEXT:      i8 1, label [[SW2:%.*]]
; CHECK-NEXT:      i8 2, label [[SW3:%.*]]
; CHECK-NEXT:    ]
; CHECK:       sw1:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[X1:%.*]], [[X2:%.*]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       sw2:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sle i8 [[X1]], [[X2]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       sw3:
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       epilog:
; CHECK-NEXT:    [[CONDITIONMET_SHRUNK:%.*]] = phi i1 [ false, [[ENTRY:%.*]] ], [ [[CMP2]], [[SW2]] ], [ [[CMP1]], [[SW1]] ], [ true, [[SW3]] ]
; CHECK-NEXT:    ret i1 [[CONDITIONMET_SHRUNK]]
;
entry:
  %conv = sext i8 %condition to i32
  switch i32 %conv, label %epilog [
  i32 0, label %sw1
  i32 1, label %sw2
  i32 2, label %sw3
  ]

sw1:
  %cmp1 = icmp eq i8 %x1, %x2
  %frombool1 = zext i1 %cmp1 to i8
  br label %epilog

sw2:
  %cmp2 = icmp sle i8 %x1, %x2
  %frombool2 = zext i1 %cmp2 to i8
  br label %epilog

sw3:
  %cmp3 = icmp sge i8 %x1, %x2
  %frombool3 = zext i1 %cmp3 to i8
  br label %epilog

epilog:
  %conditionMet = phi i8 [ 0, %entry ], [ %frombool2, %sw2 ], [ %frombool1, %sw1 ], [ 1, %sw3 ]
  %tobool = icmp ne i8 %conditionMet, 0
  ret i1 %tobool

}

define i1 @phi_allnonzeroconstant(i1 %c, i32 %a, i32 %b) {
; CHECK-LABEL: @phi_allnonzeroconstant(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret i1 false
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  br label %if.end

if.else:                                          ; preds = %entry
  call void @dummy()

  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  %x.0 = phi i32 [ 1, %if.then ], [ 2, %if.else ]
  %or = or i32 %x.0, %a
  %cmp1 = icmp eq i32 %or, 0
  ret i1 %cmp1
}

define i1 @phi_allnonzerononconstant(i1 %c, i32 %a, ptr nonnull %b1, ptr nonnull %b2) {
; CHECK-LABEL: @phi_allnonzerononconstant(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret i1 false
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  br label %if.end

if.else:                                          ; preds = %entry
  call void @dummy()

  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  %x.0 = phi ptr [ %b1, %if.then ], [ %b2, %if.else ]
  %cmp1 = icmp eq ptr %x.0, null
  ret i1 %cmp1
}

declare void @dummy()

define i1 @phi_knownnonzero_eq(i32 %n, i32 %s, ptr nocapture readonly %P) {
; CHECK-LABEL: @phi_knownnonzero_eq(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[A_0:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[A_0]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:                                          ; preds = %entry
  %0 = load i32, ptr %P
  %cmp = icmp eq i32 %n, %0
  %1 = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  %a.0 = phi i32 [ %1,  %if.then ], [ %n, %entry ]
  %cmp1 = icmp eq i32 %a.0, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_ne(i32 %n, i32 %s, ptr nocapture readonly %P) {
; CHECK-LABEL: @phi_knownnonzero_ne(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[A_0:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[A_0]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:                                          ; preds = %entry
  %0 = load i32, ptr %P
  %cmp = icmp eq i32 %n, %0
  %1 = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  %a.0 = phi i32 [ %1,  %if.then ], [ %n, %entry ]
  %cmp1 = icmp ne i32 %a.0, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_eq_2(i32 %n, i32 %s, ptr nocapture readonly %P) {
; CHECK-LABEL: @phi_knownnonzero_eq_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br i1 true, label [[IF_ELSE:%.*]], label [[IF_END]]
; CHECK:       if.else:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[A_0:%.*]] = phi i32 [ 1, [[IF_ELSE]] ], [ [[N]], [[ENTRY:%.*]] ], [ poison, [[IF_THEN]] ]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[A_0]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.then, label %if.end

if.then:
  %tobool2 = icmp slt  i32 %n, %s
  br i1 %tobool2, label %if.else, label %if.end

if.else:                                          ; preds = %entry
  %0 = load i32, ptr %P
  %cmp = icmp eq i32 %n, %0
  %1 = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  %a.0 = phi i32 [ %1,  %if.else], [ %n, %entry ], [2, %if.then]
  %cmp1 = icmp eq i32 %a.0, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_ne_2(i32 %n, i32 %s, ptr nocapture readonly %P) {
; CHECK-LABEL: @phi_knownnonzero_ne_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br i1 true, label [[IF_ELSE:%.*]], label [[IF_END]]
; CHECK:       if.else:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[A_0:%.*]] = phi i32 [ 1, [[IF_ELSE]] ], [ [[N]], [[ENTRY:%.*]] ], [ poison, [[IF_THEN]] ]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[A_0]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.then, label %if.end

if.then:
  %tobool2 = icmp slt  i32 %n, %s
  br i1 %tobool2, label %if.else, label %if.end

if.else:                                          ; preds = %entry
  %0 = load i32, ptr %P
  %cmp = icmp eq i32 %n, %0
  %1 = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  %a.0 = phi i32 [ %1,  %if.else], [ %n, %entry ], [2, %if.then]
  %cmp1 = icmp ne i32 %a.0, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_eq_oricmp(i32 %n, i32 %s, ptr %P, i32 %val) {
; CHECK-LABEL: @phi_knownnonzero_eq_oricmp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ORPHI:%.*]] = or i32 [[PHI]], [[VAL:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[ORPHI]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:
  %load = load i32, ptr %P
  %cmp = icmp eq i32 %n, %load
  %sel = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:
  %phi = phi i32 [ %sel,  %if.then ], [ %n, %entry ]
  %orphi = or i32 %phi, %val
  %cmp1 = icmp eq i32 %orphi, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_eq_oricmp_commuted(i32 %n, i32 %s, ptr %P, i32 %val) {
; CHECK-LABEL: @phi_knownnonzero_eq_oricmp_commuted(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ORPHI:%.*]] = or i32 [[PHI]], [[VAL:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[ORPHI]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:
  %load = load i32, ptr %P
  %cmp = icmp eq i32 %n, %load
  %sel = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:
  %phi = phi i32 [ %sel,  %if.then ], [ %n, %entry ]
  %orphi = or i32 %val, %phi
  %cmp1 = icmp eq i32 %orphi, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_eq_or_disjoint_icmp(i32 %n, i32 %s, ptr %P, i32 %val) {
; CHECK-LABEL: @phi_knownnonzero_eq_or_disjoint_icmp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ORPHI:%.*]] = or i32 [[PHI]], [[VAL:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[ORPHI]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:
  %load = load i32, ptr %P
  %cmp = icmp eq i32 %n, %load
  %sel = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:
  %phi = phi i32 [ %sel,  %if.then ], [ %n, %entry ]
  %orphi = or disjoint i32 %phi, %val
  %cmp1 = icmp eq i32 %orphi, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_ne_oricmp(i32 %n, i32 %s, ptr %P, i32 %val) {
; CHECK-LABEL: @phi_knownnonzero_ne_oricmp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ORPHI:%.*]] = or i32 [[PHI]], [[VAL:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[ORPHI]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:
  %load = load i32, ptr %P
  %cmp = icmp eq i32 %n, %load
  %sel = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:
  %phi = phi i32 [ %sel,  %if.then ], [ %n, %entry ]
  %orphi = or i32 %phi, %val
  %cmp1 = icmp ne i32 %orphi, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_ne_oricmp_commuted(i32 %n, i32 %s, ptr %P, i32 %val) {
; CHECK-LABEL: @phi_knownnonzero_ne_oricmp_commuted(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ORPHI:%.*]] = or i32 [[PHI]], [[VAL:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[ORPHI]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:
  %load = load i32, ptr %P
  %cmp = icmp eq i32 %n, %load
  %sel = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:
  %phi = phi i32 [ %sel,  %if.then ], [ %n, %entry ]
  %orphi = or i32 %val, %phi
  %cmp1 = icmp ne i32 %orphi, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_eq_multiuse_oricmp(i32 %n, i32 %s, ptr %P, i32 %val) {
; CHECK-LABEL: @phi_knownnonzero_eq_multiuse_oricmp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ORPHI:%.*]] = or i32 [[PHI]], [[VAL:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[ORPHI]], 0
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[CLEANUP:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[BOOL2:%.*]] = icmp eq i32 [[PHI]], 0
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[FINAL:%.*]] = phi i1 [ [[CMP1]], [[IF_END]] ], [ [[BOOL2]], [[NEXT]] ]
; CHECK-NEXT:    ret i1 [[FINAL]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:
  %load = load i32, ptr %P
  %cmp = icmp eq i32 %n, %load
  %sel = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:
  %phi = phi i32 [ %sel,  %if.then ], [ %n, %entry ]
  %orphi = or i32 %phi, %val
  %cmp1 = icmp eq i32 %orphi, 0
  br i1 %cmp1, label %next, label %cleanup

next:
  %bool2 = icmp eq i32 %phi, 0
  br label %cleanup

cleanup:
  %final =  phi i1 [ %cmp1,  %if.end ], [ %bool2, %next ]
  ret i1  %final
}

define i1 @phi_knownnonzero_ne_multiuse_oricmp_commuted(i32 %n, i32 %s, ptr %P, i32 %val) {
; CHECK-LABEL: @phi_knownnonzero_ne_multiuse_oricmp_commuted(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ORPHI:%.*]] = or i32 [[PHI]], [[VAL:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[ORPHI]], 0
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[CLEANUP:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[BOOL2:%.*]] = icmp ne i32 [[PHI]], 0
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[FINAL:%.*]] = phi i1 [ [[CMP1]], [[IF_END]] ], [ [[BOOL2]], [[NEXT]] ]
; CHECK-NEXT:    ret i1 [[FINAL]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:
  %load = load i32, ptr %P
  %cmp = icmp eq i32 %n, %load
  %sel = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:
  %phi = phi i32 [ %sel,  %if.then ], [ %n, %entry ]
  %orphi = or i32 %val, %phi
  %cmp1 = icmp ne i32 %orphi, 0
  br i1 %cmp1, label %next, label %cleanup

next:
  %bool2 = icmp ne i32 %phi, 0
  br label %cleanup

cleanup:
  %final =  phi i1 [ %cmp1,  %if.end ], [ %bool2, %next ]
  ret i1  %final
}

define i1 @phi_knownnonzero_eq_multiuse_andicmp(i32 %n, i32 %s, ptr %P, i32 %val) {
; CHECK-LABEL: @phi_knownnonzero_eq_multiuse_andicmp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[LOAD]], [[N]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i32 1, i32 2
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ [[SEL]], [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ANDPHI:%.*]] = and i32 [[PHI]], [[VAL:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[ANDPHI]], 0
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[CLEANUP:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[BOOL2:%.*]] = icmp eq i32 [[PHI]], 0
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[FINAL:%.*]] = phi i1 [ [[CMP1]], [[IF_END]] ], [ [[BOOL2]], [[NEXT]] ]
; CHECK-NEXT:    ret i1 [[FINAL]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:
  %load = load i32, ptr %P
  %cmp = icmp eq i32 %n, %load
  %sel = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:
  %phi = phi i32 [ %sel,  %if.then ], [ %n, %entry ]
  %andphi = and i32 %phi, %val
  %cmp1 = icmp eq i32 %andphi, 0
  br i1 %cmp1, label %next, label %cleanup

next:
  %bool2 = icmp eq i32 %phi, 0
  br label %cleanup

cleanup:
  %final =  phi i1 [ %cmp1,  %if.end ], [ %bool2, %next ]
  ret i1  %final
}

define i1 @phi_knownnonzero_ne_multiuse_andicmp(i32 %n, i32 %s, ptr %P, i32 %val) {
; CHECK-LABEL: @phi_knownnonzero_ne_multiuse_andicmp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[LOAD]], [[N]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i32 1, i32 2
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ [[SEL]], [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ANDPHI:%.*]] = and i32 [[PHI]], [[VAL:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[ANDPHI]], 0
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[CLEANUP:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[BOOL2:%.*]] = icmp ne i32 [[PHI]], 0
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[FINAL:%.*]] = phi i1 [ [[CMP1]], [[IF_END]] ], [ [[BOOL2]], [[NEXT]] ]
; CHECK-NEXT:    ret i1 [[FINAL]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:
  %load = load i32, ptr %P
  %cmp = icmp eq i32 %n, %load
  %sel = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:
  %phi = phi i32 [ %sel,  %if.then ], [ %n, %entry ]
  %andphi = and i32 %phi, %val
  %cmp1 = icmp ne i32 %andphi, 0
  br i1 %cmp1, label %next, label %cleanup

next:
  %bool2 = icmp ne i32 %phi, 0
  br label %cleanup

cleanup:
  %final =  phi i1 [ %cmp1,  %if.end ], [ %bool2, %next ]
  ret i1  %final
}

; This would crash trying to delete an instruction (conv)
; that still had uses because the user (the phi) was not
; updated to remove a use from an unreachable block (g.exit).

define void @main(i1 %cond, i16 %x) {
; CHECK-LABEL: @main(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[FOR_END:%.*]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    unreachable
; CHECK:       g.exit:
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       for.end:
; CHECK-NEXT:    store double undef, ptr undef, align 8
; CHECK-NEXT:    ret void
;
entry:
  br label %for.cond

for.cond:
  %p = phi double [ %conv, %g.exit ], [ undef, %entry ]
  br i1 %cond, label %for.end, label %for.body

for.body:
  %conv = sitofp i16 %x to double
  unreachable

g.exit:
  br label %for.cond

for.end:
  store double %p, ptr undef
  ret void
}

define i1 @pr57488_icmp_of_phi(ptr %ptr.base, i64 %len) {
; CHECK-LABEL: @pr57488_icmp_of_phi(
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[END:%.*]] = getelementptr inbounds i64, ptr [[PTR_BASE:%.*]], i64 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_ZERO:%.*]] = icmp eq i64 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_ZERO]], label [[EXIT:%.*]], label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[ACCUM:%.*]] = phi i1 [ [[AND:%.*]], [[LOOP]] ], [ true, [[START:%.*]] ]
; CHECK-NEXT:    [[PTR:%.*]] = phi ptr [ [[PTR_NEXT:%.*]], [[LOOP]] ], [ [[PTR_BASE]], [[START]] ]
; CHECK-NEXT:    [[PTR_NEXT]] = getelementptr inbounds i8, ptr [[PTR]], i64 8
; CHECK-NEXT:    [[VAL:%.*]] = load i64, ptr [[PTR]], align 8
; CHECK-NEXT:    [[VAL_ZERO:%.*]] = icmp eq i64 [[VAL]], 0
; CHECK-NEXT:    [[AND]] = and i1 [[ACCUM]], [[VAL_ZERO]]
; CHECK-NEXT:    [[EXIT_COND:%.*]] = icmp eq ptr [[PTR_NEXT]], [[END]]
; CHECK-NEXT:    br i1 [[EXIT_COND]], label [[EXIT]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ true, [[START]] ], [ [[AND]], [[LOOP]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
start:
  %end = getelementptr inbounds i64, ptr %ptr.base, i64 %len
  %len.zero = icmp eq i64 %len, 0
  br i1 %len.zero, label %exit, label %loop

loop:
  %accum = phi i8 [ %accum.next, %loop ], [ 1, %start ]
  %ptr = phi ptr [ %ptr.next, %loop ], [ %ptr.base, %start ]
  %ptr.next = getelementptr inbounds i64, ptr %ptr, i64 1
  %accum.bool = icmp ne i8 %accum, 0
  %val = load i64, ptr %ptr, align 8
  %val.zero = icmp eq i64 %val, 0
  %and = and i1 %accum.bool, %val.zero
  %accum.next = zext i1 %and to i8
  %exit.cond = icmp eq ptr %ptr.next, %end
  br i1 %exit.cond, label %exit, label %loop

exit:
  %res = phi i1 [ true, %start ], [ %and, %loop ]
  ret i1 %res
}

declare void @use(i32)
declare i1 @get.i1()

define i32 @phi_op_self_simplify() {
; CHECK-LABEL: @phi_op_self_simplify(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 1, [[ENTRY:%.*]] ], [ [[IV_ADD2:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_ADD:%.*]] = xor i32 [[IV]], -1
; CHECK-NEXT:    call void @use(i32 [[IV_ADD]])
; CHECK-NEXT:    [[IV_ADD2]] = xor i32 [[IV]], -1
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 1, %entry ], [ %iv.add2, %loop ]
  %iv.add = xor i32 %iv, -1
  call void @use(i32 %iv.add)
  %iv.add2 = xor i32 %iv, -1
  br label %loop
}

define i32 @phi_op_self_simplify_2(i32 %x) {
; CHECK-LABEL: @phi_op_self_simplify_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = or i32 [[X:%.*]], 1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[PHI]], [[LOOP]] ], [ 11, [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C1:%.*]] = call i1 @get.i1()
; CHECK-NEXT:    br i1 [[C1]], label [[LOOP_LATCH]], label [[LOOP]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[C2:%.*]] = call i1 @get.i1()
; CHECK-NEXT:    br i1 [[C2]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[PHI]]
;
entry:
  br label %loop

loop:
  %phi = phi i32 [ %x, %entry ], [ %or, %loop ], [ 10, %loop.latch ]
  %or = or i32 %phi, 1
  %c1 = call i1 @get.i1()
  br i1 %c1, label %loop.latch, label %loop

loop.latch:
  %c2 = call i1 @get.i1()
  br i1 %c2, label %exit, label %loop

exit:
  ret i32 %or
}

; Caused an infinite loop with D134954.
define i64 @inttoptr_of_phi(i1 %c, ptr %arg.ptr, ptr %arg.ptr2) {
; CHECK-LABEL: @inttoptr_of_phi(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[ARG_PTR2_VAL:%.*]] = load i64, ptr [[ARG_PTR2:%.*]], align 8
; CHECK-NEXT:    [[ARG_PTR2_VAL_PTR:%.*]] = inttoptr i64 [[ARG_PTR2_VAL]] to ptr
; CHECK-NEXT:    br label [[JOIN:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[INT_PTR_PTR:%.*]] = phi ptr [ [[ARG_PTR2_VAL_PTR]], [[IF]] ], [ [[ARG_PTR:%.*]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = load i64, ptr [[INT_PTR_PTR]], align 8
; CHECK-NEXT:    ret i64 [[V]]
;
entry:
  br i1 %c, label %if, label %else

if:
  %arg.ptr2.val = load i64, ptr %arg.ptr2, align 8
  br label %join

else:
  %arg.int.ptr = ptrtoint ptr %arg.ptr to i64
  br label %join

join:
  %int.ptr = phi i64 [ %arg.ptr2.val, %if ], [ %arg.int.ptr, %else ]
  %ptr = inttoptr i64 %int.ptr to ptr
  %v = load i64, ptr %ptr, align 8
  ret i64 %v
}

define void @simplify_context_instr(ptr %ptr.base, i64 %n) {
; CHECK-LABEL: @simplify_context_instr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR_END:%.*]] = getelementptr inbounds i8, ptr [[PTR_BASE:%.*]], i64 [[N:%.*]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[PTR:%.*]] = phi ptr [ [[PTR_NEXT:%.*]], [[LATCH:%.*]] ], [ [[PTR_BASE]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[PHI:%.*]] = phi i1 [ [[CMP:%.*]], [[LATCH]] ], [ true, [[ENTRY]] ]
; CHECK-NEXT:    [[V:%.*]] = load i8, ptr [[PTR]], align 1
; CHECK-NEXT:    [[CMP]] = icmp eq i8 [[V]], 95
; CHECK-NEXT:    br i1 [[CMP]], label [[LATCH]], label [[IF:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[PHI]], i32 117, i32 100
; CHECK-NEXT:    call void @use(i32 [[SEL]])
; CHECK-NEXT:    br label [[LATCH]]
; CHECK:       latch:
; CHECK-NEXT:    [[PTR_NEXT]] = getelementptr inbounds i8, ptr [[PTR]], i64 1
; CHECK-NEXT:    [[CMP_I_NOT:%.*]] = icmp eq ptr [[PTR_NEXT]], [[PTR_END]]
; CHECK-NEXT:    br i1 [[CMP_I_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %ptr.end = getelementptr inbounds i8, ptr %ptr.base, i64 %n
  br label %loop

loop:
  %ptr = phi ptr [ %ptr.next, %latch ], [ %ptr.base, %entry ]
  %phi = phi i1 [ %cmp, %latch ], [ true, %entry ]
  %v = load i8, ptr %ptr, align 1
  %cmp = icmp eq i8 %v, 95
  br i1 %cmp, label %latch, label %if

if:
  %sel = select i1 %phi, i32 117, i32 100
  call void @use(i32 %sel)
  br label %latch

latch:
  %ptr.next = getelementptr inbounds i8, ptr %ptr, i64 1
  %cmp.i.not = icmp eq ptr %ptr.next, %ptr.end
  br i1 %cmp.i.not, label %exit, label %loop

exit:
  ret void
}

define i32 @add_two_phi_node_can_fold(i1 %c, i32 %i, i32 %j)  {
; CHECK-LABEL: @add_two_phi_node_can_fold(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[ADD:%.*]] = phi i32 [ [[I:%.*]], [[IF_THEN]] ], [ [[J:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  br i1 %c, label %if.then, label %if.end

if.then:
  br label %if.end

if.end:
  %x = phi i32 [ 0, %if.then ], [ %j, %entry ]
  %y = phi i32 [ %i, %if.then ], [ 0, %entry ]
  %add = add i32 %y, %x
  ret i32 %add
}

define i32 @add_two_phi_node_cannt_fold(i1 %c, i32 %i, i32 %j)  {
; CHECK-LABEL: @add_two_phi_node_cannt_fold(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[X:%.*]] = phi i32 [ 0, [[IF_THEN]] ], [ [[J:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[Y:%.*]] = phi i32 [ [[I:%.*]], [[IF_THEN]] ], [ 1, [[ENTRY]] ]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[Y]], [[X]]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  br i1 %c, label %if.then, label %if.end

if.then:
  br label %if.end

if.end:
  %x = phi i32 [ 0, %if.then ], [ %j, %entry ]
  %y = phi i32 [ %i, %if.then ], [ 1, %entry ]
  %add = add i32 %y, %x
  ret i32 %add
}

define i32 @or_two_phi_node_can_fold(i1 %c, i32 %i, i32 %j)  {
; CHECK-LABEL: @or_two_phi_node_can_fold(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[ADD:%.*]] = phi i32 [ [[I:%.*]], [[IF_THEN]] ], [ [[J:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  br i1 %c, label %if.then, label %if.end

if.then:
  br label %if.end

if.end:
  %x = phi i32 [ 0, %if.then ], [ %j, %entry ]
  %y = phi i32 [ %i, %if.then ], [ 0, %entry ]
  %add = or i32 %y, %x
  ret i32 %add
}

define i32 @and_two_phi_node_can_fold(i1 %c, i32 %i, i32 %j)  {
; CHECK-LABEL: @and_two_phi_node_can_fold(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[ADD:%.*]] = phi i32 [ [[I:%.*]], [[IF_THEN]] ], [ [[J:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  br i1 %c, label %if.then, label %if.end

if.then:
  br label %if.end

if.end:
  %x = phi i32 [ -1, %if.then ], [ %j, %entry ]
  %y = phi i32 [ %i, %if.then ], [ -1, %entry ]
  %add = and i32 %y, %x
  ret i32 %add
}

define i32 @mul_two_phi_node_can_fold(i1 %c, i32 %i, i32 %j)  {
; CHECK-LABEL: @mul_two_phi_node_can_fold(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[ADD:%.*]] = phi i32 [ [[I:%.*]], [[IF_THEN]] ], [ [[J:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  br i1 %c, label %if.then, label %if.end

if.then:
  br label %if.end

if.end:
  %x = phi i32 [ 1, %if.then ], [ %j, %entry ]
  %y = phi i32 [ %i, %if.then ], [ 1, %entry ]
  %add = mul i32 %y, %x
  ret i32 %add
}

define i32 @xor_two_phi_node_can_fold(i1 %c, i32 %i, i32 %j)  {
; CHECK-LABEL: @xor_two_phi_node_can_fold(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[ADD:%.*]] = phi i32 [ [[I:%.*]], [[IF_THEN]] ], [ [[J:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  br i1 %c, label %if.then, label %if.end

if.then:
  br label %if.end

if.end:
  %x = phi i32 [ 0, %if.then ], [ %j, %entry ]
  %y = phi i32 [ %i, %if.then ], [ 0, %entry ]
  %add = xor i32 %y, %x
  ret i32 %add
}

define i32 @sub_two_phi_node_cant_fold(i1 %c, i32 %i, i32 %j)  {
; CHECK-LABEL: @sub_two_phi_node_cant_fold(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[X:%.*]] = phi i32 [ 0, [[IF_THEN]] ], [ [[J:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[Y:%.*]] = phi i32 [ [[I:%.*]], [[IF_THEN]] ], [ 0, [[ENTRY]] ]
; CHECK-NEXT:    [[ADD:%.*]] = sub i32 [[Y]], [[X]]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  br i1 %c, label %if.then, label %if.end

if.then:
  br label %if.end

if.end:
  %x = phi i32 [ 0, %if.then ], [ %j, %entry ]
  %y = phi i32 [ %i, %if.then ], [ 0, %entry ]
  %add = sub i32 %y, %x
  ret i32 %add
}

define i1 @cmp_eq_phi_node_can_fold_1(ptr %C) {
; CHECK-LABEL: @cmp_eq_phi_node_can_fold_1(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[SUB_IS_ZERO:%.*]], label [[JOIN:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i8 [[TMP4]], 0
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ false, [[TMP0:%.*]] ], [ [[TMP5]], [[SUB_IS_ZERO]] ]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %sub_is_zero, label %join

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  br label %join

join:
  %8 = phi i32 [ %3, %0 ], [ %7, %sub_is_zero ]
  %cmp = icmp eq i32 %8, 0
  ret i1 %cmp
}

define i1 @cmp_eq_phi_node_can_fold_2(ptr %C) {
; CHECK-LABEL: @cmp_eq_phi_node_can_fold_2(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[SUB_IS_ZERO:%.*]], label [[JOIN:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i8 [[TMP4]], 49
; CHECK-NEXT:    br i1 [[TMP5]], label [[SUB_IS_ZERO1:%.*]], label [[JOIN]]
; CHECK:       sub_is_zero1:
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 2
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP6]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp eq i8 [[TMP7]], 0
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ false, [[TMP0:%.*]] ], [ false, [[SUB_IS_ZERO]] ], [ [[TMP8]], [[SUB_IS_ZERO1]] ]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %sub_is_zero, label %join

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  %8 = sub nsw i32 %7, 49
  %9 = icmp eq i32 %8, 0
  br i1 %9, label %sub_is_zero1, label %join

sub_is_zero1:
  %10 = getelementptr inbounds i8, ptr %C, i64 2
  %11 = load i8, ptr %10, align 1
  %12 = zext i8 %11 to i32
  br label %join

join:
  %13 = phi i32 [ %3, %0 ], [ %8, %sub_is_zero ], [ %12, %sub_is_zero1 ]
  %cmp = icmp eq i32 %13, 0
  ret i1 %cmp
}

define i1 @cmp_eq_phi_node_can_fold_3(ptr %C) {
; CHECK-LABEL: @cmp_eq_phi_node_can_fold_3(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[JOIN:%.*]], label [[SUB_IS_ZERO:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i8 [[TMP4]], 0
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ true, [[TMP0:%.*]] ], [ [[TMP5]], [[SUB_IS_ZERO]] ]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %join, label %sub_is_zero

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  br label %join

join:
  %8 = phi i32 [ %3, %0 ], [ %7, %sub_is_zero ]
  %cmp = icmp eq i32 %8, 0
  ret i1 %cmp
}


define i1 @cmp_eq_phi_node_can_fold_4(ptr %C) {
; CHECK-LABEL: @cmp_eq_phi_node_can_fold_4(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[JOIN:%.*]], label [[SUB_IS_ZERO:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i8 [[TMP4]], 49
; CHECK-NEXT:    br i1 [[TMP5]], label [[JOIN]], label [[SUB_IS_ZERO1:%.*]]
; CHECK:       sub_is_zero1:
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 2
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP6]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp eq i8 [[TMP7]], 0
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ true, [[TMP0:%.*]] ], [ true, [[SUB_IS_ZERO]] ], [ [[TMP8]], [[SUB_IS_ZERO1]] ]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %join, label %sub_is_zero

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  %8 = sub nsw i32 %7, 49
  %9 = icmp eq i32 %8, 0
  br i1 %9, label %join, label %sub_is_zero1

sub_is_zero1:
  %10 = getelementptr inbounds i8, ptr %C, i64 2
  %11 = load i8, ptr %10, align 1
  %12 = zext i8 %11 to i32
  br label %join

join:
  %13 = phi i32 [ %3, %0 ], [ %8, %sub_is_zero ], [ %12, %sub_is_zero1 ]
  %cmp = icmp eq i32 %13, 0
  ret i1 %cmp
}

define i1 @cmp_ne_phi_node_can_fold_1(ptr %C) {
; CHECK-LABEL: @cmp_ne_phi_node_can_fold_1(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[SUB_IS_ZERO:%.*]], label [[JOIN:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ true, [[TMP0:%.*]] ], [ [[TMP5]], [[SUB_IS_ZERO]] ]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %sub_is_zero, label %join

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  br label %join

join:
  %8 = phi i32 [ %3, %0 ], [ %7, %sub_is_zero ]
  %cmp = icmp ne i32 %8, 0
  ret i1 %cmp
}

define i1 @cmp_ne_phi_node_can_fold_2(ptr %C) {
; CHECK-LABEL: @cmp_ne_phi_node_can_fold_2(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[SUB_IS_ZERO:%.*]], label [[JOIN:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i8 [[TMP4]], 49
; CHECK-NEXT:    br i1 [[TMP5]], label [[SUB_IS_ZERO1:%.*]], label [[JOIN]]
; CHECK:       sub_is_zero1:
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 2
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP6]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i8 [[TMP7]], 0
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ true, [[TMP0:%.*]] ], [ true, [[SUB_IS_ZERO]] ], [ [[TMP8]], [[SUB_IS_ZERO1]] ]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %sub_is_zero, label %join

sub_is_zero:                        ; preds = %0
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  %8 = sub nsw i32 %7, 49
  %9 = icmp eq i32 %8, 0
  br i1 %9, label %sub_is_zero1, label %join

sub_is_zero1:
  %10 = getelementptr inbounds i8, ptr %C, i64 2
  %11 = load i8, ptr %10, align 1
  %12 = zext i8 %11 to i32
  br label %join

join:
  %13 = phi i32 [ %3, %0 ], [ %8, %sub_is_zero ], [ %12, %sub_is_zero1 ]
  %cmp = icmp ne i32 %13, 0
  ret i1 %cmp
}

define i1 @cmp_ne_phi_node_can_fold_3(ptr %C) {
; CHECK-LABEL: @cmp_ne_phi_node_can_fold_3(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[JOIN:%.*]], label [[SUB_IS_ZERO:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ false, [[TMP0:%.*]] ], [ [[TMP5]], [[SUB_IS_ZERO]] ]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %join, label %sub_is_zero

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  br label %join

join:
  %8 = phi i32 [ %3, %0 ], [ %7, %sub_is_zero ]
  %cmp = icmp ne i32 %8, 0
  ret i1 %cmp
}

define i1 @cmp_ne_phi_node_can_fold_4(ptr %C) {
; CHECK-LABEL: @cmp_ne_phi_node_can_fold_4(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[JOIN:%.*]], label [[SUB_IS_ZERO:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i8 [[TMP4]], 49
; CHECK-NEXT:    br i1 [[TMP5]], label [[JOIN]], label [[SUB_IS_ZERO1:%.*]]
; CHECK:       sub_is_zero1:
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 2
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP6]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i8 [[TMP7]], 0
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ false, [[TMP0:%.*]] ], [ false, [[SUB_IS_ZERO]] ], [ [[TMP8]], [[SUB_IS_ZERO1]] ]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %join, label %sub_is_zero

sub_is_zero:                        ; preds = %0
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  %8 = sub nsw i32 %7, 49
  %9 = icmp eq i32 %8, 0
  br i1 %9, label %join, label %sub_is_zero1

sub_is_zero1:
  %10 = getelementptr inbounds i8, ptr %C, i64 2
  %11 = load i8, ptr %10, align 1
  %12 = zext i8 %11 to i32
  br label %join

join:
  %13 = phi i32 [ %3, %0 ], [ %8, %sub_is_zero ], [ %12, %sub_is_zero1 ]
  %cmp = icmp ne i32 %13, 0
  ret i1 %cmp
}

define i1 @cmp_sgt_phi_node_can_fold_1(ptr %C) {
; CHECK-LABEL: @cmp_sgt_phi_node_can_fold_1(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[JOIN:%.*]], label [[SUB_IS_ZERO:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ false, [[TMP0:%.*]] ], [ [[TMP5]], [[SUB_IS_ZERO]] ]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %join, label %sub_is_zero

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  br label %join

join:
  %8 = phi i32 [ %3, %0 ], [ %7, %sub_is_zero ]
  %cmp = icmp sgt i32 %8, 0
  ret i1 %cmp
}

define i1 @cmp_sgt_phi_node_can_fold_2(ptr %C) {
; CHECK-LABEL: @cmp_sgt_phi_node_can_fold_2(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[JOIN:%.*]], label [[SUB_IS_ZERO:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i8 [[TMP4]], 49
; CHECK-NEXT:    br i1 [[TMP5]], label [[JOIN]], label [[SUB_IS_ZERO1:%.*]]
; CHECK:       sub_is_zero1:
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 2
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP6]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i8 [[TMP7]], 0
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ false, [[TMP0:%.*]] ], [ false, [[SUB_IS_ZERO]] ], [ [[TMP8]], [[SUB_IS_ZERO1]] ]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %join, label %sub_is_zero

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  %8 = sub nsw i32 %7, 49
  %9 = icmp eq i32 %8, 0
  br i1 %9, label %join, label %sub_is_zero1

sub_is_zero1:
  %10 = getelementptr inbounds i8, ptr %C, i64 2
  %11 = load i8, ptr %10, align 1
  %12 = zext i8 %11 to i32
  br label %join

join:
  %13 = phi i32 [ %3, %0 ], [ %8, %sub_is_zero ], [ %12, %sub_is_zero1 ]
  %cmp = icmp sgt i32 %13, 0
  ret i1 %cmp
}

define i1 @cmp_sgt_phi_node_cant_fold_1(ptr %C) {
; CHECK-LABEL: @cmp_sgt_phi_node_cant_fold_1(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = zext i8 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], -48
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i32 [[TMP3]], 0
; CHECK-NEXT:    br i1 [[TMP4]], label [[SUB_IS_ZERO:%.*]], label [[JOIN:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = zext i8 [[TMP6]] to i32
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[TMP8:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[TMP7]], [[SUB_IS_ZERO]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %sub_is_zero, label %join

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  br label %join

join:
  %8 = phi i32 [ %3, %0 ], [ %7, %sub_is_zero ]
  %cmp = icmp sgt i32 %8, 0
  ret i1 %cmp
}

define i1 @cmp_sgt_phi_node_cant_fold_2(ptr %C) {
; CHECK-LABEL: @cmp_sgt_phi_node_cant_fold_2(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = zext i8 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], -48
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i32 [[TMP3]], 0
; CHECK-NEXT:    br i1 [[TMP4]], label [[SUB_IS_ZERO:%.*]], label [[JOIN:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = zext i8 [[TMP6]] to i32
; CHECK-NEXT:    [[TMP8:%.*]] = add nsw i32 [[TMP7]], -49
; CHECK-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], 0
; CHECK-NEXT:    br i1 [[TMP9]], label [[SUB_IS_ZERO1:%.*]], label [[JOIN]]
; CHECK:       sub_is_zero1:
; CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 2
; CHECK-NEXT:    [[TMP11:%.*]] = load i8, ptr [[TMP10]], align 1
; CHECK-NEXT:    [[TMP12:%.*]] = zext i8 [[TMP11]] to i32
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[TMP13:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[TMP8]], [[SUB_IS_ZERO]] ], [ [[TMP12]], [[SUB_IS_ZERO1]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP13]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %sub_is_zero, label %join

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  %8 = sub nsw i32 %7, 49
  %9 = icmp eq i32 %8, 0
  br i1 %9, label %sub_is_zero1, label %join

sub_is_zero1:
  %10 = getelementptr inbounds i8, ptr %C, i64 2
  %11 = load i8, ptr %10, align 1
  %12 = zext i8 %11 to i32
  br label %join

join:
  %13 = phi i32 [ %3, %0 ], [ %8, %sub_is_zero ], [ %12, %sub_is_zero1 ]
  %cmp = icmp sgt i32 %13, 0
  ret i1 %cmp
}

define i1 @cmp_slt_phi_node_can_fold_1(ptr %C) {
; CHECK-LABEL: @cmp_slt_phi_node_can_fold_1(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[JOIN:%.*]], label [[SUB_IS_ZERO:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    ret i1 false
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %join, label %sub_is_zero

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  br label %join

join:
  %8 = phi i32 [ %3, %0 ], [ %7, %sub_is_zero ]
  %cmp = icmp slt i32 %8, 0
  ret i1 %cmp
}

define i1 @cmp_slt_phi_node_can_fold_2(ptr %C) {
; CHECK-LABEL: @cmp_slt_phi_node_can_fold_2(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 48
; CHECK-NEXT:    br i1 [[TMP2]], label [[JOIN:%.*]], label [[SUB_IS_ZERO:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i8 [[TMP4]], 49
; CHECK-NEXT:    br i1 [[TMP5]], label [[JOIN]], label [[SUB_IS_ZERO1:%.*]]
; CHECK:       sub_is_zero1:
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    ret i1 false
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %join, label %sub_is_zero

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  %8 = sub nsw i32 %7, 49
  %9 = icmp eq i32 %8, 0
  br i1 %9, label %join, label %sub_is_zero1

sub_is_zero1:
  %10 = getelementptr inbounds i8, ptr %C, i64 2
  %11 = load i8, ptr %10, align 1
  %12 = zext i8 %11 to i32
  br label %join

join:
  %13 = phi i32 [ %3, %0 ], [ %8, %sub_is_zero ], [ %12, %sub_is_zero1 ]
  %cmp = icmp slt i32 %13, 0
  ret i1 %cmp
}

define i1 @cmp_slt_phi_node_cant_fold_1(ptr %C) {
; CHECK-LABEL: @cmp_slt_phi_node_cant_fold_1(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = zext i8 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], -48
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i32 [[TMP3]], 0
; CHECK-NEXT:    br i1 [[TMP4]], label [[SUB_IS_ZERO:%.*]], label [[JOIN:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = zext i8 [[TMP6]] to i32
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[TMP8:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[TMP7]], [[SUB_IS_ZERO]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP8]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %sub_is_zero, label %join

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  br label %join

join:
  %8 = phi i32 [ %3, %0 ], [ %7, %sub_is_zero ]
  %cmp = icmp slt i32 %8, 0
  ret i1 %cmp
}

define i1 @cmp_slt_phi_node_cant_fold_2(ptr %C) {
; CHECK-LABEL: @cmp_slt_phi_node_cant_fold_2(
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = zext i8 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], -48
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i32 [[TMP3]], 0
; CHECK-NEXT:    br i1 [[TMP4]], label [[SUB_IS_ZERO:%.*]], label [[JOIN:%.*]]
; CHECK:       sub_is_zero:
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 1
; CHECK-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = zext i8 [[TMP6]] to i32
; CHECK-NEXT:    [[TMP8:%.*]] = add nsw i32 [[TMP7]], -49
; CHECK-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], 0
; CHECK-NEXT:    br i1 [[TMP9]], label [[SUB_IS_ZERO1:%.*]], label [[JOIN]]
; CHECK:       sub_is_zero1:
; CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i8, ptr [[C]], i64 2
; CHECK-NEXT:    [[TMP11:%.*]] = load i8, ptr [[TMP10]], align 1
; CHECK-NEXT:    [[TMP12:%.*]] = zext i8 [[TMP11]] to i32
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[TMP13:%.*]] = phi i32 [ [[TMP3]], [[TMP0:%.*]] ], [ [[TMP8]], [[SUB_IS_ZERO]] ], [ [[TMP12]], [[SUB_IS_ZERO1]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP13]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %1 = load i8, ptr %C, align 1
  %2 = zext i8 %1 to i32
  %3 = sub nsw i32 %2, 48
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %sub_is_zero, label %join

sub_is_zero:
  %5 = getelementptr inbounds i8, ptr %C, i64 1
  %6 = load i8, ptr %5, align 1
  %7 = zext i8 %6 to i32
  %8 = sub nsw i32 %7, 49
  %9 = icmp eq i32 %8, 0
  br i1 %9, label %sub_is_zero1, label %join

sub_is_zero1:
  %10 = getelementptr inbounds i8, ptr %C, i64 2
  %11 = load i8, ptr %10, align 1
  %12 = zext i8 %11 to i32
  br label %join

join:
  %13 = phi i32 [ %3, %0 ], [ %8, %sub_is_zero ], [ %12, %sub_is_zero1 ]
  %cmp = icmp slt i32 %13, 0
  ret i1 %cmp
}

define i64 @wrong_gep_arg_into_phi(ptr noundef %ptr) {
; CHECK-LABEL: @wrong_gep_arg_into_phi(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[PTR_PN:%.*]] = phi ptr [ [[PTR:%.*]], [[ENTRY:%.*]] ], [ [[DOTPN:%.*]], [[FOR_COND]] ]
; CHECK-NEXT:    [[DOTPN]] = getelementptr i8, ptr [[PTR_PN]], i64 1
; CHECK-NEXT:    [[VAL:%.*]] = load i8, ptr [[DOTPN]], align 1
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp eq i8 [[VAL]], 0
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[EXIT:%.*]], label [[FOR_COND]]
; CHECK:       exit:
; CHECK-NEXT:    ret i64 0
;
entry:
  %add.ptr = getelementptr i8, ptr %ptr, i64 1
  br label %for.cond

for.cond:                                         ; preds = %for.cond, %entry
  %.pn = phi ptr [ %add.ptr, %entry ], [ %incdec.ptr, %for.cond ]
  %val = load i8, ptr %.pn, align 1
  %cond = icmp ne i8 %val, 0
  %incdec.ptr = getelementptr inbounds nuw i8, ptr %.pn, i64 1
  br i1 %cond, label %for.cond, label %exit

exit:                                             ; preds = %for.cond
  ret i64 0
}
