; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
;
; Test that instcombine folds allocsize function calls properly.
; Dummy arguments are inserted to verify that allocsize is picking the right
; args, and to prove that arbitrary unfoldable values don't interfere with
; allocsize if they're not used by allocsize.

declare ptr @my_malloc(ptr, i32) allocsize(1)
declare ptr @my_calloc(ptr, ptr, i32, i32) allocsize(2, 3)

define void @test_malloc(ptr %p, ptr %r) {
; CHECK-LABEL: define void @test_malloc(
; CHECK-SAME: ptr [[P:%.*]], ptr [[R:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call dereferenceable_or_null(100) ptr @my_malloc(ptr null, i32 100)
; CHECK-NEXT:    store ptr [[TMP1]], ptr [[P]], align 8
; CHECK-NEXT:    store i64 100, ptr [[R]], align 8
; CHECK-NEXT:    ret void
;
  %1 = call ptr @my_malloc(ptr null, i32 100)
  store ptr %1, ptr %p, align 8 ; To ensure objectsize isn't killed

  %2 = call i64 @llvm.objectsize.i64.p0(ptr %1, i1 false)
  store i64 %2, ptr %r, align 8
  ret void
}

define void @test_calloc(ptr %p, ptr %r) {
; CHECK-LABEL: define void @test_calloc(
; CHECK-SAME: ptr [[P:%.*]], ptr [[R:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call dereferenceable_or_null(500) ptr @my_calloc(ptr null, ptr null, i32 100, i32 5)
; CHECK-NEXT:    store ptr [[TMP1]], ptr [[P]], align 8
; CHECK-NEXT:    store i64 500, ptr [[R]], align 8
; CHECK-NEXT:    ret void
;
  %1 = call ptr @my_calloc(ptr null, ptr null, i32 100, i32 5)
  store ptr %1, ptr %p, align 8 ; To ensure objectsize isn't killed

  %2 = call i64 @llvm.objectsize.i64.p0(ptr %1, i1 false)
  store i64 %2, ptr %r, align 8
  ret void
}

; Failure cases with non-constant values...
define void @test_malloc_fails(ptr %p, ptr %r, i32 %n) {
; CHECK-LABEL: define void @test_malloc_fails(
; CHECK-SAME: ptr [[P:%.*]], ptr [[R:%.*]], i32 [[N:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @my_malloc(ptr null, i32 [[N]])
; CHECK-NEXT:    store ptr [[TMP1]], ptr [[P]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = call i64 @llvm.objectsize.i64.p0(ptr [[TMP1]], i1 false, i1 false, i1 false)
; CHECK-NEXT:    store i64 [[TMP2]], ptr [[R]], align 8
; CHECK-NEXT:    ret void
;
  %1 = call ptr @my_malloc(ptr null, i32 %n)
  store ptr %1, ptr %p, align 8 ; To ensure objectsize isn't killed

  %2 = call i64 @llvm.objectsize.i64.p0(ptr %1, i1 false)
  store i64 %2, ptr %r, align 8
  ret void
}

define void @test_calloc_fails(ptr %p, ptr %r, i32 %n) {
; CHECK-LABEL: define void @test_calloc_fails(
; CHECK-SAME: ptr [[P:%.*]], ptr [[R:%.*]], i32 [[N:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @my_calloc(ptr null, ptr null, i32 [[N]], i32 5)
; CHECK-NEXT:    store ptr [[TMP1]], ptr [[P]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = call i64 @llvm.objectsize.i64.p0(ptr [[TMP1]], i1 false, i1 false, i1 false)
; CHECK-NEXT:    store i64 [[TMP2]], ptr [[R]], align 8
; CHECK-NEXT:    [[TMP3:%.*]] = call ptr @my_calloc(ptr null, ptr null, i32 100, i32 [[N]])
; CHECK-NEXT:    store ptr [[TMP3]], ptr [[P]], align 8
; CHECK-NEXT:    [[TMP4:%.*]] = call i64 @llvm.objectsize.i64.p0(ptr [[TMP3]], i1 false, i1 false, i1 false)
; CHECK-NEXT:    store i64 [[TMP4]], ptr [[R]], align 8
; CHECK-NEXT:    ret void
;
  %1 = call ptr @my_calloc(ptr null, ptr null, i32 %n, i32 5)
  store ptr %1, ptr %p, align 8 ; To ensure objectsize isn't killed

  %2 = call i64 @llvm.objectsize.i64.p0(ptr %1, i1 false)
  store i64 %2, ptr %r, align 8


  %3 = call ptr @my_calloc(ptr null, ptr null, i32 100, i32 %n)
  store ptr %3, ptr %p, align 8 ; To ensure objectsize isn't killed

  %4 = call i64 @llvm.objectsize.i64.p0(ptr %3, i1 false)
  store i64 %4, ptr %r, align 8
  ret void
}

declare ptr @my_malloc_outofline(ptr, i32) #0
declare ptr @my_calloc_outofline(ptr, ptr, i32, i32) #1

; Verifying that out of line allocsize is parsed correctly
define void @test_outofline(ptr %p, ptr %r) {
; CHECK-LABEL: define void @test_outofline(
; CHECK-SAME: ptr [[P:%.*]], ptr [[R:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call dereferenceable_or_null(100) ptr @my_malloc_outofline(ptr null, i32 100)
; CHECK-NEXT:    store ptr [[TMP1]], ptr [[P]], align 8
; CHECK-NEXT:    store i64 100, ptr [[R]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = call dereferenceable_or_null(500) ptr @my_calloc_outofline(ptr null, ptr null, i32 100, i32 5)
; CHECK-NEXT:    store ptr [[TMP2]], ptr [[P]], align 8
; CHECK-NEXT:    store i64 500, ptr [[R]], align 8
; CHECK-NEXT:    ret void
;
  %1 = call ptr @my_malloc_outofline(ptr null, i32 100)
  store ptr %1, ptr %p, align 8 ; To ensure objectsize isn't killed

  %2 = call i64 @llvm.objectsize.i64.p0(ptr %1, i1 false)
  store i64 %2, ptr %r, align 8


  %3 = call ptr @my_calloc_outofline(ptr null, ptr null, i32 100, i32 5)
  store ptr %3, ptr %p, align 8 ; To ensure objectsize isn't killed

  %4 = call i64 @llvm.objectsize.i64.p0(ptr %3, i1 false)
  store i64 %4, ptr %r, align 8
  ret void
}

declare ptr @my_malloc_i64(ptr, i64) #0
declare ptr @my_tiny_calloc(ptr, ptr, i8, i8) #1
declare ptr @my_varied_calloc(ptr, ptr, i32, i8) #1

define void @test_overflow(ptr %p, ptr %r) {
  ; (2**31 + 1) * 2 > 2**31. So overflow. Yay.
; CHECK-LABEL: define void @test_overflow(
; CHECK-SAME: ptr [[P:%.*]], ptr [[R:%.*]]) {
; CHECK-NEXT:    [[BIG_MALLOC:%.*]] = call dereferenceable_or_null(4294967298) ptr @my_calloc(ptr null, ptr null, i32 -2147483647, i32 2)
; CHECK-NEXT:    store ptr [[BIG_MALLOC]], ptr [[P]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.objectsize.i32.p0(ptr [[BIG_MALLOC]], i1 false, i1 false, i1 false)
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[R]], align 4
; CHECK-NEXT:    [[BIG_LITTLE_MALLOC:%.*]] = call dereferenceable_or_null(508) ptr @my_tiny_calloc(ptr null, ptr null, i8 127, i8 4)
; CHECK-NEXT:    store ptr [[BIG_LITTLE_MALLOC]], ptr [[P]], align 8
; CHECK-NEXT:    store i32 508, ptr [[R]], align 4
; CHECK-NEXT:    [[BIG_MALLOC_I64:%.*]] = call dereferenceable_or_null(8589934592) ptr @my_malloc_i64(ptr null, i64 8589934592)
; CHECK-NEXT:    store ptr [[BIG_MALLOC_I64]], ptr [[P]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = call i32 @llvm.objectsize.i32.p0(ptr [[BIG_MALLOC_I64]], i1 false, i1 false, i1 false)
; CHECK-NEXT:    store i32 [[TMP2]], ptr [[R]], align 4
; CHECK-NEXT:    store i64 8589934592, ptr [[R]], align 8
; CHECK-NEXT:    [[VARIED_CALLOC:%.*]] = call dereferenceable_or_null(5000) ptr @my_varied_calloc(ptr null, ptr null, i32 1000, i8 5)
; CHECK-NEXT:    store ptr [[VARIED_CALLOC]], ptr [[P]], align 8
; CHECK-NEXT:    store i32 5000, ptr [[R]], align 4
; CHECK-NEXT:    ret void
;
  %big_malloc = call ptr @my_calloc(ptr null, ptr null, i32 2147483649, i32 2)
  store ptr %big_malloc, ptr %p, align 8

  %1 = call i32 @llvm.objectsize.i32.p0(ptr %big_malloc, i1 false)
  store i32 %1, ptr %r, align 4


  %big_little_malloc = call ptr @my_tiny_calloc(ptr null, ptr null, i8 127, i8 4)
  store ptr %big_little_malloc, ptr %p, align 8

  %2 = call i32 @llvm.objectsize.i32.p0(ptr %big_little_malloc, i1 false)
  store i32 %2, ptr %r, align 4


  ; malloc(2**33)
  %big_malloc_i64 = call ptr @my_malloc_i64(ptr null, i64 8589934592)
  store ptr %big_malloc_i64, ptr %p, align 8

  %3 = call i32 @llvm.objectsize.i32.p0(ptr %big_malloc_i64, i1 false)
  store i32 %3, ptr %r, align 4


  %4 = call i64 @llvm.objectsize.i64.p0(ptr %big_malloc_i64, i1 false)
  store i64 %4, ptr %r, align 8


  ; Just intended to ensure that we properly handle args of different types...
  %varied_calloc = call ptr @my_varied_calloc(ptr null, ptr null, i32 1000, i8 5)
  store ptr %varied_calloc, ptr %p, align 8

  %5 = call i32 @llvm.objectsize.i32.p0(ptr %varied_calloc, i1 false)
  store i32 %5, ptr %r, align 4

  ret void
}

; We had a bug where `nobuiltin` would cause `allocsize` to be ignored in
; @llvm.objectsize calculations.
define void @test_nobuiltin(ptr %p, ptr %r) {
; CHECK-LABEL: define void @test_nobuiltin(
; CHECK-SAME: ptr [[P:%.*]], ptr [[R:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call dereferenceable_or_null(100) ptr @my_malloc(ptr null, i32 100) #[[ATTR3:[0-9]+]]
; CHECK-NEXT:    store ptr [[TMP1]], ptr [[P]], align 8
; CHECK-NEXT:    store i64 100, ptr [[R]], align 8
; CHECK-NEXT:    ret void
;
  %1 = call ptr @my_malloc(ptr null, i32 100) nobuiltin
  store ptr %1, ptr %p, align 8

  %2 = call i64 @llvm.objectsize.i64.p0(ptr %1, i1 false)
  store i64 %2, ptr %r, align 8
  ret void
}

attributes #0 = { allocsize(1) }
attributes #1 = { allocsize(2, 3) }

declare i32 @llvm.objectsize.i32.p0(ptr, i1)
declare i64 @llvm.objectsize.i64.p0(ptr, i1)
