; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -relocation-model=pic -post-RA-scheduler=1 -break-anti-dependencies=critical  | FileCheck %s

; PR20308 ( http://llvm.org/bugs/show_bug.cgi?id=20308 ).
; The critical-anti-dependency-breaker must not use register def information from a kill inst.
; This test case expects such an instruction to appear as a comment with def info for RDI.
; There is an anti-dependency (WAR) hazard using RAX using default reg allocation and scheduling.
; The post-RA-scheduler and critical-anti-dependency breaker can eliminate that hazard using R10.
; That is the first free register that isn't used as a param in the call to "@Image".

@PartClass = external global i32
@NullToken = external global i64

define i32 @Part_Create(i64* %Anchor, i32 %TypeNum, i32 %F, i32 %Z, i32* %Status, i64* %PartTkn) {
; CHECK-LABEL: Part_Create:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    .cfi_def_cfa_offset 24
; CHECK-NEXT:    subq $24, %rsp
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset %rbx, -24
; CHECK-NEXT:    .cfi_offset %rbp, -16
; CHECK-NEXT:    movq NullToken@GOTPCREL(%rip), %rax
; CHECK-NEXT:    movq PartClass@GOTPCREL(%rip), %r10
; CHECK-NEXT:    xorl %edx, %edx
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    movq %rdi, %rbx
; CHECK-NEXT:    movq (%rax), %rax
; CHECK-NEXT:    movl (%r10), %ebp
; CHECK-NEXT:    movq %rax, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    leaq {{[0-9]+}}(%rsp), %rax
; CHECK-NEXT:    movl %ebp, %esi
; CHECK-NEXT:    movq %rax, (%rsp)
; CHECK-NEXT:    callq Image@PLT
; CHECK-NEXT:    movq %rbx, %rdi
; CHECK-NEXT:    callq Create@PLT
; CHECK-NEXT:    movl %ebp, %eax
; CHECK-NEXT:    addq $24, %rsp
; CHECK-NEXT:    .cfi_def_cfa_offset 24
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %PartObj = alloca i64*, align 8
  %Vchunk = alloca i64, align 8
  %1 = load i64, i64* @NullToken, align 4
  store i64 %1, i64* %Vchunk, align 8
  %2 = load i32, i32* @PartClass, align 4
  call i32 @Image(i64* %Anchor, i32 %2, i32 0, i32 0, i32* %Status, i64* %PartTkn, i64** %PartObj)
  call i32 @Create(i64* %Anchor)
  ret i32 %2
}

declare i32 @Image(i64*, i32, i32, i32, i32*, i64*, i64**)
declare i32 @Create(i64*)
