; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -O2 \
; RUN:   -ppc-gpr-icmps=all -ppc-asm-full-reg-names -mcpu=pwr8 < %s | FileCheck %s \
; RUN:  --implicit-check-not cmpw --implicit-check-not cmpd --implicit-check-not cmpl \
; RUN:  --check-prefixes=CHECK,BE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -O2 \
; RUN:   -ppc-gpr-icmps=all -ppc-asm-full-reg-names -mcpu=pwr8 < %s | FileCheck %s \
; RUN:  --implicit-check-not cmpw --implicit-check-not cmpd --implicit-check-not cmpl \
; RUN:  --check-prefixes=CHECK,LE

@glob = local_unnamed_addr global i64 0, align 8

; Function Attrs: norecurse nounwind readnone
define signext i32 @test_ileull(i64 %a, i64 %b) {
; CHECK-LABEL: test_ileull:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subfc r4, r3, r4
; CHECK-NEXT:    subfe r3, r3, r3
; CHECK-NEXT:    addi r3, r3, 1
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ule i64 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @test_ileull_sext(i64 %a, i64 %b) {
; CHECK-LABEL: test_ileull_sext:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subfc r4, r3, r4
; CHECK-NEXT:    subfe r3, r3, r3
; CHECK-NEXT:    not r3, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ule i64 %a, %b
  %sub = sext i1 %cmp to i32
  ret i32 %sub
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @test_ileull_z(i64 %a) {
; CHECK-LABEL: test_ileull_z:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cntlzd r3, r3
; CHECK-NEXT:    rldicl r3, r3, 58, 63
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ule i64 %a, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @test_ileull_sext_z(i64 %a) {
; CHECK-LABEL: test_ileull_sext_z:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addic r3, r3, -1
; CHECK-NEXT:    subfe r3, r3, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ule i64 %a, 0
  %sub = sext i1 %cmp to i32
  ret i32 %sub
}

; Function Attrs: norecurse nounwind
define void @test_ileull_store(i64 %a, i64 %b) {
; BE-LABEL: test_ileull_store:
; BE:       # %bb.0: # %entry
; BE-NEXT:    addis r5, r2, .LC0@toc@ha
; BE-NEXT:    subfc r4, r3, r4
; BE-NEXT:    ld r4, .LC0@toc@l(r5)
; BE-NEXT:    subfe r3, r3, r3
; BE-NEXT:    addi r3, r3, 1
; BE-NEXT:    std r3, 0(r4)
; BE-NEXT:    blr
;
; LE-LABEL: test_ileull_store:
; LE:       # %bb.0: # %entry
; LE-NEXT:    subfc r4, r3, r4
; LE-NEXT:    addis r5, r2, glob@toc@ha
; LE-NEXT:    subfe r3, r3, r3
; LE-NEXT:    addi r3, r3, 1
; LE-NEXT:    std r3, glob@toc@l(r5)
; LE-NEXT:    blr
entry:
  %cmp = icmp ule i64 %a, %b
  %conv1 = zext i1 %cmp to i64
  store i64 %conv1, i64* @glob
  ret void
}

; Function Attrs: norecurse nounwind
define void @test_ileull_sext_store(i64 %a, i64 %b) {
; BE-LABEL: test_ileull_sext_store:
; BE:       # %bb.0: # %entry
; BE-NEXT:    addis r5, r2, .LC0@toc@ha
; BE-NEXT:    subfc r4, r3, r4
; BE-NEXT:    ld r4, .LC0@toc@l(r5)
; BE-NEXT:    subfe r3, r3, r3
; BE-NEXT:    not r3, r3
; BE-NEXT:    std r3, 0(r4)
; BE-NEXT:    blr
;
; LE-LABEL: test_ileull_sext_store:
; LE:       # %bb.0: # %entry
; LE-NEXT:    subfc r4, r3, r4
; LE-NEXT:    addis r5, r2, glob@toc@ha
; LE-NEXT:    subfe r3, r3, r3
; LE-NEXT:    not r3, r3
; LE-NEXT:    std r3, glob@toc@l(r5)
; LE-NEXT:    blr
entry:
  %cmp = icmp ule i64 %a, %b
  %conv1 = sext i1 %cmp to i64
  store i64 %conv1, i64* @glob
  ret void
}

; Function Attrs: norecurse nounwind
define void @test_ileull_z_store(i64 %a) {
; BE-LABEL: test_ileull_z_store:
; BE:       # %bb.0: # %entry
; BE-NEXT:    addis r4, r2, .LC0@toc@ha
; BE-NEXT:    cntlzd r3, r3
; BE-NEXT:    ld r4, .LC0@toc@l(r4)
; BE-NEXT:    rldicl r3, r3, 58, 63
; BE-NEXT:    std r3, 0(r4)
; BE-NEXT:    blr
;
; LE-LABEL: test_ileull_z_store:
; LE:       # %bb.0: # %entry
; LE-NEXT:    cntlzd r3, r3
; LE-NEXT:    addis r4, r2, glob@toc@ha
; LE-NEXT:    rldicl r3, r3, 58, 63
; LE-NEXT:    std r3, glob@toc@l(r4)
; LE-NEXT:    blr
entry:
  %cmp = icmp ule i64 %a, 0
  %conv1 = zext i1 %cmp to i64
  store i64 %conv1, i64* @glob
  ret void
}

; Function Attrs: norecurse nounwind
define void @test_ileull_sext_z_store(i64 %a) {
; BE-LABEL: test_ileull_sext_z_store:
; BE:       # %bb.0: # %entry
; BE-NEXT:    addis r4, r2, .LC0@toc@ha
; BE-NEXT:    addic r3, r3, -1
; BE-NEXT:    ld r4, .LC0@toc@l(r4)
; BE-NEXT:    subfe r3, r3, r3
; BE-NEXT:    std r3, 0(r4)
; BE-NEXT:    blr
;
; LE-LABEL: test_ileull_sext_z_store:
; LE:       # %bb.0: # %entry
; LE-NEXT:    addic r3, r3, -1
; LE-NEXT:    addis r4, r2, glob@toc@ha
; LE-NEXT:    subfe r3, r3, r3
; LE-NEXT:    std r3, glob@toc@l(r4)
; LE-NEXT:    blr
entry:
  %cmp = icmp ule i64 %a, 0
  %conv1 = sext i1 %cmp to i64
  store i64 %conv1, i64* @glob
  ret void
}

