/* isoquery.c generated by valac 0.22.1, the Vala compiler
 * generated from isoquery.vala, do not modify */

/* Copyright © 2013-2014 Tobias Quathamer
 *
 * This file is part of isoquery.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <locale.h>


#define TYPE_PROGRAM_OPTIONS (program_options_get_type ())
typedef struct _ProgramOptions ProgramOptions;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ISOQUERY (isoquery_get_type ())
#define ISOQUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ISOQUERY, Isoquery))
#define ISOQUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ISOQUERY, IsoqueryClass))
#define IS_ISOQUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ISOQUERY))
#define IS_ISOQUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ISOQUERY))
#define ISOQUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ISOQUERY, IsoqueryClass))

typedef struct _Isoquery Isoquery;
typedef struct _IsoqueryClass IsoqueryClass;
typedef struct _IsoqueryPrivate IsoqueryPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _ProgramOptions {
	gchar* iso;
	gchar* filepath;
	gchar* locale;
	gboolean name;
	gboolean official_name;
	gboolean common_name;
	gboolean use_null_separator;
	gboolean version;
};

struct _Isoquery {
	GObject parent_instance;
	IsoqueryPrivate * priv;
};

struct _IsoqueryClass {
	GObjectClass parent_class;
};


static gpointer isoquery_parent_class = NULL;

GType program_options_get_type (void) G_GNUC_CONST;
ProgramOptions* program_options_dup (const ProgramOptions* self);
void program_options_free (ProgramOptions* self);
void program_options_copy (const ProgramOptions* self, ProgramOptions* dest);
void program_options_destroy (ProgramOptions* self);
GType isoquery_get_type (void) G_GNUC_CONST;
enum  {
	ISOQUERY_DUMMY_PROPERTY
};
static void _isoquery_check_options (ProgramOptions* options);
static void _isoquery_show_version_and_copyright (void);
gint isoquery_main (gchar** args, int args_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
void handle_639_show (ProgramOptions* opts, gchar** codes, int codes_length1);
void handle_639_3_show (ProgramOptions* opts, gchar** codes, int codes_length1);
void handle_639_5_show (ProgramOptions* opts, gchar** codes, int codes_length1);
void handle_3166_show (ProgramOptions* opts, gchar** codes, int codes_length1);
void handle_3166_2_show (ProgramOptions* opts, gchar** codes, int codes_length1);
void handle_4217_show (ProgramOptions* opts, gchar** codes, int codes_length1);
void handle_15924_show (ProgramOptions* opts, gchar** codes, int codes_length1);
Isoquery* isoquery_new (void);
Isoquery* isoquery_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void program_options_copy (const ProgramOptions* self, ProgramOptions* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	_tmp0_ = (*self).iso;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).iso);
	(*dest).iso = _tmp1_;
	_tmp2_ = (*self).filepath;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).filepath);
	(*dest).filepath = _tmp3_;
	_tmp4_ = (*self).locale;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).locale);
	(*dest).locale = _tmp5_;
	_tmp6_ = (*self).name;
	(*dest).name = _tmp6_;
	_tmp7_ = (*self).official_name;
	(*dest).official_name = _tmp7_;
	_tmp8_ = (*self).common_name;
	(*dest).common_name = _tmp8_;
	_tmp9_ = (*self).use_null_separator;
	(*dest).use_null_separator = _tmp9_;
	_tmp10_ = (*self).version;
	(*dest).version = _tmp10_;
}


void program_options_destroy (ProgramOptions* self) {
	_g_free0 ((*self).iso);
	_g_free0 ((*self).filepath);
	_g_free0 ((*self).locale);
}


ProgramOptions* program_options_dup (const ProgramOptions* self) {
	ProgramOptions* dup;
	dup = g_new0 (ProgramOptions, 1);
	program_options_copy (self, dup);
	return dup;
}


void program_options_free (ProgramOptions* self) {
	program_options_destroy (self);
	g_free (self);
}


GType program_options_get_type (void) {
	static volatile gsize program_options_type_id__volatile = 0;
	if (g_once_init_enter (&program_options_type_id__volatile)) {
		GType program_options_type_id;
		program_options_type_id = g_boxed_type_register_static ("ProgramOptions", (GBoxedCopyFunc) program_options_dup, (GBoxedFreeFunc) program_options_free);
		g_once_init_leave (&program_options_type_id__volatile, program_options_type_id);
	}
	return program_options_type_id__volatile;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void _isoquery_check_options (ProgramOptions* options) {
	ProgramOptions _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	ProgramOptions _tmp2_ = {0};
	const gchar* _tmp3_ = NULL;
	gchar** supported_standards = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint supported_standards_length1 = 0;
	gint _supported_standards_size_ = 0;
	gboolean supported = FALSE;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (options != NULL);
	_tmp0_ = *options;
	_tmp1_ = _tmp0_.version;
	if (_tmp1_ == TRUE) {
		_isoquery_show_version_and_copyright ();
		exit (EXIT_SUCCESS);
	}
	_tmp2_ = *options;
	_tmp3_ = _tmp2_.iso;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("3166");
		_g_free0 ((*options).iso);
		(*options).iso = _tmp4_;
	}
	_tmp5_ = g_strdup ("639");
	_tmp6_ = g_strdup ("639-3");
	_tmp7_ = g_strdup ("639-5");
	_tmp8_ = g_strdup ("3166");
	_tmp9_ = g_strdup ("3166-2");
	_tmp10_ = g_strdup ("4217");
	_tmp11_ = g_strdup ("15924");
	_tmp12_ = g_new0 (gchar*, 7 + 1);
	_tmp12_[0] = _tmp5_;
	_tmp12_[1] = _tmp6_;
	_tmp12_[2] = _tmp7_;
	_tmp12_[3] = _tmp8_;
	_tmp12_[4] = _tmp9_;
	_tmp12_[5] = _tmp10_;
	_tmp12_[6] = _tmp11_;
	supported_standards = _tmp12_;
	supported_standards_length1 = 7;
	_supported_standards_size_ = supported_standards_length1;
	supported = FALSE;
	_tmp13_ = supported_standards;
	_tmp13__length1 = supported_standards_length1;
	{
		gchar** standard_collection = NULL;
		gint standard_collection_length1 = 0;
		gint _standard_collection_size_ = 0;
		gint standard_it = 0;
		standard_collection = _tmp13_;
		standard_collection_length1 = _tmp13__length1;
		for (standard_it = 0; standard_it < _tmp13__length1; standard_it = standard_it + 1) {
			gchar* _tmp14_ = NULL;
			gchar* standard = NULL;
			_tmp14_ = g_strdup (standard_collection[standard_it]);
			standard = _tmp14_;
			{
				ProgramOptions _tmp15_ = {0};
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				_tmp15_ = *options;
				_tmp16_ = _tmp15_.iso;
				_tmp17_ = standard;
				if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
					supported = TRUE;
					_g_free0 (standard);
					break;
				}
				_g_free0 (standard);
			}
		}
	}
	_tmp18_ = supported;
	if (!_tmp18_) {
		FILE* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		ProgramOptions _tmp21_ = {0};
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp19_ = stderr;
		_tmp20_ = _ ("isoquery: ISO standard \"%(standard)s\" is not supported.\n");
		_tmp21_ = *options;
		_tmp22_ = _tmp21_.iso;
		_tmp23_ = string_replace (_tmp20_, "%(standard)s", _tmp22_);
		_tmp24_ = _tmp23_;
		fprintf (_tmp19_, "%s", _tmp24_);
		_g_free0 (_tmp24_);
		exit (EXIT_FAILURE);
	}
	supported_standards = (_vala_array_free (supported_standards, supported_standards_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void _isoquery_show_version_and_copyright (void) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	FILE* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* translation = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	FILE* _tmp12_ = NULL;
	_tmp0_ = stdout;
	_tmp1_ = _ ("isoquery %(version)s\n");
	_tmp2_ = string_replace (_tmp1_, "%(version)s", VERSION);
	_tmp3_ = _tmp2_;
	fprintf (_tmp0_, "%s", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = stdout;
	_tmp5_ = _ ("Copyright © 2007-2014 Tobias Quathamer\n");
	fprintf (_tmp4_, "%s", _tmp5_);
	_tmp6_ = _ ("Translation to LANGUAGE Copyright © YEAR YOUR-NAME\n");
	_tmp7_ = g_strdup (_tmp6_);
	translation = _tmp7_;
	_tmp8_ = translation;
	_tmp9_ = string_contains (_tmp8_, "LANGUAGE");
	if (!_tmp9_) {
		FILE* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp10_ = stdout;
		_tmp11_ = translation;
		fprintf (_tmp10_, "%s", _tmp11_);
	}
	_tmp12_ = stdout;
	fprintf (_tmp12_, "\n" \
"This program is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program.  If not, see <http://www.gnu.org/licenses/>.\n");
	_g_free0 (translation);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gint isoquery_main (gchar** args, int args_length1) {
	gint result = 0;
	ProgramOptions options = {0};
	GOptionEntry* commandline_options = NULL;
	GOptionEntry* _tmp0_ = NULL;
	gint commandline_options_length1 = 0;
	gint _commandline_options_size_ = 0;
	GOptionEntry* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GOptionEntry _tmp4_ = {0};
	GOptionEntry _tmp5_ = {0};
	GOptionEntry* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GOptionEntry _tmp9_ = {0};
	GOptionEntry _tmp10_ = {0};
	GOptionEntry* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GOptionEntry _tmp14_ = {0};
	GOptionEntry _tmp15_ = {0};
	GOptionEntry* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	const gchar* _tmp17_ = NULL;
	GOptionEntry _tmp18_ = {0};
	GOptionEntry _tmp19_ = {0};
	GOptionEntry* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	const gchar* _tmp21_ = NULL;
	GOptionEntry _tmp22_ = {0};
	GOptionEntry _tmp23_ = {0};
	GOptionEntry* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	const gchar* _tmp25_ = NULL;
	GOptionEntry _tmp26_ = {0};
	GOptionEntry _tmp27_ = {0};
	GOptionEntry* _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	const gchar* _tmp29_ = NULL;
	GOptionEntry _tmp30_ = {0};
	GOptionEntry _tmp31_ = {0};
	GOptionEntry* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	const gchar* _tmp33_ = NULL;
	GOptionEntry _tmp34_ = {0};
	GOptionEntry _tmp35_ = {0};
	GOptionEntry* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	GOptionEntry _tmp37_ = {0};
	GOptionEntry _tmp38_ = {0};
	gchar** codes = NULL;
	gchar** _tmp53_ = NULL;
	gint _tmp53__length1 = 0;
	gchar** _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	gchar** _tmp55_ = NULL;
	gint _tmp55__length1 = 0;
	gint codes_length1 = 0;
	gint _codes_size_ = 0;
	ProgramOptions _tmp56_ = {0};
	const gchar* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	GQuark _tmp60_ = 0U;
	static GQuark _tmp59_label0 = 0;
	static GQuark _tmp59_label1 = 0;
	static GQuark _tmp59_label2 = 0;
	static GQuark _tmp59_label3 = 0;
	static GQuark _tmp59_label4 = 0;
	static GQuark _tmp59_label5 = 0;
	static GQuark _tmp59_label6 = 0;
	GError * _inner_error_ = NULL;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	setlocale (LC_ALL, "");
	memset (&options, 0, sizeof (ProgramOptions));
	_tmp0_ = g_new0 (GOptionEntry, 9);
	commandline_options = _tmp0_;
	commandline_options_length1 = 9;
	_commandline_options_size_ = commandline_options_length1;
	_tmp1_ = commandline_options;
	_tmp1__length1 = commandline_options_length1;
	_tmp2_ = _ ("The ISO standard to use. Possible values: 639, 639-3, 639-5, 3166, 316" \
"6-2, 4217, 15924 (default: 3166).");
	_tmp3_ = _ ("STANDARD");
	_tmp4_.long_name = "iso";
	_tmp4_.short_name = 'i';
	_tmp4_.flags = 0;
	_tmp4_.arg = G_OPTION_ARG_STRING;
	_tmp4_.arg_data = &options.iso;
	_tmp4_.description = _tmp2_;
	_tmp4_.arg_description = _tmp3_;
	_tmp1_[0] = _tmp4_;
	_tmp5_ = _tmp1_[0];
	_tmp6_ = commandline_options;
	_tmp6__length1 = commandline_options_length1;
	_tmp7_ = _ ("Use another XML file with ISO data (default: /usr/share/xml/iso-codes/" \
"iso_3166.xml)");
	_tmp8_ = _ ("FILE");
	_tmp9_.long_name = "xmlfile";
	_tmp9_.short_name = 'x';
	_tmp9_.flags = 0;
	_tmp9_.arg = G_OPTION_ARG_STRING;
	_tmp9_.arg_data = &options.filepath;
	_tmp9_.description = _tmp7_;
	_tmp9_.arg_description = _tmp8_;
	_tmp6_[1] = _tmp9_;
	_tmp10_ = _tmp6_[1];
	_tmp11_ = commandline_options;
	_tmp11__length1 = commandline_options_length1;
	_tmp12_ = _ ("Use this locale for output.");
	_tmp13_ = _ ("LOCALE");
	_tmp14_.long_name = "locale";
	_tmp14_.short_name = 'l';
	_tmp14_.flags = 0;
	_tmp14_.arg = G_OPTION_ARG_STRING;
	_tmp14_.arg_data = &options.locale;
	_tmp14_.description = _tmp12_;
	_tmp14_.arg_description = _tmp13_;
	_tmp11_[2] = _tmp14_;
	_tmp15_ = _tmp11_[2];
	_tmp16_ = commandline_options;
	_tmp16__length1 = commandline_options_length1;
	_tmp17_ = _ ("Name for the supplied codes (default).");
	_tmp18_.long_name = "name";
	_tmp18_.short_name = 'n';
	_tmp18_.flags = 0;
	_tmp18_.arg = G_OPTION_ARG_NONE;
	_tmp18_.arg_data = &options.name;
	_tmp18_.description = _tmp17_;
	_tmp16_[3] = _tmp18_;
	_tmp19_ = _tmp16_[3];
	_tmp20_ = commandline_options;
	_tmp20__length1 = commandline_options_length1;
	_tmp21_ = _ ("Official name for the supplied codes. This may be the same as --name (" \
"only applies to ISO 3166).");
	_tmp22_.long_name = "official_name";
	_tmp22_.short_name = 'o';
	_tmp22_.flags = 0;
	_tmp22_.arg = G_OPTION_ARG_NONE;
	_tmp22_.arg_data = &options.official_name;
	_tmp22_.description = _tmp21_;
	_tmp20_[4] = _tmp22_;
	_tmp23_ = _tmp20_[4];
	_tmp24_ = commandline_options;
	_tmp24__length1 = commandline_options_length1;
	_tmp25_ = _ ("Common name for the supplied codes. This may be the same as --name (on" \
"ly applies to ISO 3166).");
	_tmp26_.long_name = "common_name";
	_tmp26_.short_name = 'c';
	_tmp26_.flags = 0;
	_tmp26_.arg = G_OPTION_ARG_NONE;
	_tmp26_.arg_data = &options.common_name;
	_tmp26_.description = _tmp25_;
	_tmp24_[5] = _tmp26_;
	_tmp27_ = _tmp24_[5];
	_tmp28_ = commandline_options;
	_tmp28__length1 = commandline_options_length1;
	_tmp29_ = _ ("Separate entries with a NULL character instead of newline.");
	_tmp30_.long_name = "null";
	_tmp30_.short_name = '0';
	_tmp30_.flags = 0;
	_tmp30_.arg = G_OPTION_ARG_NONE;
	_tmp30_.arg_data = &options.use_null_separator;
	_tmp30_.description = _tmp29_;
	_tmp28_[6] = _tmp30_;
	_tmp31_ = _tmp28_[6];
	_tmp32_ = commandline_options;
	_tmp32__length1 = commandline_options_length1;
	_tmp33_ = _ ("Show program version and copyright.");
	_tmp34_.long_name = "version";
	_tmp34_.short_name = 'v';
	_tmp34_.flags = 0;
	_tmp34_.arg = G_OPTION_ARG_NONE;
	_tmp34_.arg_data = &options.version;
	_tmp34_.description = _tmp33_;
	_tmp32_[7] = _tmp34_;
	_tmp35_ = _tmp32_[7];
	_tmp36_ = commandline_options;
	_tmp36__length1 = commandline_options_length1;
	_tmp37_.long_name = NULL;
	_tmp36_[8] = _tmp37_;
	_tmp38_ = _tmp36_[8];
	{
		GOptionContext* opt_context = NULL;
		const gchar* _tmp39_ = NULL;
		GOptionContext* _tmp40_ = NULL;
		GOptionContext* _tmp41_ = NULL;
		GOptionContext* _tmp42_ = NULL;
		GOptionEntry* _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		GOptionContext* _tmp44_ = NULL;
		_tmp39_ = _ ("[ISO codes]");
		_tmp40_ = g_option_context_new (_tmp39_);
		opt_context = _tmp40_;
		_tmp41_ = opt_context;
		g_option_context_set_help_enabled (_tmp41_, TRUE);
		_tmp42_ = opt_context;
		_tmp43_ = commandline_options;
		_tmp43__length1 = commandline_options_length1;
		g_option_context_add_main_entries (_tmp42_, _tmp43_, NULL);
		_tmp44_ = opt_context;
		g_option_context_parse (_tmp44_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch1_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			commandline_options = (g_free (commandline_options), NULL);
			program_options_destroy (&options);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally1;
	__catch1_g_option_error:
	{
		GError* err = NULL;
		FILE* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		GError* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		FILE* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp45_ = stderr;
		_tmp46_ = _ ("isoquery: %(error_message)s\n");
		_tmp47_ = err;
		_tmp48_ = _tmp47_->message;
		_tmp49_ = string_replace (_tmp46_, "%(error_message)s", _tmp48_);
		_tmp50_ = _tmp49_;
		fprintf (_tmp45_, "%s", _tmp50_);
		_g_free0 (_tmp50_);
		_tmp51_ = stderr;
		_tmp52_ = _ ("Run \"isoquery --help\" to see a full list of available command line o" \
"ptions.\n");
		fprintf (_tmp51_, "%s", _tmp52_);
		exit (EXIT_FAILURE);
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		commandline_options = (g_free (commandline_options), NULL);
		program_options_destroy (&options);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_isoquery_check_options (&options);
	_tmp53_ = args;
	_tmp53__length1 = args_length1;
	_tmp54_ = args;
	_tmp54__length1 = args_length1;
	_tmp55_ = ((_tmp53_ + 1) != NULL) ? _vala_array_dup1 (_tmp53_ + 1, _tmp54__length1 - 1) : ((gpointer) (_tmp53_ + 1));
	_tmp55__length1 = _tmp54__length1 - 1;
	codes = _tmp55_;
	codes_length1 = _tmp55__length1;
	_codes_size_ = codes_length1;
	_tmp56_ = options;
	_tmp57_ = _tmp56_.iso;
	_tmp58_ = _tmp57_;
	_tmp60_ = (NULL == _tmp58_) ? 0 : g_quark_from_string (_tmp58_);
	if (_tmp60_ == ((0 != _tmp59_label0) ? _tmp59_label0 : (_tmp59_label0 = g_quark_from_static_string ("639")))) {
		switch (0) {
			default:
			{
				ProgramOptions _tmp61_ = {0};
				gchar** _tmp62_ = NULL;
				gint _tmp62__length1 = 0;
				_tmp61_ = options;
				_tmp62_ = codes;
				_tmp62__length1 = codes_length1;
				handle_639_show (&_tmp61_, _tmp62_, _tmp62__length1);
				break;
			}
		}
	} else if (_tmp60_ == ((0 != _tmp59_label1) ? _tmp59_label1 : (_tmp59_label1 = g_quark_from_static_string ("639-3")))) {
		switch (0) {
			default:
			{
				ProgramOptions _tmp63_ = {0};
				gchar** _tmp64_ = NULL;
				gint _tmp64__length1 = 0;
				_tmp63_ = options;
				_tmp64_ = codes;
				_tmp64__length1 = codes_length1;
				handle_639_3_show (&_tmp63_, _tmp64_, _tmp64__length1);
				break;
			}
		}
	} else if (_tmp60_ == ((0 != _tmp59_label2) ? _tmp59_label2 : (_tmp59_label2 = g_quark_from_static_string ("639-5")))) {
		switch (0) {
			default:
			{
				ProgramOptions _tmp65_ = {0};
				gchar** _tmp66_ = NULL;
				gint _tmp66__length1 = 0;
				_tmp65_ = options;
				_tmp66_ = codes;
				_tmp66__length1 = codes_length1;
				handle_639_5_show (&_tmp65_, _tmp66_, _tmp66__length1);
				break;
			}
		}
	} else if (_tmp60_ == ((0 != _tmp59_label3) ? _tmp59_label3 : (_tmp59_label3 = g_quark_from_static_string ("3166")))) {
		switch (0) {
			default:
			{
				ProgramOptions _tmp67_ = {0};
				gchar** _tmp68_ = NULL;
				gint _tmp68__length1 = 0;
				_tmp67_ = options;
				_tmp68_ = codes;
				_tmp68__length1 = codes_length1;
				handle_3166_show (&_tmp67_, _tmp68_, _tmp68__length1);
				break;
			}
		}
	} else if (_tmp60_ == ((0 != _tmp59_label4) ? _tmp59_label4 : (_tmp59_label4 = g_quark_from_static_string ("3166-2")))) {
		switch (0) {
			default:
			{
				ProgramOptions _tmp69_ = {0};
				gchar** _tmp70_ = NULL;
				gint _tmp70__length1 = 0;
				_tmp69_ = options;
				_tmp70_ = codes;
				_tmp70__length1 = codes_length1;
				handle_3166_2_show (&_tmp69_, _tmp70_, _tmp70__length1);
				break;
			}
		}
	} else if (_tmp60_ == ((0 != _tmp59_label5) ? _tmp59_label5 : (_tmp59_label5 = g_quark_from_static_string ("4217")))) {
		switch (0) {
			default:
			{
				ProgramOptions _tmp71_ = {0};
				gchar** _tmp72_ = NULL;
				gint _tmp72__length1 = 0;
				_tmp71_ = options;
				_tmp72_ = codes;
				_tmp72__length1 = codes_length1;
				handle_4217_show (&_tmp71_, _tmp72_, _tmp72__length1);
				break;
			}
		}
	} else if (_tmp60_ == ((0 != _tmp59_label6) ? _tmp59_label6 : (_tmp59_label6 = g_quark_from_static_string ("15924")))) {
		switch (0) {
			default:
			{
				ProgramOptions _tmp73_ = {0};
				gchar** _tmp74_ = NULL;
				gint _tmp74__length1 = 0;
				_tmp73_ = options;
				_tmp74_ = codes;
				_tmp74__length1 = codes_length1;
				handle_15924_show (&_tmp73_, _tmp74_, _tmp74__length1);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				FILE* _tmp75_ = NULL;
				const gchar* _tmp76_ = NULL;
				_tmp75_ = stderr;
				_tmp76_ = _ ("isoquery: Internal error. Please report this bug.\n");
				fprintf (_tmp75_, "%s", _tmp76_);
				result = EXIT_FAILURE;
				codes = (_vala_array_free (codes, codes_length1, (GDestroyNotify) g_free), NULL);
				commandline_options = (g_free (commandline_options), NULL);
				program_options_destroy (&options);
				return result;
			}
		}
	}
	result = EXIT_SUCCESS;
	codes = (_vala_array_free (codes, codes_length1, (GDestroyNotify) g_free), NULL);
	commandline_options = (g_free (commandline_options), NULL);
	program_options_destroy (&options);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return isoquery_main (argv, argc);
}


Isoquery* isoquery_construct (GType object_type) {
	Isoquery * self = NULL;
	self = (Isoquery*) g_object_new (object_type, NULL);
	return self;
}


Isoquery* isoquery_new (void) {
	return isoquery_construct (TYPE_ISOQUERY);
}


static void isoquery_class_init (IsoqueryClass * klass) {
	isoquery_parent_class = g_type_class_peek_parent (klass);
}


static void isoquery_instance_init (Isoquery * self) {
}


GType isoquery_get_type (void) {
	static volatile gsize isoquery_type_id__volatile = 0;
	if (g_once_init_enter (&isoquery_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IsoqueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) isoquery_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Isoquery), 0, (GInstanceInitFunc) isoquery_instance_init, NULL };
		GType isoquery_type_id;
		isoquery_type_id = g_type_register_static (G_TYPE_OBJECT, "Isoquery", &g_define_type_info, 0);
		g_once_init_leave (&isoquery_type_id__volatile, isoquery_type_id);
	}
	return isoquery_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



