//  Copyright John Maddock 2020.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Basic sanity check that header <boost/math/filters/daubechies.hpp>
// #includes all the files that it needs to.
//
#include <boost/math/filters/daubechies.hpp>

void compile_and_link_test()
{
   using namespace boost::math::filters;

   constexpr std::array<float, 2> fa = daubechies_scaling_filter<float, 1>();
   static_assert(fa[0] == 0.70710678118654752440084436210484903928483593768847403658833986899536623923f);
   static_assert(fa[1] == 0.70710678118654752440084436210484903928483593768847403658833986899536623923f);

   constexpr std::array<double, 4> da = daubechies_scaling_filter<double, 2>();
   static_assert(da[0] == 0.48296291314453414337487159986444868381695241950420227520117153815521160699);
   static_assert(da[1] == 0.83651630373780790557529378091687320345937038834843929349534147265289472661);
   static_assert(da[2] == 0.22414386804201338102597276224040035546788351818427176138716833084015463224);
   static_assert(da[3] == -0.12940952255126038117444941881202416417453445065996525690700160365752848737);

   constexpr std::array<long double, 6> la = daubechies_scaling_filter<long double, 3>();
   static_assert(la[0] == 0.33267055295008261599851158913900563001292339924506835970847057855179372371L);
   static_assert(la[1] == 0.80689150931109257649449360408871349051929739499482361816509206360348683533L);
   static_assert(la[2] == 0.45987750211849157009515194214761672080811017743149230664338678024864033563L);
   static_assert(la[3] == -0.135011020010254588696389906699374480562219845223781191975686255357062768L);
   static_assert(la[4] == -0.085441273882026661692819169181773311536197638988086629763517489805067820106L);
   static_assert(la[5] == 0.035226291885709536602740664715510029327758387917431610398934060748942171898L);

}
